<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8" indent="no"/>

<!--

  $nls		XML-tree from nls.xml
  $lang-name	Language short name (en, ru, e.t.c.)
  $lang		XML-tree of selected language

  Server set language short name with /ui/@lang. If XML-tree for this language
  not exists in $nls (file "nls.xml") then language "en" will be used.

-->

<xsl:variable name="nls" select="document('xslt/nls.xml')/nls"/>
<xsl:variable name="server-lang-name" select="/ui/@lang"/>
<xsl:variable name="lang-name">
  <xsl:choose>
    <xsl:when test="$nls/lang[name=$server-lang-name]">
      <xsl:value-of select="$server-lang-name"/>
    </xsl:when>
    <xsl:otherwise>en</xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<xsl:variable name="lang" select="$nls/lang[name=$lang-name]"/>

<xsl:include href="xslt/index.xsl"/>
<xsl:include href="xslt/logon.xsl"/>
<xsl:include href="xslt/channels.xsl"/>
<xsl:include href="xslt/tuners.xsl"/>
<xsl:include href="xslt/relays.xsl"/>
<xsl:include href="xslt/hosts.xsl"/>
<xsl:include href="xslt/log.xsl"/>
<xsl:include href="xslt/properties.xsl"/>

<xsl:template match="/">
  <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
      <link rel="icon" href="/ui/img/favicon.bmp"></link>
      <link rel="stylesheet" type="text/css" href="/ui/style.css"/>
      <title>FIRECast</title>
    </head>
    <body>
      <a name="top"></a>

      <script type="text/javascript">
        function locLoad() { window.onunload = null; return true; };

        // Remove unload-function on links and forms actions
        window.onload = function() {
          var aElements = document.getElementsByTagName( "a" );
          var nIdx, cElements = aElements.length;

          for( nIdx = 0; nIdx &lt; cElements; nIdx++ )
            if ( !aElements[nIdx].onclick )
              aElements[nIdx].onclick = locLoad;

          aElements = document.getElementsByTagName( "form" );
          cElements = aElements.length;
          for( nIdx = 0; nIdx &lt; cElements; nIdx++ )
            aElements[nIdx].onsubmit = locLoad;
        };

        // Catch document unload event for logout
        window.onunload = function() {
          var oReq = false;

          if ( window.XMLHttpRequest )	// Mozilla, Safari,...
            oReq = new XMLHttpRequest();
          else if ( window.ActiveXObject )	// IE
          {
            try { oReq = new ActiveXObject( "Msxml2.XMLHTTP" ); }
            catch( e )
            {
              try { oReq = new ActiveXObject( "Microsoft.XMLHTTP" ); }
              catch( e ) {}
            }
          }

          if ( oReq )
          {
            oReq.open( "GET", "/ui/index?logout=1", false );
            oReq.send( "" );
          }
        };
      </script>

      <table class="header" border="0" cellpadding="0" cellspacing="0" width="100%">
        <tbody>
          <tr>
            <td class="header-title" colspan="3">
              <div class="header-controls">
                <xsl:if test="/ui/@type='admin'">
                  [<a href="/ui/index" onclick="return locLoad();">
                     <xsl:value-of select="$lang/buttons/begin"/>
                  </a>]
                  [<a href="/ui/index?logout=1" onclick="return locLoad();">
                     <xsl:value-of select="$lang/buttons/logout"/>
                  </a>]
                </xsl:if>
                <span class="language">
                  <xsl:value-of select="$lang/labels/language"/>:
                  <form enctype="multipart/form-data" method="post"
                        style="display: inline;" onsubmit="return locLoad();">
                    <select name="language">
                      <xsl:for-each select="$nls/lang">
                        <option value="{name}">
                          <xsl:if test="name=$lang-name">
                            <xsl:attribute name="selected">1</xsl:attribute>
                          </xsl:if>
                          <xsl:value-of select="title"/>
                        </option>
                      </xsl:for-each>
                    </select>
                    <input type="submit" name="submitLanguage"
                           value="{$lang/buttons/submit}"/>
                  </form>
                </span>
              </div>
              FIRECast
            </td>
          </tr>
          <tr>
            <td><div style="width: 1em;"> </div></td>
            <td valign="top" style="width: 85%;">
              <xsl:apply-templates select="ui"/>
            </td>
            <td><div style="width: 1em;"> </div></td>
          </tr>
          <tr>
            <td colspan="3" class="header-bottom">
              [<a href="#top" onclick="return true;">
                 <xsl:value-of select="$lang/buttons/top"/>
              </a>]
            </td>
          </tr>
        </tbody>
      </table>
    </body>
  </html>
</xsl:template>


<xsl:template match="/ui[not(@type='admin')]">
  <xsl:apply-templates select="index"/>
  <xsl:apply-templates select="logon"/>
</xsl:template>

<xsl:template match="/ui[@type='admin']">
  <table class="main-area" border="0" cellpadding="0" cellspacing="0">
    <tbody>
      <tr>
        <td class="main-area-buttons">
          <xsl:call-template name="main-menu-btn">
            <xsl:with-param name="text" select="$lang/menu/properties"/>
            <xsl:with-param name="link">/ui/properties</xsl:with-param>
            <xsl:with-param name="node">properties</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="main-menu-btn">
            <xsl:with-param name="text" select="$lang/menu/hosts"/>
            <xsl:with-param name="link">/ui/hosts</xsl:with-param>
            <xsl:with-param name="node">hosts</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="main-menu-btn">
            <xsl:with-param name="text" select="$lang/menu/relays"/>
            <xsl:with-param name="link">/ui/relays</xsl:with-param>
            <xsl:with-param name="node">relays</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="main-menu-btn">
            <xsl:with-param name="text" select="$lang/menu/tuners"/>
            <xsl:with-param name="link">/ui/tuners</xsl:with-param>
            <xsl:with-param name="node">tuners</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="main-menu-btn">
            <xsl:with-param name="text" select="$lang/menu/channels"/>
            <xsl:with-param name="link">/ui/channels</xsl:with-param>
            <xsl:with-param name="node">channels</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="main-menu-btn">
            <xsl:with-param name="text" select="$lang/menu/log"/>
            <xsl:with-param name="link">/ui/log</xsl:with-param>
            <xsl:with-param name="node">log</xsl:with-param>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="main-area-page">
          <xsl:apply-templates select="index"/>
          <xsl:apply-templates select="logon"/>
          <xsl:apply-templates select="channels"/>
          <xsl:apply-templates select="tuners"/>
          <xsl:apply-templates select="relays"/>
          <xsl:apply-templates select="hosts"/>
          <xsl:apply-templates select="log"/>
          <xsl:apply-templates select="properties"/>
        </td>
      </tr>
    </tbody>
  </table>
</xsl:template>


<xsl:template match="log-events">
  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <form enctype="multipart/form-data" method="post" class="control-title"
          onsubmit="return locLoad();">
      <tr>
        <td class="control-title" colspan="2" style="width: 100%">
          <label for="swHTTP">
            <input type="checkbox" id="swHTTP" name="swHTTP">
              <xsl:if test="sw-http='1'">
                <xsl:attribute name="checked">1</xsl:attribute>
              </xsl:if>
            </input>
            <xsl:value-of select="$lang/labels/http"/>
          </label>
          <label for="swUI">
            <input type="checkbox" name="swUI" id="swUI">
              <xsl:if test="sw-ui='1'">
                <xsl:attribute name="checked">1</xsl:attribute>
              </xsl:if>
            </input>
            <xsl:value-of select="$lang/labels/web-interface"/>
          </label>
          <label for="swRelay">
            <input type="checkbox" name="swRelay" id="swRelay">
              <xsl:if test="sw-relay='1'">
                <xsl:attribute name="checked">1</xsl:attribute>
              </xsl:if>
            </input>
            <xsl:value-of select="$lang/labels/relays"/>
          </label>
          <label for="swChannel">
            <input type="checkbox" name="swChannel" id="swChannel">
              <xsl:if test="sw-channel='1'">
                <xsl:attribute name="checked">1</xsl:attribute>
              </xsl:if>
            </input>
            <xsl:value-of select="$lang/labels/channels"/>
          </label>
        </td>
      </tr>
      <tr>
        <td class="control-title"> </td>
        <td class="control">
          <input type="submit" name="submitLog" value="{$lang/buttons/submit}"/>
        </td>
      </tr>
    </form>
  </table>
</xsl:template>

<xsl:template name="time-format">
  <xsl:param name="time"/>

  <xsl:variable name="year">
    <xsl:value-of select="substring($time,1,4)"/>
  </xsl:variable>
  <xsl:variable name="mo">
    <xsl:value-of select="substring($time,5,2)"/>
  </xsl:variable>
    <xsl:variable name="day">
  <xsl:value-of select="substring($time,7,2)"/>
  </xsl:variable>

  <nobr>
  <xsl:value-of select="$day"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="$mo"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="$year"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="substring($time,9)"/>
  </nobr>
</xsl:template>


<!--
	ACL
-->

<xsl:template match="acl">
  <div class="control-title">
    <xsl:value-of select="$lang/comments/acl"/>
  </div>
  <table class="acl">
    <tr>
      <th class="acl-allow"><xsl:value-of select="$lang/labels/allow"/></th>
      <th class="acl-addr"><xsl:value-of select="$lang/labels/address-mask"/></th>
    </tr>
    <xsl:for-each select="item">
      <xsl:call-template name="acl-item">
        <xsl:with-param name="type" select="../@type"/>
        <xsl:with-param name="N" select="position()"/>
        <xsl:with-param name="allow" select="@allow"/>
        <xsl:with-param name="value" select="."/>
        <xsl:with-param name="error" select="@error"/>
      </xsl:call-template>
    </xsl:for-each>

    <xsl:call-template name="acl-empty-item">
      <xsl:with-param name="count" select="4"/>
      <xsl:with-param name="type" select="@type"/>
      <xsl:with-param name="N" select="count(item)+1"/>
    </xsl:call-template>
  </table>
</xsl:template>

<xsl:template name="acl-empty-item">
  <xsl:param name="count"/>
  <xsl:param name="type"/>
  <xsl:param name="N"/>

  <xsl:call-template name="acl-item">
    <xsl:with-param name="type" select="$type"/>
    <xsl:with-param name="N" select="$N"/>
  </xsl:call-template>

  <xsl:if test="$count > 1">
    <xsl:call-template name="acl-empty-item">
      <xsl:with-param name="count" select="$count - 1"/>
      <xsl:with-param name="type" select="$type"/>
      <xsl:with-param name="N" select="$N + 1"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="acl-item">
  <xsl:param name="type"/>
  <xsl:param name="N"/>
  <xsl:param name="allow"/>
  <xsl:param name="value"/>
  <xsl:param name="error"/>

  <tr>
    <xsl:if test="$error='1'">
      <xsl:attribute name="class">error</xsl:attribute>
    </xsl:if>
    <td class="acl-allow">
      <input type="checkbox" name="{concat('aclAllow_',$type,$N)}">
        <xsl:if test="$allow='1'">
          <xsl:attribute name="checked">1</xsl:attribute>
        </xsl:if>
      </input>
    </td>
    <td class="acl-addr">
      <input type="text" class="text" maxlength="31"
             name="{concat('aclAddr_',$type,$N)}" value="{$value}"/>
    </td>
  </tr>
</xsl:template>


<!--
	Buttons
-->

<xsl:template name="main-menu-btn">
  <xsl:param name="text"/>
  <xsl:param name="link"/>
  <xsl:param name="node"/>
  <xsl:param name="selected"/>

  <span>
    <xsl:choose>
      <xsl:when test="local-name(*)=$node">
        <xsl:attribute name="class">main-menu-btn-selected</xsl:attribute>
        <xsl:value-of select="$text"/>
      </xsl:when>
      <xsl:otherwise>
        <a href="{$link}" onclick="return locLoad();">
          <xsl:value-of select="$text"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </span>
</xsl:template>

<xsl:template name="delete-btn">
  <xsl:param name="link"/>
  <xsl:param name="check"/>

  <span class="delete-btn">
    <xsl:text>[</xsl:text>
      <a href="{$link}" title="Delete" onclick="return locLoad();">
        <xsl:choose>
          <xsl:when test="$check">
            <xsl:text>X</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$lang/buttons/delete"/>
          </xsl:otherwise>
        </xsl:choose>
      </a>
    <xsl:text>]</xsl:text>
  </span>
</xsl:template>

<xsl:template name="btn">
  <xsl:param name="caption"/>
  <xsl:param name="hint"/>
  <xsl:param name="link"/>

  <span class="btn">
    [<a href="{$link}" title="{$hint}" onclick="return locLoad();">
       <xsl:value-of select="$caption"/>
    </a>]
  </span>
</xsl:template>


<!--
	Pages selector
-->

<xsl:template name="page-list">
  <xsl:param name="selected"/>
  <xsl:param name="total"/>
  <xsl:param name="get-arg"/>

  <xsl:variable name="list-start-page" select="floor(($selected - 1) div 10) * 10 + 1"/>
  <xsl:if test="$total &gt; 1">
    <table class="page-list">
      <tr>
        <td>
          <xsl:if test="$selected &gt; 1">
            <a href="?page={$selected - 1}&amp;{$get-arg}" onclick="return locLoad();">&lt;</a>
          </xsl:if>
        </td>
        <xsl:if test="$list-start-page &gt; 1">
          <td>
            <a href="?page={$list-start-page - 1}&amp;{$get-arg}" onclick="return locLoad();">...</a>
          </td>
        </xsl:if>
        <xsl:call-template name="page-selector">
          <xsl:with-param name="count">1</xsl:with-param>
          <xsl:with-param name="selected"><xsl:value-of select="$selected"/></xsl:with-param>
          <xsl:with-param name="page"><xsl:value-of select="$list-start-page"/></xsl:with-param>
          <xsl:with-param name="total"><xsl:value-of select="$total"/></xsl:with-param>
          <xsl:with-param name="get-arg"><xsl:value-of select="$get-arg"/></xsl:with-param>
        </xsl:call-template>
        <xsl:if test="($list-start-page + 10) &lt; $total">
          <td>
            <a href="?page={$list-start-page + 10}&amp;{$get-arg}" onclick="return locLoad();">...</a>
          </td>
        </xsl:if>
        <td>
          <xsl:if test="$selected &lt; $total">
            <a href="?page={$selected + 1}&amp;{$get-arg}" onclick="return locLoad();">&gt;</a>
          </xsl:if>
        </td>
      </tr>
    </table>
  </xsl:if>
</xsl:template>

<xsl:template name="page-selector">
  <xsl:param name="count" />
  <xsl:param name="selected" />
  <xsl:param name="page" />
  <xsl:param name="total" />
  <xsl:param name="get-arg"/>

  <td>
    <xsl:choose>
      <xsl:when test="$page = $selected">
        <xsl:attribute name="class">selected</xsl:attribute>
        <xsl:value-of select="$page"/>
      </xsl:when>
      <xsl:otherwise>
        <a href="?page={$page}&amp;{$get-arg}" onclick="return locLoad();">
          <xsl:value-of select="$page"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </td>

  <xsl:if test="($page &lt; $total) and ($count &lt; 10)">
    <xsl:call-template name="page-selector">
      <xsl:with-param name="count"><xsl:value-of select="$count+1"/></xsl:with-param>
      <xsl:with-param name="selected"><xsl:value-of select="$selected"/></xsl:with-param>
      <xsl:with-param name="page"><xsl:value-of select="$page+1"/></xsl:with-param>
      <xsl:with-param name="total"><xsl:value-of select="$total"/></xsl:with-param>
      <xsl:with-param name="get-arg"><xsl:value-of select="$get-arg"/></xsl:with-param>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
