.486p
model flat
ideal

; default
Ix=640/1
Iy=480/1

; 1080p
IxMax=1920
IyMax=1080

extrn DosClose:near
extrn DevCloseDC:near
extrn DosCloseEventSem:near
extrn DosCreateThread:near
extrn DosExit:near
extrn DosFreeMem:near
extrn DosOpen:near
extrn DevOpenDC:near
extrn DosOpenEventSem:near
extrn DosPostEventSem:near
extrn DosRead:near
extrn DosSetPriority:near
extrn DosSleep:near
extrn DosWrite:near

extrn GpiBitBlt:near
extrn GpiCreateBitmap:near
extrn GpiCreatePS:near
extrn GpiDestroyPS:near
extrn GpiQueryBitmapParameters:near
extrn GpiSetBitmap:near
extrn GpiSetBitmapBits:near

extrn RexxStart:near

extrn WinBeginPaint:near
extrn WinCreateMsgQueue:near
extrn WinCreateStdWindow:near
extrn WinCreateWindow:near
extrn WinDefWindowProc:near
extrn WinDestroyMsgQueue:near
extrn WinDestroyWindow:near
extrn WinDispatchMsg:near
extrn WinEndPaint:near
extrn WinFillRect:near
extrn WinGetMsg:near
extrn WinInitialize:near
extrn WinInvalidateRect:near
extrn WinInvalidateRegion:near
extrn WinLoadString:near
extrn WinMessageBox:near
extrn WinPostMsg:near
extrn WinPostQueueMsg:near
extrn WinQuerySysValue:near
extrn WinQueryWindowRect:near
extrn WinRegisterClass:near
extrn WinSetActiveWindow:near
extrn WinSetWindowPos:near
extrn WinSubclassWindow:near
extrn WinTerminate:near

extrn connect:near
extrn recv:near
extrn send:near
extrn soclose:near
extrn socket:near

stack 8192

dataseg
ImageIx dd Ix
ImageIy dd Iy
VideoIx dd 0
VideoIy dd 0

dataseg
ImageSize dd Ix*Iy

dataseg
flCreateFlags dd 00001D3Fh
szClientClass db 'WMVIDEO - Client Window',0

udataseg
szMessageText db 255 dup(?)
szWindowTitle db 255 dup(?)

udataseg
hab dd ?
hmq dd ?
hwndClient dd ?
hwndFrame  dd ?
qmsg dd 8 dup(?)

udataseg
ActionTaken dd ?

udataseg
tidObtain dd ?

dataseg
; semaphore name
szBreak db '\SEM32\Webcam\Ctrl+C',0
; semaphore handle
sBreakEvent dd 0

codeseg
proc MainRoutine c near
arg @@Mod,@@Nul,@@Env,@@Arg
; determine begin of arguments
  cld ; operate foreward scan
  mov ecx,512 ; max scan length
  mov edi,[@@Arg] ; start address
  repne scasb ; find terminator
; process passed arguments
  call ProcessArguments
; obtain anchor block handle
  call WinInitialize c,0
  test eax,eax ; success
  jz EndProcess ; failure
  mov [hab],eax ; save
; obtain program title
  sub eax,eax ; http
  cmp [RunClient],'n'
  jb ObtainProgramTitle
  mov al,1 ; pipe
  je ObtainProgramTitle
  mov al,2 ; stdi
label ObtainProgramTitle near
; obtain appropriate program title
  call WinLoadString c,[hab],0,eax,255,offset(szWindowTitle)
  test eax,eax ; success
  jz EndMainMsgQueue ; no
; obtain message queue handle
  call WinCreateMsgQueue c,[hab],0
  test eax,eax ; success
  jz EndMainMsgQueue ; no
  mov [hmq],eax ; save
; register client window class
  call WinRegisterClass c,[hab],offset(szClientClass),offset(ClientWinProc),0,0
  test eax,eax ; success
  jz EndWindow ; failure
; create frame and client windows
  call WinCreateStdWindow c,1,0,offset(flCreateFlags),offset(szClientClass),offset(szWindowTitle),0,0,1,offset(hwndClient)
  test eax,eax ; success
  jz EndWindow ; failure
  mov [hwndFrame],eax ; save
; start obtain control thread
  call DosCreateThread c,offset(tidObtain),offset(ObtainThread),0,2,8192
label ProcessMessage near
; obtain message from the message queue
  call WinGetMsg c,[hab],offset(qmsg),0,0,0
  test eax,eax ; continue message
  jz EndProcessMessage ; quit message
; dispatch message to client window procedure
  call WinDispatchMsg c,[hab],offset(qmsg)
  jmp ProcessMessage
label EndProcessMessage near
; destroy frame and client windows
  call WinDestroyWindow c,[hwndFrame]
label EndWindow near
; release message queue handle
  call WinDestroyMsgQueue c,[hmq]
label EndMainMsgQueue near
  call WinTerminate c,[hab]
label EndProcess near
; standard input break
  cmp [RunClient],'s'
  jne EndSignalStdiBreak
  cmp [BreakEnable],'1'
  jne EndSignalStdiBreak
; open break event semaphore
  call DosOpenEventSem c,offset(szBreak),offset(sBreakEvent),0,0
; signal break event semaphore
  call DosPostEventSem c,[sBreakEvent]
; close break event semaphore
  call DosCloseEventSem c,[sBreakEvent]
label EndSignalStdiBreak near
; exit the process
  call DosExit c,1,0
endp MainRoutine

dataseg
aptl dd 4*2 dup(0)
bhMemory dw 12,0,Ix,Iy,1,24
slMemory dd 0,0

dataseg
szDeviceToken db '*',0

udataseg
hbmMemory dd ?
hdcMemory dd ?
hpsMemory dd ?
hpsWindow dd ?
rclWindow dd 4 dup(?)

dataseg
SnapShot db 0 ; done

codeseg
proc ClientWinProc c near
arg @@hwnd,@@msg,@@mp1,@@mp2
; refresh video display screen
  cmp [@@msg],23h ; WM_PAINT
  jne NotRefreshScreen
  call WinBeginPaint c,[@@hwnd],0,0
  mov [hpsWindow],eax ; save
  call GpiSetBitmapBits c,[hpsMemory],0,[ImageIy],offset(rgbBuffer),offset(bhMemory)
  call GpiBitBlt c,[hpsWindow],[hpsMemory],4,offset(aptl),0CCh,2
  call WinEndPaint c,[hpsWindow]
  mov eax,1 ; done
  ret ; return
label NotRefreshScreen near
; handle resize window
  cmp [@@msg],7 ; WM_SIZE
  jne NotResize
  call WinQueryWindowRect c,[@@hwnd],offset(rclWindow)
  call GpiQueryBitmapParameters c,[hbmMemory],offset(bhMemory)
  mov eax,[rclWindow+2*4]
  mov [aptl+2*4],eax ; xRight
  mov eax,[rclWindow+3*4]
  mov [aptl+3*4],eax ; yTop
  movzx eax,[bhMemory+2*2]
  mov [aptl+6*4],eax ; width
  movzx eax,[bhMemory+3*2]
  mov [aptl+7*4],eax ; height
  call WinInvalidateRegion c,[@@hwnd],0,0
  sub eax,eax ; reserved
  ret ; return
label NotResize near
; handle erase background
  cmp [@@msg],4Fh ; WM_ERASEBACKGROUND
  jne NotEraseBackground
; set black background
  call WinFillRect c,[@@mp1],[@@mp2],0
label EndErasebackground near
  sub eax,eax ; erased
  ret ; return
label NotEraseBackground near
; handle command input
  cmp [@@msg],20h ; WM_COMMAND
  jne NotCommand
; take snapshot
  mov eax,[@@mp1]
  cmp al,1 ; SnapShot
  jb NotSnapshot
  cmp al,2 ; TestShot
  ja NotSnapshot
  mov [SnapShot],al
label NotSnapshot near
  sub eax,eax ; reserved
  ret ; return
label NotCommand near
; handle exit monitor request
  cmp [@@msg],2Ah ; WM_QUIT
  jne NotExitMonitor
  mov eax,1 ; done
  ret ; return
label NotExitMonitor near
; create video display screen
  cmp [@@msg],1 ; WM_CREATE
  jne NotCreateScreen
  call DevOpenDC c,[hab],8,offset(szDeviceToken),0,0,0
  mov [hdcMemory],eax ; save
  call GpiCreatePS c,[hab],[hdcMemory],offset(slMemory),5008h
  mov [hpsMemory],eax ; save
  sub eax,eax ; continue
  ret ; return
label NotCreateScreen near
; destroy video display sceen
  cmp [@@msg],2 ; WM_DESTROY
  jne NotDestroyScreen
  call GpiDestroyPS c,[hpsMemory],0
  call DevCloseDC c,[hdcMemory]
  mov eax,1 ; done
  ret ; return
label NotDestroyScreen near
; pass message to default window processing
  call WinDefWindowProc c,[@@hwnd],[@@msg],[@@mp1],[@@mp2]
  ret ; return
endp ClientWinProc

udataseg
fhNPipe dd ?

udataseg
ClientSocket dd ?

dataseg
port=14225
SocketAddress db 2,0,high(port),low(port),127,0,0,1,8 dup(0) ; localhost

udataseg
; image buffer
InBuffer db IxMax*IyMax dup(?)

dataseg
szNPipe db '\PIPE\Webcam\Video',0

dataseg
; http request
Request db 'GET / HTTP:1.1',13,10
RequestLength=$-Request

dataseg
BreakEnable db '0'

dataseg
RunClient db 'n'

codeseg
proc ObtainThread c near
arg @@parameter:dword
local @@hab:dword
local @@hmq:dword
; obtain anchor block handle
  call WinInitialize c,0
  test eax,eax ; success
  jz EndObtainThread
  mov [@@hab],eax ; save
; obtain message queue handle
  call WinCreateMsgQueue c,[@@hab],0
  test eax,eax ; success
  jz EndObtainMsgQueue
  mov [@@hmq],eax ; save
; open selected client
  cmp [RunClient],'s'
  je EndOpenClient
  cmp [RunClient],'h'
  je OpenClientSocket
label TryOpenNamedPipe near
; limit maximum polling rate
  call DosSleep c,20 ; mSeconds
  call DosOpen c,offset(szNPipe),offset(fhNPipe),offset(ActionTaken),0,0,1,01A0h,0
  test eax,eax ; check for errors
  jnz TryOpenNamedPipe ; retry
  jmp EndOpenClient ; success
label OpenClientSocket near
; open http client socket
  call socket c,2,1,6 ; create
  cmp eax,-1 ; check for errors
  jne SocketCreated ; success
; show appropriate error message
  call WinLoadString c,[@@hab],0,04h,255,offset(szMessageText)
  call WinMessageBox c,1,1,offset(szMessageText),offset(szWindowTitle),0,4046h
  jmp EndSocketAttempt
label SocketCreated near
  mov [ClientSocket],eax
; connect to server socket
  call connect c,[ClientSocket],offset(SocketAddress),16
  cmp eax,-1 ; check for errors
  je CloseClient ; failure
; send http reguest to server
  call send c,[ClientSocket],offset(Request),RequestLength,0
  cmp eax,-1 ; check for errors
  je CloseClient ; failure
; point to input buffer
  mov edi,offset(InBuffer)
; obtain http header from server
  mov esi,43h ; bytes to read anyway
label ObtainHttp200Header near
; protect against buffer overflow
  cmp edi,offset(Inbuffer+IxMax*IyMax-43h)
  ja CloseClient ; failure
  call recv c,[ClientSocket],edi,esi,0
  cmp eax,-1 ; check for errors
  je CloseClient ; failure
  test eax,eax ; nothing
  jz CloseClient ; stop
  add edi,eax ; bump pointer
  mov esi,1 ; read 1 more
  cmp [dword(edi)-4],0A0D0A0Dh
  jne ObtainHttp200Header
label EndOpenClient near
; foreground server priority
  call DosSetPriority c,2,4,10,0
label TryIsochronousread near
label RawIsochronousRead near
; take usb camera snapshot
  cmp [SnapShot],1 ; take
  jne EndTakeSnapShot ; no
  mov [SnapShot],0 ; done
; write usb camera bmap image
  call rgb2bmp ; wmvideo.bmp
; write usb camera jpeg image
  call rgb2jpg ; wmvideo.jpg
; invoke rexx post processing
  call RexxStart c,1,offset(ArgList),offset(RexxFile),0,0,0,0,offset(ReturnCode),offset(Result)
  test eax,eax ; return code
  jnz EndFreeString ; failure
; handle exit/return value
  mov edi,[Result+4] ; buffer
  test edi,edi ; allocated
  jz EndFreeString ; no
; show exit/return string
  cmp eax,[Result] ; empty
  je EndShowString ; yes
  mov [Result],eax ; empty
  call WinMessageBox c,1,1,edi,offset(szWindowTitle),0,4030h
label EndShowString near
; free allocated storage
  call DosFreeMem c,edi
  test eax,eax ; any errors
  jnz EndFreeString ; failure
  mov [Result+4],eax ; free
label EndFreeString near
label EndTakeSnapShot near
; point to input buffer
  mov edi,offset(InBuffer)
; obtain mime headers from server
  mov esi,40h ; bytes to read anyway
label ObtainMimeHeader near
; protect against buffer overflow
  cmp edi,offset(Inbuffer+IxMax*IyMax-40h)
  ja TryIsochronousRead ; retry
; read from selected client
  cmp [RunClient],'h'
  je ReceiveMimeHeader
; obtain mime header from named pipe or standard input
  call DosRead c,[fhNPipe],edi,esi,offset(BytesDone)
  test eax,eax ; check for errors
  jnz CloseClient ; failure
  mov eax,[BytesDone]
  test eax,eax ; nothing
  jz CloseClient ; stop
  mov [BreakEnable],'1'
  jmp CheckMimeHeader
label ReceiveMimeHeader near
; obtain mime header from http server
  call recv c,[ClientSocket],edi,esi,0
  cmp eax,-1 ; check for errors
  je CloseClient ; failure
  test eax,eax ; nothing
  jz CloseClient ; stop
label CheckMimeHeader near
  add edi,eax ; bump pointer
  mov esi,1 ; read 1 more
  cmp [dword(edi)-4],0A0D0A0Dh
  jne ObtainMimeHeader
; convert Content-Length
  mov edi,offset(InBuffer+61)
  call dec2bin ; convert
  mov esi,edx ; image size
; point to input buffer
  mov edi,offset(InBuffer)
; obtain image data from server
label ObtainImageData near
; protect against buffer overflow
  cmp edi,offset(Inbuffer+IxMax*IyMax-4096)
  ja TryIsochronousRead ; retry input
  mov eax,esi ; image size
  cmp eax,4096 ; maximum
  jna NotTooLargeSize
  mov eax,4096 ; maximum
label NotTooLargeSize near
; obtain image data
  cmp [RunClient],'h'
  je ReceiveImageData
; obtain image data from named pipe or standard input
  call DosRead c,[fhNPipe],edi,eax,offset(BytesDone)
  test eax,eax ; check for errors
  jnz CloseClient ; failure
  mov eax,[BytesDone]
  test eax,eax ; nothing
  jz CloseClient ; stop
  jmp CheckImageData
label ReceiveImageData near
; obtain image data from http server
  call recv c,[ClientSocket],edi,eax,0
  cmp eax,-1 ; check for errors
  je CloseClient ; failure
  test eax,eax ; nothing
  jz CloseClient ; stop
label CheckImageData near
  add edi,eax ; next address
  sub esi,eax ; remaining
  jnz ObtainImageData
; point to input buffer
  mov esi,offset(InBuffer)
; take usb camera testshot
  cmp [SnapShot],2 ; take
  jne EndTakeTestShot ; no
  mov [SnapShot],0 ; done
; write usb camera jpeg image
  call jpg2raw ; wmvideo.raw
label EndTakeTestShot near
; verify mjpg image present
  cmp [word(esi+0)],0D8FFh
  jne RawIsochronousRead
  cmp [word(edi-2)],0D9FFh
  jne RawIsochronousRead
; make rgb from mjpg
  mov [GoodImage],1
  call jpg2rgb
  cmp [GoodImage],1
  jne RawIsochronousRead
; check proper bitmap
  mov eax,[ImageIx]
  mov edx,[ImageIy]
  cmp eax,[VideoIx]
  jne UpdateBitmap
  cmp edx,[VideoIy]
  jne UpdateBitmap
; still proper bitmap
; trigger presentation manager screen update
  call WinInvalidateRect c,[hwndClient],0,0
  jmp RawIsochronousRead
label UpdateBitmap near
; save new dimensions
  mov [VideoIx],eax
  mov [VideoIy],edx
; create proper bitmap
  mov [bhMemory+2*2],ax
  mov [bhMemory+3*2],dx
  call GpiCreateBitmap c,[hpsMemory],offset(bhMemory),0,0,0
  mov [hbmMemory],eax
; put bitmap in presentation space
  call GpiSetBitmap c,[hpsMemory],[hbmMemory]
; trigger presentation manager screen update
  call WinInvalidateRect c,[hwndClient],0,0
; calculate frame dimensions
; calculate frame width
  mov edi,[ImageIx] ; image width
  call WinQuerySysValue c,1,28 ; SV_CXDLGFRAME
  lea edi,[eax*2+edi] ; plus borders
; calculate frame height
  mov esi,[ImageIy] ; image height
  call WinQuerySysValue c,1,29 ; SV_CYDLGFRAME
  lea esi,[eax*2+esi] ; plus borders
  call WinQuerySysValue c,1,30 ; SV_CYTITLEBAR
  lea esi,[eax+esi] ; plus title bar
  call WinQuerySysValue c,1,35 ; SV_CYMENU
  lea esi,[eax+esi] ; plus menu bar
; calculate frame horizontal position
  call WinQuerySysValue c,1,20 ; SV_CXSCREEN
  mov ebx,eax ; screen width
  sub ebx,edi ; frame width
  sar ebx,1 ; center position
; calculate frame vertical position
  call WinQuerySysValue c,1,21 ; SV_CYSCREEN
  sub eax,esi ; frame height
  sar eax,1 ; center position
; resize and show webcam monitor
  call WinSetWindowPos c,[hwndFrame],0,ebx,eax,edi,esi,108Bh
  test eax,eax ; success
  jnz RawIsochronousRead ; yes
  call ShowReturnCode ; failure
; show appropriate error message
  call WinLoadString c,[@@hab],0,03h,244,offset(szMessageText+11)
  call WinMessageBox c,1,1,offset(szMessageText),offset(szWindowTitle),0,4046h
  call WinPostQueueMsg c,[hmq],2Ah,0,0 ; WM_QUIT
label CloseClient near
; close selected client
  cmp [RunClient],'s'
  je EndObtainMsgQueue
  cmp [RunClient],'h'
  je CloseClientSocket
; close named pipe
  call DosClose c,[fhNPipe]
  jmp TryOpenNamedPipe ; again
label CloseClientSocket near
; close http client socket
  call soclose c,[ClientSocket]
  cmp eax,-1 ; check for errors
; limit maximum polling rate
  call DosSleep c,20 ; mSeconds
  jmp OpenClientSocket ; again
label EndSocketAttempt near
; mov [ClientSocket],0
label EndObtainMsgQueue near
  call WinTerminate c,[@@hab]
label EndObtainThread near
; exit the obtain thread
  call DosExit c,0,0
endp ObtainThread

dataseg
hex2ascii db '0123456789ABCDEF'

codeseg
proc ShowReturnCode near
; prepare message text
  lea edi,[szMessageText]
  mov [byte(edi+0Ah)],' '
  mov [byte(edi+09h)],']'
  mov [byte(edi)],'['
; convert return code
  sub ecx,ecx ; count
  sub edx,edx ; index
  mov cl,08h ; digits
label ConvertDigit near
  mov dl,al ; one byte
  and dl,0Fh ; hex digit
  mov dl,[hex2ascii+edx]
  mov [edi+ecx],dl ; ascii
  shr eax,4 ; next one
  loop ConvertDigit
  ret ; return
endp ShowReturnCode

udataseg
outBuffer db IxMax*IyMax*1 dup(?)
rgbBuffer db IxMax*IyMax*3 dup(?)

dataseg
RexxFile db 'wmvideo.cmd',0

udataseg
ArgList dd ?,?
ReturnCode dd ?
Result dd ?,?

dataseg
bmpFileHeader dw 4D42h,0,0,0,0,14+12,0,12,0,Ix,Iy,1,24
szOutput db 'wmvideo.bmp',0

udataseg
BytesDone dd ?
fhOutput dd ?

codeseg
proc rgb2bmp near
; write usb camera bitmap file
  call DosOpen c,offset(szOutput),offset(fhOutput),offset(ActionTaken),0,0,012h,0191h,0
  test eax,eax ; check for errors
  jnz NotBitmap ; failure
; update bitmap file header
  mov edx,offset(bmpFileHeader)
  mov eax,[ImageIy] ; Iy
  mov [edx+20],ax ; height
  mov eax,[ImageIx] ; Ix
  mov [edx+18],ax ; width
  mov eax,[ImageSize] ; Ix*Iy
  lea edi,[eax*2+eax+14+12]
  mov [edx+2],edi ; file size
; write bitmap file header
  call DosWrite c,[fhOutput],edx,14+12,offset(BytesDone)
  test eax,eax ; check for errors
  jnz EndBitmap ; failure
; write bitmap file data
  lea edi,[edi-14-12] ; header size
  call DosWrite c,[fhOutput],offset(rgbBuffer),edi,offset(BytesDone)
  test eax,eax ; check for errors
  jnz EndBitmap ; failure
label EndBitmap near
; close bmp output file
  call DosClose c,[fhOutput]
label NotBitmap near
  ret ; return
endp rgb2bmp

dataseg
zsOutput db 'wmvideo.raw',0

codeseg
proc jpg2raw near
; write usb camera jpeg file
  call DosOpen c,offset(zsOutput),offset(fhOutput),offset(ActionTaken),0,0,012h,0191h,0
  test eax,eax ; check for errors
  jnz NotOutput ; failure
  mov eax,edi ; after
  sub eax,esi ; start
  call DosWrite c,[fhOutput],esi,eax,offset(BytesDone)
; close raw output file
  call DosClose c,[fhOutput]
label NotOutput near
  ret ; return
endp jpg2raw

codeseg
proc dec2bin near
; decimal to binary
  sub eax,eax ; input
  sub edx,edx ; output
label ConvertInput near
  inc edi ; next position
  mov al,[edi] ; digit
; convert decimal digit
  cmp al,'0' ; minimum
  jb Enddec2bin ; done
  cmp al,'9' ; maximum
  ja Enddec2bin ; done
  sub al,'0' ; digit
  lea edx,[edx*4+edx]
  lea edx,[edx*2+eax]
  jmp ConvertInput
label Enddec2bin Near
  ret ; return
endp dec2bin

codeseg
proc ProcessArguments near
; scan for forward slash
  mov al,[edi] ; character
  inc edi ; next position
  cmp al,00h ; terminator
  je EndScanString ; done
  cmp al,'/' ; parameter
  jne ProcessArguments
; http client argument
  cmp [byte(edi)],'h'
  jne NotHttpClient
  mov [RunClient],'h'
  jmp ProcessArguments
label NotHttpClient near
; stdin client argument
  cmp [byte(edi)],'s'
  jne NotStdiClient
  mov [RunClient],'s'
  jmp ProcessArguments
label NotStdiClient near
; tcp/ip addr argument
  cmp [byte(edi)],'a'
  jne NotIpAddress
  call dec2bin ; convert
  shrd ebx,edx,8 ; keep
; check 1st ip number
  shr edx,8 ; zeroes
  jnz ProcessArguments
  cmp [byte(edi)],'.'
  jne ProcessArguments
  call dec2bin ; convert
  shrd ebx,edx,8 ; keep
; check 2nd ip number
  shr edx,8 ; zeroes
  jnz ProcessArguments
  cmp [byte(edi)],'.'
  jne ProcessArguments
  call dec2bin ; convert
  shrd ebx,edx,8 ; keep
; check 3rd ip number
  shr edx,8 ; zeroes
  jnz ProcessArguments
  cmp [byte(edi)],'.'
  jne ProcessArguments
  call dec2bin ; convert
  shrd ebx,edx,8 ; keep
; check 4th ip number
  shr edx,8 ; zeroes
  jnz ProcessArguments
; store validated ip address
  mov [dword(SocketAddress+4)],ebx
  jmp ProcessArguments
label NotIpAddress near
; tcp/ip port argument
  cmp [byte(edi)],'p'
  jne ProcessArguments
  call dec2bin ; convert
; check tcp/ip port number
  cmp edx,0FFFFh ; max
  ja ProcessArguments
  cmp edx,00400h ; min
  jb ProcessArguments
; store tcp/ip port number
  mov [SocketAddress+3],dl
  mov [SocketAddress+2],dh
  jmp ProcessArguments
label EndScanString near
; skip sanity checks
  ret ; return
endp ProcessArguments

include 'wmvideo.inc'

end MainRoutine
