/* $Id: globals.h,v 1.21 1998/03/16 20:35:08 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/



#ifndef GLOBALS_H
#define GLOBALS_H

#ifdef DEFINE_GLOBALS
#define EXTERN
#else
#define EXTERN extern
#endif

#ifndef DATA_STRUCT_H
#include "dataStruct.h"
#endif /*DATA_STRUCT_H*/

#ifndef _MSG_H_
#include "msg.h"
#endif /*_MSG_H_*/

/* main data structure */
EXTERN WVT_CODEC mzte_codec;

/* for displaying state information */
EXTERN Char *mapStateToText[]
#ifdef DEFINE_GLOBALS
 = {"S_ROOT", "S_NZ", "S_LEAF", "S_RVAL", "S_RVZTR", "S_RLEAF", "S_DC"}
#endif
;

/* for displaying Type information */
EXTERN Char *mapTypeToText[]
#ifdef DEFINE_GLOBALS
 =  {"IZ", "VAL", "ZTR", "VZTR", "ZTR_D", "VLEAF", "ZLEAF",
     "UNTYPED"}
#endif
;

/* for displaying arithmetic probability model information */
EXTERN Char *mapArithModelToText[]
#ifdef DEFINE_GLOBALS
= {"ACM_NONE", "ACM_SKIP", "ACM_ROOT", "ACM_VALZ", "ACM_VALNZ", "ACM_RESID",
  "ACM_DC"}
#endif
;

/* Maps the state to the arithmetic codeing probability model. */
EXTERN Int stateToProbModel[] 
#ifdef DEFINE_GLOBALS
 = {ACM_ROOT, ACM_VALNZ, ACM_VALZ, ACM_RESID, ACM_RESID, ACM_RESID, ACM_DC}
#endif
;


/* The filename (sans suffix) where the coefficient info. during 
   the encoding phase is written. */
EXTERN Char *mapFileEnc
#ifdef DEFINE_GLOBALS
="mapEnc"
#endif
;

/* The filename (sans suffix) where the coefficient info. during 
   the decoding phase is written. */
EXTERN Char *mapFileDec
#ifdef DEFINE_GLOBALS
="mapDec"
#endif
;

/* Variables to keep track of quantization values. Used when calaculating
   number of residual levels */
EXTERN Int *prevQList[3];
EXTERN Int *prevQList2[3];
EXTERN Int *scaleLev[3];


/* Probability model orders for arithmetic coder */
#define AC_MODEL_ZEROTH 0
#define AC_MODEL_FIRST  1
#define AC_MODEL_MIXED  99

/* Some arithmetic functions - be careful about using expressions
   in these as they may be calculated twice.
*/
#ifndef ABS
#define ABS(x) (((x)<0) ? -(x) : (x))
#endif
#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif

/*----- shorthand for accessing global information -----*/
#define USER_Q(c) (mzte_codec.SPlayer[c].SNRlayer.snr_image.quant)
#define ROOT_MAX(c) (mzte_codec.SPlayer[c].SNRlayer.snr_image.root_max)
#define VALZ_MAX(c) (mzte_codec.SPlayer[c].SNRlayer.snr_image.valz_max)
#define VALNZ_MAX(c) (mzte_codec.SPlayer[c].SNRlayer.snr_image.valnz_max)
#define RESID_MAX(c) (mzte_codec.SPlayer[c].SNRlayer.snr_image.residual_max)
#define ALL_ZERO(c) (mzte_codec.SPlayer[c].SNRlayer.snr_image.allzero)
#define COEFF_VAL(x,y,c) \
  (mzte_codec.SPlayer[c].coeffinfo[y][x].quantized_value)
#define COEFF_ORGVAL(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].wvt_coeff)
#define COEFF_RECVAL(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].rec_coeff)
#define COEFF_QSTATE(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].qState)
#define COEFF_STATE(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].state)
#define COEFF_TYPE(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].type)
#define COEFF_SKIP(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].skip)
#define COEFF_MASK(x,y,c) (mzte_codec.SPlayer[c].coeffinfo[y][x].mask)
#define snrStartCode (mzte_codec.SNR_start_code_enable)

#endif /*GLOBALS_H*/
