/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   M. Eckert (UPM / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Fernando Jaureguizar (UPM / ACTS-MoMuSyS)
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *   Michael Wollborn (TUH / ACTS-MoMuSys)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        io_sharp.c
 *
 * Author:      UPM - M. Eckert
 * Created:     12.03.96
 *
 * Description: IO-Functions to read and write a VOP in raw format
 *
 * Notes:
 *
 * Modified:    21.03.96 UPM - F. Jaureguizar: several modifications added.
 *              21.04.96 Robert Danielsen: Reformatted. New headers.
 *              02.07.96 UPM - F. Jaureguizar: Reformatted.
 *		18.11.97 M.Wollborn: include unistd only for non-PC
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include <stdlib.h>

#if !defined(WIN32)
#  include <unistd.h>
#endif

#include "momusys.h"
#include "mom_structs.h"
#include "mom_vop.h"
#include "io_sharp.h"

/***********************************************************CommentBegin******
 *
 * -- ReadVopSHARP --
 *
 * Author :
 *      UPM - M. Eckert
 *
 * Created :
 *      12.03.96
 *
 * Purpose :
 *
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *      21.03.96 UPM - F. Jaureguizar.
 *
 ***********************************************************CommentEnd********/

Void
ReadVopSHARP(Char   *y_file,
	     Char   *u_file, /* always ignored  */
	     Char   *v_file, /* always ignored  */
             Char   *alpha_file,
             Int    frame,
             Char   *format,     /* always ignored  */
             Vop    *vop,
	     Int    alpha_read)
{
  FILE   *fichero;
  Byte   *data;
  Int    i, j, error;
  Int    height, width;
  Int    size_y, size_uv,framesize;
  char   framefilename[ 256 ];
  char   framenumstr[ 16 ]; 

  height = vop->y_chan->y;
  width  = vop->y_chan->x;

  size_y  = width * height;
  size_uv = size_y / 4;
  framesize = size_y + 2 * size_uv;

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - READING INPUT FILES - \n");
#endif
  
  data = (Byte *)malloc(framesize * sizeof(Byte));
  /* No. of bits we have to skip to reach the frame */
  strcpy( &framefilename[ 0 ] , y_file );
  sprintf( &framenumstr[ 0 ] , "%d" , (int)frame );
  strcat( &framefilename[ 0 ] , &framenumstr[ 0 ] );
  if((fichero = fopen ( framefilename ,"rb"))==NULL)
    {
      perror( framefilename );
      return;
    }
  /* The data */
  error = fread ((Char*)data, size_y, 1, fichero);
  if (error == 0)
    fprintf(stderr," - ERROR: input Y-Data incomplete\n");

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      vop->y_chan->data->s[i*width + j] = (Byte) data[i*width + j];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Read Y-Data\n");
#endif
  /************************** U_Data ***************************/

  /* The data */
  error = fread ((Char*)data, size_uv, 1, fichero);
  if (error == 0)
    fprintf(stderr," - ERROR: input U-Data incomplete\n");

  for(i = 0; i < height/2; i++)
    for(j = 0; j < width/2; j++)
      vop->u_chan->data->s[i*width/2 + j]= (Byte) data[i*width/2 + j];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Read U-Data\n");
#endif

  /************************** V_Data ***************************/

  /* The data */

  error = fread ((Char*)data, size_uv, 1, fichero);
  if (error == 0)
    fprintf(stderr," - ERROR: input V-Data incomplete\n");

  for(i = 0; i < height/2; i++)
    for(j = 0; j < width/2; j++)
      vop->v_chan->data->s[i*width/2 + j] = (Byte) data[i*width/2 + j];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Read V-Data\n");
#endif

  fclose (fichero);

  /************************** Alpha_Data ***********************/
  if(alpha_read){
      strcpy( &framefilename[ 0 ] , alpha_file );
      sprintf( &framenumstr[ 0 ] , "%d" , (int)frame );
      strcat( &framefilename[ 0 ] , &framenumstr[ 0 ] );
      if((fichero = fopen ( framefilename ,"rb"))==NULL){
          perror( framefilename );
          return;
      }
      /* The data */
      error = fread ((Char*)data, size_y, 1, fichero);
      if (error == 0)
        fprintf(stderr," - ERROR: input Alpha-Data incomplete\n");
    
      for(i = 0; i < height; i++)
        for(j = 0; j < width; j++)
          vop->a_chan->data->s[i*width + j] = (Short) data[i*width + j];
    #ifdef _DEBUG_
      fprintf(stdout,"\t\t - Read Alpha-Data\n");
    #endif
      fclose (fichero);
  }


  
  free((Char*)data);
}

/***********************************************************CommentBegin******
 *
 * -- WriteVopRAW --
 *
 * Author :
 *      UPM - M. Eckert
 *
 * Created :
 *      12.03.96
 *
 * Purpose :
 *
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *      21.03.96 UPM - F. Jaureguizar.
 *
 ***********************************************************CommentEnd********/

Void
WriteVopSHARP(Vop    *vop,
            Char   *y_file,
            Char   *u_file,     /* always ignored  */
            Char   *v_file,     /* always ignored  */
            Char   *alpha_file,
            Int    number,
            Char   *format,     /* always ignored  */
            Char   *mode,		/* always ignored  */
            Int    write_alpha)
{
  FILE   *fichero;
  Int    height    = vop->a_chan->y;
  Int    width     = vop->a_chan->x;
  Int    height_uv = vop->a_chan->y/2;
  Int    width_uv  = vop->a_chan->x/2;
  Int    i, j;
  Char   datum;
  SInt   *data;
  Char	 file_and_number[ 100 ];
  Char	 alph_and_number[ 100 ];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - WRITING OUTPUT FILES - \n");
#endif
  sprintf(file_and_number, "%s%d", y_file, (int)number);
  sprintf(alph_and_number, "%s%d", alpha_file, (int)number);

  /************************** Y_Data ***************************/

    if((fichero = fopen (file_and_number,"wb"))==NULL)
      {
      fprintf(stderr," - ERROR: can not open Y file\n");
      return;
      }

  data = vop->y_chan->data->s;

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      {
      datum = (Char)data[i*width+j];
      fwrite (&datum, 1, 1, fichero);
      }

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Wrote Y-Data\n");
#endif

  fclose (fichero);

  /************************** U_Data ***************************/

    if ((fichero = fopen (file_and_number,"ab"))==NULL)
      {
      fprintf(stderr," - ERROR: can not open U file\n");
      return;
      }

  data = vop->u_chan->data->s;

  for(i = 0; i < height_uv; i++)
    for(j = 0; j < width_uv; j++)
      {
      datum = (Char)data[i*width_uv+j];
      fwrite (&datum, 1, 1, fichero);
      }

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Wrote U-Data \n");
#endif

  fclose (fichero);

  /************************** V_Data ***************************/

    if ((fichero = fopen (file_and_number,"ab"))==NULL)
      {
      fprintf(stderr," - ERROR: can not open V file error\n");
      return;
      }

  data = vop->v_chan->data->s;

  for(i = 0; i < height_uv; i++)
    for(j = 0; j < width_uv; j++)
      {
      datum = (Char)data[i*width_uv+j];
      fwrite (&datum, 1, 1, fichero);
      }

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Wrote V-Data\n");
#endif

  fclose (fichero);

  /************************ Alpha_Data *************************/

  if (write_alpha)
    {
      if((fichero = fopen (alph_and_number,"wb"))==NULL)
        {
        fprintf(stderr," - ERROR: can not open Alpha file\n");
        return;
        }

    data = vop->a_chan->data->s;

    for(i = 0; i < height; i++)
      for(j = 0; j < width; j++)
        {
        datum = (Char)data[i*width+j];
        fwrite (&datum, 1, 1, fichero);
        }

#ifdef _DEBUG_
    fprintf(stdout,"\t\t - Wrote Alpha-Data\n");
#endif

    fclose (fichero);
    }
}

/*******************************************
*               ReadAlpha                  *
********************************************/
 
Void
ReadAlpha(Char   *alpha_file,
          Int    frame,
          Char   *format,     
          Vop    *vop)
{
  FILE   *fichero;
  Byte   *data;
  Int    i, j, error;
  Int    height, width;
  Int    size_y;
  char   framefilename[ 256 ];
  char   framenumstr[ 16 ]; 

  height = vop->y_chan->y;
  width  = vop->y_chan->x;

  size_y  = width * height;
  data = (Byte *)malloc(size_y * sizeof(Byte));
  
  
  /************************** Alpha_Data ***********************/
  strcpy( &framefilename[ 0 ] , alpha_file );
  sprintf(&framenumstr[ 0 ]  , "%d" , (int)frame );
  strcat( &framefilename[ 0 ] , &framenumstr[ 0 ] );
  
  if((fichero = fopen ( framefilename ,"rb"))==NULL){
      perror( framefilename );
      return;
  }
  /* The data */
  error = fread ((Char*)data, size_y, 1, fichero);
  if (error == 0)
        fprintf(stderr," - ERROR: input Alpha-Data incomplete\n");

  for(i = 0; i < height; i++)
        for(j = 0; j < width; j++)
              vop->a_chan->data->s[i*width + j] = (Short) data[i*width + j];

  fclose (fichero);
  free((Char*)data);
}

/******************************************
*               WriteAlpha                *
*******************************************/
Void
WriteAlpha(Vop     *vop,
            Char   *alpha_file,
            Int    number,
            Char   *format,     /* always ignored  */
            Char   *mode,	/* always ignored  */
            Int    write_alpha)
{
  FILE   *fichero;
  Int    height    = vop->a_chan->y;
  Int    width     = vop->a_chan->x;
  
  /*Int    height_uv = vop->a_chan->y/2;
  Int    width_uv  = vop->a_chan->x/2;*/
  
  Int    i, j;
  Char   datum;
  SInt   *data;
  Char	 alph_and_number[ 100 ];

  sprintf(alph_and_number, "%s%d", alpha_file, (int)number);
  if (write_alpha)
    {
      if((fichero = fopen (alph_and_number,"wb"))==NULL)
        {
        fprintf(stderr," - ERROR: can not open Alpha file\n");
        return;
        }

    data = vop->a_chan->data->s;
    for(i = 0; i < height; i++)
      for(j = 0; j < width; j++)
        {
        datum = (Char)data[i*width+j];
        fwrite (&datum, 1, 1, fichero);
        }
    fclose (fichero);
    }
}


