/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;

public class TeletextPageMatrix
extends JFrame {
    public Picture picture;
    private String title = Resource.getString("ttpagematrix.title");
    private int w = 310;
    private int h = 410;

    public TeletextPageMatrix() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TeletextPageMatrix.this.close();
            }
        });
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
        this.picture = new Picture();
        this.getContentPane().add("Center", this.picture);
        this.setTitle(this.title);
        ((Component)this).setSize(new Dimension(this.w, this.h));
        ((Component)this).setLocation(100, 100);
        this.setResizable(false);
    }

    public void close() {
        this.dispose();
    }

    public class Picture
    extends JPanel {
        private Color[] color = new Color[]{Color.red, Color.yellow, Color.green, new Color(255, 144, 0), new Color(144, 144, 255), Color.cyan, Color.magenta, Color.white, Color.black, new Color(0, 200, 0)};
        private BufferedImage bimg;
        private Graphics2D big;
        private int x = 0;
        private int y = 0;

        public Picture() {
            this.bimg = new BufferedImage(TeletextPageMatrix.this.w, TeletextPageMatrix.this.h, 1);
            this.big = this.bimg.createGraphics();
            this.big.setFont(new Font("Sans Serif", 0, 12));
            this.setBackground(this.color[8]);
            this.setToolTipText(Resource.getString("ttpagematrix.tip"));
            this.init();
        }

        public void init() {
            this.init("");
        }

        public void init(String string) {
            this.x = 0;
            this.y = 0;
            this.big.setColor(this.color[8]);
            this.big.fillRect(0, 0, TeletextPageMatrix.this.w, TeletextPageMatrix.this.h);
            this.big.setColor(this.color[7]);
            this.big.drawString(String.valueOf(Resource.getString("ttpagematrix.file")) + ": " + string, this.x + 10, this.y + 14);
            this.y += 16;
            this.big.drawString(String.valueOf(Resource.getString("ttpagematrix.composition1")) + ": ", this.x + 10, this.y + 14);
            this.big.drawString(Resource.getString("ttpagematrix.composition2"), this.x + 20, this.y + 30);
            this.big.drawString(String.valueOf(Resource.getString("ttpagematrix.composition3")) + ":", this.x + 10, this.y + 46);
            int n = 0;
            while (n < 8) {
                this.big.drawString(" = " + (n + 1), this.x + 28 + (n << 5), this.y + 62);
                ++n;
            }
            int n2 = 0;
            while (n2 < 8) {
                this.big.setColor(this.color[n2]);
                this.big.fillRect(this.x + 22 + (n2 << 5), this.y + 52, 3, 12);
                ++n2;
            }
            this.big.setColor(this.color[7]);
            this.big.drawString("X", this.x + 40, this.y + 80);
            this.big.drawString("Y", this.x + 8, this.y + 113);
            this.x += 20;
            this.y += 84;
            int n3 = 0;
            while (n3 < 16) {
                this.big.drawString(Integer.toHexString(n3).toUpperCase(), this.x + 20 + (n3 << 4), this.y + 12);
                this.big.drawString(Integer.toHexString(n3).toUpperCase(), this.x + 5, this.y + 29 + (n3 << 4));
                ++n3;
            }
            this.big.setColor(this.color[9]);
            int n4 = 1;
            while (n4 < 18) {
                this.big.drawLine(this.x, this.y + (n4 << 4), this.x + 272, this.y + (n4 << 4));
                this.big.drawLine(this.x + (n4 << 4), this.y, this.x + (n4 << 4), this.y + 272);
                ++n4;
            }
            this.x += 18;
            this.y += 19;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (this.big == null) {
                return;
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void update(String string) {
            int n = Integer.parseInt(string, 16);
            int n2 = (0xF & n >>> 8) - 1;
            if (n2 < 0) {
                return;
            }
            int n3 = this.x + (0xF0 & n) + ((3 & n2) << 2);
            int n4 = this.y + (0xF0 & n << 4) + ((4 & n2) != 0 ? 6 : 0);
            if ((0xFFFFFF & this.bimg.getRGB(n3, n4)) != 0) {
                return;
            }
            this.big.setColor(this.color[n2]);
            this.big.fillRect(n3, n4, 2, 5);
            if (TeletextPageMatrix.this.picture.isVisible()) {
                this.repaint();
            }
        }
    }
}

