/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.Video;

public class Gop {
    private byte[] headerrescue = new byte[1];
    private long VbvBuffer_Value = 0L;
    private boolean progressive_sequence = false;
    private long total_pulldownfields = 0L;
    private boolean Debug;
    private boolean CreateD2vIndex;
    private boolean SplitProjectFile;
    private boolean AddSequenceHeader;
    private boolean Message_3;
    private boolean AddSequenceDisplayExension;
    private boolean PatchToProgressive;
    private boolean PatchToInterlaced;
    private boolean ToggleFieldorder;
    private boolean ClearCDF;
    private boolean Save1stFrameOfGop;
    private boolean Preview_AllGops;
    private boolean Preview_fastDecode;
    private boolean TrimPts;
    private boolean IgnoreErrors;
    private boolean OptionDAR;
    private boolean OptionHorizontalResolution;
    private boolean WriteVideo;
    private boolean InsertEndcode;
    private boolean DumpDroppedGop;
    private boolean UseGOPEditor;
    private int ChangeBitrateInAllSequences;
    private int ChangeVbvDelay;
    private int CutMode;
    private int ExportDAR;
    private int ChangeAspectRatio;
    private int ChangeVbvBuffer;
    private int Preview_YGain;
    private String ExportHorizontalResolution;
    private String SDE_Value;
    private JobProcessing job_processing;

    public Gop(JobCollection jobCollection) {
        this.getSettings(jobCollection);
    }

    private int getBits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[0] >>> 3;
        if (n == 0) {
            return 0;
        }
        if (n2 >= byArray.length - 4) {
            nArray[0] = nArray[0] + n;
            return -1;
        }
        int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
        n3 <<= nArray[0] & 7;
        nArray[0] = nArray[0] + n;
        return n3 >>>= 32 - n;
    }

    private int getCodeNum(byte[] byArray, int[] nArray) {
        int n = -1;
        int n2 = 0;
        while (n2 == 0) {
            n2 = this.getBits(byArray, nArray, 1);
            ++n;
        }
        int n3 = (1 << n) - 1 + this.getBits(byArray, nArray, n);
        return n3;
    }

    private void getSettings(JobCollection jobCollection) {
        this.Debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.CreateD2vIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createD2vIndex);
        this.SplitProjectFile = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile);
        this.AddSequenceHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addSequenceHeader);
        this.Message_3 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg3);
        this.AddSequenceDisplayExension = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addSde);
        this.PatchToProgressive = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_patchToProgressive);
        this.PatchToInterlaced = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_patchToInterlaced);
        this.ToggleFieldorder = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_toggleFieldorder);
        this.ClearCDF = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_clearCDF);
        this.Save1stFrameOfGop = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_save1stFrameOfGop);
        this.Preview_AllGops = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Preview_AllGops);
        this.Preview_fastDecode = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Preview_fastDecode);
        this.TrimPts = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Video_trimPts);
        this.IgnoreErrors = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Video_ignoreErrors);
        this.OptionDAR = jobCollection.getSettings().getBooleanProperty(Keys.KEY_OptionDAR);
        this.OptionHorizontalResolution = jobCollection.getSettings().getBooleanProperty(Keys.KEY_OptionHorizontalResolution);
        this.WriteVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeVideo);
        this.InsertEndcode = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_insertEndcode);
        this.DumpDroppedGop = jobCollection.getSettings().getBooleanProperty(Keys.KEY_dumpDroppedGop);
        this.ChangeBitrateInAllSequences = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInAllSequences);
        this.ChangeVbvDelay = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeVbvDelay);
        this.CutMode = jobCollection.getSettings().getIntProperty(Keys.KEY_CutMode);
        this.ExportDAR = jobCollection.getSettings().getIntProperty(Keys.KEY_ExportDAR);
        this.ChangeAspectRatio = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeAspectRatio);
        this.ChangeVbvBuffer = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeVbvBuffer);
        this.Preview_YGain = jobCollection.getSettings().getIntProperty(Keys.KEY_Preview_YGain);
        this.ExportHorizontalResolution = jobCollection.getSettings().getProperty(Keys.KEY_ExportHorizontalResolution);
        this.SDE_Value = jobCollection.getSettings().getProperty(Keys.KEY_VideoPanel_SdeValue);
        this.UseGOPEditor = jobCollection.getSettings().getBooleanProperty(Keys.KEY_useGOPEditor);
    }

    private int getSignedCodeNum(byte[] byArray, int[] nArray) {
        int n = this.getCodeNum(byArray, nArray);
        n = (n & 1) == 0 ? n >>> 1 : -(n >>> 1);
        return n;
    }

    public void goptest(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2) {
        this.goptest(jobProcessing, iDDBufferedOutputStream, byArray, byArray2, dataOutputStream, string, nArray, list, list2, true);
    }

    public void goptest(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2, boolean bl) {
        long l;
        int n;
        int n2;
        int n3;
        int[] nArray2 = jobProcessing.getStatusVariables();
        int n4 = 0;
        Object[] objectArray = jobProcessing.getStatusStrings();
        Common.setFps(jobProcessing.getSourceVideoFrameNumber());
        if (byArray.length < 12) {
            Common.setMessage(Resource.getString("video.msg.error.lackofdata", String.valueOf(nArray2[6])));
            return;
        }
        if (byArray2.length == 0) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < byArray.length - 7) {
                n3 = CommonParsing.validateStartcode(byArray, n6);
                if (n3 < 0) {
                    n6 += -n3;
                    continue;
                }
                n2 = CommonParsing.getPES_IdField(byArray, n6);
                if (n2 == 184) {
                    d2 = 90.0 * (3600000.0 * (double)((0x7C & byArray[n6 + 4]) >>> 2) + 60000.0 * (double)((3 & byArray[n6 + 4]) << 4 | (0xF0 & byArray[n6 + 5]) >>> 4) + 1000.0 * (double)((7 & byArray[n6 + 5]) << 3 | (0xE0 & byArray[n6 + 6]) >>> 5) + (double)((0x1F & byArray[n6 + 6]) << 1 | (0x80 & byArray[n6 + 7]) >>> 7) * (CommonParsing.getVideoFramerate() / 90.0));
                    n6 += 7;
                    continue;
                }
                if (n2 == 0) {
                    n5 = n6;
                    d4 = CommonParsing.getVideoFramerate() * (double)((0xFF & byArray[n6 + 4]) << 2 | (0xC0 & byArray[n6 + 5]) >>> 6);
                    d = d4 + (double)jobProcessing.getEndPtsOfGop();
                    break;
                }
                n6 += 4;
            }
            d3 = d2 - (double)jobProcessing.getLastGopTimecode();
            if (d3 >= 0.0 && d3 < 2.7E7) {
                d = (double)jobProcessing.getLastGopPts() + d3 + d4;
                Common.setMessage(Resource.getString("video.msg.error.nopts.use_goptc", String.valueOf(nArray2[6])));
            } else {
                Common.setMessage(Resource.getString("video.msg.error.nopts.use_lastpts", String.valueOf(nArray2[6])));
            }
            byArray2 = new byte[16];
            n = 0;
            while (n < 8) {
                byArray2[7 - n] = (byte)(0xFFL & (long)d >>> n * 8);
                byArray2[15 - n] = (byte)(0xFFL & (long)n5 >>> n * 8);
                ++n;
            }
            jobProcessing.setLastGopTimecode((long)d2);
        }
        long[][] lArray = new long[2][byArray2.length / 16];
        int[] nArray3 = new int[1024];
        int n7 = 0;
        while (n7 < byArray2.length / 16) {
            int n8 = 0;
            while (n8 < 8) {
                long[] lArray2 = lArray[0];
                int n9 = n7;
                lArray2[n9] = lArray2[n9] | (0xFFL & (long)byArray2[n7 * 16 + n8]) << (7 - n8) * 8;
                long[] lArray3 = lArray[1];
                int n10 = n7;
                lArray3[n10] = lArray3[n10] | (0xFFL & (long)byArray2[n7 * 16 + 8 + n8]) << (7 - n8) * 8;
                ++n8;
            }
            ++n7;
        }
        if (lArray[0].length > 1 && Math.abs(lArray[0][lArray[0].length - 1] - lArray[0][0]) < 100L) {
            long l2 = lArray[0][0];
            long l3 = lArray[1][0];
            lArray = new long[2][1];
            lArray[0][0] = l2;
            lArray[1][0] = l3;
            nArray2[8] = nArray2[8] + 1;
        }
        if (this.Debug) {
            System.out.println("\ngop" + nArray2[6] + "/tc_o53 " + jobProcessing.getLastGopTimecode() + "/lp_o54 " + jobProcessing.getLastGopPts() + "/lp_o8 " + jobProcessing.getEndPtsOfGop() + "/lp_o40 " + jobProcessing.getLastSimplifiedPts());
            int n11 = 0;
            while (n11 < lArray[0].length) {
                System.out.println("p" + n11 + " " + lArray[0][n11] + "/ " + lArray[1][n11]);
                ++n11;
            }
        }
        Calendar calendar = Calendar.getInstance();
        String string2 = Common.formatTime_1((long)((double)jobProcessing.getExportedVideoFrameNumber() * (CommonParsing.getVideoFramerate() / 90.0)));
        String string3 = "";
        String[] stringArray = new String[]{"MPEG-1", "MPEG-2", "MPEG-4/H.264"};
        String[] stringArray2 = new String[]{"res.", "1.000 (1:1)", "0.6735 (4:3)", "0.7031 (16:9)", "0.7615 (2.21:1)", "0.8055", "0.8437", "0.9375", "0.9815", "1.0255", "1.0695", "1.1250", "1.1575", "1.2015", "res."};
        String[] stringArray3 = new String[]{"forbidden fps", "23.976fps", "24fps", "25fps", "29.97fps", "30fps", "50fps", "59.94fps", "60fps", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def."};
        double[] dArray = new double[16];
        dArray[1] = 3753.7537;
        dArray[2] = 3750.0;
        dArray[3] = 3600.0;
        dArray[4] = 3003.003;
        dArray[5] = 3000.0;
        dArray[6] = 1800.0;
        dArray[7] = 1501.5015;
        dArray[8] = 1500.0;
        double[] dArray2 = dArray;
        n3 = -1;
        n2 = -1;
        n = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 1;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = -1;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 65535;
        int n26 = jobProcessing.getExportedVideoFrameNumber();
        int n27 = 0;
        int n28 = -1;
        int n29 = -1;
        int n30 = -1;
        int n31 = 0;
        int[] nArray4 = new int[]{5, 50, 20, 5, 5, 5, 5, 5};
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        long l4 = jobProcessing.getVideoExportTime();
        long l5 = jobProcessing.getLastGopTimecode();
        long l6 = 0L;
        long l7 = l = jobProcessing.getEndPtsOfGop() == -10000L ? -20000L : jobProcessing.getEndPtsOfGop();
        long l8 = 0L;
        String[] stringArray4 = new String[]{"0", "I", "P", "B", "D", "5", "6", "7"};
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<long[]> arrayList4 = new ArrayList<long[]>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byte by = 0;
        try {
            int n32;
            int n33;
            int n34;
            int n35;
            byte[] byArray3;
            if (jobProcessing.hasSequenceHeader()) {
                byteArrayOutputStream2.write(-120);
            } else {
                byteArrayOutputStream2.write(-128);
            }
            if (jobProcessing.getSplitSize() > 0L && !jobProcessing.hasSequenceHeader() && jobProcessing.getExportedVideoFrameNumber() == 0) {
                byArray3 = new byte[this.headerrescue.length + byArray.length];
                System.arraycopy(this.headerrescue, 0, byArray3, 0, this.headerrescue.length);
                System.arraycopy(byArray, 0, byArray3, this.headerrescue.length, byArray.length);
                byArray = byArray3;
                jobProcessing.setSequenceHeader(true);
                n35 = 0;
                while (n35 < lArray[1].length) {
                    long[] lArray4 = lArray[1];
                    int n36 = n35++;
                    lArray4[n36] = lArray4[n36] + (long)this.headerrescue.length;
                }
            } else if (!(list.isEmpty() || jobProcessing.hasSequenceHeader() || CommonParsing.getCutStatus())) {
                byArray3 = new byte[this.headerrescue.length + byArray.length];
                System.arraycopy(this.headerrescue, 0, byArray3, 0, this.headerrescue.length);
                System.arraycopy(byArray, 0, byArray3, this.headerrescue.length, byArray.length);
                byArray = byArray3;
                jobProcessing.setSequenceHeader(true);
                n35 = 0;
                while (n35 < lArray[1].length) {
                    long[] lArray5 = lArray[1];
                    int n37 = n35++;
                    lArray5[n37] = lArray5[n37] + (long)this.headerrescue.length;
                }
            } else if (!jobProcessing.hasSequenceHeader() && this.AddSequenceHeader) {
                byArray3 = new byte[this.headerrescue.length + byArray.length];
                System.arraycopy(this.headerrescue, 0, byArray3, 0, this.headerrescue.length);
                System.arraycopy(byArray, 0, byArray3, this.headerrescue.length, byArray.length);
                byArray = byArray3;
                jobProcessing.setSequenceHeader(true);
                n35 = 0;
                while (n35 < lArray[1].length) {
                    long[] lArray6 = lArray[1];
                    int n38 = n35++;
                    lArray6[n38] = lArray6[n38] + (long)this.headerrescue.length;
                }
            }
            if (jobProcessing.hasSequenceHeader()) {
                int n39 = (0xFF & byArray[n31 + 4]) << 4 | (0xF0 & byArray[n31 + 5]) >>> 4;
                n35 = (0xF & byArray[n31 + 5]) << 8 | 0xFF & byArray[n31 + 6];
                n34 = 0xF & byArray[n31 + 7];
                n33 = 0xF & byArray[n31 + 7] >>> 4;
                double d = dArray2[n34];
                if (n39 == 0 || n35 == 0 || d == 0.0 || n33 == 0 || n33 > 13) {
                    nArray2[4] = nArray2[4] + 1;
                    this.messageDropError(byArray, byArray2, n18, n19, nArray2[6], jobProcessing.getExportedVideoFrameNumber(), l7, l, string, n4 |= 0x80);
                    jobProcessing.setSequenceHeader(false);
                    byteArrayOutputStream.close();
                    byteArrayOutputStream2.close();
                    byArray = null;
                    return;
                }
                CommonParsing.setVideoFramerate(d);
                this.VbvBuffer_Value = 16384 * ((0x1F & byArray[n31 + 10]) << 5 | (0xF8 & byArray[n31 + 11]) >>> 3);
                Object[] objectArray2 = new String[]{String.valueOf(n39), String.valueOf(n35), stringArray3[n34], stringArray2[n33], ""};
                nArray2[7] = n33 - 1;
                if (jobProcessing.isNewVideoStream() || jobProcessing.getExportedVideoFrameNumber() == 0) {
                    string3 = String.valueOf(Resource.getString("video.msg.basics")) + " " + (String)objectArray2[0] + "*" + (String)objectArray2[1] + " @ " + (String)objectArray2[2] + " @ " + (String)objectArray2[3] + " @ " + ((0xFF & byArray[n31 + 8]) << 10 | (0xFF & byArray[n31 + 9]) << 2 | (0xC0 & byArray[n31 + 10]) >>> 6) * 400 + " bps - vbv " + ((0x1F & byArray[n31 + 10]) << 5 | (0xF8 & byArray[n31 + 11]) >>> 3);
                    arrayList3.add(string3);
                    if (jobProcessing.getExportedVideoFrameNumber() == 0) {
                        bl7 = true;
                        by = byArray[n31 + 7];
                    } else {
                        bl9 = true;
                    }
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                }
                if (!Arrays.equals(objectArray, objectArray2)) {
                    String string4 = String.valueOf(Resource.getString("video.msg.basics")) + " " + (String)objectArray2[0] + "*" + (String)objectArray2[1] + " @ " + (String)objectArray2[2] + " @ " + (String)objectArray2[3] + " @ " + ((0xFF & byArray[n31 + 8]) << 10 | (0xFF & byArray[n31 + 9]) << 2 | (0xC0 & byArray[n31 + 10]) >>> 6) * 400 + " bps - vbv " + ((0x1F & byArray[n31 + 10]) << 5 | (0xF8 & byArray[n31 + 11]) >>> 3);
                    Common.setMessage("-> " + Resource.getString("video.msg.newformat", String.valueOf(nArray2[6])) + " (" + string2 + ")");
                    Common.setMessage(string4);
                    jobProcessing.getChapters().addChapter(string2, string4);
                    bl9 = true;
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                }
                n31 = 12;
            }
            nArray2[6] = nArray2[6] + 1;
            while (n31 < byArray.length - 10) {
                int n40 = CommonParsing.validateStartcode(byArray, n31);
                if (n40 < 0) {
                    n31 += -n40 - 1;
                } else {
                    if (n29 > -1 && this.ClearCDF) {
                        Arrays.fill(byArray, n29, n31, (byte)0);
                        n29 = -1;
                    }
                    if ((arrayList2.size() & 1) != 0 && !arrayList2.get(arrayList2.size() - 1).toString().startsWith("_")) {
                        arrayList2.add(String.valueOf(n31));
                    }
                    if ((n35 = CommonParsing.getPES_IdField(byArray, n31)) >= 1 && n35 <= 175) {
                        if (this.Debug) {
                            System.out.println("A " + n31 + " /slice " + n35);
                        }
                        n31 += 7;
                    } else if (n35 == 178) {
                        if ((arrayList2.size() & 1) == 0) {
                            arrayList2.add(String.valueOf(n31));
                        }
                        n29 = n31;
                        n31 += 3;
                    } else if ((0xF0 & byArray[n31 + 3]) == 224) {
                        n34 = 4;
                        if (CommonParsing.getPES_LengthField(byArray, n31) == 0) {
                            if (n31 + (n34 += 5 + (0xFF & byArray[n31 + 8])) >= byArray.length) {
                                n34 = byArray.length - n31;
                            }
                            Arrays.fill(byArray, n31, n31 + n34, (byte)0);
                            if (this.Message_3) {
                                Common.setMessage(Resource.getString("video.msg.error.pesext_in_es", String.valueOf(nArray2[6] - 1), String.valueOf(n31)));
                            }
                        } else {
                            Arrays.fill(byArray, n31, n31 + n34, (byte)0);
                            if (this.Message_3) {
                                Common.setMessage(Resource.getString("video.msg.error.pes_in_es", String.valueOf(nArray2[6] - 1), String.valueOf(n31)));
                            }
                        }
                        n31 += n34 - 1;
                    } else if (!bl8 && n35 == 181 && byArray[n31 + 4] >>> 4 == 1) {
                        nArray[0] = 1;
                        bl8 = true;
                        n30 = n31 + 5;
                        this.progressive_sequence = (8 & byArray[n30]) != 0;
                        n28 = n31 + 10;
                        n31 += 9;
                        if (jobProcessing.hasSequenceHeader() && byteArrayOutputStream2.size() == 1) {
                            byteArrayOutputStream2.reset();
                            byteArrayOutputStream2.write((byte)(8 | (8 & byArray[n30]) << 4));
                        }
                    } else if (!bl13 && n35 == 181 && byArray[n31 + 4] >>> 4 == 2) {
                        if (this.AddSequenceDisplayExension && jobProcessing.hasSequenceHeader()) {
                            Video.setSequenceDisplayExtension(byArray, n31, this.SDE_Value, (String[])objectArray);
                        }
                        bl14 = true;
                        n31 += 8;
                    } else if (n35 == 184) {
                        bl13 = true;
                        n22 = n31 + 7;
                        bl5 = true;
                        bl12 = (0x40 & byArray[n31 + 7]) != 0;
                        bl11 = (0x20 & byArray[n31 + 7]) != 0;
                        l6 = 90L * (3600000L * (long)((0x7C & byArray[n31 + 4]) >>> 2) + 60000L * (long)((3 & byArray[n31 + 4]) << 4 | (0xF0 & byArray[n31 + 5]) >>> 4) + 1000L * (long)((7 & byArray[n31 + 5]) << 3 | (0xE0 & byArray[n31 + 6]) >>> 5) + (long)((double)((0x1F & byArray[n31 + 6]) << 1 | (0x80 & byArray[n31 + 7]) >>> 7) * (CommonParsing.getVideoFramerate() / 90.0)));
                        if ((double)Math.abs(l6 - jobProcessing.getLastGopTimecode()) < CommonParsing.getVideoFramerate() || jobProcessing.getSourceVideoFrameNumber() == 0) {
                            jobProcessing.setLastGopTimecode(l6);
                        }
                        if (this.Debug) {
                            System.out.println("\n//b8 " + l6 + "/ " + Integer.toHexString(0x80 & byArray[n31 + 4] | 0x7F & byArray[n31 + 7]) + "/ " + n31 + "/ " + jobProcessing.hasSequenceHeader());
                        }
                        if (jobProcessing.hasSequenceHeader()) {
                            this.headerrescue = new byte[n31];
                            System.arraycopy(byArray, 0, this.headerrescue, 0, n31);
                        }
                        Date date = new Date((long)((double)jobProcessing.getExportedVideoFrameNumber() * (CommonParsing.getVideoFramerate() / 90.0)));
                        calendar.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
                        calendar.setTime(date);
                        n33 = calendar.get(11);
                        int n41 = calendar.get(12);
                        n32 = calendar.get(13);
                        int n42 = calendar.get(14) / ((int)CommonParsing.getVideoFramerate() / 90);
                        byArray[4 + n31] = (byte)(0x80 & byArray[n31 + 4] | n33 << 2 | n41 >>> 4);
                        byArray[5 + n31] = (byte)((0xF & n41) << 4 | 8 | n32 >>> 3);
                        byArray[6 + n31] = (byte)((7 & n32) << 5 | n42 >>> 1);
                        byArray[7 + n31] = (byte)(0x7F & byArray[n31 + 7] | n42 << 7);
                        n31 += 6;
                    } else if (n35 == 0) {
                        bl13 = true;
                        n17 = (0xFF & byArray[n31 + 4]) << 2 | (0xC0 & byArray[n31 + 5]) >>> 6;
                        n27 = (0x38 & byArray[n31 + 5]) >>> 3;
                        if (n27 < 1 || n27 > 4) {
                            Common.setMessage(String.valueOf(Resource.getString("video.msg.error.frame.wrong", String.valueOf(n27))) + " " + n17);
                            bl10 = true;
                            n4 |= 1;
                        }
                        arrayList.add(String.valueOf(n17 << 4 | n27));
                        if (this.ChangeBitrateInAllSequences != 2 && this.ChangeBitrateInAllSequences > 0 && this.ChangeVbvDelay > 0) {
                            int n43 = n31 + 5;
                            byArray[n43] = (byte)(byArray[n43] | 7);
                            int n44 = n31 + 6;
                            byArray[n44] = (byte)(byArray[n44] | 0xFF);
                            int n45 = n31 + 7;
                            byArray[n45] = (byte)(byArray[n45] | 0xF8);
                        }
                        if (n17 > n18) {
                            n18 = n17;
                        }
                        if (this.Debug) {
                            System.out.println(String.valueOf(n19) + "/ " + n18 + "/ " + n17 + "/ " + n31 + " * " + stringArray4[n27] + "/ " + byArray.length);
                        }
                        if (!bl2 && (long)n31 >= lArray[1][0]) {
                            l7 = lArray[0][0] - (long)(CommonParsing.getVideoFramerate() * (double)n17);
                            n3 = n17;
                            bl2 = true;
                        } else if (!bl3 && (long)n31 >= lArray[1][lArray[1].length - 1]) {
                            l = lArray[0][lArray[0].length - 1] - (long)(CommonParsing.getVideoFramerate() * (double)n17);
                            n2 = n17;
                            bl3 = true;
                        }
                        if (n19 == -1 && n27 == 1) {
                            n25 = (7 & byArray[n31 + 5]) << 13 | (0xFF & byArray[n31 + 6]) << 5 | (0xF8 & byArray[n31 + 7]) >>> 3;
                            bl6 = true;
                            if (jobProcessing.getExportedVideoFrameNumber() == 0) {
                                arrayList3.add(String.valueOf(Resource.getString("video.msg.export.start")) + " " + (nArray2[6] - 1));
                            }
                            if (n17 > 0 && (bl11 || (double)Math.abs(l7 - jobProcessing.getEndPtsOfGop()) > CommonParsing.getVideoFramerate()) && (!bl12 || bl12 && bl11)) {
                                byArray[n31 + 4] = 0;
                                int n46 = n31 + 5;
                                byArray[n46] = (byte)(byArray[n46] & 0x3F);
                                int n47 = n22;
                                byArray[n47] = (byte)(byArray[n47] | 0x40);
                                if (bl11) {
                                    int n48 = n22;
                                    byArray[n48] = (byte)(byArray[n48] & 0xFFFFFFDF);
                                }
                                byteArrayOutputStream.write(byArray, 0, n31);
                                n23 = n31;
                                if (jobProcessing.getExportedVideoFrameNumber() > 0) {
                                    arrayList3.add(String.valueOf(Resource.getString("video.msg.pts.diff", String.valueOf(l7 - jobProcessing.getEndPtsOfGop()), Common.formatTime_1((l7 - jobProcessing.getEndPtsOfGop()) / 90L))) + " " + (bl11 ? Resource.getString("video.msg.error.brokenlink") : ""));
                                }
                                arrayList3.add(String.valueOf(Resource.getString("video.msg.frame.drop", String.valueOf(nArray2[6] - 1))) + " " + Common.formatTime_1((long)((double)jobProcessing.getExportedVideoFrameNumber() * (CommonParsing.getVideoFramerate() / 90.0))));
                                jobProcessing.countExportedVideoFrameNumber(-n17);
                                n20 -= n17;
                                n24 = n17;
                                bl4 = true;
                                nArray2[0] = nArray2[0] + 1;
                            }
                        }
                        if (n19 > -1 && bl4) {
                            if (bl5) {
                                byteArrayOutputStream.write(byArray, n23, n31 - n23);
                            }
                            n23 = n31;
                            if (n24 > n17) {
                                bl5 = false;
                                if ((arrayList2.size() & 1) == 0) {
                                    arrayList2.add("_" + String.valueOf(n31));
                                }
                            } else {
                                bl5 = true;
                                byArray[n31 + 4] = (byte)(n17 - n24 >>> 2);
                                byArray[n31 + 5] = (byte)(0x3F & byArray[n31 + 5] | n17 - n24 << 6);
                                if ((arrayList2.size() & 1) == 1) {
                                    arrayList2.add("_" + String.valueOf(n31));
                                }
                            }
                        }
                        if (n27 == 2) {
                            if (!bl4) {
                                long[] lArray7 = new long[]{jobProcessing.getSourceVideoFrameNumber(), n31};
                                arrayList4.add(lArray7);
                            } else {
                                long[] lArray8 = new long[]{jobProcessing.getSourceVideoFrameNumber(), byteArrayOutputStream.size()};
                                arrayList4.add(lArray8);
                            }
                        }
                        jobProcessing.countSourceVideoFrameNumber(1);
                        jobProcessing.countExportedVideoFrameNumber(1);
                        ++n19;
                        ++n20;
                        n21 = 128;
                        n = 0;
                        n12 = 0;
                        int n49 = n31 + 6;
                        while (n49 < n31 + 15 && n49 + 10 < byArray.length) {
                            n40 = CommonParsing.validateStartcode(byArray, n49);
                            if (n40 < 0) {
                                n49 += -n40 - 1;
                            } else if (byArray[n49 + 3] == -75 && (0xF0 & byArray[n49 + 4]) == 128) {
                                n = 2 & byArray[n49 + 7];
                                n21 = 0x80 & byArray[n49 + 8];
                                if (this.PatchToProgressive) {
                                    int n50 = n49 + 8;
                                    byArray[n50] = (byte)(byArray[n50] | 0xFFFFFF80);
                                } else if (this.PatchToInterlaced) {
                                    int n51 = n49 + 8;
                                    byArray[n51] = (byte)(byArray[n51] & 0x7F);
                                }
                                if (this.ToggleFieldorder) {
                                    int n52 = n49 + 7;
                                    byArray[n52] = (byte)(byArray[n52] ^ 0xFFFFFF80);
                                }
                                n12 = byArray[n49 + 7] | 0x80;
                                if (!this.ClearCDF || (0x40 & byArray[n49 + 8]) == 0) break;
                                int n53 = n49 + 8;
                                byArray[n53] = (byte)(byArray[n53] & 0xFFFFFF80);
                                byArray[n49 + 9] = 0;
                                byArray[n49 + 10] = 0;
                                if ((arrayList2.size() & 1) == 0) {
                                    arrayList2.add(String.valueOf(n49 + 9));
                                }
                                n31 = n49;
                                break;
                            }
                            ++n49;
                        }
                        if (n != 0 && bl5) {
                            n33 = n14 = this.progressive_sequence ? 2 : 1;
                            if (this.progressive_sequence && n12 != 0) {
                                n33 += n14;
                            }
                            nArray3[n17] = n33;
                            n13 += n33;
                            this.total_pulldownfields += (long)n33;
                            if (this.total_pulldownfields % 2L == 0L || this.progressive_sequence) {
                                n33 = n33 < 2 ? 1 : n33 / 2;
                                jobProcessing.countSourceVideoFrameNumber(n33);
                                jobProcessing.countExportedVideoFrameNumber(n33);
                            }
                        }
                        if (bl6 || !bl4 || bl4 && bl5) {
                            byteArrayOutputStream2.write((byte)(n27 | n21));
                        }
                        n31 += 7;
                        bl6 = false;
                    }
                }
                ++n31;
            }
            if (n13 > 0) {
                n34 = 0;
                while (n34 < n3) {
                    n15 += nArray3[n34];
                    ++n34;
                }
                n16 = n15;
                n33 = n3;
                while (n33 < n2) {
                    n16 += nArray3[n33];
                    ++n33;
                }
                l = lArray[0].length > 1 ? (l -= (long)(CommonParsing.getVideoFramerate() * (double)n16 / 2.0)) : (l7 -= (long)(CommonParsing.getVideoFramerate() * (double)n15 / 2.0));
            }
            if (bl4) {
                if (bl5) {
                    byteArrayOutputStream.write(byArray, n23, byArray.length - n23);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                bl4 = false;
            }
            if (n30 != -1 && n30 < byArray.length) {
                if (this.PatchToProgressive) {
                    int n54 = n30;
                    byArray[n54] = (byte)(byArray[n54] | 8);
                } else if (this.PatchToInterlaced) {
                    int n55 = n30;
                    byArray[n55] = (byte)(byArray[n55] & 0xFFFFFFF7);
                }
            }
            if (lArray[0].length < 2) {
                l = l7;
                nArray2[1] = nArray2[1] + 1;
            }
            if (jobProcessing.get1stVideoPTS() == -1L) {
                jobProcessing.set1stVideoPTS(l7);
            }
            int[] nArray5 = new int[arrayList.size()];
            n33 = 0;
            while (n33 < nArray5.length) {
                nArray5[n33] = Integer.parseInt(arrayList.get(n33).toString());
                ++n33;
            }
            int[] nArray6 = new int[nArray5.length];
            Arrays.fill(nArray6, -1);
            if (nArray5.length == 0) {
                Common.setMessage(Resource.getString("video.msg.error.frame.not", String.valueOf(nArray2[6] - 1)));
                bl10 = true;
                n4 |= 2;
            }
            if (nArray5.length > 0 && (nArray5[0] & 0xF) != 1) {
                Common.setMessage(Resource.getString("video.msg.error.frame.not.i", String.valueOf(nArray2[6] - 1)));
            }
            n32 = 0;
            while (!bl10 && n32 < nArray5.length) {
                int n56 = nArray5[n32] >>> 4;
                if (n56 < 0 || n56 > nArray5.length - 1 || nArray6[n56] != -1) {
                    bl10 = true;
                    n4 |= 4;
                    break;
                }
                nArray6[n56] = nArray5[n32];
                ++n32;
            }
            int n57 = 0;
            while (!bl10 && n57 < nArray6.length) {
                if (nArray6[n57] == -1) {
                    bl10 = true;
                    n4 |= 8;
                }
                ++n57;
            }
            if (this.Save1stFrameOfGop) {
                Common.getMpvDecoderClass().decodeArray(byArray, false, this.Preview_AllGops, this.Preview_fastDecode, this.Preview_YGain);
            }
            if ((double)l7 < (double)jobProcessing.getLastGopPts() - CommonParsing.getVideoFramerate() / 2.0) {
                Common.setMessage(Resource.getString("video.msg.error.pts.early", String.valueOf(nArray2[6] - 1), String.valueOf(jobProcessing.getLastGopPts())));
                bl10 = true;
                n4 |= 0x10;
            }
            if (this.TrimPts && l7 < jobProcessing.getEndPtsOfGop() && (double)(jobProcessing.getEndPtsOfGop() - l7) < CommonParsing.getVideoFramerate() / 2.0) {
                if (this.Debug) {
                    System.out.println("videostart trimmed to o8 " + jobProcessing.getEndPtsOfGop() + " /sp " + l7);
                }
                l7 = jobProcessing.getEndPtsOfGop();
            }
            if (n18 != n19 || Math.abs(l - l7) > 2000L) {
                bl10 = true;
                n4 |= 0x20;
            }
            if (jobProcessing.getSourceVideoFrameNumber() > 0 && this.IgnoreErrors) {
                l = l7;
                n18 = n19;
                bl10 = false;
            }
            if (Integer.parseInt(objectArray[0]) <= 720 && byArray.length > 2750000) {
                bl10 = true;
                n4 |= 0x40;
            }
            jobProcessing.setLastSimplifiedPts(l7 + (long)((double)n24 * CommonParsing.getVideoFramerate()) + (long)(((double)n18 + (double)n13 / 2.0 - (double)n24 + 1.0) * CommonParsing.getVideoFramerate()));
            if (bl10 && this.UseGOPEditor) {
                byArray = Common.getGuiInterface().editGOP(byArray, lArray);
            }
            if (bl10) {
                jobProcessing.setExportedVideoFrameNumber(n26);
                nArray2[4] = nArray2[4] + 1;
                this.messageDropError(byArray, byArray2, n18, n19, nArray2[6], jobProcessing.getExportedVideoFrameNumber(), l7, l, string, n4);
            } else {
                arrayList4.clear();
                jobProcessing.countLastGopTimecode((long)(CommonParsing.getVideoFramerate() * ((double)n18 + (double)n13 / 2.0 + 1.0)));
                jobProcessing.setLastGopPts(l7 + (long)(CommonParsing.getVideoFramerate() * ((double)n18 + (double)n13 / 2.0 + 1.0)));
                switch (this.CutMode) {
                    case 0: {
                        l8 = jobProcessing.getCutByteposition();
                        break;
                    }
                    case 1: {
                        l8 = nArray2[6];
                        break;
                    }
                    case 2: {
                        l8 = jobProcessing.getSourceVideoFrameNumber();
                        break;
                    }
                    case 3: {
                        l8 = l7 + 1000L;
                        break;
                    }
                    case 4: {
                        l8 = l7 - jobProcessing.get1stVideoPTS();
                    }
                }
                if (!CommonParsing.makecut(jobProcessing, string, l7, l8, arrayList4, n26, list, nArray2[6] - 1, jobProcessing.getCellTimes())) {
                    jobProcessing.setExportedVideoFrameNumber(n26);
                } else if (this.OptionDAR && this.ExportDAR != nArray2[7]) {
                    jobProcessing.setExportedVideoFrameNumber(n26);
                } else if (this.OptionHorizontalResolution && !this.ExportHorizontalResolution.equals(objectArray[0])) {
                    jobProcessing.setExportedVideoFrameNumber(n26);
                } else if (bl) {
                    int n58;
                    jobProcessing.setEndPtsOfGop((l7 += (long)((double)n24 * CommonParsing.getVideoFramerate())) + (long)(((double)n18 + (double)n13 / 2.0 - (double)n24 + 1.0) * CommonParsing.getVideoFramerate()));
                    dataOutputStream.writeLong(l7);
                    dataOutputStream.writeLong(jobProcessing.getEndPtsOfGop());
                    dataOutputStream.writeLong(l4);
                    dataOutputStream.writeLong(jobProcessing.countVideoExportTime((long)(((double)n18 + (double)n13 / 2.0 - (double)n24 + 1.0) * CommonParsing.getVideoFramerate())));
                    double d = CommonParsing.getVideoFramerate() * (double)(n18 - n24 + 1);
                    if (d <= 0.0) {
                        d = CommonParsing.getVideoFramerate() * 10.0;
                    }
                    int n59 = (int)((double)(90000L * (long)(byArray.length * 8)) / d / 400.0);
                    if (jobProcessing.hasSequenceHeader()) {
                        if (this.ChangeBitrateInAllSequences == 2 && n25 < 65535) {
                            n59 = (int)(90000L * this.VbvBuffer_Value / (long)n25 / 400L);
                        }
                        if (this.ChangeAspectRatio > 0) {
                            byArray[7] = (byte)(0xF & byArray[7] | this.ChangeAspectRatio << 4);
                        }
                        if (this.ChangeVbvBuffer > 0) {
                            byArray[10] = (byte)(0xE0 & byArray[10] | 3);
                            byArray[11] = (byte)(7 & byArray[11] | 0x80);
                        }
                    }
                    if (n59 < jobProcessing.getMinBitrate()) {
                        jobProcessing.setMinBitrate(n59);
                    }
                    if (n59 > jobProcessing.getMaxBitrate()) {
                        jobProcessing.setMaxBitrate(n59);
                    }
                    if (jobProcessing.hasSequenceHeader()) {
                        if (this.ChangeBitrateInAllSequences > 0) {
                            int n60 = (this.ChangeBitrateInAllSequences - 3) * 2500 * 3;
                            if (n60 > 0) {
                                n59 = n60;
                            }
                            n58 = n59;
                            if (this.ChangeBitrateInAllSequences == 3) {
                                n58 = 262143;
                            }
                            byArray[8] = (byte)(n58 >>> 10);
                            byArray[9] = (byte)(0xFF & n58 >> 2);
                            byArray[10] = (byte)(0x3F & byArray[10] | (3 & n58) << 6);
                            nArray2[2] = nArray2[2] + 1;
                        } else {
                            nArray2[3] = nArray2[3] + 1;
                        }
                    }
                    byteArrayOutputStream2.flush();
                    byte[] byArray4 = byteArrayOutputStream2.toByteArray();
                    n58 = 0;
                    int n61 = Short.MAX_VALUE & nArray2[9] >>> 15;
                    int n62 = Short.MAX_VALUE & nArray2[9];
                    int n63 = nArray2[9] >>> 30;
                    int n64 = 1;
                    while (n64 < byArray4.length) {
                        n58 += 2;
                        n63 |= (0x80 & byArray4[n64]) != 0 ? 2 : 1;
                        ++n64;
                    }
                    if (n58 < n61 || n61 == 0) {
                        n61 = n58;
                    }
                    if (n58 > n62 || n62 == 0) {
                        n62 = n58;
                    }
                    nArray2[9] = n63 << 30 | (Short.MAX_VALUE & n61) << 15 | Short.MAX_VALUE & n62;
                    Common.getGuiInterface().updateBitrateMonitor(n59, byArray4, Common.formatTime_1((jobProcessing.getVideoExportTimeSummary() + jobProcessing.getVideoExportTime()) / 90L).substring(0, 8));
                    if (jobProcessing.isNewVideoStream() && arrayList3.size() > 0) {
                        jobProcessing.getChapters().addChapter(string2, string3);
                    }
                    int n65 = 0;
                    while (n65 < arrayList3.size()) {
                        Common.setMessage(arrayList3.get(n65).toString());
                        jobProcessing.setNewVideoStream(false);
                        ++n65;
                    }
                    if (bl7 && (this.CreateD2vIndex || this.SplitProjectFile)) {
                        jobProcessing.getProjectFileD2V().FrameRate(by);
                        bl7 = false;
                    }
                    jobProcessing.getProjectFileD2V().addGOP(jobProcessing.getProjectFileExportLength(), n20);
                    if (bl9 && this.InsertEndcode) {
                        if (this.WriteVideo) {
                            iDDBufferedOutputStream.write(Video.getSequenceEndCode());
                            jobProcessing.countMediaFilesExportLength(4L);
                            jobProcessing.countAllMediaFilesExportLength(4L);
                            jobProcessing.countProjectFileExportLength(4L);
                        }
                        jobProcessing.addCellTime(String.valueOf(jobProcessing.getExportedVideoFrameNumber()));
                        Common.setMessage("-> save ChapterFrameIndex: " + jobProcessing.getExportedVideoFrameNumber());
                    }
                    if (this.WriteVideo) {
                        if (bl8 && this.AddSequenceDisplayExension && !bl14 && jobProcessing.hasSequenceHeader()) {
                            int n66 = n28 != -1 ? n28 : this.headerrescue.length;
                            iDDBufferedOutputStream.write(byArray, 0, n66);
                            iDDBufferedOutputStream.write(Video.setSequenceDisplayExtension(this.SDE_Value, (String[])objectArray));
                            iDDBufferedOutputStream.write(byArray, n66, byArray.length - n66);
                            jobProcessing.countMediaFilesExportLength(12L);
                            jobProcessing.countAllMediaFilesExportLength(12L);
                            jobProcessing.countProjectFileExportLength(12L);
                        } else {
                            iDDBufferedOutputStream.write(byArray);
                        }
                        jobProcessing.countMediaFilesExportLength(byArray.length);
                        bl15 = true;
                    }
                    if (list2.indexOf(String.valueOf(l8)) >= 0) {
                        jobProcessing.addCellTime(String.valueOf(jobProcessing.getExportedVideoFrameNumber()));
                        Common.setMessage("-> save ChapterFrameIndex: " + jobProcessing.getExportedVideoFrameNumber());
                    }
                    jobProcessing.countProjectFileExportLength(byArray.length);
                    jobProcessing.countAllMediaFilesExportLength(byArray.length);
                }
                Common.getGuiInterface().showExportStatus(bl15 ? Resource.getString("audio.status.write") : Resource.getString("audio.status.pause"));
            }
            arrayList3.clear();
            jobProcessing.setSequenceHeader(false);
            byteArrayOutputStream.close();
            byteArrayOutputStream2.close();
            byArray = null;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void h264test(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2) {
        int n;
        long l;
        nArray[0] = 2;
        String[] stringArray = new String[]{"MPEG-1", "MPEG-2", "MPEG-4/H.264"};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        boolean bl = false;
        int[] nArray2 = jobProcessing.getStatusVariables();
        int n2 = 0;
        long l2 = l = jobProcessing.getEndPtsOfGop() == -10000L ? -20000L : jobProcessing.getEndPtsOfGop();
        long l3 = jobProcessing.getVideoExportTime();
        int n3 = jobProcessing.getExportedVideoFrameNumber();
        long l4 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        long[][] lArray = new long[2][byArray2.length / 16];
        long l5 = -1L;
        int n4 = 0;
        while (n4 < byArray2.length / 16) {
            n = 0;
            while (n < 8) {
                long[] lArray2 = lArray[0];
                int n5 = n4;
                lArray2[n5] = lArray2[n5] | (0xFFL & (long)byArray2[n4 * 16 + n]) << (7 - n) * 8;
                long[] lArray3 = lArray[1];
                int n6 = n4;
                lArray3[n6] = lArray3[n6] | (0xFFL & (long)byArray2[n4 * 16 + 8 + n]) << (7 - n) * 8;
                ++n;
            }
            ++n4;
        }
        if (this.Debug) {
            System.out.println("\ngop" + nArray2[6] + "/tc_o53 " + jobProcessing.getLastGopTimecode() + "/lp_o54 " + jobProcessing.getLastGopPts() + "/lp_o8 " + jobProcessing.getEndPtsOfGop() + "/lp_o40 " + jobProcessing.getLastSimplifiedPts());
            n = 0;
            while (n < lArray[0].length) {
                System.out.println("p" + n + " " + lArray[0][n] + "/ " + lArray[1][n]);
                ++n;
            }
        }
        n = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int[] nArray3 = new int[2];
        boolean bl4 = false;
        boolean bl5 = false;
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        Object[] objectArray = jobProcessing.getStatusStrings();
        Object[] objectArray2 = new String[5];
        int[] nArray4 = new int[12];
        double[] dArray = new double[3];
        byte[] byArray3 = new byte[5];
        byArray3[3] = 1;
        byArray3[4] = 10;
        byte[] byArray4 = byArray3;
        AccessUnit accessUnit = null;
        ArrayList<AccessUnit> arrayList3 = new ArrayList<AccessUnit>();
        ArrayList<AccessUnit> arrayList4 = new ArrayList<AccessUnit>();
        try {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18 = 0;
            while (n18 < byArray.length - 10) {
                int n19 = CommonParsing.validateMp4Startcode(byArray, n18);
                if (n19 < 0) {
                    n18 += -n19 - 1;
                } else {
                    int n20 = byArray[n18 + 4];
                    if (n20 >= 0) {
                        n20 &= 0x1F;
                        int n21 = 3 & byArray[n18 + 4] >> 5;
                        if (this.Debug) {
                            System.out.println("Au " + bl4 + " /Ap " + n11 + " /U " + n18 + " /ppt " + (7 & byArray[n18 + 5] >> 5) + " /ref " + n21 + " /typ " + n20);
                        }
                        if (bl5 && n10 < 0) {
                            n10 = n18;
                        }
                        switch (n20) {
                            case 1: 
                            case 5: {
                                if (!bl4) break;
                                l5 = -1L;
                                int n22 = n12;
                                while (n22 < lArray[1].length) {
                                    if (lArray[1][n22] <= (long)n11) {
                                        l5 = lArray[0][n22];
                                        n12 = n22 + 1;
                                        break;
                                    }
                                    ++n22;
                                }
                                if (accessUnit != null) {
                                    accessUnit.setEnd(n11);
                                }
                                this.slice_wo_partitioning(byArray, n18, n20, nArray4);
                                accessUnit = new AccessUnit(n, n9, 7 & byArray[n18 + 5] >> 5, nArray4, l5, n20, n21, n11);
                                arrayList3.add(accessUnit);
                                ++n;
                                byteArrayOutputStream.write((byte)(1 - nArray4[6] << 7 | n9 + 1));
                                bl4 = false;
                                break;
                            }
                            case 6: {
                                this.readSEIMessage(byArray, n18);
                                break;
                            }
                            case 7: {
                                bl5 = true;
                                this.readH264SequenceParameterSet(byArray, n18, (String[])objectArray2, nArray4);
                                byteArrayOutputStream.write(-120);
                                CommonParsing.setVideoFramerate(90000.0 / Double.parseDouble(objectArray2[2].substring(0, objectArray2[2].indexOf(" ", 2)).trim()));
                                if (jobProcessing.isNewVideoStream() || jobProcessing.getExportedVideoFrameNumber() == 0) {
                                    arrayList2.add(String.valueOf(Resource.getString("video.msg.basics")) + " " + stringArray[nArray[0]] + " " + (String)objectArray2[4] + ", " + (String)objectArray2[0] + "*" + (String)objectArray2[1] + ", " + (String)objectArray2[2] + " @ " + (String)objectArray2[3]);
                                    if (jobProcessing.getExportedVideoFrameNumber() > 0) {
                                        bl2 = true;
                                    }
                                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                                }
                                if (Arrays.equals(objectArray, objectArray2)) break;
                                String string2 = String.valueOf(Resource.getString("video.msg.basics")) + " MPEG-4/H.264, " + (String)objectArray2[4] + ", " + (String)objectArray2[0] + "*" + (String)objectArray2[1] + ", " + (String)objectArray2[2] + " @ " + (String)objectArray2[3];
                                Common.setMessage("-> " + Resource.getString("video.msg.newformat", String.valueOf(nArray2[6])));
                                Common.setMessage(string2);
                                bl2 = true;
                                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                                break;
                            }
                            case 9: {
                                bl4 = true;
                                n11 = n18;
                                n9 = 7 & byArray[n18 + 5] >> 5;
                                break;
                            }
                            case 10: {
                                Common.setMessage("-> SequenceEndMarker detected at rel. pos " + n18);
                                break;
                            }
                            case 11: {
                                Common.setMessage("-> StreamEndMarker detected at rel. pos " + n18);
                                break;
                            }
                        }
                    }
                }
                ++n18;
            }
            if (accessUnit != null) {
                accessUnit.setEnd(byArray.length);
            }
            if (arrayList3.size() > 0) {
                accessUnit = (AccessUnit)arrayList3.get(0);
                if (accessUnit.getPPTAU() != 0) {
                    Common.setMessage(Resource.getString("video.msg.error.frame.not.i", String.valueOf(nArray2[6] - 1)));
                    n2 |= 1;
                } else {
                    l2 = accessUnit.getPTS();
                }
            } else {
                Common.setMessage(Resource.getString("video.msg.error.frame.not", String.valueOf(nArray2[6] - 1)));
                n2 |= 2;
            }
            if (n2 != 0) {
                bl3 = true;
            }
            if (!bl3) {
                int n23 = 0;
                n17 = 0;
                n16 = 0;
                n15 = 0;
                while (n23 < arrayList3.size()) {
                    accessUnit = (AccessUnit)arrayList3.get(n23);
                    if (n23 == 0) {
                        dArray[0] = (double)accessUnit.getPTS() - (double)accessUnit.getPicOrder() * (CommonParsing.getVideoFramerate() / 2.0);
                        n17 = accessUnit.getFrameNum();
                        arrayList4.add(accessUnit);
                    } else {
                        dArray[1] = (double)accessUnit.getPTS() - (double)accessUnit.getPicOrder() * (CommonParsing.getVideoFramerate() / 2.0);
                        if (accessUnit.getPTS() != -1L && Math.abs(dArray[0] - dArray[1]) > 100.0) {
                            n2 |= 4;
                        }
                    }
                    n8 += accessUnit.isFieldPic() ? 1 : 2;
                    if (accessUnit.getPTS() < l2 && accessUnit.getPTS() != -1L) {
                        l2 = accessUnit.getPTS();
                    }
                    if (accessUnit.getFrameNum() != n17 && accessUnit.getFrameNum() != (1 + n17 & -1 >>> 32 - nArray4[0])) {
                        n2 |= 8;
                        Common.setMessage("!> discontinuity in framenum: exp/rec " + (n17 + 1) + "/" + accessUnit.getFrameNum());
                    }
                    n17 = accessUnit.getFrameNum();
                    n15 = n16;
                    n16 = 0;
                    while (n23 > 0 && n16 < arrayList4.size()) {
                        if (accessUnit.getPTS() == -1L) {
                            arrayList4.add(n15 + 1, accessUnit);
                            break;
                        }
                        if (accessUnit.getPTS() < ((AccessUnit)arrayList4.get(n16)).getPTS()) {
                            arrayList4.add(n16, accessUnit);
                            break;
                        }
                        ++n16;
                    }
                    if (n16 == arrayList4.size()) {
                        arrayList4.add(accessUnit);
                    }
                    ++n23;
                }
                int n24 = 0;
                n14 = 0;
                n13 = 0;
                while (n24 < arrayList4.size()) {
                    accessUnit = (AccessUnit)arrayList4.get(n24);
                    if (n24 == 0) {
                        dArray[2] = accessUnit.getPTS();
                    }
                    int n25 = n14 = accessUnit.isFieldPic() ? 2 : 1;
                    if (n24 > 0 && accessUnit.getPTS() != -1L && Math.abs((double)accessUnit.getPTS() - dArray[2]) > 100.0) {
                        n2 |= 0x20;
                    }
                    dArray[2] = dArray[2] + CommonParsing.getVideoFramerate() / (double)n14;
                    if (accessUnit.getPPTAU() == 0) {
                        n13 = 1;
                    } else if (n13 == 0) {
                        nArray3[0] = nArray3[0] + 1;
                        nArray3[1] = nArray3[1] + (accessUnit.isFieldPic() ? 1 : 2);
                    }
                    ++n24;
                }
                if ((0x24 & n2) == 4) {
                    n2 &= 0xFFFFFFFB;
                }
                n7 = n8 / 2;
                l = l2 + Math.round((double)n8 * CommonParsing.getVideoFramerate() / 2.0);
            }
            nArray2[6] = nArray2[6] + 1;
            if ((double)l2 < (double)jobProcessing.getLastGopPts() - CommonParsing.getVideoFramerate() / 2.0) {
                Common.setMessage(Resource.getString("video.msg.error.pts.early", String.valueOf(nArray2[6] - 1), String.valueOf(jobProcessing.getLastGopPts())));
                n2 |= 0x10;
            }
            if (n2 != 0) {
                bl3 = true;
            }
            if (this.Debug) {
                int n26 = 0;
                while (n26 < arrayList3.size()) {
                    System.out.println("E " + arrayList3.get(n26).toString());
                    ++n26;
                }
                n17 = 0;
                while (n17 < arrayList4.size()) {
                    System.out.println("R " + arrayList4.get(n17).toString());
                    ++n17;
                }
            }
            if (bl3) {
                jobProcessing.setExportedVideoFrameNumber(n3);
                nArray2[4] = nArray2[4] + 1;
                this.messageDropError(byArray, byArray2, (int)((dArray[2] - (double)l2) / CommonParsing.getVideoFramerate()), n7, nArray2[6], jobProcessing.getExportedVideoFrameNumber(), l2, l, string, n2);
            } else {
                switch (this.CutMode) {
                    case 0: {
                        l4 = jobProcessing.getCutByteposition();
                        break;
                    }
                    case 1: {
                        l4 = nArray2[6];
                        break;
                    }
                    case 2: {
                        l4 = jobProcessing.getSourceVideoFrameNumber();
                        break;
                    }
                    case 3: {
                        l4 = l2 + 1000L;
                        break;
                    }
                    case 4: {
                        l4 = l2 - jobProcessing.get1stVideoPTS();
                    }
                }
                if (!CommonParsing.makecut(jobProcessing, string, l2, l4, arrayList, n3, list, nArray2[6] - 1, jobProcessing.getCellTimes())) {
                    jobProcessing.setExportedVideoFrameNumber(n3);
                } else if (this.OptionDAR && this.ExportDAR != nArray2[7]) {
                    jobProcessing.setExportedVideoFrameNumber(n3);
                } else if (this.OptionHorizontalResolution && !this.ExportHorizontalResolution.equals(objectArray[0])) {
                    jobProcessing.setExportedVideoFrameNumber(n3);
                } else {
                    if (jobProcessing.getExportedVideoFrameNumber() == 0) {
                        arrayList2.add(String.valueOf(Resource.getString("video.msg.export.start")) + " " + (nArray2[6] - 1));
                    }
                    if (nArray3[1] > 0 && (double)jobProcessing.getLastGopPts() < (double)l2 - CommonParsing.getVideoFramerate() / 2.0) {
                        int n27 = 0;
                        n17 = 0;
                        while (n27 < nArray3[0]) {
                            n17 = ((AccessUnit)arrayList4.get(n27)).getCount();
                            n16 = 0;
                            while (n16 < arrayList3.size()) {
                                accessUnit = (AccessUnit)arrayList3.get(n16);
                                if (n17 == accessUnit.getCount()) {
                                    n8 -= accessUnit.isFieldPic() ? 1 : 2;
                                    l2 = (long)((double)l2 + CommonParsing.getVideoFramerate() / (double)(accessUnit.isFieldPic() ? 2 : 1));
                                    arrayList3.remove(n16);
                                    break;
                                }
                                ++n16;
                            }
                            ++n27;
                        }
                        n16 = 0;
                        while (n16 < arrayList3.size()) {
                            accessUnit = (AccessUnit)arrayList3.get(n16);
                            byteArrayOutputStream2.write(byArray, accessUnit.getStart(), accessUnit.getLength());
                            if (this.Debug) {
                                System.out.println("bu " + n16 + " /au " + accessUnit.getCount() + " /fn " + accessUnit.getFrameNum() + " /pptau " + accessUnit.getPPTAU() + " /ppt " + accessUnit.getPPT() + " /st " + accessUnit.getStart() + " /en " + accessUnit.getEnd());
                            }
                            ++n16;
                        }
                        byteArrayOutputStream2.flush();
                        byArray = byteArrayOutputStream2.toByteArray();
                        n7 = n8 / 2;
                        arrayList2.add("!> removing " + nArray3[1] + " preceding fields from GOP #" + (nArray2[6] - 1));
                    }
                    int n28 = 0;
                    while (n28 < arrayList2.size()) {
                        Common.setMessage(arrayList2.get(n28).toString());
                        jobProcessing.setNewVideoStream(false);
                        ++n28;
                    }
                    if (this.WriteVideo) {
                        double d = CommonParsing.getVideoFramerate() * (double)n7;
                        if (d <= 0.0) {
                            d = CommonParsing.getVideoFramerate() * 20.0;
                        }
                        if ((n15 = (int)((double)(90000L * (long)(byArray.length * 8)) / d / 400.0)) < jobProcessing.getMinBitrate()) {
                            jobProcessing.setMinBitrate(n15);
                        }
                        if (n15 > jobProcessing.getMaxBitrate()) {
                            jobProcessing.setMaxBitrate(n15);
                        }
                        byteArrayOutputStream.flush();
                        byte[] byArray5 = byteArrayOutputStream.toByteArray();
                        n14 = Short.MAX_VALUE & nArray2[9] >>> 15;
                        n13 = Short.MAX_VALUE & nArray2[9];
                        int n29 = nArray2[9] >>> 30;
                        int n30 = 1;
                        while (n30 < byArray5.length) {
                            n29 |= (0x80 & byArray5[n30]) != 0 ? 2 : 1;
                            ++n30;
                        }
                        if (n8 < n14 || n14 == 0) {
                            n14 = n8;
                        }
                        if (n8 > n13 || n13 == 0) {
                            n13 = n8;
                        }
                        nArray2[9] = n29 << 30 | (Short.MAX_VALUE & n14) << 15 | Short.MAX_VALUE & n13;
                        Common.getGuiInterface().updateBitrateMonitor(n15, byArray5, Common.formatTime_1((jobProcessing.getVideoExportTimeSummary() + jobProcessing.getVideoExportTime()) / 90L).substring(0, 8));
                        iDDBufferedOutputStream.write(byArray);
                        nArray2[3] = nArray2[3] + 1;
                        jobProcessing.countExportedVideoFrameNumber(n7);
                        jobProcessing.setEndPtsOfGop(l);
                        jobProcessing.setLastGopPts(l);
                        dataOutputStream.writeLong(l2);
                        dataOutputStream.writeLong(jobProcessing.getEndPtsOfGop());
                        dataOutputStream.writeLong(l3);
                        jobProcessing.countVideoExportTime(l - l2);
                        dataOutputStream.writeLong(jobProcessing.getVideoExportTime());
                        jobProcessing.countMediaFilesExportLength(byArray.length);
                        jobProcessing.countAllMediaFilesExportLength(byArray.length);
                        bl = true;
                        Common.getGuiInterface().showExportStatus(bl ? Resource.getString("audio.status.write") : Resource.getString("audio.status.pause"));
                    }
                }
            }
            arrayList2.clear();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void messageDropError(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, long l, long l2, String string, int n5) {
        block2: {
            Common.setMessage(String.valueOf(Resource.getString("video.msg.error.gop.drop", String.valueOf(n3 - 1), Common.formatTime_1(l / 90L), String.valueOf(l))) + ", errorcode: " + Integer.toHexString(n5).toUpperCase());
            Common.setMessage(String.valueOf(Resource.getString("video.msg.error.gop.diff", String.valueOf(String.valueOf(n + 1)) + "/" + (n2 + 1), String.valueOf((l2 - l) / 90L))) + " " + Common.formatTime_1((long)((double)n4 * (CommonParsing.getVideoFramerate() / 90.0))));
            if (!this.DumpDroppedGop) break block2;
            String string2 = String.valueOf(string) + "-GOP#" + (n3 - 1) + ".bin";
            byte[] byArray3 = new byte[16];
            Arrays.fill(byArray3, (byte)-1);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
                dataOutputStream.writeInt(n3 - 1);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeInt(n2);
                dataOutputStream.write(byArray3, 0, 4);
                dataOutputStream.write(byArray2);
                dataOutputStream.write(byArray3);
                dataOutputStream.write(byArray);
                dataOutputStream.write(Video.getSequenceEndCode());
                dataOutputStream.flush();
                dataOutputStream.close();
                Common.setMessage(String.valueOf(Resource.getString("video.msg.error.gop.dump")) + " " + string);
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
    }

    private boolean readH264SequenceParameterSet(byte[] byArray, int n, String[] stringArray, int[] nArray) {
        int n2;
        byte[] byArray2 = new byte[100];
        int[] nArray2 = new int[]{4 + n << 3};
        int n3 = this.getBits(byArray, nArray2, 1);
        int n4 = this.getBits(byArray, nArray2, 2);
        int n5 = this.getBits(byArray, nArray2, 5);
        if (n3 != 0 || n5 != 7) {
            return false;
        }
        int n6 = 5 + n;
        int n7 = 0;
        while (n7 < 97) {
            if (byArray[n6] == 0 && byArray[n6 + 1] == 0 && byArray[n6 + 2] == 3) {
                n7 += 2;
                n6 += 2;
            } else {
                byArray2[n7++] = byArray[n6];
            }
            ++n6;
        }
        nArray2[0] = 0;
        int n8 = this.getBits(byArray2, nArray2, 8);
        this.getBits(byArray2, nArray2, 4);
        n3 = this.getBits(byArray2, nArray2, 4);
        if (n3 != 0) {
            return false;
        }
        int n9 = this.getBits(byArray2, nArray2, 8);
        int n10 = this.getCodeNum(byArray2, nArray2);
        int n11 = 1;
        if (n8 == 100 || n8 == 110 || n8 == 122 || n8 == 44 || n8 == 244) {
            n11 = this.getCodeNum(byArray2, nArray2);
            if (n11 == 3) {
                this.getBits(byArray2, nArray2, 1);
            }
            this.getCodeNum(byArray2, nArray2);
            this.getCodeNum(byArray2, nArray2);
            this.getBits(byArray2, nArray2, 1);
            n10 = this.getBits(byArray2, nArray2, 1);
            if (n10 == 1) {
                n2 = 0;
                while (n2 < (n11 != 3 ? 8 : 12)) {
                    if (this.getBits(byArray2, nArray2, 1) == 1) {
                        if (n2 < 6) {
                            this.scaling_list(byArray2, nArray2, null, 16, null);
                        } else {
                            this.scaling_list(byArray2, nArray2, null, 64, null);
                        }
                    }
                    ++n2;
                }
            }
        }
        nArray[0] = 4 + this.getCodeNum(byArray2, nArray2);
        nArray[2] = this.getCodeNum(byArray2, nArray2);
        if (nArray[2] == 0) {
            nArray[3] = 4 + this.getCodeNum(byArray2, nArray2);
        } else if (nArray[2] == 1) {
            this.getBits(byArray2, nArray2, 1);
            this.getSignedCodeNum(byArray2, nArray2);
            this.getSignedCodeNum(byArray2, nArray2);
            n10 = this.getCodeNum(byArray2, nArray2);
            n2 = 0;
            while (n2 < n10) {
                this.getSignedCodeNum(byArray2, nArray2);
                ++n2;
            }
        }
        nArray[8] = this.getCodeNum(byArray2, nArray2);
        nArray[9] = this.getBits(byArray2, nArray2, 1);
        if (this.Debug) {
            System.out.println("num_ref_fr " + nArray[8] + " /gapsallow " + nArray[9]);
        }
        n2 = 16 * (1 + this.getCodeNum(byArray2, nArray2));
        int n12 = 16 * (1 + this.getCodeNum(byArray2, nArray2));
        nArray[5] = n10 = this.getBits(byArray2, nArray2, 1);
        stringArray[0] = String.valueOf(n2);
        stringArray[1] = String.valueOf(n10 == 0 ? n12 << 1 : n12);
        stringArray[4] = n8 == 66 ? "Base@" : (n8 == 77 ? "Main@" : (n8 == 88 ? "Ext@" : (n8 == 100 ? "High@" : (n8 == 110 ? "High10@" : (n8 == 122 ? "High422" : (n8 == 144 ? "High444@" : (n8 == 44 ? "High444a@" : (n8 == 244 ? "High444b@" : String.valueOf(String.valueOf(n8)) + "@"))))))));
        stringArray[4] = String.valueOf(stringArray[4]) + String.valueOf((double)n9 / 10.0);
        if (n10 == 0) {
            this.getBits(byArray2, nArray2, 1);
        }
        this.getBits(byArray2, nArray2, 1);
        n10 = this.getBits(byArray2, nArray2, 1);
        if (n10 == 1) {
            this.getCodeNum(byArray2, nArray2);
            this.getCodeNum(byArray2, nArray2);
            this.getCodeNum(byArray2, nArray2);
            this.getCodeNum(byArray2, nArray2);
        }
        if ((n10 = this.getBits(byArray2, nArray2, 1)) == 1) {
            this.vui_parameters(byArray2, nArray2, stringArray);
        }
        return true;
    }

    private void readSEIMessage(byte[] byArray, int n) {
        int n2 = 0;
        int[] nArray = new int[]{5 + n << 3};
        int n3 = 0;
        while ((n2 = this.getBits(byArray, nArray, 8)) == 255) {
            n3 += 255;
        }
        n3 += n2;
        int n4 = 0;
        while ((n2 = this.getBits(byArray, nArray, 8)) == 255) {
            n4 += 255;
        }
        n4 += n2;
        if (this.Debug) {
            System.out.println("SEI pos " + n + " /pT " + n3 + " /pS " + n4);
        }
    }

    private void scaling_list(byte[] byArray, int[] nArray, int[] nArray2, int n, boolean[] blArray) {
        int n2 = 8;
        int n3 = 8;
        int n4 = 0;
        while (n4 < n) {
            if (n3 != 0) {
                int n5 = this.getSignedCodeNum(byArray, nArray);
                n3 = (n2 + n5 + 256) % 256;
            }
            n2 = n3 == 0 ? n2 : n3;
            ++n4;
        }
    }

    private byte[] setSEIMsg6(int n) {
        int n2 = 0;
        int n3 = 31;
        int n4 = n + 1;
        int n5 = 0;
        while (n3 >= 0) {
            if ((n4 & 1 << n3) != 0) {
                n5 = 23 - (n3 << 1);
                n2 |= n4 << n5;
                n2 |= 4 << (n5 -= 4);
                if ((n5 & 7) != 0) {
                    n2 |= 1 << --n5;
                }
                n2 |= 3 - (n5 >>>= 3) << 24;
                byte[] byArray = new byte[10 - n5];
                byArray[3] = 1;
                byArray[4] = 6;
                byArray[5] = 6;
                byArray[6] = (byte)((n2 |= 128 << (--n5 << 3)) >> 24);
                byArray[7] = (byte)(n2 >> 16);
                byArray[8] = (byte)(n2 >> 8);
                if (byArray.length > 9) {
                    byArray[9] = (byte)n2;
                }
                if (this.Debug) {
                    int n6 = 0;
                    while (n6 < byArray.length) {
                        System.out.println("m " + n6 + " / " + Integer.toHexString(0xFF & byArray[n6]));
                        ++n6;
                    }
                }
                return byArray;
            }
            --n3;
        }
        return new byte[0];
    }

    private void slice_wo_partitioning(byte[] byArray, int n, int n2, int[] nArray) {
        int[] nArray2 = new int[]{5 + n << 3};
        int n3 = this.getCodeNum(byArray, nArray2);
        nArray[11] = this.getCodeNum(byArray, nArray2);
        n3 = this.getCodeNum(byArray, nArray2);
        nArray[1] = this.getBits(byArray, nArray2, nArray[0]);
        if (nArray[5] == 0) {
            nArray[6] = this.getBits(byArray, nArray2, 1);
            if (nArray[6] == 1) {
                nArray[7] = this.getBits(byArray, nArray2, 1);
            }
        }
        if (n2 == 5) {
            this.getCodeNum(byArray, nArray2);
        }
        if (nArray[2] == 0) {
            nArray[10] = nArray2[0];
            nArray[4] = this.getBits(byArray, nArray2, nArray[3]);
        }
    }

    private void vui_parameters(byte[] byArray, int[] nArray, String[] stringArray) {
        int n;
        int n2;
        int n3;
        String[] stringArray2 = new String[]{"Unspec.", "1:1", "12:11", "10:11", "16:11", "40:33", "24:11", "20:11", "32:11", "80:33", "18:11", "15:11", "64:33", "160:99", "4:3", "3:2", "2:1"};
        double[] dArray = new double[]{1.0, 1.0, 1.0909, 0.90909, 1.45454, 1.21212, 2.18181, 1.81818, 2.90909, 2.42424, 1.63636, 1.36364, 1.93939, 1.61616, 1.33333, 1.5, 2.0};
        int n4 = this.getBits(byArray, nArray, 1);
        if (n4 == 1) {
            n3 = this.getBits(byArray, nArray, 8);
            if (n3 == 255) {
                n2 = this.getBits(byArray, nArray, 16);
                n = this.getBits(byArray, nArray, 16);
                stringArray[3] = "SAR: " + n2 + ":" + n;
                stringArray[3] = String.valueOf(stringArray[3]) + " >> " + String.valueOf((int)(Double.parseDouble(stringArray[0]) * (double)n2 / (double)n)) + "*" + stringArray[1];
            } else {
                stringArray[3] = "SAR: " + (n3 < 17 ? stringArray2[n3] : "res.");
                stringArray[3] = String.valueOf(stringArray[3]) + " >> " + (n3 < 17 ? String.valueOf(Math.round(Double.parseDouble(stringArray[0]) * dArray[n3])) : "res.") + "*" + stringArray[1];
            }
        }
        if ((n4 = this.getBits(byArray, nArray, 1)) == 1) {
            this.getBits(byArray, nArray, 1);
        }
        if ((n4 = this.getBits(byArray, nArray, 1)) == 1) {
            this.getBits(byArray, nArray, 3);
            this.getBits(byArray, nArray, 1);
            n4 = this.getBits(byArray, nArray, 1);
            if (n4 == 1) {
                this.getBits(byArray, nArray, 8);
                this.getBits(byArray, nArray, 8);
                this.getBits(byArray, nArray, 8);
            }
        }
        if ((n4 = this.getBits(byArray, nArray, 1)) == 1) {
            this.getCodeNum(byArray, nArray);
            this.getCodeNum(byArray, nArray);
        }
        if ((n4 = this.getBits(byArray, nArray, 1)) == 1) {
            n3 = this.getBits(byArray, nArray, 24) << 8 | this.getBits(byArray, nArray, 8);
            n2 = this.getBits(byArray, nArray, 24) << 8 | this.getBits(byArray, nArray, 8);
            n = this.getBits(byArray, nArray, 1);
            stringArray[2] = String.valueOf((double)(1000 * n2 / (2 * n3)) / 1000.0) + " fps (" + (n == 1 ? "f)" : "v)");
        }
    }

    class AccessUnit {
        int cnt = -1;
        int pptau = -1;
        int ppt = -1;
        int framenum = -1;
        int picorder = -1;
        long pts = -1L;
        int unittype = -1;
        int unitref = -1;
        int start = -1;
        int end = -1;
        int fieldpic = 0;
        int btmfield = 0;
        int marker = 0;
        int slicetype = 0;

        public AccessUnit(int n, int n2, int n3, int[] nArray, long l, int n4, int n5, int n6) {
            this.cnt = n;
            this.pptau = n2;
            this.ppt = n3;
            this.framenum = nArray[1];
            this.picorder = nArray[4];
            this.fieldpic = nArray[6];
            this.btmfield = nArray[7];
            this.marker = nArray[10];
            this.slicetype = nArray[11];
            this.pts = l;
            this.start = n6;
            this.unittype = n4;
            this.unitref = n5;
        }

        private int getCount() {
            return this.cnt;
        }

        private int getEnd() {
            return this.end;
        }

        private int getFrameNum() {
            return this.framenum;
        }

        private int getLength() {
            return this.end - this.start;
        }

        private int getMarker() {
            return this.marker;
        }

        private int getPPT() {
            return this.ppt;
        }

        private int getPPTAU() {
            return this.pptau;
        }

        private long getPTS() {
            return this.pts;
        }

        private int getPicOrder() {
            return this.picorder;
        }

        private int getStart() {
            return this.start;
        }

        private int getUnitRef() {
            return this.unitref;
        }

        private int getUnitType() {
            return this.unittype;
        }

        private boolean isBtmPic() {
            return this.btmfield != 0;
        }

        private boolean isFieldPic() {
            return this.fieldpic != 0;
        }

        private void setEnd(int n) {
            this.end = n;
        }

        public String toString() {
            return "AU " + this.cnt + " /frnm " + this.framenum + " /picord " + this.picorder + " /pptau " + this.pptau + " /ppt " + this.ppt + " /slicetyp " + this.slicetype + " /fldpic " + this.fieldpic + " /btmfld " + this.btmfield + " /ut " + this.unittype + " /ur " + this.unitref + " /pts " + this.pts + " /st " + this.start + " /en " + this.end;
        }
    }
}

