/* REXX PROGRAM */
/* OMNIFILE INSTALLATION PROGRAM */
SAY "INSTALLATION PROGRAM FOR OMNIFILE"
SAY ""
/* You may optionally specify the destination path for the program as an argument. */
/* If you do not specify the destination path you will be prompted to enter a path. */
PARSE SOURCE os processor cmd
srcdrive = FILESPEC("drive",cmd)
srcpath = FILESPEC("path",cmd)
src = srcdrive||srcpath

"@echo off"
arg destpath

/* Determine if user is installing from floppies or hard disk */
minHardDiskSize = 3800000  /* ~3.8 MB */
call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'
driveInfo = SysDriveInfo(srcdrive)
driveSize = SUBWORD(driveInfo, 3, 1)
IF driveSize > minHardDiskSize
   THEN InstallFromFloppy = FALSE
   ELSE InstallFromFloppy = TRUE

InstallInCurDir = FALSE
call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
DO FOREVER
   IF destpath == "" THEN DO
      IF InstallFromFloppy == TRUE THEN DO
         SAY "Enter the full directory path (including drive) where you would like"
         SAY "OmniFile installed.  If you press Enter without typing anything"
         SAY 'it will be installed in the "C:\OMNIFILE" directory.'
         END
      ELSE DO
         tempsrc = STRIP(src, 'T', '\')
         SAY "If you would like to install this program"
         SAY "in "tempsrc" without copying"
         SAY "the files to a new directory simply"
         SAY "press Enter without typing anything."
         SAY ""
         SAY "Otherwise enter the full directory path (including drive)"
         SAY "where you would like the program to be installed."
         SAY '(We suggest "C:\OMNIFILE").'
         END
      SAY ""
      SAY "If you would like to abort this installation type QUIT and press Enter."
      PULL destpath
      IF destpath = "QUIT" THEN EXIT
      IF destpath = "" THEN DO
         IF InstallFromFloppy == TRUE
            THEN destpath = "C:\OMNIFILE"
            ELSE DO
               InstallInCurDir = TRUE
               destpath = src
               LEAVE
               END
         END
      END
   rc = SysMkDir(destpath)
   if rc == 0 THEN LEAVE
   SAY ""
   SAY "ERROR: Unable to make the directory "destpath"."
   if rc == 3 THEN say "The path was not found."
   if rc == 5 THEN say "Either it already exists or you do not have access to the directory."
   SAY "Enter a new path."
   SAY ""
   destpath = ""
   END

/* Copy the files */
IF InstallInCurDir == FALSE THEN DO
   IF InstallFromFloppy == TRUE
      THEN CopyCmd = src"decomp "
      ELSE CopyCmd = "copy "
   SAY ""
   SAY "Now copying files..."
   CopyCmd src"Omnifile.exe "destpath"\Omnifile.exe"
   CopyCmd src"Omnifile.hlp "destpath"\Omnifile.hlp"
   "copy "src"*.cmd "destpath"/v"
   "copy "src"*.txt "destpath"/v"

   /* Copy registration info if found */
   rc = SysFileTree("register.dat", TempFileTime, 'FT')
   IF TempFileTime.0 \= 0 THEN "copy "src"register.dat "destpath"/v"

   "md "destpath"\ICONS.OS2 2>nul"
   "copy "src"ICONS.OS2\*.* "destpath"\ICONS.OS2/v"
   "md "destpath"\SYSTEM 2>nul"
   "copy "src"SYSTEM\*.db* "destpath"\SYSTEM/v"

   CopyCmd src"impex2wn.ntx "destpath"\impex2wn.ntx"
   CopyCmd src"impex295.ntx "destpath"\impex295.ntx"
   CopyCmd src"impexpwn.ntx "destpath"\impexpwn.ntx"
   CopyCmd src"impexp95.ntx "destpath"\impexp95.ntx"
   CopyCmd src"impexpwn.gbf "destpath"\impexpwn.gbf"
   CopyCmd src"impexpwn.gbt "destpath"\impexpwn.gbt"
   CopyCmd src"impexp95.gbf "destpath"\impexp95.gbf"
   CopyCmd src"impexp95.gbt "destpath"\impexp95.gbt"
   "copy "src"*.rep "destpath"/v"

   CopyCmd src"cicooi01.dll "destpath"\cicooi01.dll"
   CopyCmd src"cicoom0.dll "destpath"\cicoom0.dll"
   CopyCmd src"cicoor01.dll "destpath"\cicoor01.dll"

   IF InstallFromFloppy == TRUE THEN DO
      SAY ""
      SAY "Insert the disk Labeled Disk 2 and press Enter."
      PULL response
      SAY ""
      SAY "Now copying files..."
      END
   CopyCmd src"cicoop01.dll "destpath"\cicoop01.dll"
   CopyCmd src"cicooa01.dll "destpath"\cicooa01.dll"
   CopyCmd src"cicoov01.dll "destpath"\cicoov01.dll"
   CopyCmd src"cicoow01.dll "destpath"\cicoow01.dll"
   CopyCmd src"cicood01.dll "destpath"\cicood01.dll"
   CopyCmd src"cicoot01.dll "destpath"\cicoot01.dll"
   CopyCmd src"cicoob0.dll "destpath"\cicoob0.dll"
   CopyCmd src"cicoou0.dll "destpath"\cicoou0.dll"

   IF InstallFromFloppy == TRUE THEN DO
      SAY ""
      SAY "Insert the disk Labeled Disk 3 and press Enter."
      PULL response
      SAY ""
      SAY "Now copying files..."
      END
   CopyCmd src"cicoox01.dll "destpath"\cicoox01.dll"

   "erase "destpath"\install.cmd 2>nul"
   "erase "destpath"\upgrade.cmd 2>nul"
   END

/* Make sub directories */
"md "destpath"\FILES 2>nul"

/* Create the Omnifile Icon. */
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
if SysCreateObject('WPProgram', 'OmniFile', '<WP_DESKTOP>', 'EXENAME='destpath'\Omnifile.exe;STARTUPDIR='destpath, 'replace') == 0 then SAY 'Unable to create the OmniFile icon.  You should add it manually after the installation program finishes.'

SAY ""
SAY "DONE INSTALLING OMNIFILE."
SAY "To use the program double click on the OmniFile icon on your desktop."
IF InstallInCurDir == TRUE THEN DO
   SAY "Once you have verified the installation was successful"
   SAY "we suggest you delete the following files from this directory:"
   SAY "   install.cmd"
   SAY "   omnifile.zip"
   END
SAY ""
EXIT
