/* Rexx Installation for PTime by Wolfram Schmid <w.schmid@ws-it.de>
*/

'@ECHO OFF'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Yellow  = '[1;33m'
Red     = '[1;31m'
Green   = '[1;32m'
Blue    = '[1;36m'
Default = '[0m'

CrLf = x2c('0d0a');

CreateWpsObjects.en = "Creating WPS Objects...";
CreateWpsObjects.ge = "Erstelle WPS Objekte...";

InstMsg.ge = "Dieses Installationsprogramm legt einen WPS Ordner fr PTime an."CrLf ||,
             "Das aktuelle Verzeichnis wird verwendet. Es werden keine Dateien kopiert.";

InstMsg.en = "This installation script creates a WPS folder for PTime."CrLf ||,
             "The current directory will be used. No files will be copyed.";

StartInstall.en = "Installation beginnen (y/n):";
StartInstall.ge = "Start installation (j/n)";


SAY Green"Choose language..."Default;
SAY "  0  Englisch";
SAY "  1  Deutsch";

Key = EnterLanguage();

if Key==27 then
  exit

language = "EN";

if (Key-48)==0 then
  language = "EN";
else if (Key-48)==1 then
  language = "GE";

SAY Green || InstMsg.language || Default;
Key = EnterYesNo();

if (Key==27) | ((Key<>89) & (Key<>74)) then
  exit;

if language=="EN" then 
  "copy PTime_en.Cfg PTime.Cfg ";
if language=="GE" then 
  "copy PTime_ge.Cfg PTime.Cfg ";

folder.name = 'PTime/2'
basedir = directory()

SAY CreateWpsObjects.language;

if language=="EN" then 
do
  rc = SysCreateObject(	'WPFolder', ,
      folder.name, ,
      '<WP_DESKTOP>', ,
      'OBJECTID=<'||folder.objid||'>;ICONFONT=8.Helv;MENUBAR=NO;OPEN=ICON'||folder.icon, ,
      'ReplaceIfExists')
  
  rc = SysCreateObject(	'WPProgram', ,
      'PTime', ,
      '<'folder.objid'>', ,
      'OBJECTID=<PTIME_EXE>;EXENAME='||basedir||'\PTime.Exe;PARAMETERS=;STARTUPDIR='||basedir, ,
      'ReplaceIfExists')
  
  rc = SysCreateObject(	'WPProgram', ,
      'PTime Manual', ,
      '<'folder.objid'>', ,
      'OBJECTID=<PTIME_MANUAL>;EXENAME=VIEW.EXE;PARAMETERS=PTime_en.Hlp;STARTUPDIR='||basedir||';', ,
      'ReplaceIfExists')
  
  rc = SysCreateObject(	'WPProgram', ,
      'Readme', ,
      '<'folder.objid'>', ,
      'OBJECTID=<PTIME_README>;EXENAME=E.EXE;PARAMETERS='||basedir||'\PTime_en.txt;',
      'ReplaceIfExists')
end

if language=="GE" then 
do
  rc = SysCreateObject(	'WPFolder', ,
      folder.name, ,
      '<WP_DESKTOP>', ,
      'OBJECTID=<'||folder.objid||'>;ICONFONT=8.Helv;MENUBAR=NO;OPEN=ICON'||folder.icon, ,
      'ReplaceIfExists')
  
  rc = SysCreateObject(	'WPProgram', ,
      'PTime', ,
      '<'folder.objid'>', ,
      'OBJECTID=<PTIME_EXE>;EXENAME='||basedir||'\PTime.Exe;PARAMETERS=;STARTUPDIR='||basedir, ,
      'ReplaceIfExists')
  
  rc = SysCreateObject(	'WPProgram', ,
      'PTime Manual', ,
      '<'folder.objid'>', ,
      'OBJECTID=<PTIME_MANUAL>;EXENAME=VIEW.EXE;PARAMETERS=PTime_ge.Hlp;STARTUPDIR='||basedir||';', ,
      'ReplaceIfExists')
  
  rc = SysCreateObject(	'WPProgram', ,
      'Readme', ,
      '<'folder.objid'>', ,
      'OBJECTID=<PTIME_README>;EXENAME=E.EXE;PARAMETERS='||basedir||'\PTime_ge.txt;',
      'ReplaceIfExists')
end

exit


ErrorSound:
  do 18
    call Beep 100, 30
    call Beep 200, 30
  end 
return


WarningSound:
  do 10
    call Beep 1000, 30
    call Beep 2000, 30
  end 
return 


WrongkeySound:
  call Beep 3300, 30
return 


EnterLanguage:
  call charout ,'Enter number (0/1): '
  do forever
    Char = SysGetKey( 'noecho' )
    if c2d( Char )=224 | c2d( Char )=0 then
    do 
      Char = SysGetKey( 'noecho' )
      Char = c2d( Char )
    end 
    else
    do
      Zahl = c2d( translate( Char ) )
      if (Zahl>=48 & Zahl<=57) | (Zahl==27) then 
      do
        if Zahl>48 & Zahl<128 then call charout , ' <' || d2c( Zahl ) || '>'
        if Zahl==27 then call charout ,'<Esc>'
        say ''
        return Zahl
      end 
      else
        call WrongkeySound
      say Zahl
    end 
  end 
return 0


EnterYesNo:
  call charout ,StartInstall.language
  do forever
    Char = SysGetKey( 'noecho' )
    if c2d( Char )=224 | c2d( Char )=0 then
    do 
      Char = SysGetKey( 'noecho' )
      Char = c2d( Char )
    end 
    else
    do
      Zahl = c2d( translate( Char ) )
      if (Zahl==89) | (Zahl==78) | (Zahl==74) | (Zahl==27) then 
      do
        if Zahl>48 & Zahl<128 then call charout , ' <' || d2c( Zahl ) || '>'
        if Zahl==27 then call charout ,'<Esc>'
        say ''
        return Zahl
      end 
      else
        call WrongkeySound
      say Zahl
    end 
  end 
return 0
