/*********************************************************************/
/*  MAKEICON.CMD - SkyGate Install REXX Command File                 */
/*      Usage:     makeicon c:\SkyGate                               */
/*********************************************************************/
Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

Call SysCls
Say
Say COPIES('-',78)
Say
Say CENTER(' SSSSS   K    K  Y     Y   GGGGG    AAAAA   TTTTTTT  EEEEEEE',78)
Say CENTER('S     S  K   K    Y   Y   G     G  A     A     T     E      ',78)
Say CENTER('S        K  K      Y Y    G        A     A     T     E      ',78)
Say CENTER(' SSSSS   KKKK       Y     G  GGG   AAAAAAA     T     EEEEE  ',78)
Say CENTER('      S  K   K      Y     G     G  A     A     T     E      ',78)
Say CENTER('S     S  K    K     Y     G     G  A     A     T     E      ',78)
Say CENTER(' SSSSS   K     K    Y      GGGGG   A     A     T     EEEEEEE',78)
Say
Say CENTER('SkyGate for Os/2 v1.0 Installation Procedure',78)
Say
Say COPIES('-',78)
Say
Say CENTER('This procedure will create a SkyGate folder on your desktop.',78)
Say
Say
Say
Say ('  Press Enter to continue or "Q" & Enter to quit')
Parse Upper Pull response .
If LEFT(response,1) = 'Q' Then Exit

Say ('  Please Enter SkyGate drive:\path (ENTER = c:\SkyGate)')
Parse Pull path .
If path = '' Then path = 'c:\SkyGate'

Say
Say
Say '  SkyGate Directory'
Say
Say '     'path
Say
Say
Say '  Press Enter to continue or "Q" & Enter to quit'
Parse Upper Pull response .
If LEFT(response,1) = 'Q' Then Exit

retry = 0
If \SysCreateObject('WPFolder','SkyGate for OS/2','<WP_DESKTOP>','OBJECTID=<SKYFOLDER>') Then Do
  Do retry = 1 to 10
    If SysCreateObject('WPFolder','SkyGate for OS/2:'retry,'<WP_DESKTOP>','OBJECTID=<SKYFOLDER'retry'>') Then
      Leave
    End
  If retry = 11 Then Do
    Say '**** ERROR: Unable to create SkyGate folder.'
    Exit
    End
  End

If retry = 0 Then Do
  Say '--> SkyGate for OS/2 folder created.'
  location = '<SKYFOLDER>'
  End
Else Do
  Say '--> SkyGate for OS/2:'retry 'folder created.'
  location = '<SKYFOLDER'retry'>'
  End

Do retry = 1 to 10
  setup = 'OBJECTID=<SKYGATE'retry'>;EXENAME='path'\SkyGate.Exe;STARTUPDIR='path
  If SysCreateObject('WPProgram','SkyGate',location,setup) Then Do
    Say '--> SkyGate icon created.'
    Leave
    End
  End
If retry = 11 Then
  Say '**** ERROR: Unable to create SkyGate icon.'

Do retry = 1 to 10
  setup = 'OBJECTID=<SKYVIEW'retry'>;EXENAME='path'\SkyView.Exe;STARTUPDIR='path
  If SysCreateObject('WPProgram','SkyView',location,setup) Then Do
    Say '--> SkyView icon created.'
    Leave
    End
  End
If retry = 11 Then
  Say '**** ERROR: Unable to create SkyView icon.'

Say
Say 'SkyGate installation proceedure completed.'
Exit
