// pmcomplx.h
/* 
Petr Mikulik (mikulik@sci.muni.cz) - 1996--1999
This header file eliminates the bordel in complex, Complex, Complx etc. 
of declarations, templates etc.

No need till gcc 2.6.3, complex problems are double since gcc 2.7.2
Hope this works for sometime now.
*/

#ifndef PMCOMPLX_H
#define PMCOMPLX_H

#if defined(__GNUC__)
  /*
  GNU C++ until 2.6.3: Complex is class; since 2.7.: complex is template; 
  I have used sth like:  #if (__GNUC__ <= 2 && __GNUC_MINOR__ <= 6)
     Well, let us now ignore #include <Complex.h>, since this is called 
  <Complx.h> in EMX, and some other compilers don't have it at all.
  */
  #include <complex>
  typedef complex<double> Complex;

// other compilers

#else
  // Valid for at least Borland C++ (DOS, OS/2), DEC C++, HP CC, Watcom
  #include <complex.h>
  #define Complex complex
#endif


/*
// I have even noticed a C++ compiler without complex numbers (long time ago)!
#ifndef NO_SYSTEM_COMPLEX
  #include <complex.h>
//  #define complex Complex
#else
  #include "complex.h"
#endif
*/

#endif

// eof pmcomplx.h