// pmmath.cpp

// Requirements: if  UseAA  is defined, then you will use
// Angstroms instead of meters in procedure  MetersOrAngstroms

#include <math.h>
#if defined(__MSDOS__)
  #include <conio.h>
#endif
#include "ansicpp.h"
#include "pmmath.h"


   const double MachEps     = 2.3e-16;  // DBL_EPSILON
   const double SqrtMachEps = 1.55e-8;  // sqrt(DBL_EPSILON)

   const double M_3_PI_2 = 1.5 * M_PI;  //  3*/2
   const double M_SQRT_TWO_PI = sqrt(M_TWO_PI); // sqrt(2*)

   const double sec2rad = M_PI / (180.*3600);
   const double min2rad = M_PI / (180.*60);
   const double deg2rad = M_PI / 180.;
   const double rad2sec = 1 / sec2rad;
   const double rad2min = 1 / min2rad;
   const double rad2deg = 1 / deg2rad;

   const double GoldenMean = 0.618033988749895;

int OKinterval ( double from, double to, double step ) {
 return !(step<=0 || from>to ); }

int OKinterval_noeq ( double from, double to, double step ) {
 return !(step<=0 || from>=to ); }

double angle2_pipi ( double angle ) {
while ( angle<-M_PI ) angle += M_TWO_PI;
while ( angle>M_PI ) angle -= M_TWO_PI;
return angle;
}

double angle2_02pi ( double angle ) {
while ( angle<0 ) angle += M_TWO_PI;
while ( angle>M_TWO_PI ) angle -= M_TWO_PI;
return angle;
}

#ifndef __hpux
double pow ( double x, int n ) {
if (!n) return 1;
if (x==0) return 0;
int m = n>=0 ? n : -n;
double y=1;
for ( ; ; ) {
  if (m & 1) y *= x;
  if (m >>= 1) x *=x;
    else return n>=0 ? y : 1/y;
  }
}
#endif

double sinc ( double x ) {
 if (x==0) return 1; else return sin(x)/x; }
double sinc ( float x ) {
 if (x==0) return 1; else return sin(x)/x; }

int in_angles( double x, double a1, double a2 ) {
// returns 1 if  x  belongs to the interval  [a1,a2]
// where all three parameters are angles in radians
if (a2-a1>=M_TWO_PI_LESS) return 1;
if (x<a1) { do x+=M_TWO_PI; while (x<a1); return x<=a2; }
if (x>a2) { do x-=M_TWO_PI; while (x>a2); return x>=a1; }
return 1;
}

int in_angles( float x, float a1, float a2 ) {
// returns 1 if  x  belongs to the interval  [a1,a2]
// where all three parameters are angles in radians
if (a2-a1>=M_TWO_PI_LESS) return 1;
if (x<a1) { do x+=M_TWO_PI; while (x<a1); return x<=a2; }
if (x>a2) { do x-=M_TWO_PI; while (x>a2); return x>=a1; }
return 1;
}

// eof pmmath.cpp
