## Copyright (C) 1996, 1997 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} subwindw (@var{xn}, @var{yn})
## Sets the subwindw position in multiplt mode for the next plot.  The
## multiplt mode has to be previously initialized using the
## @code{multiplt} function, otherwise this command just becomes an alias
## to @code{multiplt}
## @end deftypefn

## Author: Vinayak Dutt <Dutt.Vinayak@mayo.EDU>
## Created: 3 July 95
## Adapted-By: jwe

function subwindw (xn, yn)

  if (! gnuplot_has_multiplt)
    error ("subwindw: gnuplot does not appear to support this feature");
  endif

  ## global variables to keep track of multiplt options

  global __multiplt_mode__ = 0;
  global __multiplt_xsize__;
  global __multiplt_ysize__;
  global __multiplt_xn__;
  global __multiplt_yn__;

  ## check calling argument count

  if (nargin != 2)
    usage ("subwindw (xn, yn)");
  endif

  ## check for scalar inputs

  if (! (is_scal (xn) && is_scal (yn)))
    error ("subwindw: xn and yn have to be scalars");
  endif

  xn = round (xn);
  yn = round (yn);

  ## switch to multiplt mode if not already in, and use the args as the
  ## args to multiplt()

  if (! __multiplt_mode__)
    multiplt (xn, yn);
    return;
  endif

  ## get the sub plot location

  if (xn < 1 || xn > __multiplt_xn__ || yn < 1 || yn > __multiplt_yn__)
    error ("subwindw: incorrect xn and yn");
  endif

  xo = (xn - 1.0) * __multiplt_xsize__;
  yo = (__multiplt_yn__ - yn) * __multiplt_ysize__;

  eval (sprintf ("gset origin %g, %g", xo, yo));

  clearplot;

endfunction
