/*
** ****************************************************************************
** Loading/Unloading of DLLs for OS/2
** (c) 1997, Klaus Gebhardt
** ****************************************************************************
*/

/*
** ****************************************************************************
** This was written for the OS/2 port of Octave, but it is not part of Octave!
** You can use the code UNMODIFIED. If you think changes are necessary,
** please send me a mail (gebhardt@crunch.ikp.physik.th-darmstadt.de).
** Thanks,
**   Klaus Gebhardt
** ****************************************************************************
*/

#ifndef __dlfcn_h__
#define __dlfcn_h__

#ifdef __cplusplus
extern "C" {
#endif

/* Mode flags for the dlopen routine. */
#define RTLD_LAZY	1	/* lazy function call binding */
#define RTLD_NOW	2	/* immediate function call binding */
#define RTLD_GLOBAL	0x100	/* allow symbols to be global */

struct dl_info
{
  void (*init)(void);
  void (*fini)(void);
};

void *dlopen(const char *, int);
void *dlsym(void *, const char *);
char *dlerror(void);
int dlclose(void *);

#ifdef __cplusplus
}
#endif

#endif
