## Copyright (C) 1996, 1997 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} saveimg (@var{file}, @var{x}, @var{fmt}, @var{map})
## Save the matrix @var{x} to @var{file} in image format @var{fmt}.
## 
## Note: if the colormap contains only two entries and these entries are
## black and white, the bitmap ppm and PostScript formats are used.  If the
## image is a gray scale image (the entries within each row of the colormap
## are equal) the gray scale ppm and PostScript image formats are used,
## otherwise the full color formats are used.
## @end deftypefn

## Author: Klaus Gebhardt <100114.1371@compuserve.com>
## Created: November 1996

function saveimg (filename, img, img_form, map, opt)

  if (nargin < 2 || nargin > 5)
    usage ("saveimg (filename, matrix, [format, [colormap, [opt]]])");
  endif

  if (nargin < 4)
    map = colormap ();
  endif

  if (nargin < 3)
    img_form = "img";
  elseif (! isstr (img_form))
    error ("image format specification must be a string");
  endif

  if (! is_mat (img))
    warning ("image variable is not a matrix");
  endif

  if (! isstr (filename))
    error ("file name must be a string");
  endif

  if (nargin < 5)
    eval (sprintf ("%s_enc (filename, map, img);", img_form));
  else
    eval (sprintf ("%s_enc (filename, map, img, opt);", img_form));
  endif

endfunction
