## Copyright (C) 1996, 1997 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {[@var{x}, @var{map}] =} loadimage (@var{file})
## Load an image file and it's associated color map from the specified
## @var{file}.  The image must be stored in Octave's image format.
## @end deftypefn

## SEE ALSO: saveimage, load, save

## Author: Klaus Gebhardt <110114.1371@compuserve.com>
## Created: November 1996

function [X, map] = loadimage (filename, fmt)

  if (nargin != 1 && nargin != 2)
    usage ("loadimage (filename[, fmt])");
  elseif (! isstr (filename))
    error ("loadimage: expecting filename as a string");
  endif

  if (nargin == 1)
    fmt = "img";
  endif

  if (! isstr (fmt))
    error ("loadimage: expecting fmt as a string");
  endif

  file = file_in_path (IMAGEPATH, filename);

  if (isempty (file))
    error ("loadimage: unable to find image file");
  endif

  eval (sprintf ("[X, map] = %s_dec (file);", fmt));

endfunction
