#define INCL_OS2
#define INCL_PM

#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/**************************************************************************/
  Any variables that must retain their values between draw proc. calls
  must be global and should be defined here.
/**************************************************************************/

VOID    define_global_variables_here;


 /* The following are global variables used in the star-field alg. */

POINTL  points[3000];           /* array of points in the star field.        */
SWP     windowPos;              /* position of YowZa! window.                */
RECTL   windowRect;             /* window pos. in global coordinates         */
UCHAR   screen_cleared=FALSE;   /* screen_clear flag - TRUE = screen cleared */

/**************************************************************************/
  Here begins the draw procedure.
/**************************************************************************/

VOID EXPENTRY YowzaDrawProc(hab, hps, theWindow, parm1, parm2, paintFlag,sysFlags)
HAB     hab;
HPS     hps;
HWND    theWindow;
ULONG   parm1;
ULONG   parm2;
UCHAR  *paintFlag;
UCHAR   sysFlags;

{
/**************************************************************************/
  Declare any local variables here.  Their value will be lost between
  draw proc. calls.
/**************************************************************************/

VOID    define_local_variables_here;


POINTL  aPoint;

   /* this line will make the grapihcs routine re-start if the grapihcs
      are stopped and re-started. */

   if (new_update)
      screen_cleared=FALSE;

   /* place your graphics code here - code for the star field display is
      shown as an example. */


  /* on the first time through, we find the location of YowZa!'s main window
     and convert it to global coordinates then fill the rectangle with
     black - ie. erase the main window to black. */

  if (!screen_cleared)
   {
     WinQueryWindowPos(theWindow,&windowPos);
     windowRect.xLeft   = (LONG) windowPos.x;
     windowRect.yBottom = (LONG) windowPos.y;
     windowRect.xRight  = (LONG) (windowPos.x + windowPos.cx);
     windowRect.yTop    = (LONG) (windowPos.y + windowPos.cy);
     screen_cleared = TRUE;
     WinFillRect(hps,&windowRect,CLR_BLACK);
   }

  /* now pick a random point within the screen bounds and store in the
     star field array. */

  aPoint.x = (rand() % (windowPos.cx-2));
  aPoint.y = (rand() % windowPos.cy);
  points[loop_count++] = aPoint;

  /* pick a random colour to draw this point with and draw it on the screen */

  GpiSetColor(hps,(LONG) rand() % 31);
  GpiMove(hps,&aPoint); aPoint.x++;
  GpiLine(hps,&aPoint);

  /* once we've drawn all 3000 points, we loop through each point in the
     star field and erase each one.  Note the paintFlg reference in the
     for loop.  This insures we don't waste time completing the loop if the
     user moves the mouse or hits a key. */

  if (loop_count == 3000)
   {
     GpiSetColor(hps,CLR_BLACK);
     for (i=0;(i<maxPoints) && *paintFlag;i++)
      {
        GpiMove(hps,&(points[i])); (points[i].x)++;
        GpiLine(hps,&(points[i]));
      }
     loop_count=0;
   }
}

/************************************************************************
  A Sample YowzaQueryGraphics routine.
 ************************************************************************/

VOID EXPENTRY YowzaQueryGraphics(numGraphics, nameText)
USHORT *numGraphics;
UCHAR  **nameText;
{
   *numGraphics = number_of_graphics_routines_in_YOWDRAW_DLL;
   *nameText = (UCHAR*) graphics_names_text_array;
}

 /***************************************************************************
  * This function returns whether a particular graphics algorithm requires  *
  * the screen to be cleared when the routine is first started.             *
  ***************************************************************************/

BOOL EXPENTRY YowzaQueryErase(testAlg)
USHORT  testAlg;

{
   return(GraphicsEraseTable[testAlg]);
}
