#define INCL_DOS
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include "btalk.h"
#include "btclient.h"

int _System BTSayString(char *temp, long frequency, double speed, int flutter)
{
   HQUEUE que;
   HEV sem = 0;
   PID serverpid;
   ULONG rc = FALSE;
   struct QUEUEDATA *queuedata;

   if(!DosAllocSharedMem((void**)&queuedata,NULL,sizeof(struct QUEUEDATA),PAG_COMMIT|OBJ_GIVEABLE|PAG_WRITE) &&
      !DosAllocSharedMem((void**)&queuedata->string,NULL,strlen(temp)+1,PAG_COMMIT|OBJ_GIVEABLE|PAG_WRITE)       )
   {
      strcpy(queuedata->string,temp);
      queuedata->F0hz10 = frequency;
      queuedata->mSec_per_frame = speed;
      queuedata->f0_flutter = flutter;

      if(  !DosOpenQueue(&serverpid,&que,QUEUE) &&
           !DosOpenEventSem(SEMAPHORE,&sem)     &&
           !DosGiveSharedMem(queuedata,serverpid,PAG_WRITE) &&
           !DosGiveSharedMem(queuedata->string,serverpid,PAG_WRITE)  )
      {
         DosWriteQueue(que,SAYSTRING,sizeof(struct QUEUEDATA),queuedata,0);
         DosCloseQueue(que);
         DosPostEventSem(sem);
         DosCloseEventSem(sem);
         rc = TRUE;
      }

      DosFreeMem(queuedata->string);
      DosFreeMem(queuedata);
   }
   return rc;
}

int _System BTSayFile(char *temp, long frequency, double speed, int flutter)
{
   HQUEUE que;
   HEV sem = 0;
   PID serverpid;
   ULONG rc = FALSE;
   struct QUEUEDATA *queuedata;

   if(!DosAllocSharedMem((void**)&queuedata,NULL,sizeof(struct QUEUEDATA),PAG_COMMIT|OBJ_GIVEABLE|PAG_WRITE) &&
      !DosAllocSharedMem((void**)&queuedata->string,NULL,strlen(temp)+1,PAG_COMMIT|OBJ_GIVEABLE|PAG_WRITE)       )
   {
      strcpy(queuedata->string,temp);
      queuedata->F0hz10 = frequency;
      queuedata->mSec_per_frame = speed;
      queuedata->f0_flutter = flutter;

      if(  !DosOpenQueue(&serverpid,&que,QUEUE) &&
           !DosOpenEventSem(SEMAPHORE,&sem)     &&
           !DosGiveSharedMem(queuedata,serverpid,PAG_WRITE) &&
           !DosGiveSharedMem(queuedata->string,serverpid,PAG_WRITE)   )
      {
         DosWriteQueue(que,SAYFILE,sizeof(struct QUEUEDATA),queuedata,0);
         DosCloseQueue(que);
         DosPostEventSem(sem);
         DosCloseEventSem(sem);
         rc = TRUE;
      }

      DosFreeMem(queuedata->string);
      DosFreeMem(queuedata);
   }
   return rc;
}

int _System BTSayNumQueue(long frequency, double speed, int flutter)
{
   HQUEUE que;
   HEV sem = 0;
   PID serverpid;
   ULONG rc = FALSE;
   struct QUEUEDATA *queuedata;

   if(!DosAllocSharedMem((void**)&queuedata,NULL,sizeof(struct QUEUEDATA),PAG_COMMIT|OBJ_GIVEABLE|PAG_WRITE))
   {
      queuedata->string = NULL;
      queuedata->F0hz10 = frequency;
      queuedata->mSec_per_frame = speed;
      queuedata->f0_flutter = flutter;

      if(  !DosOpenQueue(&serverpid,&que,QUEUE) &&
           !DosOpenEventSem(SEMAPHORE,&sem) &&
           !DosGiveSharedMem(queuedata,serverpid,PAG_WRITE)   )
      {
         DosWriteQueue(que,NUMQUEUE,sizeof(struct QUEUEDATA),queuedata,5); /* higher priority */
         DosCloseQueue(que);
         DosPostEventSem(sem);
         DosCloseEventSem(sem);
         rc = TRUE;
      }

      DosFreeMem(queuedata);
   }
   return rc;
}

/* REXX */

#define INCL_REXXSAA
#include <rexxsaa.h>

ULONG _System RxBTSayString(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename, RXSTRING *retstr)
{
   int rc;

   if(argc != 4) return 40;

   rc = BTSayString(argv[0].strptr, atoi(argv[1].strptr), atof(argv[2].strptr), atoi(argv[3].strptr));

   _itoa(rc, retstr->strptr, 10);
   retstr->strlength = strlen(retstr->strptr);
   return 0;
}

ULONG _System RxBTSayFile(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename, RXSTRING *retstr)
{
   int rc;

   if(argc != 4) return 40;

   rc = BTSayFile(argv[0].strptr, atoi(argv[1].strptr), atof(argv[2].strptr), atoi(argv[3].strptr));

   _itoa(rc, retstr->strptr, 10);
   retstr->strlength = strlen(retstr->strptr);
   return 0;
}

ULONG _System RxBTSayNumQueue(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename, RXSTRING *retstr)
{
   int rc;

   if(argc != 3) return 40;

   rc = BTSayNumQueue(atoi(argv[0].strptr), atof(argv[1].strptr), atoi(argv[2].strptr));

   _itoa(rc, retstr->strptr, 10);
   retstr->strlength = strlen(retstr->strptr);
   return 0;
}

ULONG _System RxBTLoad(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename, RXSTRING *retstr)
{
   retstr->strlength = 0;

   RexxRegisterFunctionDll("RxBTSayString","BTCLIENT","RxBTSayString");
   RexxRegisterFunctionDll("RxBTSayFile","BTCLIENT","RxBTSayFile");
   RexxRegisterFunctionDll("RxBTSayNumQueue","BTCLIENT","RxBTSayNumQueue");
   return 0;
}
