/*                                                                   */
/* Tests the REXX interface to SpellGuard                            */
/*                                                                   */
/*   opens the dictionary                                            */
/*   finds the word "test"                                           */
/*   does not find the word "tesst"                                   */
/*   matches the word "tesst"                                         */
/*   prints out the matches of "tesst" along with their               */
/*    similarity index                                               */
/*   closes the dictionary                                           */
/*                                                                   */
PARSE ARG
SIGNAL ON HALT NAME STOP

call RxFuncAdd 'LoadRxGrdFuncs', 'RXGRD', 'LoadRxGrdFuncs'
words.0=0
call LoadRxGrdFuncs
ret=RxSGOpenDictionary("spellgrd.dct","words.usr","spellgrd.ini")

/* 0 is everything okay - 3 just means words.usr not found */
IF ((ret=0) | (ret=3)) THEN
   bOkay=TRUE
ELSE
   bOkay=FALSE

IF (bOkay=FALSE) THEN
DO
   say "ret from Open was " ret
END
ELSE
DO
   ret=RxSGFindWord("test")
   IF (ret = 0) THEN
   DO
      SAY "test not found"
   END
   ELSE
   DO
      SAY "test found"
   END
   ret=RxSGFindWord("tesst")
   IF (ret = 0) THEN
   DO
      SAY "tesst  not found"
      SAY "now running a match for tesst"
      ret=RxSGMatchWord("tesst",75,"words")
      IF (ret = 0) THEN
      DO
         SAY "no matches found"
      END
      ELSE
      DO
         SAY words.0 " matches found "
         DO I=1 to words.0
           SAY words.I.word "-" words.I.index
         END
      END
   END
   ELSE
   DO
      SAY a_word "found"
   END
   CALL RxSGCloseDictionary
END
EXIT

STOP:
   CALL RxSGCloseDictionary
