/*****************************************************************************/
/* Lotus 1-2-3 For OS/2 sample @function. 											  */
/* 																								  */
/* @REXX("REXXDISK.CMD","SPACE",disks..)                                     */
/* 																								  */
/* Returns the most free space available among 'disks'.                      */
/* 																								  */
/* This program isses the DIR command to determine how much space there is   */
/* on each disk, and pipes the output to the REXX queue.  It then reads from */
/* that queue to get the information.	If you run this under OS/2 2.0 there  */
/* is probably a built-in function that could be used in its stead, and it   */
/* is probably much faster.																  */
/* 																								  */
/* @REXX("REXXDISK.CMD logFileName","SPACE",disks..)                         */
/* 																								  */
/* Writes any TRACE or SAY output to a log file named 'logFileName'.         */
/* 																								  */
/* Copyright (c) 1991 Lotus Development Corporation.	This code is supplied  */
/* on an 'as is' basis as an example only.  This code has only received      */
/* informal testing by Lotus.  Permission is granted	to copy and modify	  */
/* this code to your heart's content.  No warrenties expressed or implied.   */
/* Remember, your mileage may vary.  Let us know if you find support of REXX */
/* by 1-2-3 useful.																			  */
/*****************************************************************************/
TRACE R
ARG what,  drives
say what
say drives
IF what = "?" THEN SIGNAL Tell    /* give info if called with "?" as 1st arg */
numDrives = Words(drives)
mostSpace = 0
ADDRESS "CMD"                                     /* direct commands to OS/2 */
DO i = 1 TO numDrives								  /* loop to examine each drive */
	drive = Word(drives, i) 									 /* get the next drive */
	"DIR" drive"\" "| RXQUEUE"         /* fails if no files in root directory */
	DO Queued() - 1; PULL .; END									 /* get the results */
	PULL space . .
	IF space > mostSpace THEN mostSpace = space			  /* most space so far */
	END
IF what = "SPACE" THEN RETURN mostSpace  /* some day return other info maybe */
RETURN 0

Tell: 													  /* return a brief description */
RETURN '@REXX("REXXDISK.CMD","SPACE",disks..) ==> returns most free space',
	"on one of 'disks'."
