/*****************************************************************************/
/* Lotus 1-2-3 For OS/2 sample macro command.                                */
/*                                                                           */
/* {REXXRV "REXXPRSE.CMD",range1,range2}                                     */
/*                                                                           */
/* Intelligently parse a column of strings ('range1') into a range of cells  */
/* ('range2').                                                               */
/*                                                                           */
/* {REXXRV "REXXPRSE.CMD logFileName",range1,range2}                         */
/*                                                                           */
/* Writes any TRACE or SAY output to a log file named 'logFileName'.         */
/*                                                                           */
/* In spreadsheets one often has a table of numbers labeled on the left.     */
/* This macro creates such a table from a column of strings, in which the    */
/* number are separated by blanks.  Such a column of strings can be created  */
/* by pasting a table of numbers from the clipboard.                         */
/*                                                                           */
/* The strategy below is to parse each string from the right, stopping when  */
/* the first non-numeric value is reached.  See the REXXLINK.WG2 file for a  */
/* usage example.                                                            */
/*                                                                           */
/* Copyright (c) 1991 Lotus Development Corporation.  This code is supplied  */
/* on an 'as is' basis as an example only.  This code has only received      */
/* informal testing by Lotus.  Permission is granted  to copy and modify     */
/* this code to your heart's content.  No warrenties expressed or implied.   */
/* Remember, your mileage may vary.  Let us know if you find support of REXX */
/* by 1-2-3 useful.                                                          */
/*****************************************************************************/

ARG inRange, outRange
IF inRange <> "RANGE1" | outRange <> "RANGE2" THEN DO
   CALL Display123Error "Arguments to REXXADD.CMD are not ranges."
   RETURN
   END
PARSE VAR range1.0 cells sheets cols rows
IF sheets > 1 | cols > 1 THEN DO          /* quit if too many sheets or cols */
   CALL Display123Error "range1 must lie in 1 column on 1 sheet."
   RETURN
   END
DO row = 1 TO cells                   /* loop through the cells of the range */
   foundNum = 'no'         /* have not found a numeric value in this row yet */
   parsedIndex = 0
   DO i = Words(range1.row) TO 1 BY -1      /* parse this row from the right */
      thisWord = Word(range1.row, i)
      IF Datatype(thisWord) = "NUM" THEN DO         /* this word is a number */
         parsedIndex = parsedIndex + 1
         parsedValue.parsedIndex = thisWord
         parsedType.parsedIndex = "NUMBER"
         foundNum = 'yes'
         END
      ELSE                                      /* this word is a characters */
         IF foundNum = 'no' THEN DO                   /* no numbers seen yet */
            parsedIndex = parsedIndex + 1
            parsedValue.parsedIndex = thisWord
            parsedType.parsedIndex = "STRING"
            END
         ELSE DO                   /* numbers previously seen; stop the scan */
            parsedIndex = parsedIndex + 1
            parsedValue.parsedIndex = Subword(range1.row, 1, i)
            parsedType.parsedIndex = "STRING"
            LEAVE                                      /* done with this row */
            END
      END
   /* We make a special case if there are 5 cells to be set in this row, in  */
   /* order to demonstrate the Set123Range external function.                */
   IF parsedIndex = 5 THEN DO               /* special case: use Set123Range */
      CALL Set123Range "RANGE1", 1, 4, row, parsedType.5, parsedValue.5, ,
         parsedType.4, parsedValue.4, parsedType.3, parsedValue.3, ,
         parsedType.2, parsedValue.2, parsedType.1, parsedValue.1
      END
   ELSE DO                                                 /* use Set123Cell */
      j = 1
      DO i = parsedIndex TO 1 BY -1                 /* loop to set the cells */
         CALL Set123Cell "RANGE2", 1, j, row, parsedType.i, parsedValue.i
         j = j + 1
         END
      END
   END
RETURN
