/* InsTurbo.CMD */

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

/* Find Mozilla product in the current directory */

SAY
product=''
IF Stream('MOZILLA.EXE','C','QUERY EXISTS')<>'' THEN product='Mozilla'
IF Stream('THUNDERBIRD.EXE','C','QUERY EXISTS')<>'' THEN product='TB'
IF Stream('FIREFOX.EXE','C','QUERY EXISTS')<>'' THEN product='FF'
IF Stream('SEAMONKEY.EXE','C','QUERY EXISTS')<>'' THEN product='SM'
here=Translate(Directory())
IF product='' THEN DO
   SAY 'Error, cannot find any main Mozilla executable in the current directory:'
   SAY '      ' here
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END
SAY 'Product found:' product
IF product='Mozilla' THEN product='MOZ'

/* Compile a list of DLLs, with one space between relative full DLL file specs */

dlls=''
IF Length(product)=2 THEN DO
   
   /* DLLs shared by all non-legacy products */
   dlls=Strip('XUL.DLL LGPLLIBS.DLL MOZSQLT3.DLL FREEBL3.DLL NSPR4.DLL NSS3.DLL NSSCKBI.DLL NSSDBM3.DLL NSSUTIL3.DLL PLC4.DLL PLDS4.DLL SMIME3.DLL SOFTOKN3.DLL SSL3.DLL')
   
   /* Additional DLLs exclusive for FF only */
   IF product='FF' THEN dlls=Strip(dlls 'browser\components\BRWSRCMP.DLL gmp-clearkey\0.1\CLEARKEY.DLL')
   
   /* Additional DLLs exclusive for both SM and TB */
   IF product='SM' | product='TB' THEN dlls=Strip(dlls 'LDAP60.DLL LDIF60.DLL PRLDAP60.DLL')
   
   /* Additional DLLs exclusive for SM only */
   IF product='SM' THEN dlls=Strip(dlls 'components\SUITE.DLL')

END

dll.0=Words(dlls)
DO i=1 TO dll.0
   dll.i=Word(dlls,i)
END i

/* Find the matching TURBO.EXE in the same current directory */

turbo=product||'TURBO.EXE'
IF Stream(turbo,'C','QUERY EXISTS')='' THEN DO
   SAY 'Error, cannot find' turbo 'in the current directory:' here
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END
SAY turbo 'found.'

/* Load DLLs high, if the product is not the legacy Mozilla? */

IF dll.0>0 THEN DO
   loadhigh=0
   IF Length(product)=2 THEN DO
      SAY
      SAY 'Do you want to use memory above 512 MiB for DLLs (default, recommended),'
      CALL CharOut '',"which doesn't require having more than 512 MiB of RAM installed (Y/n)? "
      PULL answer
      answer=Strip(answer)
      IF answer='' THEN answer='Y'
      IF Left(answer,1)='Y' THEN loadhigh=1
      SAY
   END

   /* Load DLLs high? Then first check if all expected DLLs can be found */

   IF loadhigh=1 THEN DO
      dircounter=0
      source=SysBootDrive()||'\CONFIG.SYS'
      DO WHILE Lines(source)>0
         line=Strip(LineIn(source))
         IF Left(Translate(line),8)='LIBPATH=' THEN DO
            PARSE VAR line 1 . 9 line
            begin=Strip(Value('BEGINLIBPATH',,'ENVIRONMENT'))
            IF Right(begin,1)<>';' THEN begin=begin||';'
            IF begin<>';' THEN line=begin||line
            DO WHILE line<>''
               dircounter=dircounter+1
               PARSE VAR line dir.dircounter ';' line
               dir.dircounter=Strip(dir.dircounter)
               IF Right(dir.dircounter,1)<>'\' THEN dir.dircounter=dir.dircounter||'\'
            END
         END
      END
      CALL LineOut source
      dir.0=dircounter

      errors=0
      DO i=1 TO dll.0
         /* DLL file in current directory? */
         
         IF Stream(dll.i,'C','QUERY EXISTS')='' THEN DO
            
            /* Otherwise DLL file in LIBPATH directory? */
            
            DO j=1 TO dir.0
               retry=Stream(dir.j||FileSpec('N',dll.i),'C','QUERY EXISTS')
               IF retry<>'' THEN DO
                  dll.i=dir.j||FileSpec('N',dll.i)
                  j=dir.0
               END
            END j   
            IF retry='' THEN DO
               SAY 'Error: required DLL file' dll.i 'not found in' here 'nor LIBPATH'
               errors=errors+1
            END
         END
      END i
      IF errors>0 THEN DO
         SAY
         CALL Charout '',errors 'fatal DLL file error(s). Press <ENTER>... '
         PULL .
         EXIT
      END
   END
   SAY 'All expected DLLs found.'
   SAY
END

/* Load high */

IF loadhigh=1 THEN DO
   
   /* Try to find ABOVE512.EXE or HIGHMEM.EXE, if the answer was (Y)es */

   file='ABOVE512.EXE'
   high=Stream(file,'C','QUERY EXISTS')
   IF high='' THEN high=Stream('HIGHMEM.EXE','C','QUERY EXISTS')
   IF high='' THEN high=SysSearchPath('PATH',file)
   IF high='' THEN high=SysSearchPath('PATH','HIGHMEM.EXE')
   IF high='' THEN DO
      SAY 'Please enter the full path to' file 'or HIGHMEM.EXE, or press nothing'
      CALL CharOut '','but <ENTER> to try to find it: '
      PARSE PULL high
      SAY
      IF Strip(high)<>'' THEN DO
         IF Right(high,1)<>'\' THEN high=high||'\'
         orghigh=high
         high=high||file
         IF Stream(high,'C','QUERY EXISTS')='' THEN DO
            IF Stream(orghigh||'HIGHMEM.EXE','C','QUERY EXISTS')='' THEN DO
               SAY 'Error: cannot find file' high
               SAY
               CALL CharOut '','Press <ENTER>... '
               PULL .
               EXIT
            END
         END
      END
   END
   IF Strip(high)='' THEN DO   
      SAY file 'or HIGHMEM.EXE not found in current directory nor PATH.'
      SAY 'Searching...'
      drives=SysDriveMap('A:')
      IF drives='' THEN DO
         SAY
         SAY 'Error: no drives found.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END
      drive.0=Words(drives)
      DO i=1 TO drive.0
         okay.i=0
         IF SysDriveInfo(Word(drives,i))<>'' THEN okay.i=1
      END i
      DO i=1 TO drive.0
         IF okay.i=0 THEN ITERATE i
         IF high='' THEN DO
            SAY 'Scanning drive' Word(drives,i)
            pattern1=Word(drives,i)||'\'||file
            pattern2=Word(drives,i)||'\HIGHMEM.EXE'
            IF SysFileTree(pattern1,'hit.','FOS')=2 THEN DO
               SAY
               SAY 'Error: not enough available memory to query a list of files.'
               SAY
               CALL CharOut '','Press <ENTER>... '
               PULL .
               EXIT
            END
            IF hit.0=0 THEN DO
               IF SysFileTree(pattern2,'hit.','FOS')=2 THEN DO
                  SAY
                  SAY 'Error: not enough available memory to query a list of files.'
                  SAY
                  CALL CharOut '','Press <ENTER>... '
                  PULL .
                  EXIT
               END
            END
            IF hit.0>0 THEN DO
               high=hit.1
               SAY
               SAY 'Found:' high
            END
         END
      END i
   END
   IF high='' THEN DO
      SAY
      SAY 'Error:' file 'nor HIGHMEM.EXE found.'
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END
   DO i=1 TO dll.0
      
      /* Is the DLL read-only? */
      
      restore=0
      IF SysFileTree(dll.i,'readonly.','F','***+*')=2 THEN DO
         SAY
         SAY 'Error: not enough available memory to query a list of files.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END
      
      /* If so, then (try to) toggle the setting */
      
      IF readonly.0=1 THEN DO
         restore=1
         IF SysFileTree(dll.i,'readonly.','F',,'***-*')=2 THEN DO
            SAY
            SAY 'Error: not enough available memory to query a list of files.'
            SAY
            CALL CharOut '','Press <ENTER>... '
            PULL .
            EXIT
         END
         IF SysFileTree(dll.i,'readonly.','F','***-*')=2 THEN DO
            SAY
            SAY 'Error: not enough available memory to query a list of files.'
            SAY
            CALL CharOut '','Press <ENTER>... '
            PULL .
            EXIT
         END
         IF readonly.0>0 THEN SAY dll 'unmarked as a read-only file.'
      END
      arguments=dll.i '-c'
      IF Translate(FileSpec('N',high))='HIGHMEM.EXE' THEN arguments='-c' dll.i
      '@'||high arguments
      
      /* (Try to) restore the read-only setting, if possibly changed */
      
      IF restore=1 THEN DO
         IF SysFileTree(dll.i,'readonly.','F',,'***+*')=2 THEN DO
            SAY
            SAY 'Error: not enough available memory to query a list of files.'
            SAY
            CALL CharOut '','Press <ENTER>... '
            PULL .
            EXIT
         END
         IF SysFileTree(dll.i,'readonly.','F','***+*')=2 THEN DO
            SAY
            SAY 'Error: not enough available memory to query a list of files.'
            SAY
            CALL CharOut '','Press <ENTER>... '
            PULL .
            EXIT
         END
         IF readonly.0>0 THEN SAY dll 'marked as a read-only file again.'
      END
   END i
END

name=''
IF product='FF' THEN name='Firefox'
IF product='MOZ' THEN name='Mozilla'
IF product='SM' THEN name='SeaMonkey'
IF product='TB' THEN name='Thunderbird'

name=name 'Turbo'
SAY
IF SysCreateObject('WPProgram',name,'<WP_DESKTOP>','EXENAME=CMD.EXE;PARAMETERS=/c detach' here||'\'||turbo '-l;STARTUPDIR='||here||';MINIMIZED=YES;OBJECTID=<TURBO_'||product||'>','R') THEN DO
   SAY 'Object created:' name
   IF SysCreateObject('WPProgram',name '(unload)','<WP_DESKTOP>','EXENAME='||here||'\'||turbo||';PARAMETERS=-u;STARTUPDIR='||here||';MINIMIZED=YES;OBJECTID=<TURBO_'||product||'_UNLOAD>','R') THEN DO
      SAY 'Object created:' name '(unload)'
      IF SysCreateShadow('<TURBO_'||product||'>','<WP_START>') THEN DO
         SAY'WPS shadow object of' name 'created in the startup folder.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END
   END
END
   
SAY 'Error: cannot create all 3 WPS objects.'
SAY
CALL CharOut '','Press <ENTER>... '
PULL .

EXIT
