/* */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

nl = "0d0a"x

parse source . . sourcepath
sourcepath = left(sourcepath, lastpos("\", sourcepath));

welcome = "",
"Welcome to the _HtmlBook_ installation script"nl||,
"This script will create a folder with some  program objects in the"nl||,
"'Programs\Utilities' folder or on the desktop."nl||,
"NO FILE IS MOVED OR COPIED BY THIS SCRIPT"nl||,
"Before going on with the installation take care of moving the program files"nl||,
"to a proper directory. There is no need to put them in a 'PATH' directory."nl||,
nl||,
"   Press the 'Y' key and 'Enter' to go on with the installation,"nl||,
"   press any other key to abort installation"

say welcome
pull reply
if reply \= 'Y' then
   exit

if (SysOpenObject("<WP_TOOLS>", "DEFAULT", "TRUE")) then
   location = "<WP_TOOLS>"
else
   location = "<WP_DESKTOP>"

/* application folder */
class = "WPFolder"
title = "HtmlBook"
setup = "OBJECTID=<AFC_HTB_FOLDER>;"
rc = makeobj(class, title, location, setup);

/* HtmlBook viewer */
class = "WPProgram"
title = "HtmlBook"
location = "<AFC_HTB_FOLDER>"
setup = "ASSOCFILTER=*.HTB;EXENAME="sourcepath"HTMLBOOK.EXE;"||,
        "OBJECTID=<AFC_HTB_VIEWER>;PARAMETERS=;"
rc = makeobj(class, title, location, setup);

/* HtmlBook bookshelf */
title = "Creator"
setup = "EXENAME="sourcepath"HTMLBOOK.EXE;ICONFILE="sourcepath"HTBMAKE.ICO;"||,
        "OBJECTID=<AFC_HTB_CREATOR>;PARAMETERS=/C;"
rc = makeobj(class, title, location, setup);

/* HtmlBook - Options */
title = "Options"
setup = "EXENAME="sourcepath"HTMLBOOK.EXE;ICONFILE="sourcepath"HTBSETS.ICO;"||,
        "OBJECTID=<AFC_HTB_OPTIONS>;PARAMETERS=/O;"
rc = makeobj(class, title, location, setup);

/* readme object */
htmlviewer = SysIni("USER", "WPURLDEFAULTSETTINGS", "DefaultBrowserExe")
htmlviewer = strip(htmlviewer, "T", "00"x)
workpath = SysIni("USER", "WPURLDEFAULTSETTINGS", "DefaultWorkingDir")
workpath = strip(workpath, "T", "00"x)
title = "Documentation"
setup = "EXENAME="htmlviewer";OBJECTID=<AFC_HTB_DOCS>;"||,
        "PARAMETERS="sourcepath"README.HTM;STARTUPDIR="workpath";"
/*
say " htmlviewer : "htmlviewer
say " workpath   : "workpath
say "setup       : "setup
"@pause"
*/
rc = makeobj(class, title, location, setup);

exit

/* ----------------------------------------------------- */
makeobj: procedure
   parse arg class, title, location, setup
   if SysCreateObject(class, title, location, setup, "R") then
      say " "title" succesfully created..."
   else
      do
         say "Could not create "title
         exit
      end /* do */
   return 1



