/* REXX installation script for WvHTML/2
 * by Russian Team OS/2 
 * http://os2.ru/
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

cls
say '____________________________________________________________'
say ''
say 'WvHtml/2 by Russian Team OS/2                               '
say '____________________________________________________________'
say ''
say 'WvHTML 0.6.1 and WvPM 0.4 installation'
say ''
say ''
say ''


/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

installdir = directory()"\"
installlog = installdir"install.log"

if GetYesNo( "Install WvHTML/2 in" installdir ) == 0 then
   exit

/*------------------------------------------------------------------
 * Create folder
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPFolder","WvHTML","<WP_DESKTOP>",,
                      "OBJECTID=<WPWVHTMLFolder>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log "WvHTML folder successfully created on desktop..."
else       call log "ERROR: WvHTML folder creating failed!"


/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", "WvPM", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WPWVPM>;EXENAME="installdir"wvpm.exe;ASSOTIATION=*.DOC;STARTUPDIR="installdir";REPLACE" )
if rc then       call log "WvPM object successfully created..."
  else           call log "ERROR: WvPM object creating failed!"


rc = SysCreateObject( "WPProgram", "WvHTML/2", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WPWVHTML>;EXENAME="installdir"wvhtml.exe;PARAMETERS=[Enter command line parameters];STARTUPDIR="installdir";REPLACE" )
if rc then       call log "WvHTML/2 object successfully created..."
  else           call log "ERROR: WvHTML/2 object creating failed!"

rc = SysCreateObject( "WPProgram", "Wv Summary", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WPWVHTMLSumm>;EXENAME="installdir"wvsummary.exe;STARTUPDIR="installdir";REPLACE" )
if rc then       call log "Wv Summary object successfully created..."
  else           call log "ERROR: Wv Summary object creating failed!"

rc = SysCreateObject( "WPProgram", "WMF to PNG convertor", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WPWVwmf2png>;EXENAME="installdir"wmf2png\wmf2png.exe;PARAMETERS=[Usage: input.wmf output.png];STARTUPDIR="installdir";REPLACE" )
if rc then       call log "WMF to PNG convertor object successfully created..."
  else           call log "ERROR: WMF to PNG convertor object creating failed!"


rc = SysCreateObject( "WPProgram", "Readme (Russian)", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WVHTMLDocru>;EXENAME=e.exe;PARAMETERS="installdir"\readme_ru.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Readme (rus) object successfully created..."
   else       call log "ERROR: Readme (rus) object creating failed!"

rc = SysCreateObject( "WPProgram", "Readme (English)", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WVHTMLDocen>;EXENAME=e.exe;PARAMETERS="installdir"\readme_en.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Readme(en) object successfully created..."
   else       call log "ERROR: Readme(en) object creating failed!"

rc = SysCreateObject( "WPProgram", "History changes", "<WPWVHTMLFolder>",,
                      "OBJECTID=<WVHTMLHistory>;EXENAME=e.exe;PARAMETERS="installdir"\history.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "History  object successfully created..."
      else    call log "ERROR: History  object creating failed!"




/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/




Exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "INSTALL: "msg

return
