.******************************************************************************
.*  Maul Publisher Rahmen-Handler Hilfedatei
.*   Peter Koller 1998, All Rights Reserved
.* 2003-06    : fw : first partial translation
.* 2004-03    : ch : finished translation, proof-reading re. spelling, grammar,
.*                   and meaning, changed some terms for consistency with other
.*                   help files
.* 2004-11-29 : ch : synchronized HP_OBJ_SAVESTYLE, HP_OBJ_CLIPART with updated
.*                   English version
.* 2005-04-16 : ch : added new translation for objekt wizard help
.* bersetzung Frank Wochatz, Jun 2003
.******************************************************************************
:userdoc.
:title. Hilfe fr den Maul-Rahmen-Handler
:docprof toc=1234.
:h1 res=1 id=intro.ber den Maul-Rahmen-Handler
:i1 id=all.ber den Maul-Rahmen-Handler
:p.:artwork name='bizarre.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul-Voreinstellung fr den Rahmen-Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.berblick ber den Maul-Rahmen-Handler:ehp2.
:p.Der Rahmen-Handler bietet die Mglichkeit, Rahmen in einem Dokument zu erzeugen. 
Ein Rahmen dient als Gerst zur Aufnahme weiterer Handler und zur Formung von Objekten.
Werden einem Rahmen andere Handler zugeordnet, wird in dem Dokument aus einem Rahmen 
ein sichtbares Objekt. 
:p.Wird beispielsweise ein Rahmen in Form einer Linie erstellt, und dieser Linie dann ein 
Umrandungs-Handler zugewiesen, dann wird diese Linie entsprechend ausgedruckt. Die Attribute des 
Umrandungs-Handlers wie Liniendicke und Farbe werden dabei bercksichtigt.
 
:p.Mit dem Rahmen-Handler knnen verschiedene geometrische Formen wie Rechtecke, Figuren 
und Bgen erstellt werden, wobei jede Figur in zwei oder mehreren unterschiedlichen Varianten
zur Verfgung steht. Rechtecke knnen z.B. auch gerundete Ecken bekommen, Figuren knnen aus 
mehreren editierbaren Elementen bestehen, Bgen knnen auch die Form von Kreisauschnitten 
(sog. "Tortenstcke") oder Kreisen haben.
:p.Darber hinaus knnen Rahmen in Gruppen zusammengefat und dann wie ein Objekt behandelt 
werden. Diese Objekte knnen als Cliparts abgespeichert und in andere Dokumente bernommen 
werden.
:p.Zur Einstellung der Gestalt und der Gre der Rahmen werden einige Werkzeuge angeboten.
Mit diesen Werkzeugen knnen die Rahmen skaliert, positioniert und gedreht werden.
Einige Rahmen-Typen erlauben auch das Hinzufgen und Entfernen von bestimmten Elementen.
Rahmen knnen geffnet und geschlossen werden, dadurch kann beispielsweise ein Kreis zu einem
Kreisauschnitt (oder umgekehrt) umgeformt werden. All diese Werkzeuge orientieren sich zur Positionierung 
der einzelnen Objekte an den mglichen Koordinaten des Druckers bzw. an der Druckauflsung
und sind dadurch sehr przise.
:p.Sind die Rahmen-Handler einmal korrekt ins Dokument eingefgt, knnen diesen Rahmen weitere Handler 
hinzugefgt werden. Das kann manuell oder ber Stilvorlagen erfolgen.
:p.
.br
.br
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998, 2001 Peter Koller, Maison Anglais. Alle Rechte vorbehalten.
:p.Details der Lizenzbestimmungen entnehmen Sie bitte dem Urheberrechtshinweis im Haupthandbuch  
des Maul Publishers. 
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
:h1 res=7 id=7 global.Benutzung der Maus
:i1 id=mouseops.Benutzung der Maus
:p.Halten Sie die linke Maustaste gedrckt, um einen Auswahlrahmen aufzuziehen. Dieser Rahmen wird
als gestrichelte Linie dargestellt. Alle anderen Rahmen, die vollstndig innerhalb dieses Auswahlrahmens liegen,
werden nach Loslassen der Maustaste selektiert. Mit dieser Vorgehensweise knnen Sie auf einfache Weise auch 
Rahmen selektieren, die sich sonst nur schwer auswhlen bzw. anklicken lassen, weil sie beispielsweise durch andere Rahmen
verdeckt sind oder nur die Gre eines kleinen Punktes haben.
:p.Im Maul Publisher knnen grundstzlich alle Rahmen nachtrglich mit der Maus verndert werden. Die verschiedenen
Rahmentypen bieten dabei jedoch geringfgig unterschiedliche Optionen.
:p.Die meisten Mausaktionen werden dabei in Kombination mit der Umschalttaste ausgefhrt, einige aber auch mit der 
Strg- oder Alt-Taste. In den meisten Fllen ist die Auswahl der richtigen Taste jedoch offensichtlich.
:p.:hp2.Allgemeine Funktionen:ehp2.
:p.Mit der rechten Maustaste lt sich fr jedes Objekt ein Kontextmen aufrufen. Dieses Men enthlt fr jeden Handler
unterschiedliche objektspezifische Eintrge.
:p.Mit der linken Maustaste knnen alle Objekte durch Ziehen der Maus verschoben werden. Handelt es sich
um Linien oder Kurven, mu die Maus dabei auf der Linie, bei flchigen Rahmen innerhalb der umrandeten Flche 
positioniert werden.
:p.Wird mit der linken Maustaste auf eine Randmarkierung oder auf die Markierung des Objektzentrums geklickt, stehen 
objektspezifische Mausfunktionen zur Verfgung. Die auswhlbaren Objektmarkierungen haben unterschiedliche Formen.
Eine quadratische, schwarz gefllte Markierung zeigt einen Teil einer Linie oder einer Kurve an und wird Griffpunkt genannt.
Eine Markierung in runder oder Diamantform kontrolliert die Kurve einer Linie. Solche Markierungen werden Kontrollpunkte 
genannt. Mittelpunkte von Bgen oder Kreisen werden mit einem Kreuz (X) gekennzeichnet und knnen nicht direkt 
verschoben werden. Benutzen Sie stattdessen die Kontrollpunkte zum Verndern solcher Figuren.
:p.Das Zentrum eines Objekts wird durch ein Kreuz in einem Kreis gekennzeichnet. An diesem Punkt orientieren
sich Funktionen zum Drehen des Objekts. Wird dieser Punkt verschoben, wird die neue Position als Mittelpunkt fr
Drehungen verwendet. Ebenso wird dieser Punkt zum Zentrieren von Bildern und Hintergnden verwendet, in 
Abhngigkeit davon, ob der jeweilige Objekt-Handler das Objektzentrum nutzt.
:p.:hp2.Rechtecke:ehp2.
:p.Rechtecke benutzen Griffpunkte in den Ecken und in der Mitte der Seitenlinien. Durch Ziehen eines Griffpunkts
einer Seitenlinie kann das Objekt in einer Richtung verkleinert oder vergrert werden. Dabei wird die markierte
Linie verschoben und die angrenzenden anderen Seitenlinien des Rechteckes entsprechend verlngert oder
verkrzt. Durch Verschieben eines Eckgriffpunktes werden die Lngen der beiden anliegenden Seitenlinien verndert
und die Gre des Rechtecks kann in zwei Richtungen verndert werden.
:p.Ein Rechteck kann durch Drcken der Umschalttaste beim Ziehen eines Eckgriffpunktes in ein Quadrat umgewandelt werden. 
:p.Siehe auch :link reftype=hd res=40.Erstellung von Rechtecken:elink..
:p.:hp2.Abgerundete Rechtecke:ehp2.
:p.Abgerundete Rechtecke verhalten sich genauso wie normale Rechtecke. Benutzen Sie den Dialog "Bearbeiten",
um den Radius der Rundung der Ecken zu verndern.
:p.:hp2.Figuren:ehp2.
:p.Figuren bestehen aus Linien, Kurven oder Bogensegmenten aus mindestens drei Punkten. Die Funktionsweise
der Maus in Verbindung mit der Strg- und der Umschalttaste hngt davon ab, ob die Figur offen oder geschlossen ist und ob
es sich bei den anliegenden Segmenten um Linien, Kurven oder Bgen handelt.
:p.In jedem Fall bewirkt gleichzeitiges Drcken von Strg und Alt whrend des Ziehens ein Zurcksetzen der
Figur in eine rechtwinklige Form.
:p.&sqbul.Liniensegmente
:p.Linien haben einen Start- und einen Endgriffpunkt. Wird beim Ziehen eines solchen Punktes gleichzeitig die Umschalttaste
gedrckt, kann der Punkt nur so positioniert werden, da eine vertikale, horizontale oder diagonale, um 45 geneigte Linie entsteht. 
:p.&sqbul.Kurvensegmente
:p.Kurven sind Abfolgen verbundener Kurvenlinien mit einem Griffpunkt an jedem Ende und zwei 
Kontrollpunkten. Die Kontrollpunkte haben eine andere Form als die Endgriffpunkte und dienen
zur Justierung der Kurve.
:p.Whrend des Ziehens eines Endgriffpunktes einer Kurve werden die angrenzenden Kontrollpunkte
mit verschoben. Gleichzeitiges Drcken der Umschalttaste aktiviert das Fangraster und erlaubt das Verschieben
des Endgriffpunktes horizontal, vertikal oder diagonal im Winkel von 45. Probieren Sie es am besten einmal aus!
:p.Beim Ziehen eines Kontrollpunktes wird der dazugehrige zweite Kontrollpunkt automatisch mit verschoben
und entsprechend um den Endgriffpunkt der Kurve gedreht.
:p.:artwork name='splex2.bmp' align=left.
:p.In Verbindung mit der Strg-Taste kann eine einzelner Kontrollpunkt gezogen und dadurch eine einzelne
Seite einer Kurve verndert werden. Der zweite Kontrollpunkt wird in diesem Fall nicht bewegt.
:p.:artwork name='splex3.bmp' align=left.
:p.&sqbul.Drei-Punkt-Kreisbogensegmente
:p.Drei-Punkt-Kreisbgen verhalten sich wie Linien, mit der Ausnahme, da zustzlich ein Mittelpunkt vorhanden ist.
Durch Ziehen dieses Punktes wird die Linie 'verbogen' bzw. die Krmmung der Kurve geformt.
:p.:hp2.Bgen:ehp2.
:p.Durch Drcken der Umschalttaste whrend des Ziehens eines Kontrollpunktes wird der Bogen zu einem
Kreisbogen um den Mittelpunkt (gekennzeichnet durch das Kreuz).
:p.Kreisausschnitte haben einen Start- und Endpunkt. Ziehen Sie den Startpunkt um den 
Kreisauschnitt, um den Mittelpunkt zu drehen; ziehen Sie den Endpunkt, um den Kreisausschnitt zu vergrern
oder verkleinern. Die Gre des Kreisbogens wird dabei in der Statuszeile in Prozent angezeigt.
:p.:hp2.Gruppen:ehp2.
:p.:link reftype=hd res=6.Gruppen:elink. verhalten sich wie Rechtecke. 
Halten Sie die Umschalttaste gedrckt, um einen quadratischen statt rechteckigen Auswahlrahmen zu erhalten.
.br
.br
.******************************************************************************
:h1 res=6 id=6 global.ber Gruppen
:i1 id=groups.ber Gruppen
:p.:artwork name='house.bmp' align=left.
:p.Gruppen bestehen aus mehreren Rahmen. Durch Benutzung der Gruppierungsfunktion knnen verschiedene andere 
Rahmen zu einem einzelnen Objekt zusammengefat werden.
:p.nderungen an der Gre oder Position einer Gruppe verndern proportional die Gre oder Positionen der 
enthaltenen Rahmen.
:p.Gruppen knnen wie normale Rahmen bearbeitet, kopiert, eingefgt und ausgeschnitten werden. 
Einschrnkungen bestehen darin, da Gruppen nicht gedreht werden knnen und die Verknpfung von Textrahmen nicht erhalten bleibt. 
Letztgenannte Verknpfungen mssen manuell nach Kopieren oder Einfgen von Gruppen, die verknpfte Textrahmen 
enthalten, angelegt werden.
:p.Eine Gruppierung behindert nicht die normale Rahmenauswahl. Der ausgewhlte Rahmen innerhalb einer Gruppe
wird in einer anderen Farbe dargestellt als die brigen Rahmen dieser Gruppe.
Wenn Sie eine Reihe von Rahmen mittels Gruppierungsmarkierung umschlieen, kann es sein, das kein Rahmen 
ausgewhlt wird. Gruppierungen sind nur mit Rahmen-Handlern mglich. Wenn Sie zu einem anderen Handler wechseln, 
wird der ausgewhlte Rahmen nur hervorgehoben.
:p.Bereits bestehende Gruppen knnen wiederum in anderen Rahmen und Gruppen zusammengefat werden.
Wird eine solche Gruppierung aufgehoben, dann werden die darin bestehenden einzelnen Gruppen wieder korrekt hergestellt.
Diese hierarchische Verschachtelung von Gruppen in Gruppen kann beliebig oft und tief erfolgen.
:p.Gruppen knnen auf die gleiche Art und Weise wie andere Objekte zu jeder anderen Gruppe ausgerichtet, in der Gre 
verndert und zentriert werden. 
.br
.******************************************************************************
.*  Men Bearbeiten
.******************************************************************************
:h1 res=8 id=8 global.Das Men Bearbeiten des Rahmen-Handlers
:i1 id=edit.Das Men Bearbeiten des Rahmen-Handlers
:p.Dieses Men fgt Maul folgende Funktionen hinzu&colon.
:ul compact.
:li.:link reftype=hd res=22.Bearbeiten:elink. eines Objektes oder einer :link reftype=hd res=6.Gruppe:elink.
unter Verwendung eines Dialoges fr grere Przision.
:li.:link reftype=hd res=10.Ausschneiden:elink. eines Objektes oder einer Gruppe und Kopieren in die Zwischenablage.
:li.:link reftype=hd res=11.Kopieren:elink. eines Objektes oder einer Gruppe in die Zwischenablage.
:li.:link reftype=hd res=12.Einfgen:elink. eines Objektes oder einer Gruppe aus der Zwischenablage.
:li.:link reftype=hd res=13.Lschen:elink. eines Objektes oder einer Gruppe.
:li.:link reftype=hd res=14.Schtzen:elink. eines Objektes oder einer Gruppe.
:li.:link reftype=hd res=15.Zurcksetzen:elink. des Objektzentrums.
:li.:link reftype=hd res=16.Verschieben:elink. einen Objektes in den Vordergrund oder hinter ein anderes Objekt.
:li.:link reftype=hd res=18.Gruppieren:elink. von Objekten.
:li.:link reftype=hd res=19.Ausrichten:elink. von Objekten zueinander.
:li.:link reftype=hd res=20.Zentrieren:elink. von Objekten auf der Seite.
:li.:link reftype=hd res=21.Angleichung:elink. 
:li.:link reftype=hd res=27.Drehen:elink. oder Spiegeln eines Rahmens oder einer Gruppe.
:li.:link reftype=hd res=28.Ein neues Objekt erstellen:elink.
:li.Festlegen des :link reftype=hd res=17.Objektmodus:elink..
:li.Festlegen der Reihenfolge der :link reftype=hd res=56.Ebenen:elink. eines Objekts.
:li.Festlegen des :link reftype=hd res=26.Stils:elink. eines Objekts.
:eul.
.*******************************************************************************
:h2 res=22 id=22 global.Bearbeiten eines Objektes oder eines Gruppe ber einen Dialog
:i2 refid=edit.Bearbeiten eines Objektes oder eines Gruppe ber einen Dialog
:p.Sie knnen ein Objekt oder eine :link reftype=hd res=6.Gruppe:elink. bearbeiten, indem Sie die Hhe, Breite
und Position auf der Seite verndern. Der entsprechende Dialog behandelt alle Objekte wie Rechtecke mit einer horizontalen
und vertikalen Komponente. Hat das Objekt eine abweichende Form, dann wird um das Objekt ein imaginres Rechteck gelegt, 
welches die Form des Objektes vollstndig umschliet, und die gewnschte Vernderung diesem Rechteck entsprechend
berechnet.
nderungen an der Gre oder Position dieses imaginren Rechtecks bewirken eine Skalierung und Bewegung
des ausgewhlten Objektes oder der Gruppe, so da diese perfekt in die Gre oder Position des neuen Rechteckes 
eingepat werden.
:p.Geben Sie in jedes Feld, dessen Wert Sie ndern mchten, eine Zahl und die zu verwendene Maeinheit ein, z.B. 0.5cm.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt). 
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. In diesem Fall handelt es sich um ein 
britisches Inch. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel 
interpretiert. Der Wert wird stets in dieser Einheit gespeichert.
.*******************************************************************************
:h3 res=23 id=23 global.Drehen eines Objektes mittels Dialog
:i2 refid=edit.Drehen eines Objektes mittels Dialog
:artwork name='rotdlg.bmp' align=left.
:p.Dieser Dialog bietet einige interessante Mglichkeiten. Sie knnen damit Objekte drehen, aber auch die 
Ausrichtung bestimmter Objekte verndern.
:p.Die Ausrichtung wirkt sich nicht auf die eigentliche Gestalt bzw. den Umri eines Objektes aus, sondern 
dient zur Drehung der sichtbaren Daten eines Objekt-Handlers innerhalb eines Rahmens. Auf diese Weise
lassen sich mit einem Rahmen verbundener Text und/oder Bilder gleichzeitig drehen.
.*******************************************************************************
:h3 res=24 id=24 global.Eingabe der Werte fr die Rundung von Rechtecken mittels Dialog
:i2 refid=edit.Eingabe der Werte fr die Rundung von Rechtecken mittels Dialog
:p.Geben Sie in jedes Feld, dessen Wert Sie ndern mchten, eine Zahl und die zu verwendene Maeinheit ein, z.B. 0.5cm. 
Der Wert steht fr den Radius der gerundeteten Ecken. Auf Null gesetzt bewirkt der Wert, da die Ecken nicht abgerundet,
sondern eckig werden. Wenn Sie fr das Rechteck einen Wert eingeben, der grer ist als die Gre der Figur, erhalten Sie 
einen seltsamen aber recht interessanten Effekt. 
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt). 
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. In diesem Fall handelt es sich um ein 
britisches Inch. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel 
interpretiert. Der Wert wird stets in dieser Einheit gespeichert.
.*******************************************************************************
:h3 res=25 id=25 global.Dialog Tortensegmente oder Kreisausschnittsgre und Ausrichtung
:i2 refid=edit.Dialog Tortensegmente oder Kreisausschnittsgre und Ausrichtung
:artwork name='arcdlg.bmp' align=left.
:p.Benutzen Sie diesen Dialog, um Tortensegmente oder Kreisausschnitte zu erstellen.
Dabei ist es wichtig zu verstehen, da der Startwinkel relativ zur aktuellen Objektausrichtung steht
und da diese durch die Bogenkontrollpunkte bestimmt wird.
:p.Um die Erstellung von Geschftsgrafiken zu vereinfachen, wird das Bogenma in Prozent und nicht in Grad
angegeben, wobei 100 Prozent fr einen vollstndigen Kreis stehen, 50 Prozent fr einen Halbkreis (180) usw.
.*******************************************************************************
:h2 res=10 id=10 global.Ausschneiden eines Objektes oder einer Gruppe in die Zwischenablage
:i2 refid=edit.Ausschneiden eines Objektes oder einer Gruppe in die Zwischenablage
:p.Benutzen Sie diesen Meneintrag, um das aktuelle Objekt einschlielich Inhalt auszuschneiden und in die Zwischenablage zu
kopieren. Anschlieend wird das Objekt aus dem Dokument gelscht.
:p.Verknpfungen zu dem ausgeschnittenen Objekt gehen dabei verloren. Wenn das Objekt wieder aus der Zwischenablage 
in das Dokument eingefgt wird, mssen die Verknpfungen manuell neu hergestellt werden.
:p.Wird die Funktion auf eine Reihe von gruppierten Objekten angewendet, werden alle Objekte wie ein groes Objekt 
behandelt. Die Daten aus der Zwischenablage sind nicht kompatibel mit lteren Versionen des Maul Publishers.
:p.Der Befehl Ausschneiden kann mit der Tastenkombination Umschalten + Entfernen aufgerufen werden.
.*******************************************************************************
:h2 res=11 id=11 global.Kopieren eines Objektes oder einer Gruppe in die Zwischenablage
:i2 refid=edit.Kopieren eines Objektes oder einer Gruppe in die Zwischenablage
:p.Benutzen Sie diesen Meneintrag, um das aktuelle Objekt einschlielich Inhalt in die Zwischenablage zu 
kopieren. 
:p.Verknpfungen zu dem kopierten Objekt gehen dabei verloren. Wenn das Objekt aus der Zwischenablage 
in das Dokument eingefgt wird, mssen die Verknpfungen manuell neu hergestellt werden.
:p.Wird die Funktion auf eine Reihe von gruppierten Objekten angewendet, werden alle Objekte wie ein groes Objekt 
behandelt. Die Daten aus der Zwischenablage sind nicht kompatibel mit lteren Versionen des Maul Publishers.
:p.Der Befehl Kopieren kann mit der Tastenkombination Strg + Einfgen aufgerufen werden.
.*******************************************************************************
:h2 res=12 id=12 global.Einfgen eines Objektes oder einer Gruppe aus der Zwischenablage
:i2 refid=edit.Einfgen eines Objektes oder einer Gruppe aus der Zwischenablage
:p.Benutzen Sie diesen Meneintrag, um das aktuelle Objekt einschlielich 
Inhalt aus der Zwischenablage in die aktuelle Seite einzufgen. Form und Gre 
des Objektes werden an die momentanen DPI-Einstellungen (dots per inch) des 
Dokumentes angepat, und das neue Objekt wird auf dem Bildschirm zentriert. 
:p.Das z.Z. ausgewhlte Objekt wird dabei nicht gelscht.
:p.Wird die Funktion auf eine Reihe von gruppierten Objekten angewendet, 
werden alle Objekte wie ein groes Objekt behandelt. Die Daten aus der 
Zwischenablage sind nicht kompatibel mit lteren Versionen des Maul 
Publishers. 
:p.Durch Auswahl des Meneintrags 'Rahmen/Gruppe mehrmals einfgen'
lassen sich Rahmen oder Gruppen so oft wie mglich in eine Seite
einfgen. Die Seite wird dabei von links nach rechts und von oben nach
unten aufgefllt, wobei der Abstand so gering gewhlt wird, da sich
benachbarte Rahmen gerade nicht berlappen.
:p.Der Befehl Einfgen kann mit der Tastenkombination Umschalten + Einfgen aufgerufen werden.
.*******************************************************************************
:h2 res=13 id=13 global.Lschen eines Objektes oder einer Gruppe
:i2 refid=edit.Lschen eines Objektes oder einer Gruppe
:p.Benutzen Sie diesen Meneintrag, um das aktuelle Objekt einschlielich Inhalt zu lschen.
:p.Wenn das gelschte Objekt Teil einer Kette verknpfter Objekte war, dann wird das vorhergehende Objekt der
Kette mit dem nachfolgenden Objekt verknpft.
:p.Wird die Funktion auf eine Reihe von gruppierten Objekten angewendet, werden alle Objekte wie ein groes Objekt 
behandelt.
:p.Der Befehl Lschen kann mit der Taste Entfernen aufgerufen werden.
.*******************************************************************************
:h2 res=14 id=14 global.Objekt oder Gruppe sperren
:i2 refid=edit.Objekt oder Gruppe sperren
:p.Das Objekt oder die :link reftype=hd res=6.Gruppe:elink. kann gesperrt werden. 
Ein gesperrtes Objekt kann nicht verschoben, in der Gre verndert oder gruppiert werden.
Das ist bei der Arbeit mit Objekten ntzlich, die nicht aus Versehen verndert werden drfen.
Wird ein gesperrtes Objekt kopiert und die Kopie in das Dokument eingefgt, wird die Sperrung des
neuen Objekts automatisch aufgehoben.
.*******************************************************************************
:h2 res=15 id=15 global.Zurcksetzen des Objektzentrums
:i2 refid=edit.Zurcksetzen des Objektzentrums
:p.Diese Funktion ermittelt das kleinste Rechteck, welches die ausgewhlte Figur umschlieen kann. Dann wird das
Zentrum des Objektes auf das Zentrum des imaginren Rechtecks gesetzt.
Das Objektzentrum wird von einigen Handlern verwendet, um die Position der Darstellung der Daten innerhalb des 
Objektes zu bestimmen. Desweiteren wird es als Mittelpunkt fr die Drehung des Objektes benutzt.
:p.Beachten Sie, da einige Operationen an bestimmten Objekt-Handlern ebenfalls ein Zurcksetzung des Zentrums bewirken.
.*******************************************************************************
:h2 res=16 id=16 global.Reihenfolge der Rahmen
:i2 refid=edit.Reihenfolge der Rahmen
:p.:hp2.Rahmen in den Hinter- oder Vordergrund verschieben:ehp2.
:p.Benutzen Sie diese Funktion, um einen Rahmen in der Vorder- oder Hintergrund zu verschieben.
Dies ist z.B. erforderlich, wenn einzelne Objekte durch andere verdeckt werden.
:p.Maul ist in der Lage, Text Bilder umflieen zu lassen, wenn ein Bildobjektrahmen 
in den Vordergrund eines Textobjektrahmens geschoben wird. Dies trifft auch zu,
wenn sowohl Text- als auch Bildobjekt nicht rechteckig sind.
.*******************************************************************************
:h2 res=18 id=18 global.Gruppierung von Objekten
:i2 refid=edit.Gruppierung von Objekten
:p.Mitunter entsteht der Wunsch, Objekte zu Gruppen verbinden zu knnen. Eine Gruppe kann eine Reihe von
Rahmen enthalten, die als eine Einheit kopiert, gesichert, skaliert und bewegt werden knnen.
Sobald ein Satz Rahmen gruppiert worden ist, werden beim Bewegen eines Rahmens alle anderen Rahmen
gleichermaen bewegt, das Kopieren einer Gruppe kopiert alle darin enthaltenen Rahmen usw.
:p.Die meisten Gruppenoperationen sind ber einfachen Ziehen eines gestrichelten Auswahlrahmens um
die Rahmen oder Gruppen von Interesse mglich. Smtliche Rahmen oder Gruppen, die sich nicht vollstndig
innerhalb dieser Umrahmung befinden, werden dabei ignoriert.
:p.Zum Kopieren und Einfgen oder Laden und Sichern von Gruppen mssen die Objekte zuerst gruppiert werden.
Ist dies erfolgt, wird bei Auswahl eines Rahmens der Gruppe nur dieser Rahmen ausgewhlt, damit Vorgnge
fr einzelne Rahmen, wie das Hinzufgen eines Objekt-Handlers, weiterhin stattfinden knnen. Der ausgewhlte
Rahmen wird in einer von den anderen Rahmen verschiedenen Farbe dargestellt. Der Rahmen-Handler selektiert und
behandelt die Gruppe aus Rahmen jedoch als eine Einheit, wodurch es mglich wird, alle Rahmen zusammen in
der Gre zu ndern und zu verschieben.
:p.Wenn es erforderlich werden sollte, einen einzelnen Rahmen einer Gruppe zu modifizieren, kann die Gruppierung
einer Gruppe aufgehoben werden. Desweiteren knnen Rahmen einer Gruppe hinzugefgt werden, indem beide ausgewhlt
und dann gruppiert werden. Mehreren Gruppen und Rahmen knnen zu umfangreicheren Gruppen zusammengefat werden.
.*******************************************************************************
:h2 res=19 id=19 global.Objekte ausrichten
:i2 refid=edit.Objekte ausrichten
:p.Mit Hilfe dieser Funktion knnen Objekte aneinander ausgerichtet werden. Der Vorgang hngt von den ausgewhlten
Objekten ab.
:p.:hp2.Ausgewhlte Objekte bilden eine einzelne Gruppe:ehp2.
:p.Alle anderen Rahmen innerhalb der Gruppe werden am derzeit ausgewhlten Rahmen ausgerichtet.
:p.:hp2.Ausgewhlte Objekte bestehen aus einer Reihe von Rahmen oder Gruppen:ehp2.
:p.Smtliche Objekte oder Gruppen werden am Mittelpunkt des Auswahlrahmens ausgerichtet. Dabei bleiben die
Verhltnisse der Objekte in Gruppen zueinander erhalten.
:p.Bei obigen Vorgngen knnen die Objekte vertikal, horizontal oder in beiden Richtungen ausgerichtet werden.
.*******************************************************************************
:h2 res=20 id=20 global.Objekte zentrieren
:i2 refid=edit.Objekte zentrieren
:p.Mit Hilfe dieser Funktion lassen sich Objekte am Mittelpunkt der aktuellen Seite zentrieren. Dabei knnen
entweder smtliche Objekte zum Mittelpunkt der Seite bewegt werden, oder es werden alle ausgewhlten Objekte
unter Beibehaltung ihrer relativen Positionen zentriert. ber diese Funktion kann auch ein einzelnes Objekt
zentriert werden.
:p.Bei obigen Vorgngen knnen die Objekte vertikal, horizontal oder in beiden Richtungen ausgerichtet werden.
.*******************************************************************************
:h2 res=21 id=21 global.Objektgren angleichen
:i2 refid=edit.Objektgren angleichen
:p.Mit Hilfe dieser Funktion lassen sich Objekte auf eine einheitliche Gre bringen. Dabei hngt es
von den ausgewhlten Objekten ab, was der Vorgang genau bewirkt.
:p.:hp2.Die ausgewhlten Objekte stammen aus einer einzelnen Gruppe:ehp2.
:p.Smtliche Rahmen der Gruppe werden an die Gre des derzeit ausgewhlten Rahmens angepat.
:p.:hp2.Bei den ausgewhlten Objekten handelt es sich um eine Reihe von Rahmen und Gruppen:ehp2.
:p.Smtliche Objekte oder Gruppen werden an die Gre der grten Gruppe angepat.
:p.:hp2.Bei den ausgewhlten Objekten handelt es sich ausschlielich um Rahmen:ehp2.
:p.Smtliche Objekte werden an die Gre des grten Rahmens angepat.
:p.Bei allen Gruppenvorgngen kann ausgewhlt werden, ob die Objekte vertikal, horizontal oder in beiden
Richtungen angepat werden.
.br
.br
.*******************************************************************************
:h2 res=27 id=27 global.Drehen oder Spiegeln von Rahmen und Gruppen
:i2 refid=edit.Drehen oder Spiegeln von Rahmen und Gruppen
:p.Rahmen und Gruppen lassen sich in Schritten von 90 Grad drehen. Desweiteren knnen Rahmen
und Gruppen durch horizontales oder vertikales Umdrehen gespiegelt werden.
:p.:hp2.Drehen:ehp2.
:p.Beim Drehen von Rahmen wird die interne Ausrichtung der Rahmen angepat, um die nderung
wiedergeben.
:p.Die Rahmenausrichtung wird von Objekt-Handlern genutzt, und die Objekt-Handler zeichnen
den Bildschirm entsprechend der nderung neu.
:p.Beachten Sie, da Objekt-Handler eigenen Werte fr Ausrichtung und Richtung verwenden knnen
und sich die schlieliche Ausrichtung von Text oder Bildern daher aus einer Kombination
verschiedener Einstellungen ergeben kann.
:p.:hp2.Spiegeln:ehp2.
:p.Beim Spiegeln von Rahmen wird die interne Ausrichtung der Rahmen angepat, um die nderung
wiedergeben.
:p.Die Spiegelfunktion unterteilt die aktuelle Rahmenausrichtung in vertikale und horizontale
Kompenenten und kehrt dann die zutreffende Komponente vor der Neuberechnung des Vektors um.
:p.Die Rahmenausrichtung wird von Objekt-Handlern genutzt, und die Objekt-Handler zeichnen
den Bildschirm entsprechend der nderung neu.
:p.Beachten Sie, da Objekt-Handler eigenen Werte fr Ausrichtung und Richtung verwenden knnen
und sich die schlieliche Ausrichtung von Text oder Bildern daher aus einer Kombination
verschiedener Einstellungen ergeben kann.
:p.Als Beispiel sei ein Hintergrund mit Farbverlauf mit einem horizontalen Winkel der Objektdaten
von 90 Grad und einem Rahmenwinkel von 90 Grad gegeben. Wird der Rahmen gespiegelt, so ndert sich
der Farbverlauf des Hintergrunds nicht so, wie man es vielleicht erwarten wrde. Bei einer vertikalen
Umkehrung ndert sich die Richtung des horizontalen Farbverlaufs, eine horizontale Umkehrung wird
ignoriert.
.br
.br
.*******************************************************************************
:h2 res=28 id=28 global.Objekterstellungsassistent
:i2 refid=edit.Objekterstellungsassistent
:p.Der Objekterstellungsassistent soll neuen Anwendern des Maul Publisher bei der Erstellung von
Text oder Bildern helfen. Der Assistent fhrt Sie mit Hilfe von entweder drei oder vier Dialogen
durch den Vorgang.
:p.Nachdem Sie gelernt haben, dies manuell durchzufhren, knnen Sie den Assistenten deaktivieren.
:p.:hp2.Die Dialoge des Assistenten:ehp2.
:ul.
:li.:link reftype=hd res=29.Inhalts- oder Umrandungsebene auswhlen:elink.
:li.:link reftype=hd res=30.Ebene auswhlen:elink.
:li.:link reftype=hd res=31.Objekt-Handler auswhlen:elink.
:li.:link reftype=hd res=32.Datenquelle auswhlen:elink.
:eul.
.br
.br
.*******************************************************************************
:h3 res=29 id=29 global.Inhalts- oder Datenebene auswhlen
:p.Hat man einen Rahmen mit einer Innenflche erstellt, wie etwa ein Rechteck, so kann
eine Inhaltsebene hinzugefgt werden. Hat man dagegen einen offenen Rahmen erstellt, wie
etwa eine Linie, lt sich nur eine Umrandungsebene hinfgen.
:p.Dieser Dialog bernimmt die Auswahl einer der Objektebenenschaltflchen. Bei diesen handelt
es sich um die Schaltflchen mit Fragezeichen.
:p.Entfernen Sie die Markierung des Markierungsfelds 'Stets Objektassistent verwenden', damit
der Assistent nicht automatisch aufgerufen wird. Der Assistent lt sich anschlieend immer
noch ber das Men 'Bearbeiten' des Rahmen-Handlers aufrufen.
.br
.br
.*******************************************************************************
:h3 res=30 id=30 global.Ebene auswhlen
:p.Es stehen vier Ebenen zur Verfgung. Die Schichtung mehrerer Objekte in Rahmen hat
den Vorteil, da Objekte wie Text und Bilder zum selben Rahmen gehren und als eine
Einheit bewegt werden knnen. Die beiden oberen Ebenen knnen in Wechselwirkung gebracht werden,
beispielsweise, um Text innerhalb von Bildern zu plazieren. Siehe die
:link reftype=hd res=17.Einstellungen fr Objektmodi:elink..
:p.Falls gewnscht, knnen die Ebenen zu einem spteren Zeitpunkt mit Hilfe des Dialogs
:link reftype=hd res=56.Ebenenanordnung:elink. vertauscht werden.
:p.Dieser Dialog bernimmt die Auswahl einer der aus den Objektebenenschaltflchen
ausklappenden Schaltflchen sowie die Auswahl einer spezifischen Ebene. Dieser Schritt lt sich
durch Nutzung der Objektebenenschaltflchen umgehen.
.br
.br
.*******************************************************************************
:h3 res=31 id=31 global.Objekt-Handler auswhlen
:p.Text und Bilder werden mit Hilfe von Objekt-Handlern dargestellt. Der Dialog zeigt die
fr diese Ebene verfgbaren Objekt-Handler an.
:p.Mehr ber die Funktion eines Objekt-Handlers erfahren Sie, indem Sie ihn auswhlen
und 'Hilfe' drcken. Dadurch wird die Hilfeseite 'ber' des jeweiligen Handlers aufgerufen.
:p.Zum Erstellen der neuen Objektebene drcken Sie 'Weiter' oder 'Fertig'.
.br
.br
.*******************************************************************************
:h3 res=32 id=32 global.Datenquelle auswhlen
:p.Nach Auswahl eines Objekt-Handlers kann dieser angewiesen werden, z.B. Daten aus der Zwischenablage
zu laden oder ein Bild einzuscannen.
:p.Dieser Dialog wird nur angezeigt, wenn aus verschiedenen Datenquellen ausgewhlt werden kann.
Die hier ausgewhlten Optionen werden als Anforderung an den Objekt-Handler gesendet. Die verschiedenen
Handler reagieren auf solche Anfragen unterschiedlich.
:ul.
:li.Einfgen aus Zwischenablage. Diese Option steht zur Verfgung, wenn der Assistent erkannt hat,
da in der Zwischenablage fr dem ausgewhlten Handler kompatible Daten vorhanden sind.
:li.Datei laden, wenn mglich. Dies ist die Voreinstellung. Der Assistent weist den Objekt-Handler an,
Daten aus einer geeigneten Datei zu laden. Der Objekt-Handler kann diese Aufforderung ignorieren
oder anders reagieren. In einem solchen Fall mssen Sie entweder Text oder eine Option eingeben oder
statt dessen eine der Importfunktionen des Mens 'Datei' benutzen.
:li.Mit Scanner einlesen. Diese Option steht derzeit nur fr Bitmaps zur Verfgung. Es knnen alle
TWAIN-kompatiblen Datenquellen wie Scanner oder Digitalkameras verwendet werden.
:li.Objekt leer lassen. Mit dieser Option wird dem Rahmen ein Objekt hinzugefgt, jedoch nichts weiter.
Der Objekt-Handler wird mit Standardwerten initialisiert. Bei manchen Handlern hat diese Option dieselbe
Funktion wie 'Daten laden'.
:eul.
.br
.br
.*******************************************************************************
:h2 res=17 id=17 global.Festlegen des Objektmodus
:i2 refid=edit.Festlegen des Objektmodus
:p.Fr Objekte steht eine Reihe von Modi zur Verfgung. Grundstzlich entscheiden diese Modi darber,
wie Handler mit Rahmen umgehen.
:p.:hp2.Objekt sperren:ehp2.
:p.Das Objekt ist gesperrt; es kann weder gezogen noch in der Gre verndert werden.
:p.:hp2.Transparentes Objekt:ehp2.
:p.Ist diese Option aktiviert, wirkt sich das Objekt nicht auf darunterliegende Objekte aus. Befindet sich
beispielsweise ein Rahmen ber einem anderen, wird der Inhalt des unteren Rahmens so neu formatiert, da
er den oberen umfliet. Im Rahmemmodus transparent ist die Neuformatierung abgeschaltet.
:artwork name='transpar.bmp' align=left.
.br
:p.:hp2.Selbstzuschneidendes Objekt (Inhalt oder Umrandung):ehp2.
:p.Dieser Modus ist fr Handler bestimmt, die Artefakte erzeugen. Ein Artefakt ist eine gezeichnete Figur, wie
etwa Text, Linien oder eine bestimmte Form mit einer einzigen Farbe. Beachten Sie, da es sich bei z.B. Bitmaps
nicht um Artefakte handelt.
:p.Derzeit ist Text (einschlielich der Textsymbole) das einzige zur Verfgung stehende Artefakt. OS/2 ist in der
Lage, aus Artefakten wie Text einen Schneidpfad zu erzeugen, und dann folgende Zeichnungen auf den Schneidpfad
zuzuschneiden.
:p.Erstellen Sie einen Rahmen. Fgen Sie dann der Ebene 0 ein Textobjekt hinzu, und der Ebene 1 ein Bitmap-
oder farbiges Hintergrundobjekt. Es ist sogar mglich, Text innerhalb von Text zu positionieren, wobei dieser
jedoch nicht so formatiert wird, da er in den oberen Text hineinpat. Dieses Vorgehen funktioniert sowohl
bei Rahmenumrandungen als auch bei Rahmeninhalten.
:p.Setzen Sie den Selbstzuschneidemodus fr Umrandung oder Inhalt, und der Rahmen-Handler kehrt die Zeichenreihenfolge
um, so da der Hintergrund (Ebene 1) innerhalb des Vordergrunds (Ebene 0) erscheint.
:p.Damit lassen sich Ergebnisse der folgenden Art erzielen...
:p.:artwork name='wow.bmp' align=left.
.br
:p.:hp2.Maskengrenzen aktivieren:ehp2.
:p.Es ist mglich, Text um maskierte Bitmaps herum zu formatieren. Die Funktion wird ber diesen Modus
aktiviert. Es gilt jedoch, einige Punkte zu beachten.
:ul.
:li.Die Bitmap mu eine Maske besitzen und in der Inhaltsebene Null liegen.
:li.Bei der Feststellung der Grenzen wird die Maske :hp1.anstelle:ehp1. des Rahmens verwendet.
:li.Die Maske mu vollstndig im kleinsten Rechteck liegen, von dem sich der Rahmen umschlieen lt,
oder es kommt zu Abschneideeffekten.
:li.Handelt es sich um eine ausgelagerte Bitmap, so wird nur die Maske des Platzhalters verwendet. Dies rhrt daher,
da bei der Grenzbestimmung kein zustzlicher Speicher zur Verfgung steht, in den ausgelagerte Bitmaps geladen
werden knnten, und weil es wenig oder keinen Sinn macht, Grenzen noch genauer zu bestimmen.
:eul.
:p.:artwork name='maskmap.bmp' align=left.
.br
:p.:hp2.Gruppe automatisch skalieren:ehp2.
:p.Dieser Modus lt sich aufgrund der Verfahrensweise bei der Skalierung von Gruppen nur auf Gruppen
anwenden. Wird der Modus aktiviert, wird den zugeordneten Handlern mitgeteilt, wenn eine Gruppe in der
Gre gendert wird. Auf diese Weise wird sichergestellt, da die Objektdaten entsprechend der Objektgre
skaliert werden. Der Skalierungseffekt wirkt normalerweise rechtwinklig; wenn man also die Hhe eines Objekts
ndert, bedeutet dies nicht notwendigerweise, da die Objektdaten so verzerrt werden, da es perfekt eingepat
wird.
.br
.br
.*******************************************************************************
:h2 res=56 id=56 global.Dialog Objektebenen anordnen
:i2 refid=edit.Dialog Objektebenen anordnen
:p.Durch Auswahl des Meneintrags 'Objektebenen anordnen...' des Mens 'Objekt' wird der Dialog 'Objektebenen anordnen'
aufgerufen.
:p.:hp2.Beschreibung:ehp2.
:p.Der sichtbare Teil eines Rahmens wird durch Objekte bestimmt. Diese Objekte werden ber Objekt-Handler modifiziert.
:p.Der Rahmen-Handler ist fr die Reihenfolge verantwortlich, in der Objekte dargestellt werden. Jeder Rahmen
ist in der Lage, jeweils vier Inhalts- und Umrandungsebenen zu untersttzen. Beim Darstellungsvorgang wird jede
Ebene ber die vorhergehende gezeichnet und trgt so zum Endzustand des Bildes auf der Seite bei.
:p.Mit Hilfe des Dialogs zur Ebenenanordnung knnen Objekte so getauscht werden, da sie in einer anderen Reihenfolge
dargestellt werden. Da Ebenen auch leer sein knnen, ist es auch mglich, mit leeren Ebenen zu tauschen.
Oben im Listenfeld aufgefhrte Ebenen werden zuletzt gezeichnet und berdecken so die darunter befindlichen Ebenen.
:p.:hp2.Anwendung:ehp2.
:p.Whlen Sie die zu bewegende Ebene aus. Klicken Sie dann auf die Schaltflchen 'Auf' und 'Ab', bis sich die Ebene
an der gewnschten Position befindet. Nach Beendigung der Arbeiten klicken Sie auf die Schaltflche 'Anwenden',
um die nderungen zu bernehmen. Anschlieend knnen Sie die Ebenen nochmals ndern, durch Klick
auf einen anderen Rahmen dessen Ebenen bearbeiten oder den Dialog durch Bettigen der Schaltflche 'Beenden' verlassen.
:p.Wie alle Maul-Dialoge, die mit den Schaltflchen 'Anwenden' und 'Beenden' ausgerstet sind, luft auch der
Dialog zur Ebenenanordnung in einem eigenen Thread und kann sogar auf dem Bildschirm verbleiben, wenn man
die darunterliegenden Rahmen bearbeitet. Er wird beim Beenden oder durch Auswahl eines anderen Handlers automatisch
geschlossen.
:p.:hp2.Darstellungsreihenfolge verstehen:ehp2.
:ol.
:li. Zeichenmodus auf "DROPSHADOWS" setzen - (3)
:li. Umrandung, Ebene 3
:li. Umrandung, Ebene 2
:li. Umrandung, Ebene 1
:li. Umrandung, Ebene 0
:li.Zurcksetzen
:li. Zeichenmodus auf "CONTENTPAINT" setzen
:li. Inhalt, Ebene 3
:li. Inhalt, Ebene 2
:li. Inhalt, Ebene 1 - (1)
:li. Inhalt, Ebene 0 - (1)
:li.ZUrcksetzen, setzt auch Beschneidungspfad zurck - (1)
:li. Zeichenmodus auf "BORDERPAINT" setzen
:li. Umrandungr, Ebene 3
:li. Umrandungr, Ebene 2
:li. Umrandungr, Ebene 1 - (2)
:li. Umrandungr, Ebene 0 - (2)
:li.ZUrcksetzen, setzt auch Beschneidungspfad zurck - (2)
:eol.
:note text='Hinweis (1):'.Die Inhaltsebenen 0 und 1 werden beim Selbstzuschneiden des Inhalts vertauscht.
:note text='Hinweis (2):'.Die Umrandungsebenen 0 und 1 werden beim Selbstzuschneiden der Umrandung vertauscht.
:note text='Hinweis (3):'.Spezielle Effektumrandungen werden vor allen anderen Ebenen gezeichnet.
.*******************************************************************************
:h2 res=26 id=26 global.Rahmenstil setzen
:i2 refid=edit.Rahmenstil setzen
:p.Durch Auswahl des Meneintrags 'Rahmenstil setzen' wird dem Rahmen eine Reihe von Objekt-Handlern
zugewiesen.
:p.Dieser Vorgang ist hufig schneller ausgefhrt, als nacheinander jede Handler-Schaltflche zu bettigen
und einen Handler auszuwhlen.
:p.Mit Hilfe der kleinen Schaltflche zur rechten des Meneintrags kann aus der Liste der verfgbaren
Rahmenstile ausgewhlt werden.
:p.Siehe auch :link reftype=hd res=54.Rahmenstile bearbeiten:elink..
.br
.br
.******************************************************************************
.*  Object Menu
.******************************************************************************
:h1 res=9 id=9 global.Das Men 'Objekt' des Rahmen-Handlers
:i1 id=object.Das Men 'Objekt' des Rahmen-Handlers
:p.Dieses Men stattet Maul mit Befehlen zur Erstellung und Anpassung von Rahmen aus.
.*******************************************************************************
:h2 res=42 id=42 global.Veraltete Objekttypen
:i2 refid=object.Veraltete Objekttypen
:p.Dieser Rahmen-Handler wurde gegenber frheren Versionen wesentlich gendert. Im besonderen wurden
polygongesttzte durch figurgesttzte Rahmen ersetzt. Figuren bieten wesentlich mehr als Polygone und
ersetzen folgende Rahmentypen:
:ul.
:li.Linien (TRACKING_LINE).
:li.Kurven (TRACKING_MULTISPLINE).
:li.Polygone (TRACKING_POLYGON).
:eul.
:p.Zur Sicherstellung einer gewissen Abwrtskompatibilitt knnen diesen Typen noch mit diesem Handler
bearbeitet werden. Es ist jedoch nicht mglich, Rahmen dieser Typen neu zu erstellen. Kurven, Polygone
und Rechtecke knnen in Figuren umgewandelt werden.
:p.Werden mit diesem Handler neue Rahmen der neuen Typen erstellt, ist es nicht mehr mglich, die neue Datei
mit einer Version des Maul Publisher vor V1.20 zu bearbeiten.
:p.Weitere nderungen dieses Handlers umfassen Untersttzung fr gruppierte Figuren und Metadatei-Clipart.
.*******************************************************************************
:h2 res=40 id=40 global.Rechtecke erzeugen
:i2 refid=object.Rechtecke erzeugen
:p.Einfache Rechtecke werden durch Bettigen der Schaltflche :artwork name='rectbut.bmp' runin. erzeugt.
Alternativ lassen sich durch Drcken der Schaltflche :artwork name='rrectbut.bmp' runin. Rechtecke mit
abgerundeten Ecken erzeugen. Die Eckenabrundung wird automatisch aus der Seitengre bestimmt, lt sich
jedoch auch mit Hilfe des Dialogs :link reftype=hd res=22.Objekt bearbeiten:elink. anpassen.
:p.Der Cursor ndert sich auf ein Fadenkreuz. Halten Sie die linke Maustaste gedrckt und ziehen Sie
das gewnschte Rechteck auf. Die Form des Rechtecks lt sich mit Hilfe der diversen Griffpunkte anpassen.
:p.:artwork name='rectex.bmp' align=left runin. 
:p.Hlt man beim Ziehen die Umschalttaste gedrckt, wird ein Quadrat erzeugt.
:p.Durch Klicken mit der linken Maustaste innerhalb des Rahmens und Gedrckthalten lt sich der gesamte
Rahmen auf die gewnschte Position verschieben.
:p.Anklicken des Rahmens mit der rechten Maustaste ruft das Men 'Bearbeiten' auf.
:p.Jedesmal, wenn ein Rahmen bearbeitet wird, zeigt der Rahmen-Handler auf der rechten Seite der Werkzeugleiste
eine Statusmeldung an.
.*******************************************************************************
:h2 res=41 id=41 global.Figuren erstellen
:i2 refid=object.Figuren erstellen
:p.Figuren sind aus einer Reihe von Figursegmenten bestehende, strukturierte Rahmen. Eine Figur kann,
beispielsweise bei einem Polygon, geschlossen oder, wie bei einer Linie oder Kurve, offen sein.
In einem offenen Rahmen lassen sich weder Text noch Bilder plazieren, da ein offener Rahmen kein
'Inneres' besitzt.
:p.Figuren knnen auf vielfltigere Art und Weise :link reftype=hd res=44.bearbeitet:elink.
werden, als es bei diesem Handler bisher der Fall war. Smtliche Standardfigurformen lassen sich durch
Hinzufgen und Entfernen von Figursegmenten modifizieren. Siehe
'Figuren :link reftype=hd res=44.bearbeiten:elink.'.
:p.Eine Reihe von Formen kann unter Verwendung der unten angegebenen Schaltflchen direkt erstellt werden.
:p.:hp2.Offene Figuren:ehp2.
:p.:artwork name='linebut.bmp' align=left runin.:hp2.Linien:ehp2.
:p.Die einfachste Figurform ist eine einzelne Linie. Bettigen Sie die Schaltflche und ziehen Sie die gewnschte
Lnge und Gre der Linie auf.
:p.:artwork name='3plnbut.bmp' align=left runin.:hp2.3-Punkt-Bgen:ehp2.
:p.3-Punkt-Bgen verhalten sich wie Linien. Hat man die Linie mit der richtigen Lnge aufgezogen, kann sie durch Ziehen
des in der Mitte befindlichen Kontrollpunkts gebogen werden. Nach Bettigung der Schaltflche erfolgt eine Abfrage,
wie viele Bgen erstellt werden sollen. Segmente knnen auch zu einem spteren Zeitpunkt hinzugefgt oder entfernt werden.
:p.:artwork name='splinebut.bmp' align=left runin.:hp2.Kurven:ehp2.
:p.Kurven werden auf die gleiche Art und Weise wie Linien und Bgen erstellt. Nach Bettigung der Schaltflche erfolgt
eine Abfrage, wie viele Bgen erstellt werden sollen. Danach zieht man die gewnschte Linie auf. Diese Linie lt sich
dann mit Hilfe der zur Verfgung stehenden Kontrollpunkte in interessante Formen biegen und krmmen.
:p.:hp2.Geschlossene Figuren:ehp2.
:p.:artwork name='polybut.bmp' align=left runin.:hp2.Polygone:ehp2.
:p.Polygone sind aus Liniensegmenten bestehende, geschlossene Figuren. Die Mindestanzahl der Liniensegmente betrgt
drei, wodurch eine Dreieck erstellt wird. Nach Bettigen der Schaltflche erfolgt eine Abfrage, wie viele Eckpunkte
das Polygon besitzen soll. Segmente knnen auch zu einem spteren Zeitpunkt hinzugefgt oder entfernt werden, solange
die Mindestanzahl von drei nicht unterschritten wird.
:p.:artwork name='3polybut.bmp' align=left runin.:hp2.3-Punkt-Bogenpolygone:ehp2.
:p.3-Punkt-Bogenpolygone werden genau wie normale Polygone erstellt, und mssen aus mindestens zwei 3-Punkt-Bgen
bestehen. Anfangs sind die Bgen an den Enden verbunden, so da sie einen Kreis ergeben.
:p.:artwork name='spolybut.bmp' align=left runin.:hp2.Kurvenpolygone:ehp2.
:p.Kurvenpolygone werden durch Verbindung einer oder mehrerer Kurven an deren Enden erstellt. Die Mindestanzahl der
Kurven in einem Kurvenpolygon betrgt eins. In diesem Fall werden die Enden der Kurve verbunden und man erhlt
eine Trnenform.
:p.:hp2.Siehe auch:ehp2.
:p.Figuren :link reftype=hd res=44.bearbeiten:elink.
:p.Effektive Nutzung der :link reftype=hd res=7.Maus:elink.
.*******************************************************************************
:h3 res=44 id=44 global.Figuren bearbeiten
:i2 refid=object.Figuren bearbeiten
:p.Smtliche Figuren bestehen aus drei Arten von Figursegmenten. Eine Figur kann im wahrsten Sinne des Wortes
hunderte dieser Segmente umfassen; bis zu dem Punkt, an dem die Leistungsfhigkeit des Rechners erschpft ist&colon.
:p.:hp2.Eine Linie:ehp2.
.br
:artwork name='linex.bmp' runin.
:p.:hp2.Ein 3-Punkt-Bogen:ehp2.
.br
:artwork name='3plnex.bmp' runin.
:p.:hp2.Eine Kurve:ehp2.
.br
:artwork name='splex.bmp' runin.
:p.Auer den fr die Figuren zur Verfgung stehenden, grundliegenden Bearbeitungsmglichkeiten Verschieben, Drehen
und Krmmen lassen sich den Figuren auch Figursegmente hinzufgen und aus ihnen entfernen.
:p.:hp2.Figursegmente hinzufgen:ehp2.
:p.Durch Bettigen der Schaltflche :artwork name='addbut.bmp' runin. erscheint ein kleines Ausklappmen mit einer
Auswahl der drei Segmenttypen, die hinzugefgt werden knnen. Whlen Sie den gewnschten Typ, klicken Sie dann den Endpunkt
einer vorhandenen Figur an und ziehen Sie bei gedrckter Maustaste das neue Segment auf. Einer Figur knnen jederzeit
beliebige Segmenttypen hinzugefgt werden.
:p.:hp2.Figursegmente entfernen:ehp2.
:p.Bettigen Sie die Schaltflche :artwork name='rembut.bmp' runin., und klicken Sie dann das zu entfernende Segment an.
Weitere Segmente knnen durch Anklicken entfernt werden. Der Modus Entfernen wird durch nochmalige Bettigen der oben
genannten Schaltflche oder durch Aufheben der Auswahl des Rahmens durch Anklicken eines leeren Dokumentteils
verlassen.
:p.:hp2.Figuren aufbrechen:ehp2.
:p.Bettigen Sie die Schaltflche :artwork name='openbut.bmp' runin. und ziehen Sie einen beliebigen Endpunkt
des Rahmens von seinem Nachbarn weg.
:p.:hp2.Figuren schlieen:ehp2.
:p.Kann die Figur geschlossen werden, so werden beim Bettigen der Schaltflche :artwork name='clsbut.bmp' runin.
die Enden der Figur verbunden. Wenn die Endpunkte einen gewissen Abstand haben, werden sie aufeinander zu bewegt.
Zum Schlieen der Figur werden keine weiteren Segmente hinzugefgt.
:p.:hp2.Hinweise:ehp2.
:p.Im allgemeinen wirken sich die oben genannten Vorgnge beginnend beim bearbeiteten Endpunkt im Uhrzeigersinn
auf Segmente aus.
:p.Bgen und Kuchensegmente sind nicht mit Figuren kompatibel. Kuchensegmente knnen jedoch in Bgen aufgebrochen
und Bgen zu Kuchensegmenten geschlossen werden.
.*******************************************************************************
:h2 res=45 id=45 global.Bgen und Kuchensegmente erstellen
:i2 refid=object.Bgen und Kuchensegmente erstellen
:p.Bgen und Kuchensegmente stehen zur einfachen Erstellung von Kuchendiagrammen zur Verfgung. Diese Formen sind
nicht mit Figuren kompatibel, so da bei ihnen nicht dieselben Bearbeitungsmglichkeiten wie bei Figuren
zur Verfgung stehen.
:p.Bei smtlichen Bgen und Kuchensegmenten werden die Bogenparameter durch vier Kontrollpunkte bestimmt.
Die Bogenparameter definieren sowohl die Form des Bogens als auch seine Ausrichtung. Fr vollstndige Bgen
stehen nur diese Steuerelemente zur Verfgung; mit ihnen kann beispielsweise ein Kreis in eine Ellipse
berfhrt werden.
:p.Teilbgen und Kuchensegmente besitzen zwei Endpunkte. Im Uhrzeigersinn gesehen beeinflut der erste
Griffpunkt die Bogengre. Die Gre wird dabei zur Erleichterung der Erstellung von Geschftsgrafiken
in Prozent gemessen. Mit dem zweiten Griffpunkt wird der Teilbogen oder das Kuchensegment entlang der
durch die Bogenparameter definierten Kurve verschoben.
:p.Teilbgen knnen mit Hilfe der Schaltflche :artwork name='clsbut.bmp' runin. in Kuchensegmente umgewandelt
werden.
:p.Kuchensegmente lassen sich mit Hilfe der Schaltflche :artwork name='openbut.bmp' runin. in Teilbgen
umwandeln.
.*******************************************************************************
:h2 res=46 id=46 global.Vordefinierte Objekte und Gruppen laden
:i2 refid=object.Vordefinierte Objekte und Gruppen laden
:p.:hp2.Rahmen als Clipart:ehp2.
:p.Der Rahmen-Handler ist in der Lage, vordefinierte Rahmen oder Gruppen zu speichern und wiederzuverwenden.
Zwei Dialoge vereinfachen das Importieren und Exportieren von Rahmenobjekten.
:p.Die Import- und Export-Funktionen knnen stets zum Speichern von Rahmen verwendet werden&colon.-
.br
Durch Hinzufgen von Ordnern zu Mauls etc-Pfad knnen Objektkataloge erstellt werden. Diese Ordner
mssen dem Namensschema 'ordnername.cat' folgen; der Ordner 'example.cat' zeigt ein Beispiel. Anschlieend
knnen Rahmen in die neuen Katalogordner exportiert werden. Beachten Sie, da sich Rahmen beim Importieren und
Exportieren nicht in einem Katalogordner befinden mssen.
:p.Mit den im folgenden beschriebenen Dialogen lassen sich Clipart-Kataloge wesentlich effektiver anlegen.
:p.:hp2.Rahmen oder Gruppe laden:ehp2.
:p.ber den Dialog 'Rahmen/Gruppe laden...' knnen Rahmen und Gruppen aus den Katalogen betrachtet und geladen werden.
:p.Whlen Sie einen Katalog aus dem Ausklappmen aus; oder whlen Sie '<>', um an den Anfang zurckzukehren, und
dann einen Rahmen aus dem Listenfeld. Der Dialog zeigt eine Skizze des zum Laden ausgewhlten Rahmens oder der Gruppe an. Drcken
Sie 'OK', um den Rahmen oder die Gruppe zu laden.
:p.:hp2.Rahmen oder Gruppe sichern:ehp2.
:p.ber den Dialog 'Rahmen/Gruppe sichern...' knnen Rahmen und Gruppen in einem Katalog gespeichert werden.
:p.Sie knnen entweder einen bereits vorhandenen Katalog auswhlen oder einen Namen fr einen neuen Katalog eingaben.
Die Angabe der Dateiendung ist nicht erforderlich. Wenn der Katalog noch nicht vorhanden ist, erfolgt eine Abfrage,
ob er erstellt werden soll.
:p.Sie knnen entweder eine bestehende Datei auswhlen oder den Namen fr eine neue Datei eingeben. Ist
die Datei bereits vorhanden, kann sie gelscht werden. Beim Versuch, eine bereits vorhandene Datei zu
berschreiben, wird eine Warnung angezeigt.
:p.Leere Kataloge ohne enthaltene Dateien knnen gelscht werden.
.*******************************************************************************
:h2 res=47 id=47 global.Polygone und Kurven skalieren
:i2 refid=object.Polygone und Kurven skalieren
:p.Bettigen Sie die Schaltflche :artwork name='scalebut.bmp' runin. .
:p.Whlen Sie einen Griffpunkt aus und ziehen Sie, um das Objekt in der Gre zu ndern.
:p.Hlt man beim Skalieren des Objekts die Umschalttaste gedrckt, wird die Grennderung
in vertikaler und horizontaler Richtung so gleichmig wie mglich durchgefhrt. Es kann
vorkommen, da die angezeigten Skalierungsfaktoren nicht vollstndig bereinstimmen, da
sich die Druckerauflsungen der beiden Richtungen voneinander unterscheiden knnen.
:p.Bei der Skalierung wird das Objekt in ein imaginres, um das Objekt gelegtes Rechteck
eingerastet.
.*******************************************************************************
:h2 res=48 id=48 global.Polygone und Kurven drehen
:i2 refid=object.Polygone und Kurven drehen
:p.Bettigen Sie die Schaltflche :artwork name='rotbut.bmp' runin. .
:p.Whlen Sie einen Griffpunkt aus und ziehen Sie, um das Objekt zu drehen.
:p.Standardmig erfolgt die Drehung in Schritten von 1&deg.. Ist dies nicht erwnscht,
kann durch Drcken der Umschalttaste eine freie Drehung erzielt werden. Deren Auflsung
hngt dabei stark von der Genauigkeit des Maus-Cursors und der Bildschirmauflsung ab.
Aus diesem Grunde lt sich bei einer hheren Vergrerungsstufe ein genaueres Ergebnis
erzielen.
.*******************************************************************************
:h2 res=49 id=49 global.Polygone und Kurven scheren
:i2 refid=object.Polygone und Kurven scheren
:p.Drcken Sie die Schaltflche :artwork name='shearbut.bmp' runin. .
:p.Whlen Sie einen Griffpunkt aus und ziehen Sie, um das Objekt zu scheren.
:p.Das Scheren ist ein Vorgang, bei dem ein Objekt auf kontrollierte Art und Weise verzerrt wird.
Ein gescherter Buchstabe sieht beispielsweise kursiv aus. Schert man ein Objekt sowohl in vertikaler
wie horizontaler Richtung, sieht das Objekt aus, als ob es im 3D-Raum gedreht worden wre. Die
Scherung eines Objekts wirkt sich jedoch nicht auf die Ausrichtung des Inhalts aus.
.*******************************************************************************
:h2 res=55 id=55 global.Rechtecke und veraltete Typen in Figuren umwandeln
:i2 refid=object.Rechtecke und veraltete Typen in Figuren umwandeln
:p.Hierzu verwendet man den Meneintrag 'Rechteck oder Polygon nach Figur' des Mens 'Objekt'.
:p.Ihnen ist vielleicht aufgefallen, da Rechtecke nicht geschert, skaliert oder gedreht werden knnen.
Nach Umwandlung eines Rechtecks in eine Figur kann jede Ecke einzeln gendert und es knnen smtliche
zur Verfgung stehenden Transformationen angewendet werden.
:p.Mit lteren Maul-Versionen erstellte Dokumente knnen :link reftype=hd res=42.veraltete:elink.
Polygone oder Linien enthalten. Um die bei Figuren zur Verfgung stehende Funktionalitt zu erhalten, mssen diese
Typen konvertiert werden. Dies hat keinerlei sichtbare Auswirkung auf das Dokument, aber man kann es danach
nur noch mit dieser oder zuknftigen Versionen des Rahmen-Handlers bearbeiten.
.*******************************************************************************
:h2 res=54 id=54 global.Rahmenstile bearbeiten
:i2 refid=object.Rahmenstile bearbeiten
:p.Der Rahmen-Handler verwendet Allgemeine Stilvorlagen. Weitere Informationen hierzu
entnehmen Sie bitte dem Maul-Publisher-Handbuch.
:p.:hp2.Stile sichern:ehp2.
:p.Der Rahmen-Handler sichert eine Stilvorlage fr sich selbst sowie eine Reihe sekundrer
oder Folge-Stilvorlagen fr die jeweils zugeordneten Handler. Fr den Inhalt dieser sekundren
Stilvorlagen ist nicht der Rahmen-Handler verantwortlich. Statt dessen sendet er zum Abfragen
und Festlegen der untergeordneten Stile eine Anforderung an die jeweils verantwortlichen Objekt-Handler.
Mit anderen Worten erhlt man eine Hierarchie von Stilvorlagen, welche den Rahmen
und die darin enthaltenen Objekte wiederspiegelt.
:p.:hp2.Verwendung eines Standardstils:ehp2.
:p.Wird im Dialog 'Allgemeine Stilvorlagen' mit Hilfe des Markierungsfeldes 'Standard' eine Standardstilvorlage
festgelegt, so werden alle neuen Rahmen automatisch mit dem ausgewhlten Stil versehen. Standardstilvorlagen
sind besonders hilfreich, wenn mit Maul Grafikobjekte gezeichnet werden und alle neuen Objekte
beispielsweise die gleiche Umrandung oder den gleichen Hintergrund besitzen sollen.
:p.:hp2.Stile setzen:ehp2.
:p.Wenn ein Stil gesetzt wird, leitet der Rahmen-Handler die Folgestilvorlagen an die entsprechenden Objekt-Handler
weiter. Enthlt eine solche Folgestilvorlage ein Bild oder hnliches, so wird das Objekt sofort sichtbar.
:p.Bei der Anwendung von Folgestilen werden sogar einige Dinge bercksichtigt. Wird eine Stilvorlage
mit einem Hintergrund und einer Umrandung in unteren Objektebenen gesichert, kann diese Stilvorlage nicht
nur angewendet, sondern auch mit einer anderen Stilvorlage berlagert werden.
:p.Fr das berlagern von Folgestilvorlagen gelten folgende Regeln&colon. 
:ul.
:li.Leere Objektebenen werden mit den Daten aus den Folgestilvorlagen gefllt.
:li.Bereits belegte Objektebenen werden angepat, wenn der Objekttyp mit dem der Folgestilvorlage bereinstimmt.
:li.Ist keine bereinstimmung vorhanden, wird das bestehende Objekt nicht verndert.
:eul.
.br
.br
.******************************************************************************
.*
.*
.*  statusbar information
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=80 id=80 global.Die Statuszeile
:i1 id=stats.Die Statuszeile
:p.Die Statuszeile zeigt Informationen ber den aktuellen Rahmen oder das aktuelle Objekt an.
.br
.br
.******************************************************************************
:h2 res=81 id=81 global.Cursor-Position
:i2 refid=stats.Cursor-Position
:p.Dieses Statuszeilenelement gibt die aktuelle Cursor-Position in
Bezug auf die gedruckte Seite an.
:p.Die bei der Anzeige dieser Information verwendeten Mae sind von den
gerade gltigen Maeinstellungen fr die Lineale
abhngig.
.br
.br
.******************************************************************************
:h2 res=82 id=82 global.Dynamische Rahmeninformationen
:i2 refid=stats.Dynamische Rahmeninformationen
:p.Dieses Statuszeilenelement zeigt dynamische Informationen ber den
derzeit ausgewhlten Rahmen an.
:p.Die Art der angezeigten Informationen hngt stark vom Rahmentyp und
dem gerade manipulierten Griffpunkt ab. Es werden unterschiedliche
Informationen fr Skalierung, Drehung, Ziehen einzelner Griffpunkte
oder Ziehen des Objektmittelpunkts angezeigt.
:p.Darber hinaus verhlt sich das Statuszeilenelement unterschiedlich
je nachdem, ob eine Linie, ein Rechteck, eine Figur, ein Bogen, ein
Tortensegment oder ein Kreis neu erstellt oder aktualisiert wird.
Folgende Modi werden den Umstnden entsprechend verwendet&colon.
:ul.
:li.:hp2.PUNKT:ehp2. Punkt (x,y).
:li.:hp2.LINIE:ehp2. Ursprung (x,y), Lnge und Winkel.
:li.:hp2.RECHTECK:ehp2. Ursprung (x,y), Breite, Hhe.
:li.:hp2.MITTELPUNKT:ehp2. Punkt (x,y).
:li.:hp2.BEWEGUNG:ehp2. Entfernung (x,y).
:li.:hp2.BOGENPARAMETER:ehp2. Radius 'A', Radius 'B' und Winkel (die
beiden Radien bilden eine Ellipse).
:li.:hp2.BOGENSTART:ehp2. Winkel in Grad.
:li.:hp2.BOGENWINKEL:ehp2. Mittelpunktswinkel des Kreisbogens in
Prozent (fr Tortensegmente).
:li.:hp2.DURCHMESSER:ehp2. Der Durchmesser.
:li.:hp2.WINKEL:ehp2. Winkel in Grad.
:li.:hp2.RAHMEN:ehp2. Mittelpunkt (x,y) und Radius, soweit bekannt.
:eul.
:p.Die bei der Anzeige dieser Information verwendeten Mae sind von den
gerade gltigen Maeinstellungen fr die Lineale abhngig.
.br
.br
.******************************************************************************
.*
.*
.*  other information
.*
.*
.******************************************************************************
.******************************************************************************
:h1 res=60 id=60 global.Rahmen importieren und exportieren
:i1.Rahmen importieren und exportieren
:p.Das Importieren und Exportieren von Rahmen ist untersttzt. Der Rahmen-Handler ist in der Lage,
Rahmen oder aus Rahmen bestehende Gruppen in einem standardisierten Format zu importieren und exportieren. Zustzliche
Export-Formate wie z.b. Bitmaps und Metadateien sind untersttzt mit hilfe von installierten Export-Handlern.
:p.Bitmaps sind auf 75dpi reduziert damit diese Bilder evtl. auch fr Web Browser geeignet sind.
:p.Der Rahmen-Handler verwendet exportierte Daten zur Bereitstellung vordefinierter Rahmen und Gruppen. Mehr darber,
wie man mit Hilfe des Mens 'Objekt' direkt auf Rahmen zugreifen kann, erfahren Sie unter
':link reftype=hd res=46.Vordefinierte Objekte und Gruppen laden:elink.'.
:p.:hp2.Importieren:ehp2.
:p.Es knnen beliebige zuvor von diesem Handler exportierte Rahmendaten importiert werden. Die voreingestellte Dateierweiterung
ist '*.fob' (fr FrameOBject, also Rahmenobjekt). Mit Hilfe dieses Dialogs knnen Rahmen importiert werden, auf die
nicht direkt ber das Men 'Objekt' zugegriffen werden kann.
:p.Der Dialog zeigt eine Skizze des zum Importieren ausgewhlten Rahmens an.
:p.:hp2.Exportieren:ehp2.
:p.Rahmendateien knnen aus diesem Programm fr zwei verschiedene Zwecke exportiert werden. Beim ersten werden Rahmen
zur allgemeinen Verwendung gesichert. Der zweite ist etwas interessanter. Erstellt man nmlich Katalogordner im Unterverzeichnis
etc des Installationsverzeichnisses, lassen sich so Rahmen- und Gruppenbibliotheken anlegen, auf die direkt ber das
Men 'Objekt' zugegriffen werden kann. Einzige Bedingung ist, da die Katalogordner die Erweiterung '.cat' besitzen,
z.B. 'Haus.cat' oder 'Sterne.cat' und sich - wie oben beschrieben - im Unterverzeichnis '.\etc' befinden.
Das bedeutet, da Kataloge nicht geschachtelt werden sollten.
.******************************************************************************
.*
.*
.*
.*  Dialog Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  dialogs
.******************************************************************************
:h1 res=61 id=61 global.Polygonpunkte auswhlen
:i1.Polygonpunkte auswhlen
:p.Es knnen Polygone mit drei bis 180 Eckpunkten erstellt werden; darber hinaus
mssen Linien von Hand hinzugefgt werden.
Polygone bestehen aus einer Reihe von Punkten, wobei jeder Punkt das Ende einer
geraden Linie ist.
:p.Die Anzahl der Punkte im Polygon lt sich mit Hilfe des Drehreglers bestimmen.
:p.Bei drei Punkten wird ein Dreieck erstellt und bei fnfzig Punkten fast ein Kreis.
:p.:artwork name='polyex.bmp' align=left.
.******************************************************************************
:h1 res=62 id=62 global.Kurven auswhlen
:i1.Kurven auswhlen
:p.Es knnen Kurven mit bis zu 60 Knotenpunkten erstellt werden; darber hinaus mssen
Linien von Hand hinzugefgt werden. Jeder Knoten einer Kurve unterliegt der Kontrolle
zweier Kontrollpunkte und besitzt zwei Endpunkte.
:p.:hp2.Eine Kurve:ehp2.
:p.:artwork name='splex.bmp' align=left runin.
.******************************************************************************
:h1 res=63 id=63 global.3-Punkt-Bgen auswhlen
:i1.3-Punkt-Bgen auswhlen
:p.Es knnen Figuren mit bis zu 90 Bgen erstellt werden; darber hinaus mssen Bgen von
Hand hinzugefgt werden.
Jeder Bogen besitzt in der Mitte einen Kontrollpunkt, ber den die Krmmung des Bogens
angepat werden kann.
:p.Eine geschlossene Figur besteht aus mindestens zwei Bgen.
:p.:hp2.Ein 3-Punkt-Bogen:ehp2.
:p.:artwork name='3plnex.bmp' align=left runin.
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=64 id=64 global.Hilfe zu Tasten
:i1 id=keys.Hilfe zu Tasten
:p.Fr diesen Handler stehen die folgenden Tastenkrzel zur Verfgung. Es werden die gebruchlichsten Tastenkrzel aufgefhrt, jedoch
keine Tastenkrzel, die fr andere Handler spezifisch sind. Whlen Sie einen Rahmen und Handler aus, fr die Sie Informationen
bentigen und rufen Sie die Hilfe nochmals auf.
:p.Ist kein Rahmen ausgewhlt, so wird die Tastenhilfe fr das Hauptprogramm des Maul Publisher angezeigt.
:p.Bitte beachten Sie, da Sie diese Tasten ndern knnen, und da hier nur die Standardeinstellungen angezeigt werden.
:p.:hp2.Allgemeine Tastenbelegung:ehp2.
:ol.
:li.:hp2.Menauswahl:ehp2.
:dl compact tsize=16.
:dt.Alt+B:dd.Men Bearbeiten
:dt.Alt+D:dd.Men Datei
:dt.Alt+H:dd.Men Hilfe
:dt.Alt+O:dd.Men Optionen
:dt.Alt+S:dd.Men Seite
:dt.Alt+W:dd.Men Widerrufen
:dt.Alt+A:dd.Men Anzeige
:dt.Alt+U:dd.Umschalten zu (Umschaltliste)
:edl.
:li.:hp2.Men Datei:ehp2.
:dl compact tsize=16.
:dt.Strg+N:dd.Neue Datei
:dt.Strg+:dd.Datei ffnen...
:dt.Strg+I:dd.Importieren...
:dt.Strg+X:dd.Exportieren...
:dt.Strg+S:dd.Datei sichern
:dt.Strg+A:dd.Datei sichern unter...
:dt.Strg+R:dd.Datei drucken...
:edl.
:li.:hp2.Men Seite:ehp2.
:dl compact tsize=16.
:dt.Strg+P:dd.Seitendruckeinstellungen...
:dt.Strg+M:dd.Rnder und Gitter...
:dt.Strg+Umschalt+M:dd.Seitenvorlage verwenden...
:dt.Strg+T:dd.Seitenvorlage sichern/lschen
:dt.Alt+Umschalt+Entf:dd.Eine Seite kopieren
:dt.Alt+Umschalt+Einfg:dd.Eine Seite aus der Zwischenablage einfgen
:dt.Strg+Umschalt+I:dd.Eine neue Seite einfgen
:dt.Strg+Umschalt+J:dd.Eine neue erste Seite einfgen
:dt.Strg+Umschalt+D:dd.Eine Seite lschen
:dt.Alt+G:dd.Gehe zu Seite
:dt.Strg+Umschalt+N:dd.Nchste Seite
:dt.Strg+Umschalt+P:dd.Vorige Seite
:edl.
:li.:hp2.Men Anzeige:ehp2.
:dl compact tsize=16.
:dt.Strg+1:dd.Seitenanzeige Drucker
:dt.Strg+2:dd.Seitenanzeige
:dt.Strg+3:dd.Auf Breite anpassen
:dt.Strg+4:dd.Wirkliche Gre
:dt.Strg+Plus:dd.Vergrern
:dt.Strg+Minus:dd.Verkleinern
:dt.Strg+F:dd.Rahmenbearbeitungsmodus
:dt.Strg+C:dd.Inhaltsbearbeitungsmodus
:dt.Strg+G:dd.Hintergrundbearbeitungsmodus
:dt.Strg+B:dd.Umrandungsbearbeitungsmodus
:edl.
:li.:hp2.Men Widerrufen:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Letzte nderung widerrufen
:dt.Strg+Backspace:dd.Letzte nderung wiederholen
:dt.Strg+U:dd.Widerrufsliste...
:edl.
:li.:hp2.Men Optionen:ehp2.
:dl compact tsize=16.
:dt.Strg+Umschalt+R:dd.Druckereinstellungen...
:dt.Strg+E:dd.Raster aktivieren
:dt.Strg+Umschalt+S:dd.Rastereinstellungen...
:edl.
:li.:hp2.Men Hilfe:ehp2.
:dl compact tsize=16.
:dt.Strg+H:dd.Inhaltsverzeichnis
:dt.Strg+Umschalt+H:dd.Hilfeindex
:dt.Strg+K:dd.Hilfe fr Tasten
:dt.Strg+L:dd.Alle Handler anzeigen
:dt.Strg+Z:dd.Produktinformation...
:edl.
:eol.
:p.:hp2.Tastenbelegung des Rahmen-Handlers:ehp2.
:ol.
:li.:hp2.Men Bearbeiten:ehp2.
:dl compact tsize=16.
:dt.Strg+Umschalt+E:dd.Objekt/Gruppe bearbeiten...
:dt.Umschalt+Entfernen:dd.Objekt/Gruppe ausschneiden
:dt.Strg+Einfgen:dd.Objekt/Gruppe kopieren
:dt.Umschalt+Einfgen:dd.Objekt/Gruppe einfgen
.br
:dt.Strg+Umschalt+L:dd.Objekt/Gruppe sperren
:dt.Strg+Umschalt+O:dd.Objektmittelpunkt zurcksetzen
.br
:dt.Strg+Umschalt+F:dd.Objekt nach vorne holen
:dt.Strg+Umschalt+B:dd.Objekt nach hinten schieben
.br
:dt.Strg+Alt+T:dd.Transparentes Objekt
:dt.Strg+Alt+I:dd.Selbstzuschneidendes Objekt
.br
:dt.Strg+Umschalt+G:dd.Objekte gruppieren
:dt.Strg+Umschalt+U:dd.Objektgruppierung aufheben
.br
:dt.Strg+Alt+V:dd.Objekte horizontal ausrichten
:dt.Strg+Alt+H:dd.Objekte vertikal ausrichten
.br
:dt.Strg+Alt+X:dd.Objekt(e) horizontal zentrieren
:dt.Strg+Alt+Y:dd.Objekt(e) vertikel zentrieren
:dt.Strg+Umschalt+X:dd.Gruppe horizontal zentrieren
:dt.Strg+Umschalt+Y:dd.Gruppe vertikal zentrieren
.br
:dt.Alt+X:dd.Objekte horizontal angleichen
:dt.Alt+Y:dd.Objekte vertikal angleichen
.br
:dt.Strg+Alt+S:dd.Objektstil festlegen...
:dt.Entfernen:dd.Objekt lschen
:edl.
:li.:hp2.Men Objekt:ehp2.
:dl compact tsize=16.
:dt.R:dd.Rechteck erstellen
:dt.U:dd.Abgerundetes Rechteck erstellen
:dt.L:dd.Linien erstellen
:dt.I:dd.Kurven erstellen
:dt.N:dd.3-Punkt-Bgen erstellen
:dt.P:dd.Polyfigur erstellen
:dt.S:dd.Kurvenfigur erstellen
:dt.O:dd.3-Punkt-Bogenfigur erstellen
.br
:dt.Umschalt+C:dd.Objekt skalieren
:dt.Umschalt+O:dd.Objekt drehen
:dt.Umschalt+H:dd.Objekt scheren
:dt.Umschalt+E:dd.Figur wiederholen und schlieen
:dt.Umschalt+J:dd.Enden zum Schlieen verbinden
:dt.Umschalt+B:dd.Figur ffnen (aufbrechen)
.br
:dt.Umschalt+L:dd.Linie hinzufgen
:dt.Umschalt+I:dd.Kurve hinzufgen
:dt.Umschalt+N:dd.3-Punkt-Bogen hinzufgen
:dt.D:dd.Figurelemente entfernen
.br
:dt.F:dd.Rechteck oder Polygon in Figur umwandeln
:dt.W:dd.Inhalt und Hintergrund tauschen
.br
:dt.Y:dd.Objektstil sichern
:edl.
:eol.
.******************************************************************************
.*  Options help
.******************************************************************************
:h1 res=70 id=70 global.Darstellungsoptionen
:i1 id=paintena.Darstellungsoptionen
:p.Der Rahmen-Handler bietet die Mglichkeit, die Darstellung bestimmter Elemente eines Dokuments
zu aktivieren oder deaktivieren.
:p.:hp2.Vorschaumodus anzeigen:ehp2.
:p.Im Vorschaumodus ist die Darstellung von Bildschirmartefakten wie dem Markierungsrahmen und
Rahmenumrissen deaktiviert. Die daraus resultierende Ansicht kommt dem Aussehen der Seite beim
Ausdruck sehr nah.
:p.:hp2.Dialog Darstellung:ehp2.
:p.Mit Hilfe des Dialogs 'Darstellung' lassen sich Objekt-Handler vorbergehen nach Nutzung oder
Typ deaktivieren.
:p.Der Dialog zeigt zwei getrennte Listen an. Eine fhrt smtliche Verwendungsmglichkeiten eines
Rahmens auf. Die andere zeigt die Namen smtlicher Objekt-Handler (Handler, die zur Darstellung von Dingen
dienen) an.
:p.Hervorgehobene Eintrge sind aktiviert. Deaktiviert man alle Umrandungen, werden smtliche einer Umrandung
zugewiesenen Handler deaktiviert. Deaktiviert man nur einen Handler, werden nur die Darstellungsoperationen
dieses Handlers unterdrckt. Denken Sie daran, da manche Handler sowohl in Umrandungen als auch in
Hintergrnden Verwendung finden.
:p.Die beiden Listen funktionieren unabhngig voneinander, und es gibt zwischen ihnen keinerlei Verbindung.
:p.Die hier vorgenommenen Einstellungen wirken sich nur auf den Bildschirm aus, nicht auf den Ausdruck.
:euserdoc.
