.******************************************************************************
.*  Maul Publisher Index Import Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul-Hilfe zum Registerimport
:docprof toc=1234.
:h1 res=1 id=1.ber den Registerimport-Handler
:i1 id=all.ber den Registerimport-Handler
:p.:font facename='Tms Rmn' size=24x24.
:hp2.Maul-Registerimport-Handler V1.00:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.bersicht des Maul-Registerimport-Handlers:ehp2.
:p.Dieser Handler wird zur Erstellung eines Registers fr das Dokument
verwendet. Das Erstellen eines Registers ist ein komplexer und zeitraubender
Proze. Dieses Indizierungsdienstprogramm kann Ihnen eine Menge Zeit und Mhen
ersparen. Denken Sie jedoch daran, da die Erstellung eines guten Registers viel
Handarbeit erfordert, die Ihnen keine Maschine abnehmen kann.
:p.Dieses Indizierungsdienstprogramm wird dazu verwendet, Text in der
Publikation zu finden, der den Daten in einem von Ihnen bereitgestellten Register
entspricht, und die Seitennummern zu diesem Register hinzuzufgen.
Im Gegensatz zu einem Inhaltsverzeichnis wird ein Register mit Hilfe einer :link
reftype=hd res=10.Registererstellungsdatei:elink.
und durch :link reftype=hd res=20.Importieren:elink. dieser Datei in einen
leeren Textrahmen erstellt.
:p.
.br
.br
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1999 - 2002 Peter Koller, Maison Anglais. Alle Rechte vorbehalten.
:p.Details der Lizenzbestimmungen entnehmen Sie bitte dem Urheberrechtshinweis im Haupthandbuch
des Maul Publishers.
.br
:h1 res=20 id=20 global.Registererstellungsdateien importieren
:i1 id=index.Registererstellungsdateien importieren
:p.Bei einer :link reftype=hd res=10.Registererstellungsdatei:elink. handelt es
sich um eine einfache ASCII-Textdatei, die Informationen zur
Indizierung enthlt. Sie knnen beliebig viele solcher Dateien benutzen, und sie knnen
mit einem beliebigen Editor fr normalen Text, wie beispielsweise dem Systemeditor
'E', editiert werden.
:p.Um ein Register zu importieren, erstellen Sie einen leeren Textrahmen und importieren
die Registererstellungsdatei. Dadurch wird ein Register erstellt.
Nach Beendigung des Imports werden Sie dieses Register wahrscheinlich bearbeiten mssen.
:p.Falls der Indizierungsproze zu lange dauern sollte oder Sie ihn aus irgendeinem Grund
abbrechen mchten, drcken Sie die Taste <Esc> auf Ihrer Tastatur. Der Proze wird dann
sofort beendet.
.br
.br
:h1 res=10 id=10 global.Syntax der Registererstellungsdatei
:i1 id=import.Syntax der Registererstellungsdatei
:p.:hp2.bersicht:ehp2.
:p.Bei einer Registererstellungsdatei handelt sich um eine einfache ASCII-Textdatei, die Informationen zur
Indizierung enthlt. Sie knnen beliebig viele solcher Dateien benutzen, und sie knnen mit einem beliebigen Editor fr normalen Text, wie
beispielsweise dem Systemeditor 'E', editiert werden.
:p.Um ein Register zu importieren, erstellen Sie einen leeren Textrahmen und importieren die Registererstellungsdatei. Dadurch wird ein Register erstellt.
Nach Beendigung des Imports werden Sie dieses Register wahrscheinlich editieren mssen.
:p.Falls der Indizierungsproze zu lange dauern sollte oder Sie ihn aus irgendeinem Grund abbrechen mchten, drcken Sie die Taste <Esc>
auf Ihrer Tastatur. Der Proze wird dann sofort beendet.
:p.:hp2.Kommentare:ehp2.
:p.Die Registererstellungsdatei kann, und sollte, einen Kommentar oder eine beliebige Zahl von Kommentaren enthalten, die erlutern, was die Datei tut.
Kommentare werden mit den gebruchlichen Kommentierungsmethoden aus 'C' und 'C++' erstellt. Ein Beispiel beider Methoden folgt.
:xmp.
/*
Dies ist ein C-artiger Kommentar. Beachten Sie, da
der Kommentar mit Schrgstrich-Stern beginnt, und mit
Stern-Schrgstrich endet.
Solche Kommentare drfen NIE verschachtelt werden.
*/
 
/************** Gltiger Kommentar *******************/
 
/* Schlechter Kommentar... ungltig /*
 
//Dies ist ein Kommentar im Stil von C++, der Kommentar
//geht bis zum Zeilenende weiter.
 
/*  //Man kann Kommentare im Stil von C++ innerhalb
    //solcher im C-Stil plazieren.  */
:exmp.
:p.:hp2.Registereintrge:ehp2.
:p.Ein Registereintrag besteht aus dem Text, wie er im Register erscheinen wrde, gefolgt von einem Zeichenketten-Ausdruck, der den in
der Datei zu suchenden Text beschreibt. Im einfachsten Falle she ein Registereintrag so aus&colon.
:xmp.
Eintrag;
:exmp.
:p.Diese Form ist als impliziter Eintrag bekannt, da der Registertext und das zu suchende Wort gleich sind.
Dies entspricht der Eingabe von&colon.
:xmp.
Eintrag = eintrag;
:exmp.
:p.Dieser leicht modifizierte Eintrag besitzt den Vorteil, da der Text fr den
Registereintrag und das zu suchende Wort nicht mehr gleich sein mssen. Beispeilsweise
wre ein Eintrag wie der folgende durchaus in Ordnung&colon.
:xmp.
Eintrag = eintrge;
:exmp.
:p.Die eigentliche Syntax definiert sich folgendermaen&colon.
.br
:hp2.<eintrag>[=<ausdruck>];:ehp2.
.br
Beachten Sie, da Eintrge in eckigen Klammern wahlfrei sind und Eintrge in
spitzen Klammern durch etwas anderes ersetzt werden.
:p.Beachten Sie, da fhrende oder folgende Leerzeichen ignoriert werden.
Beachten Sie bitte auch, da der Eintrag mit einem Semikolon abgeschlossen
werden mu. Der Registereintrag kann sich ber so viele Zeilen hinziehen, wie Sie
mchten, solange Sie den Eintrag nur mit einem ';' beenden.
:p.Dieser grundliegende Syntax kann erheblich erweitert werden...
:p.:hp2.Zeichenketten in Anfhrungszeichen:ehp2.
:p.Enthlt ein <eintrag> oder ein <ausdruck> fhrende oder folgende Leerzeichen, knnen Sie den Text in Anfhrungszeichen einschlieen.
:xmp.
"Dieser Registereintrag" = "suche nach dieser Zeichenkette";
:exmp.
:p.Wenn die Zeichenkette in Anfhrungszeichen selbst ein Anfhrungszeichen enthlt, knnen Sie es durch Voranstellen eines umgekehrten Schrgstrichs ('\') eingeben.
:xmp.
"Dieser Registereintrag" = "suche nach einem \"Paar von Anfhrungszeichen\"";
:exmp.
:p.Wenn die Zeichenkette in Anfhrungszeichen lnger als eine Zeile ist, knnen Sie einen umgekehrten Schrgstrich ('\') als Zeilenfortsetzungszeichen verwenden.
:xmp.
"Dieser Registereintrag" = "erstreckt sich ber mehr als \
eine Zeile";
:exmp.
:p.Das Zeichen des umgekehrten Schrgstrichs kann zudem verwendet werden, um einen Zeilenumbruch '\n', sich selbst '\\' oder eine beliebige Anzahl von ASCII-Codes einzugeben&colon.
:table cols='25 25 30' rules=both frame=box.
:row.
:c.\b = (Rcktaste):c.\" = ("Anfhrungszeichen"):c.\<nummer> = (dezimale Nummer)
:row.
:c.\f = (Seitenumbruch):c.\' = ('Anfhrungszeichen'):c.\0<nummer> = (oktale Nummer)
:row.
:c.\n = (Zeilenumbruch):c.\0 = (null):c.\0x<nummer> = (hexadezimale Nummer)
:row.
:c.\r = (Wagenrcklauf):c.\\ = (\):c.\<leerzeichen> = Zeilen- fortsetzung
:row.
:c.\t = (Tabulator):c.\v = (vertikaler Tabulator)
:etable.
:p.:hp2.Ausdrcke:ehp2.
:p.Der <ausdruck>-Teil eines Registereintrags erlaubt das logische Durchsuchen Ihrer Publikation.
Es werden zwei Arten von Vergleichen angestellt. Der erste ist ein Komma. Bei einer Aufzhlung von durch Komma getrennten Zeichenketten fungiert es als ODER-Funktion.
Jede beliebige der Zeichenketten fhrt dazu, da eine Registerseitennummer hinzugefgt wird.
:xmp.
/* Suche nach 'index' ODER 'eintrag'*/
"Dieser Registereintrag" = index, eintrag;
:exmp.
:p.Der zweite Vergleichstyp ist das Plus-Zeichen.
:xmp.
/* Suche nach 'index' UND 'eintrag'*/
"Dieser Registereintrag" = index + eintrag;
:exmp.
:p.Sie knnen die Operation eines Ausdrucks invertieren.
:xmp.
/* Suche nach 'index' UND NICHT 'eintrag'*/
"Dieser Registereintrag" = index + !(eintrag);
 
//beachten Sie den Gebrauch der Klammern
:exmp.
:p.:hp2.Auswertungsreihenfolge der Ausdrcke:ehp2.
:p.Ausdrcke werden von links nach rechts ausgewertet. Sie knnen die Auswertungsreihenfolge durch Verwendung von Klammern ndern&colon.
:xmp.
"Leben und Wirken von Albert Einstein" =
(leben, wirken) + "Albert Einstein";
:exmp.
:p.Hierbei suchen wir nach Rahmen, die 'Albert Einstein' erwhnen und auerdem ber 'leben' oder 'wirken' sprechen.
:p.:hp2.Ein komplexer Registereintrag:ehp2.
:p.Das folgende Beispiel zeigt, wie ein komplexer Registereintrag aufgebaut sein knnte. Beachten Sie die Verwendung von Klammern zur Festlegung
der korrekten Interpretation&colon.
:xmp.
"Leben und Wirken von Albert Einstein (aber nicht James Bond)" =
!"James Bond" + ((leben, wirken) + "Albert Einstein");
:exmp.
:p.:hp2.Eingabe und Ergebnisse:ehp2.
:p.Mit der folgenden Registererstellungsdatei...
:xmp.
 
Aston = autos;
 
"Leben und Wirken von Albert Einstein" = (leben, wirken) + "Albert Einstein";
 
"Stze, die 'der, am, oder, und' enthalten" = der, am, oder, und;
 
"Das Theater" = theater;
 
:exmp.
:p....she das Ergebnis in etwa so aus&colon.
:fig.
Aston
Leben und Wirken von Albert Einstein
Stze, die 'der, am, oder, und' enthalten, 1, 2
Das Theater
:efig.
:p.Beachten Sie, da fr 'Aston', 'Leben und Wirken von Albert Einstein' und 'Das Theater' keine Seitennummern gefunden wurden. Diese
Eintrge wurden dem Register hinzugefgt, besitzen aber keine entsprechende Seite, da sie nicht in der indizierten Datei vorhanden sind.
Seitennummern wurden fr 'Stze, die... ' hinzugefgt, da eines oder mehrere der erforderlichen Wrter gefunden wurden.
:p.Beachten Sie zudem, da die Eintrge nicht alphabetisch sortiert, sondern so gelesen wurden, wie sie der Registererstellungsdatei entnommen wurden.
.br
.br
.br
:euserdoc.
 
 
