.******************************************************************************
.*  Maul Publisher Spell Checker Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul-Hilfe zum Rechtschreibprfungs-Handler
:docprof toc=1234.
:h1 res=1 id=intro.ber den Rechtschreibprfungs-Handler
:i1 id=all.ber den Rechtschreibprfungs-Handler
:p.:font facename='Tms Rmn' size=24x24.
:hp2.bersicht des Rechtschreibprfungs-Handlers:ehp2.
:font facename=default.
:p.Dieser Handler basiert auf zwei Open-Source-Projekten, MySpell und Libhnj.
Der Handler stellt Funktionen fr die Rechtschreibprfung und Silbentrennung zur Verfgung.
:p.:hp2.Dieser Handler bietet&colon.:ehp2.
:ul.
:li.Rechtschreib- und Grammatikprfung.
:li.Eine Reihe von Rechtschreibprfungsoptionen, die das Produkt in die Lage versetzen, auch
unter ungewhnlichen Rahmenbedingungen zu arbeiten, wie etwa kommagetrennten Listen oder von Texterkennungen
generiertem Text.
:li.Eine Ausnahmewortliste, nach der bestimmte Wrter whrend der Rechtschreibprfung ignoriert werden.
:li.Automatische Silbentrennung.
:eul.
.br
.br
:p.:hp2.nderungen und Neues:ehp2.
:p.Copyright 2003 Peter Koller, Maison Anglais, Plonevez du Faou, Frankreich. Alle Zustze unterliegen
dem unten aufgefhrten MYSPELL COPYRIGHT.
:p.Der Quellcode fr den Rechtschreibprfungsteil dieses Handlers (den cleveren Teil) liegt dem
vollstndigen Paket bei. Er befindet sich in einem ZIP-Archiv im Unterverzeichnis .\etc\myspell
des Maul-Installationsverzeichnisses. Dort finden sich auch die erforderlichen Wrterbcher.
:p.:hp2.MySpell Urheberrechtshinweis:ehp2.
:xmp.
/*
 * Copyright 2002 Kevin B. Hendricks, Stratford, Ontario, Canada
 * And Contributors.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All modifications to the source code must be clearly marked as
 *    such.  Binary redistributions based on modified source code
 *    must be clearly marked as modified versions in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KEVIN B. HENDRICKS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL 
 * KEVIN B. HENDRICKS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * NOTE: A special thanks and credit goes to Geoff Kuenning
 * the creator of ispell.  MySpell's affix algorithms were
 * based on those of ispell which should be noted is
 * copyright Geoff Kuenning et.al. and now available
 * under a BSD style license. For more information on ispell
 * and affix compression in general, please see:
 * http&colon.//www.cs.ucla.edu/ficus-members/geoff/ispell.html
 * (the home page for ispell)
 *
 * An almost complete rewrite  of MySpell for use by  
 * the Mozilla project has been developed by David Einstein 
 * (Deinst@world.std.com).  David and I are now 
 * working on parallel development tracks to help 
 * our respective projects (Mozilla and OpenOffice.org 
 * and we will maintain full affix file and dictionary 
 * file compatibility and work on merging our versions 
 * of MySpell back into a single tree. David has been 
 * a significant help in improving MySpell.
 * 
 * Special thanks also go to La'szlo' Ne'meth 
 * <nemethl@gyorsposta.hu> who is the author of the 
 * Hungarian dictionary and who developed and contributed 
 * the code to support compound words in MySpell 
 * and fixed numerous problems with the encoding 
 * case conversion tables.
 *
 */
:exmp.
:p.:hp2.LibHnj Urheberrechtshinweis:ehp2.
:p.:note text='Hinweis:'.Dieser Handler verwendet nur einen Teil der libhnj-Bibliothek von Raph Levien. Tatschlich
wird nur der Teil fr die Silbentrennung verwendet.
:xmp.
LibHnj is a library for high quality hyphenation and justification. It
is dual licensed under both LGPL and MPL to encourage widespread use.
The parseAFM.[ch] files are written by Adobe and distributed under a
slightly different license, but one that appears to be compatible with
both LGPL and MPL.
 
The code is currently fairly rough. In particular, psset has many
fixed-size buffers and is simply not suitable for production. Further
speedups are also possible, although the code isn't exactly slow now.
:exmp.
:p.:hp2.Urheberrechtshinweis des Rechtschreibprfungs-Handlers:ehp2.
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:xmp.
Maul Rechtschreibprfungs-Handler
Copyright  2001 Peter Koller, Maison Anglais.
Alle Rechte vorbehalten.
:exmp.
:p.Details der Lizenzbestimmungen entnehmen Sie bitte dem Urheberrechtshinweis im Haupthandbuch 
des Maul Publishers. 
.******************************************************************************
:h1 res=2 id=2 global.Verwaltung von Wrterbchern und Zeichenstzen
:i1 id=techno.Verwaltung von Wrterbchern und Zeichenstzen
:p.:hp2.Die Wrterbuch-Steuerungsdatei 'MYSPELL.DLS':ehp2.
:p.Wie viele andere Steuerungsdateien befindet sich diese Datei im Maul-Ordner .\etc.
Wrterbcher werden in einem Unterverzeichnis gespeichert. Dieses Unterverzeichnis wird
in der Wrterbuch-Steuerungsdatei angegeben. Desweiteren hlt die Datei Informationen
zu Silbentrennungswrterbchern, Sprachen sowie zur 'ber'-Nachricht bereit, die ber den
Rechtschreibprfungsdialog abgerufen werden kann.
:p.Diese Datei wird von einem relativ hochentwickelten Parser verarbeitet, weswegen Kenntnisse
ber die Funktion von nutzen sind.
:p.:hp1.Kommentare:ehp1.
:p.Kommentare folgen den C++-Konventionen. Damit stehen /* und */ zur Verwendung grerer
Kommentarblcke zur Verfgung, sowie Zeilenkommentare mit //, die bis zum Ende der Zeile gelten.
:p.Zeilenkommentare knnen innerhalb von Blockkommentaren verwendet, Blockkommentare aber nicht
geschachtelt werden.
:p.:hp1.Befehle:ehp1.
:p.Befehle beginnen immer mit einem <befehl> und enden mit einem ';'.
:p.:hp1.Strings:ehp1.
:p.Enthlt ein String Zeichen, die Teil der Syntax sind, so knnen sie in "doppelte Anfhrungszeichen"
eingeschlossen werden, damit der Parser den String nicht aufteilt.
:p.:hp2.Wrterbuchsteuerungsdatei-Definition:ehp2.
:p.Jede Sprache besitzt ihre eigenen Wrterbcher. Diese Wrterbcher werden in einem Steuerungsblock angegeben.
:xmp.
<dict>"name","unterverzeichnis", "sprachid", "info";
<spl>"sprachid", "rechtschreibwrterbuch", "affix-datei";
<hyp>"sprachid", "silbentrennungswrterbuch", minlinks, minln, minrechts;
:exmp.
:p.:hp1.<dict>:ehp1.
:ul.
:li."name"&colon. Dies sollte ein anwenderfreundlicher Name in der dem Wrterbuch entsprechenden Sprache sein.
:li."unterverzeichnis"&colon. Das Unterverzeichnis von .\etc, in dem sich die Wrterbcher befinden. D.h. wenn
hier der String "myspell" stnde, befnden sich die Dateien in ".\etc\myspell". Wenn
hier der String "!off" steht, ist kein Wrterbcher installiert.
:li."sprachid"&colon. Dieser Wert wird verwendet, um die Sprachen der Wrterbuchsteuerungsblcke zu unterscheiden,
anstelle der einzelnen Wrterbcher. Damit Maul das Wrterbuch nutzen kann, mu in der Datei DATECONV.LCI der
gleiche Wert fr die Sprach-ID vorkommen wie im Handbuch des Text-Handlers beschrieben.
:li."info"&colon. Dieser optionale String dient der Angabe von Informationen zu den Wrterbchern,
wie z.B. Versionen, Urheberrechtsinformationen oder allgemeinen Anmerkungen. Wenn dafr keine Verwendung besteht, kann der String
leer gelassen werden.
:eul.
:p.:hp1.<spl>:ehp1.
:ul.
:li."sprachid"&colon. Gibt die Sprache der tatschlichen Wrterbcher an, und nicht die Sprache,
fr die sie verwendet werden, beispielsweise "en_us".
:li."rechtschreibwrterbuch"&colon. Der vollstndige Dateiname des Wrterbuches, beispielsweise "en_us.dic".
:li."affix-datei"&colon. Der vollstndige Dateiname der Affix-Datei, beispielsweise "en_us.aff".
:eul.
:p.:hp1.<hyp>:ehp1.
:ul.
:li."sprachid"&colon. Gibt die Sprache der tatschlichen Wrterbcher an, und nicht die Sprache,
fr die sie verwendet werden, beispielsweise "en_us".
:li."silbentrennungswrterbuch"&colon. Der vollstndige Dateiname des Wrterbuchs, beispielsweise "hyph_en.dic".
:li."minlinks"&colon. Eine Zahl, welche die Mindestlnge des linken Teils eines getrennten Wortes angibt.
:li."minln"&colon. Eine Zahl, welche die Mindestlnge zu trennender Wrter angibt.
Hinweis&colon. minln >= minlinks + minrechts
:li."minrechts"&colon. Eine Zahl, welche die Mindestlnge des rechten Teils eines getrennten Wortes angibt.
:eul.
:p.Es kann mehr als ein Silbentrennungswrterbuch angegeben werden. Im Silbentrennungsdialog kann dann
das gewnschte ausgewhlt werden.
:p.:hp1.Beispiel:ehp1.
:p.Es folgt ein realistisches Beispiel&colon.
:xmp.
//Definition fr das Wrterbuch Britisches Englisch
<dict>English, myspell, en_gb, "Ausgabe R 1.14, 15/12/02 oder neuer";
<spl>en_gb, en_gb.dic, en_gb.aff;
<hyp>en_gb, hyph_en.dic, 3, 5, 2;
:exmp.
:p.Der Wrterbuchsteuerungsdatei knnen beliebig viele Wrterbcher hinzugefgt werden.
:p.:hp2.Quellen fr Wrterbcher:ehp2.
:p.Die bis jetzt beste Quelle fr MySpell- und Libhnj-Wrterbcher scheinen die Open-Office-Webseiten
fr Sprachkomponenten zu sein:
:link reftype='launch' object='netscape.exe' data='http://lingucomponent.openoffice.org/'.
http&colon.//lingucomponent.openoffice.org/:elink.
:p.:hp2.Zeichensatzkonvertierungstabellen:ehp2.
:p.Fr die ordnungsgeme Funktion der Rechtschreibprfung ist es erforderlich, da
Maul eine Konvertierung vom der im Textartikel verwendeten Zeichensatz zu dem des
Wrterbuchs durchfhrt.
:p.Myspell-Wrterbcher nutzen gewhnlich ISO-Zeichenstze, da Myspell fr
Unix-kompatible Systeme entworfen wurde. Die verwendeten Wrterbcher knnen, wie
in der Myspell-Quelldatei 'csutil.cpp' festgelegt, folgende Zeichenstze
verwenden&colon.
:ul.
:li.Zeichensatz 819, 'ISO8859-1'
:li.Zeichensatz 912, 'ISO8859-2'
:li.Zeichensatz 913, 'ISO8859-3'
:li.Zeichensatz 914, 'ISO8859-4'
:li.Zeichensatz 915, 'ISO8859-5'
:li.Zeichensatz 1089, 'ISO8859-6'
:li.Zeichensatz 813, 'ISO8859-7'
:li.Zeichensatz 916, 'ISO8859-8'
:li.Zeichensatz 920, 'ISO8859-9'
:li.Zeichensatz 919, 'ISO8859-10'
:li.Zeichensatz 878, 'KOI8-R'
:li.Zeichensatz 1251, 'CP-1251' (ein Windows-Zeichensatz)
:li.Zeichensatz 1252, 'CP-1252' (ein Windows-Zeichensatz)
:eul.
:p.Dieser Handler verwendet Unicode-Konvertierung zur bertragung
von OS/2- und ISO-Zeichenstze und umgekehrt.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Dialog Item Help
.*
.*
.*
.******************************************************************************
:h1 res=95 id=95 global.Rechtschreibprfung
:i1 id=spellchk.Rechtschreibprfung
:p.Mit Hilfe dieses Dialoges kann eine Rechtschreibprfung durchgefhrt werden. Soll nicht
der gesamte Artikel berprft werden, markieren Sie vorher den zu prfenden Text. Wenn kein
Text markiert ist, erfolgt die Rechtschreibprfung ab der Cursor-Position. Markieren Sie
'Gesamten Artikel prfen', um den vollstndigen Artikel prfen zu lassen.
:p.Bevor mit der Rechtschreibprfung begonnen wird, knnen Sie durch Bettigen der Schaltflche
':link reftype=hd res=98.Weitere Optionen >>:elink.' fr diesen Prfungsvorgang
spezifische Optionen setzen, einschlielich Methoden zum Suchen oder Ignorieren bestimmter
Zeichen oder Wrter sowie bestimmter Grammatiktestoptionen.
:p.:hp2.bersicht des Rechtschreibprfungsvorgangs:ehp2.
:p.Wenn Sie bereit sind, drcken Sie 'Start', um mit der Rechtschreibprfung zu beginnen.
Wird ein Wort gefunden, das nicht im Wrterbuch vorhanden ist, bietet der Rechtschreibprfungsdialog
eine Reihe von mglichen Alternativen an. Die wahrscheinlichste Alternative wird automatisch im
Listenfeld ausgewhlt und im Eingabefeld 'Derzeitiges Wort' angezeigt.
:p.Durch Bettigen der Schaltflche 'Aus Datei wiederherstellen' wird das originale, falsch geschriebene
Wort wieder in das Eingabefeld 'Derzeitiges Wort' geladen. Dort knnen Sie es bearbeiten, bevor Sie
'Korrigieren' drcken. Mit dieser Schaltflche wird das Wort im Artikel durch das Wort im Eingabefeld
'Derzeitiges Wort' ersetzt.
:p.Klicken Sie whrend des Prfungsvorganges auf 'Stop', so wird die Rechtschreibprfung abgebrochen.
Die Schaltflche mit dem Titel 'Wort berspringen' wird auf 'Start' gendert; bei Bettigung beginnt
die Rechtschreibprfung erneut vom Anfang des Artikels an.
:p.Durch Klicken auf 'Wort berspringen' fhrt die Rechtschreibprfung ohne irgendwelche anderen Aktionen fort.
:p.Durch Klicken auf 'Wort immer berspringen' wird das Wort im Artikel in einem temporren Ausschluwrterbuch
gespeichert. Der Prfungsvorgang ignoriert smtliche Wrter, die sich in diesem temporren Ausschluwrterbuch befinden.
Es wird ohne weitere Aktionen mit der Rechtschreibprfung fortgefahren.
 
.*******************************************************************************
:h1 res=96 id=96 global.Dialog Rechtschreiboptionen
:i1 id=spellopt.Dialog Rechtschreiboptionen
:p.:artwork name='splopt.bmp' align=left.
:p.Zum Laden des korrekten Wrterbuchs mu ein Textartikel ausgewhlt sein. Ist kein
solcher ausgewhlt, ist der Meneintrag fr die Rechtschreiboptionen deaktiviert.
:p.:hp2.Sprache:ehp2.
:p.Die im derzeit ausgewhlten Textartikel verwendete Sprache wird angezeigt.
Durch Drcken von 'ber' werden Urheberrechtsinformationen zu dieser Sprache angezeigt.
:p.Die Sprachauswahl wirkt sich zudem auf die fr die
:link reftype=hd res=97.Silbentrennung:elink. verwendeten Wrterbcher aus.
:p.:hp2.Weitere Optionen:ehp2.
:p.Nach Drcken der Schaltflche 'Mehr >>' knnen die Standardoptionen fr den Rechtschreibprfungsvorgang
festgelegt werden. Wird von hier aus auf den Dialog
':link reftype=hd res=98.Erweiterte Rechtschreiboptionen:elink.' zugegriffen, so wird
dadurch sichergestellt, da diese Optionen auch fr zuknftige Prfvorgnge gelten.
.br
.br
.*******************************************************************************
:h1 res=98 id=98 global.Dialog Erweiterte Rechtschreiboptionen
:i1 id=spellmore.Dialog Erweiterte Rechtschreiboptionen
:p.:artwork name='splmore.bmp' align=left.
:p.:hp1.Voreinstellungen der erweiterten Rechtschreiboptionen:ehp1.
:p.:hp2.Suche nach:ehp2.
:ul.
:li.kleingeschriebenen Satzanfngen
.br
Es wird nach Stzen gesucht, die mit einem kleinen Buchstaben beginnen, z.B.
"Ich sagte 'Guten Tag'. er sagte 'Auf wiedersehen'."
:li.Wrtern mit Sonderzeichen
.br
Es wird nach Wrtern gesucht, die die angegebenen Zeichen enthalten. Geben Sie diese
Zeichen in das entsprechende Eingabefeld ein. Diese Option ist beim Auffinden konsistenter
Fehler in Text hilfreich, der mit einer Texterkennungssoftware (OCR) erstellt wurde.
:li.Wrter zwischen Sonderzeichen
.br
Hiermit knnen Wrter gefunden werden, die durch bestimmte Zeichen getrennt sind, z.B.
"Meine-getrennte-Liste". Geben Sie das/die Trennungszeichen in das entsprechende Eingabefeld
ein.
:eul.
:p.:hp2.Ignoriere:ehp2.
:ul.
:li.Wrter aus einzelnen Zeichen
.br
Ignoriert Wrter wie "A" (Englisch fr 'ein').
:li.Zahlen
.br
Ignoriert Zahlen, wie beispielsweise "1234".
:li.Wrter mit Zahlen
.br
Ignoriert Wrter, in denen sich Zahlen befinden, wie beispielsweise "Catch22".
:li.Komplett grogeschriebene Wrter
.br
Ignoriert Wrter wie "USA" oder "BBC".
:li.Rmische Zahlen
.br
Ignoriert Wrter wie "LVXCII". Beachten Sie, da diese Option dazu fhren kann, da
Schreibfehler bersehen werden.
:li.Wrter mit Sonderzeichen
.br
Ignoriert Wrter, die bestimmte Zeichen beinhalten, z.B. wird bei Angabe von "$" das Wort "tri$met"
nicht geprft. Geben Sie das/die Zeichen, die ignoriert werden sollen, in das entsprechende Eingabefeld ein.
:li.Sonderzeichen in Wrtern
.br
Entfernt vor der Prfung bestimmte Zeichen aus Wrtern. Beispielsweise wird bei Angabe von "()" das Wort
"(Hallo)" als "Hallo" geprft. Geben Sie die zu entfernenden Zeichen in das entsprechende Eingabefeld ein.
:eul.
.*******************************************************************************
:h1 res=97 id=97 global.Dialog Silbentrennungsoptionen
:i1 id=hyphopt.Dialog Silbentrennungsoptionen
:p.:hp2.Hierarchische Einstellungen fr den Silbentrennungsmodus:ehp2.
:p.Die Silbentrennung wird von drei Faktoren beeinflut.
:ul.
:li.Die im Initialisierungsprofil gespeicherten globalen Einstellungen werden fr alle
neuen Dokumente als Voreinstellungen verwendet. Diese globalen Einstellungen knnen
angepat werden, indem im Hauptdialog der Silbentrennung das Markierungsfeld 'Als Standard sichern'
ausgewhlt wird.
:li.Die artikelweiten Einstellungen werden in der Datei selbst gespeichert. Diese Einstellungen
gelten fr alle neuen Rahmen.
:li.Die Silbentrennung kann fr jeden Textartikel getrennt aktiviert und deaktiviert werden.
Diese Funktion berschreibt die o.g. Einstellungen, so da bei Deaktivierung der Silbentrennung
in einem Artikel die globaleren Einstellungen sie nicht wieder aktivieren knnen.
Der Status der Silbentrennung wird durch den Meneintrag 'Silbentrennung aktivieren'
der Text- und Tabellen-Handler festgelegt.
:eul.
:p.:hp2.Globale Einstellungen des Silbentrennungsmodus:ehp2.
:p.Fr das Laden der richtigen Wrterbcher ist erforderlich, da ein Textartikel ausgewhlt
ist. Ist dies nicht der Fall, wird der Meneintrag fr die Silbentrennungsoptionen deaktiviert.
:p.:artwork name='hyph1.bmp' align=left.
:p.:hp2.Silbentrennungsmodus auswhlen:ehp2.
:p.Der Rechtschreibprfungs-Handler untersttzt nur zwei verschiedene Rechtschreibprfungsmodi.
:ul.
:li.Keine Trennung.
.br
Wrter werden nicht automatisch getrennt.
:li.Entwurfstrennung.
.br
Wrter werden nach den Regeln des aktuellen Silbentrennungswrterbuchs getrennt.
:eul.
:p.Untersttzt die derzeit ausgewhlte Sprache verschiedene Silbentrennungswrterbcher, kann
das passende Wrterbuch aus der Liste ausgewhlt werden.
:p.Bei Auswahl der Schaltflche 'Als Standard sichern' werden die Informationen im Initialisierungsprofil
des Maul Publisher gespeichert und von allen neuen Dokumenten bernommen.
:euserdoc.
 
