******************************************************************************
*                            ICC Make Include File
*
*                            (c) Peter Koller 1996
*
* ICC, ILINK, RC, IPFC, etc. are all (c)IBM.
******************************************************************************



***************************** Core settings **********************************


"
******** Remove this message when you are happy with the configuration *******
^msg("Configuration setup warning", "Have you correctly setup the core settings in 'make.inc'?", $TRUE);


SYSTEMRESOURCECOMPILER, this must point to the resource compiler rc.exe in the <bootdrive>\os2 folder!
DRIVE, where the *.nls folders are created
MAULROOT, where maul is currently installed
PROJECTROOT, root folder for the language kit
CreatePacksHere, where the language files are packed
"

^vars()
    {
        MAULVERSION = "316";
		SYSTEMRESOURCECOMPILER = "c:\os2\rc.exe";
		DRIVE = "d:\runtime\";
        MAULROOT = "d:\runtime\";
        PROJECTROOT = "d:\maul30\Language";
		CreatePacksHere = "d:\out";
    }


************************************ Derived **********************************
^vars()
    {
        FALSE           =   0;
        TRUE            =   1;
        MENU_GENERAL_ID =  100;
        ERREXIT_ID      =  101;
        MAKEALLID       =  401;

		ENV_INCLUDE = $PROJECTROOT"\API;";
		ENV_PATH = $PROJECTROOT"\BIN;";
    }
^out()
	{
		set PATH=$ENV_PATH%PATH%
		set INCLUDE=$ENV_INCLUDE%INCLUDE%
	}
^menu($MENU_GENERAL_ID,"General Options")
    {
        ($ERREXIT_ID, "Exit on Error", $TRUE);
		($MAKEALLID, "pmmake action = /ALL", $FALSE);
    }
^vars()
    {
        ERR_LEV = ^get($ERREXIT_ID,"@if errorlevel 1 exit",);
    }

^actions()
    {
        msgc    =
                @ECHO Create message file $[out]
                $PROJECTROOT\bin\msgc $*.txt
                $ERR_LEV
                ;
        copy    =
                @ECHO ...copy files
                @copy $[src] $[out]\.
                $ERR_LEV
            ;
        delete  =
                @ECHO ...delete files
                @del $[out]\$[src] /n 2>NUL
            ;
        namecpy =
                @ECHO ...copy file to $[out]
                @copy $[src] $[out]
                $ERR_LEV
            ;
        Prelink =
                @echo 
                @echo  Link $[out] 
                @echo 
                ilink /out:$[out] "/dll" $*.obj $*.def
                $ERR_LEV
            ;
		Link386Res =
                @echo 
                @echo  Link $[out] 
                @echo 
                link386 /nod $*.obj, $[out], NUL, , $*.def
                $ERR_LEV
                $SYSTEMRESOURCECOMPILER -x $*.res $[out]
				$ERR_LEV
			;
        ResNoCp =
                @echo 
                @echo  Resource link $[out] + resource 
                @echo 
                $SYSTEMRESOURCECOMPILER -x $*.res $[out]
                $ERR_LEV
            ;
        MaulRes =
                @echo 
                @echo  Resource link $[out] + resource 
                @echo 
                @copy $*.dll $[out]
                $ERR_LEV
                $SYSTEMRESOURCECOMPILER -x $*.res $[out]
                $ERR_LEV
            ;
        Resource =
                @echo 
                @echo  Running resource compiler on $*.rc 
                @echo 
                rc -r $*.rc
                $ERR_LEV
            ;
        Help =
                @echo 
                @echo  Building $[out] 
                @echo 
                ipfc $*.ipf
                $ERR_LEV
            ;
        IpfcCompile =
                @echo 
                @echo  Building $[out] 
                @echo 
                ipfc -i $*.ipf
                $ERR_LEV
            ;
        IPFPrecompile =
                @echo 
                @echo  Precompile $[out] 
                @echo 
                $PROJECTROOT\bin\ipfcprep $*.scr $[out] /n
                $ERR_LEV
            ;
        packfiles    =
                @echo 
                @echo  Create package $[out] 
                @echo 
                pack2 *.* $[out]
                $ERR_LEV
            ;
        listfiles    =
                @dir /n /a:-d /o:n *.*     >>  $[out]
            ;
        pmmake      =
                @echo 
                @echo  Call pmmake $[out] 
                @echo 
                $PROJECTROOT\bin\PMMAKE.exe /x ^get($MAKEALLID, /a, /r){} /e$PROJECTROOT\bin\pmmkicc.dll /i$PROJECTROOT\make.inc $[out]
            ;
		zipfiles	=
                @echo 
                @echo  Create archive $[out], then test it 
                @echo 
				$PROJECTROOT\bin\zip.exe -9 -j $[out] $[all]
				$ERR_LEV
				$PROJECTROOT\bin\unzip.exe -t $[out]
				$ERR_LEV
			;
    }
