/* Entertainment Pack for OS/2 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing Entertainment Pack (Tic Tac Toe, Version 1.1) for OS/2...'
Say ''
Result = SysFileTree( 'TIC.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: TIC.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'TIC.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: TIC.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'LICENSE.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: LICENSE.TXT not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'TIC.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: TIC.DOC not found! Installation cancelled.'
  Signal DONE
  End
Say 'Please enter the full name of the directory to which you want'
Say 'the Entertainment Pack (Tic Tac Toe, Version 1.1) for OS/2'
Say 'installed (default C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory. Installation cancelled.'
    Signal DONE
    End
  End
Say ''
Say 'The program object will be placed in the Games folder...'
Folder = '<WP_GAMES>'
Say ''
Say 'Copying TIC.EXE to' Directory '...'
Copy TIC.EXE Directory                  '1>NUL'
Say 'Copying TIC.HLP to' Directory '...'
Copy TIC.HLP Directory                  '1>NUL'
Say 'Copying LICENSE.TXT to' Directory '...'
Copy LICENSE.TXT Directory                  '1>NUL'
Say 'Copying TIC.DOC to' Directory '...'
Copy TIC.DOC Directory                  '1>NUL'
Say ''
Say 'Creating program object...'
Say ''
Type = 'WPProgram'
Title = 'Tic Tac Toe'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\TIC.EXE;STARTUPDIR='Directory';OBJECTID=<TIC>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Say 'The Entertainment Pack (Tic Tac Toe, Version 1.1) for'
  Say 'OS/2 was successfully installed.'
  Say 'Please read TIC.DOC for additional information.'
  Exit

Say 'ERROR: Unable to create object. Installation cancelled.'
Exit

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Installation error.'
Signal DONE
DONE:
Exit
