// mode: -*- C++ -*-
/*****************************************************************************
 * sidebar.h - header file for sidebar
 ****************************************************************************/
#ifndef SIDEBAR_H
#define SIDEBAR_H

#include <vector>
#include "SDL.h"
#include "actioneventqueue.h"
#include "font.h"

class Player;

enum createmode_t {
    CM_INVALID, CM_INFANTRY, CM_VEHICLE, CM_BOAT, CM_PLANE, CM_HELI, CM_STRUCT
};

class Sidebar {
public:
    Sidebar(Player *pl, Uint16 height, const char* theatre);
    ~Sidebar();

    bool getVisChanged();
    bool getVisible() {return visible;}
    void toggleVisible();

    SDL_Surface* getTabImage() {return tab;}
    SDL_Rect* getTabLocation() {return &tablocation;}

    SDL_Surface* getSidebarImage(SDL_Rect location);
    bool isOriginalType() {return isoriginaltype;}

    Uint8 getButton(Uint16 x, Uint16 y);
    void clickButton(Uint8 index, char* unitname, createmode_t* createmode);
    void resetButton();
    void scrollSidebar(bool scrollup);
    void updateSidebar();

    void startRadarAnim(Uint8 mode, bool* minienable);

    Font* getFont() {return gamefnt;}

    Uint8 getSteps() const {return steps;}

    class SidebarError {};

    enum sidebarop {sbo_null = 0, sbo_build = 1, sbo_scroll = 2, sbo_unit = 4,
        sbo_structure = 8, sbo_up = 16, sbo_down = 32};

    struct SidebarGeometry {
        Uint16 bw,bh;
    };
    const SidebarGeometry& getGeom() {return geom;}
private:
    Sidebar() {};
    Sidebar(const Sidebar&) {};
    Sidebar& operator=(const Sidebar&) {return *this;}

    class RadarAnimEvent : public ActionEvent {
    public:
        RadarAnimEvent(Uint8 mode, bool* minienable, SHPImage* radarshp);
        void run();
    private:
        Uint8 mode, frame, framend;
        bool* minienable;
        SHPImage* radarshp;
    };

    friend class RadarAnimEvent;

    class SidebarButton {
    public:
        SidebarButton(Sint16 x, Sint16 y, const char* fname, Uint8 f,
                const char* theatre, Uint8 palnum);
        ~SidebarButton();
        void ChangeImage(const char* fname);
        void ChangeImage(const char* fname, Uint8 number);
        SDL_Surface* getSurface() const {
            return pic;
        }
        SDL_Rect getRect() const {
            return picloc;
        }
        Uint8 getFunction() const {
            return function;
        }
        static SDL_Surface* fallback(const char* fname);
    private:
        SDL_Surface* pic;
        Uint8 function, palnum;
        const char* theatre;

        bool using_fallback;

        SDL_Rect picloc;
    };

    // 1 - DOS, 0 - GOLD
    bool isoriginaltype;
    Uint8 spalnum;

    void setupbuttons(Uint16 height);
    void scrollbuildlist(Uint8 dir, Uint8 type);
    void build(Uint8 index, Uint8 type, char* unitname, createmode_t* createmode);
    void updateicons();
    void updateAvailableLists();
    void downbutton(Uint8 index);
    void addButton(Uint16 x, Uint16 y, const char* fname, Uint8 f, Uint8 pal);
    void drawButton(Uint8 index);
    void drawClock(Uint8 index, Uint8 imgnum);

    SDL_Surface *tab;
    SDL_Rect tablocation;

    SDL_Surface *sbar;
    SDL_Rect sbarlocation;

    SHPImage* radarshp;
    SDL_Surface* radarlogo;

    Font *gamefnt;

    bool visible, vischanged;

    const char* theatre;

    Uint8 buttondown;
    bool bd;

    Uint8 buildbut;
    std::vector<SidebarButton *> buttons;

    std::vector<char*> uniticons;
    std::vector<char*> structicons;

    const char* radarname;
    RadarAnimEvent* radaranim;
    bool radaranimating;

    Uint8 unitoff,structoff; // For scrolling

    Player *player;
    int scaleq;

    Uint8 steps;

    SidebarGeometry geom;
};

#endif /* SIDEBAR_H */
