/* Command-line aud player
 * used to debug the aud decoding and playing code
 */

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <string>
#include "SDL.h"
#include "stubs.h"
#include "inifile.h"
#include "soundengine.h"
#include "vfs.h"
#include "common.h"
#include "logger.h"

using std::string;

void usage(char* biname)
{
    printf("Usage: %s <audname.aud>\n",biname);
}

Logger* logger;
bool done;
int main(int argc, char* argv[])
{
    SoundEngine* snd;

    if (argc != 2) {
        usage(argv[0]);
        exit(1);
    }
    if ((strcasecmp(argv[1],"-h")==0)||(strcasecmp(argv[1],"-help")==0)||
            (strcasecmp(argv[1],"--help")==0)) {
        usage(argv[0]);
        exit(1);
    }
    const string& binpath = determineBinaryLocation(argv[0]);
    string lf(binpath); lf += "/audplay.log";
    VFS_PreInit(binpath.c_str());
    logger = new Logger(lf.c_str(),0);
    VFS_Init(binpath.c_str());
    done = false;
    if( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_NOPARACHUTE) < 0) {
        logger->error("Couldn't initialize SDL: %s\n", SDL_GetError() );
        exit(1);
    }
    try {
        snd = new SoundEngine();
    } catch (SoundError&) {
        delete logger;
        VFS_Destroy();
        SDL_Quit();
        exit(1);
    }
    try {
        snd->queueSound(argv[1]);
    } catch (SoundError&) {
        logger->error("File not found! %s\n",argv[1]);
        delete snd;
        delete logger;
        VFS_Destroy();
        SDL_Quit();
        exit(1);
    }
    while (!done) {
        // TODO: some form of text based ui (r to restart etc.)
        //SDL_Delay(10);
    }
    delete snd;
    delete logger;
    VFS_Destroy();
    SDL_Quit();
    exit(0);
}
