!    DOMENU             A replacement for Inform's standard DoMenu
!  version 5.0a         built for Inform 6 by L. Ross Raszewski
!                       (rraszews@skipjack.bluecrab.org)
!
!
!  Requires version 3.0 or greater of the Utility.h library
!  To install:
!  Add the following lines BEFORE the inclusion of the parser header file:
!       Replace DoMenu;
!       Replace LowKey_Menu;
!  Include this library AFTER the inclusion of parser.h and utility.h     
!
!  new in 5.0a: tinkered with the multi-screen code to make the display nicer
!  New in 5.0:  *COMPLETE CODE REWRITE of Domenu();
!               The new version eliminates "spaghetti" looping, 
!               gives me more room for future improvements, and
!               should be easier to read.
!               *Upgraded Lowkey_menu to the 6/7 library code base
!               *new feature: tagarray (see below)
!               *more User-definable symbols: define MENU_MARKER
!               to the character you wish to indicate the current
!               line on the menu.  default is '>'
!               define MORE__TX before inclusion to replace the [More] 
!               message on long menus
!               *fixed the "long menu" bug, which causes a superfluous
!               [MORE] to be displayed by the interpreter on some menus.
!               *changed the value of SKIP to prevent conflicts with
!               some old menus
!
!  Other features:
!       Multi-page support                                      (v.4)
!       Multilingual (Inform 6.3+) support                      (v.3)
!       Null-menu objects                                       (v.3)
!       dynamic menu support                                    (v.2)
!       multi-line descriptions                                 (v.1)
!       Second title bar line                                   (v.1)
!       Suppression of terminating <look>                       (v.1)
!       Automatic centering of titles                           (v.1)
!
!  This menu system was designed to support the Altmenu object based
!  menu system.  It does still, and always will support old style domenus.
!
! Differences in usage from standard Domenu:
!   Supression of terminating <look>:
!       to prevent the library from executing a <<look>> command upon exiting
!       the menu, add ,1 to the end of the argument list:
!       DoMenu(menu_choices,entryr,choicer,1);
!   Null-objects:
!       When EntryR is called with a menu_item of -5,
!       the global skipitem will contain the number equivalent to the current 
!       selection.  To force a skip of that selection, make EntryR return SKIP:
!               (from EntryR:)
!               if (menu_item==-5 && skipitem==3) return skip;
!               will skip the third option.
!   Multi-line descriptions:
!      When EntryR() is called with menu_item=-1, return the number of lines
!                in the description:
!               (from EntryR:)
!               if (menu_item==-1) return x;
!       where x is the number of lines of description
!    Title Bars:
!       When EntryR() is called with menu_item=-1, set item_name to the
!         title bar string:
!          (from EntryR)
!          if (menu_item==-1) { item_name="Second Line"; return 4;}
!               (where 4 is the number of lines of description)
!
!     Long menus:
!       menu_choices (which must be a function for multipage menus) is now
!       called with a parameter.  This parameter is the number of the menu
!       item to start with.  Descriptive text should only be printed if
!       the parameter is zero:
!       [ Menu_choices doFrom;
!               if (doFrom==0) print "Introductory text";
!               if (doFrom<=1) print "Item 1";
!               if (doFrom<=2) print "item 2";
!               ...
!       ]
!      Inserts the word [More] at the top and bottom to
!      indicate additional selections.
!     Tagarray:
!       to change the default messages displayed on the domenu top
!       banner, pass an array containing replacement tags as the 5th argument:
!       DoMenu(menu_choices,entryr,choicer,0,MY_TAGS);
!       the structure of the tag array is as follows:
!       -->0: top-left tag
!       -->1: top-right tag
!       -->2: bottom-left tag
!       -->3: bottom-right tag: unnested menu
!       -->4: bottom-right tag: nested menu
!       -->5: right-margin offset for top-right tag
!       -->6: right-margin offset for bottom-right tag
!
!
! Comments?  e-mail me!
!
!
! For maximum enjoyment, add on (not required)
!  AltMenu.H   -> An alternative to menus, object oriented menu system
!                       (inspired by Graham Nelson's attempt to do the same
!                        thing.  Mine makes use of the nifty abilities of this
!                        library)
Iffalse UTILITY_LIBRARY>=30;
message error "DoMenu 5.0 requires version 3 or greater of the Utility.h library.";
endif;
ifndef DOMENU_LIBRARY;
Constant DOMENU_LIBRARY 50;
! Global Skipitem, used for specifying items to be skipped.
global Skipitem;
! SKIP  The return value for skip objects.
constant SKIP = -55;
! tagarray: holds the text-tags used in the domenu banner
global tagarray;
! DM_TAG is the default tagarray
Array DM_TAG--> NKEY__TX PKEY__TX RKEY__TX QKEY1__TX QKEY2__TX 12 17;
! Language Block
Default MORE__TX "[More]";      ! Message displayed to indicate multipage
Default MENU_MARKER '>';        ! Marks the current selection


! Loykey version of Domenu.  NOTE: skipped options do not work in lowkey
! mode.

[ LowKey_Menu menu_choices EntryR ChoiceR inflag lines main_title i j;
  menu_nesting++;
 .LKRD;
  menu_item=0;
  lines=indirect(EntryR);
  main_title=item_name;
  print "--- "; print (string) main_title; print " ---^";
  menu_item=-1;
  item_name=-1;
  indirect(EntryR);
  if (item_name ofclass string) print (string) item_name;
  if (menu_choices ofclass Routine) menu_choices.call();
  else print (string) menu_choices;
  for (::)
  {   L__M(##Miscellany, 52, lines);
      print "> ";

      #IFV3; read buffer parse;
      #IFNOT; read buffer parse DrawStatusLine;
      #ENDIF;

      i=parse-->1;
      if (i==QUIT1__WD or QUIT2__WD || parse->1==0)
      {   menu_nesting--; if (menu_nesting>0) rfalse;
          if (deadflag==0 && inflag==0) <<Look>>;
          rfalse;
      }
      i=TryNumber(1);
      if (i==0) jump LKRD;
      if (i<1 || i>lines) continue;
      menu_item=i;
      j=indirect(ChoiceR);
      if (j==2) jump LKRD;
      if (j==3) rfalse;
  }
];



#IFV3;
[ DoMenu menu_choices EntryR ChoiceR inflag;
  LowKey_Menu(menu_choices,EntryR,ChoiceR,inflag);
];
#ENDIF;

! Domenu: syntax is the same as always

[ DoMenu Menu_choices EntryR ChoiceR inflag D_tagarray cl;
 if (D_tagarray==0) D_tagarray=DM_TAG;
 menu_nesting++;
 cl=1;
 while(cl~=-1)
 {
  tagarray=D_Tagarray;
  cl=DM_Menu(Menu_choices,EntryR,ChoiceR,cl);
 }
 menu_nesting--;
 if (menu_nesting==0)
 {
  @erase_window -1; 
  if (deadflag==0 && inflag==0)
  {
   DrawStatusline();
   <<Look>>;
  }
 }
];


! Domenu internal functions: DO NOT CALL SEPARATELY
[ DM_Menu Menu_choices EntryR ChoiceR cl menu_title
          sub_title lines d_lines oldcl offset dofrom i cursor_move;
 menu_item=0;
 lines=indirect(EntryR);
 menu_title=item_name;
 item_name=NULL;
 menu_item=-1;
 d_lines=indirect(EntryR);
 sub_title=item_name;
 oldcl=cl;
 dofrom=DM_CheckDofrom(cl, dofrom, d_lines);
 if (dofrom==0) offset=d_lines+4;
 else {
        dofrom=dofrom+5;
        offset=5-dofrom;
      }
 DM_DrawMenu(menu_choices,menu_title,sub_title,lines,d_lines,
             dofrom);
 DM_PutCursor(offset,cl,oldcl);
 do {
  @set_cursor 0 0;
  @read_char 1 0 0 i;
  cursor_move=0;
  if (i=='n' or 'N' or 130) cursor_move=1;
  else if (i=='p' or 'P' or 129) cursor_move=-1;
  else if (i=='q' or 'Q' or 27) return -1;
  else if (i==10 or 13 or 132)
  {
   menu_item=cl;
   indirect(EntryR);
   @erase_window -1;
   @split_window 1;
   i = 0->33; if (i==0) i=80;
   @set_window 1;
   @set_cursor 1 1;
   style reverse; spaces(i);
   CenterU(item_name,1);
   style roman; @set_window 0; new_line;
   i = indirect(ChoiceR);
   if (i==3) return -1;
   else if (i==2) return cl;
   L__M(##Miscellany,53);
   WaitForKey(" ");
   return cl;
  }
  if (cursor_move~=0)
  {
   do {
    cl=cl+cursor_move;
    if (cl>lines) cl=1;
    else if (cl<1) cl=lines;
    menu_item=-5;
    skipitem=cl;
   } until (indirect(EntryR)~=SKIP);
   i=DM_CheckDofrom(cl, dofrom, d_lines);
   if (i~=dofrom)
   {
    dofrom=i;
    DM_DrawMenu(menu_choices,menu_title,sub_title,lines,d_lines,
                dofrom);
   }
   if (dofrom==0) offset=d_lines+4;
   else offset=5-dofrom;
   DM_PutCursor(offset,cl,oldcl);
   oldcl=cl;
  }
 } until (false);
];

[ DM_CheckDofrom cl dofrom d_lines offset;
 if (dofrom==0) offset=d_lines+4;
 else offset=5-dofrom;
 if ((offset+cl)>(0->32))
  return DM_CheckDofrom(cl,dofrom+1,d_lines);
 if ((offset+cl)<=5)
  return DM_CheckDofrom(cl,dofrom-1,d_lines);
 return dofrom;
];

[ DM_DrawMenu menu_choices menu_title sub_title lines d_lines dofrom
              height width i j;
 @erase_window -1;
 height=d_lines+lines+5;
 @split_window height;
 @set_window 1;
 width=(0->33); if (width==0) width=80;
 style reverse;
 for (i=1:i<=3:i++)
 {
  @set_cursor i 1;
  spaces(width);
 }
 CenterU(menu_title,1);
 @set_cursor 2 2;
 print (string) tagarray-->0;
 j=width-tagarray-->5;
 @set_cursor 2 j;
 print (string) tagarray-->1;
 @set_cursor 3 2;
 print (string) tagarray-->2;
 j=width-tagarray-->6;
 @set_cursor 3 j;
 if (menu_nesting==1)
  print (string) tagarray-->3;
 else print (string) tagarray-->4;
 if (sub_title ~= NULL)
 {
  style bold;
  CenterU(sub_title,2);
 }
 style roman;
 @set_cursor 5 1;
 if (menu_choices ofclass String) print (string) menu_choices;
 else indirect(menu_choices,doFrom);
 j=width-7;
 if (dofrom>0)
 {
  i=d_lines+5;
  @set_cursor i j;
  print (string) MORE__TX;
 }
 if ((height>(0->32) && dofrom==0) || ((lines+5-dofrom)>(0->32)))
 {
  i=0->32;
  @set_cursor i j;
  print (string) MORE__TX;
 }
];

[ DM_PutCursor offset cl oldcl i;
  i=offset+oldcl;
  @set_cursor i 4;
  if (i>=5 && i<=(0->32))
  print " ";
  i=offset+cl;
  @set_cursor i 4;
  print (char) MENU_MARKER;
];
Endif;
