! DescOrd.h - a library file to ensure the exact order in which objects
! are described.  Version 1, 971005, written by Neil James Brown.
!
! To be most useful, all collectable or non-scenery objects (except
! locations) should be given the class descord. This class defines the
! describe property, so in its place, define descstring as a suitable string
! describing the object, and give the object a descrank property, containing
! the position the object should normally appear in (1 being highest).

Global descord_set = 0;
Array descord_objs --> 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                       0 0 0 0 0; ! 32 object limit - expand as necessary.

Class descord
  with describe
        [ i n total temp1 temp2 tennos;
          descord_set++;
          n=0;
          i=0;
          objectloop (i in location && i hasnt concealed && i hasnt scenery
                      && i ofclass descord) n++;
          if (n>32) "** Error - too many objects for DescOrd to deal with! \
           **";
          if (descord_set>1)
          { if (descord_set==n) descord_set=0;
            rtrue;
          }
          total=n;
          n=0;
          objectloop (i in location && i hasnt concealed && i hasnt scenery
                      && i ofclass descord)
          { descord_objs-->n=i;
            n++;
          }
          do
          { n=0;
            for (i=0: i<(total-1): i++)
            { temp1=descord_objs-->i;
              temp2=descord_objs-->(i+1);
              if (temp1.descrank>temp2.descrank)
              { descord_objs-->(i+1)=temp1;
                descord_objs-->i=temp2;
                n++;
              }
            }
          } until (n==0);
          for (i=0: i<total: i++)
          { temp1=descord_objs-->i;
            if (temp1.descrank==10)
            { if (tennos==0) print "^You can also see ";
              if (i==total-1)
              { if (tennos>0)
                { print ", and "; }
                print_ret (a) temp1, " here.";
              }
              temp2=descord_objs-->(i+1);
              if (temp2.descrank>10)
              { print " and ", (a) temp1, " here.^";
              }
              else
              { if (tennos>0)
                { print ", ", (a) temp1;
                }
                else
                { print (a) temp1;
                }
              }
              tennos++;
            }
            else  
            { if (temp1 provides descstring)
              { if (temp1.descstring ofclass string)
                { print "^", (string) temp1.descstring, "^";
                }
                else
                { temp1.descstring();
                }
              }
              else
              { print "^You can see ", (a) temp1, " here.^";
              }
            }
          }
          rtrue;
        ];