/*************************************************************************/
/***	MYFUNCTIONS-LIB-INCLUDE-FILE (Some handy defines...)             ***/
/*************************************************************************/
/***  Autor         : Thorsten Thielen                                 ***/
/***	Begonnen am		:	??.??.1992																			 ***/
/***	Last Change		:	17.05.1996																			 ***/
/*************************************************************************/

#ifndef _MYDEFS_H_

#define   _MYDEFS_H_

/*************************************************************************/

/*** TC has it, but GCC does not ... so define it here ***/

/*struct tm
 { int  tm_sec,  tm_min,  tm_hour;
   int  tm_mday, tm_mon,  tm_year;
   int  tm_wday, tm_yday;
   int  tm_isdst;
 };*/

#ifndef __TURBOC__

struct date
 { int   da_year;  /* Jahr - 1980 */
   char  da_day;   /* Tag (1..31) */
   char  da_mon;   /* Monat (1..12) */
 };

enum { BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LIGHTGRAY,
       DARKGRAY, LIGHTBLUE, LIGHTGREEN, LIGHTCYAN, LIGHTRED, LIGHTMAGENTA,
       YELLOW, WHITE };

struct text_info {
  unsigned char  winleft,   wintop;
  unsigned char  winright,  winbottom;
  unsigned char  attribute, normattr;
  unsigned char  currmode;
  unsigned char  screenheight;
  unsigned char  screenwidth;
  unsigned char  curx, cury;
};

#define  gotoxy              v_gotoxy
#define  delline             v_delline (1)
#define  cputs               v_puts
#define  textattr            v_attrib
#define  putch               v_putc
#define  clreol              v_clreol
#define  farmalloc           malloc
#define  farfree             free
#define  delay               _sleep2

/*
#define  kbhit
#define  gettext
#define  puttext
*/

#endif

/*************************************************************************/

#ifdef __cplusplus
#define   min(a,b)                     ((a) < (b) ? (a) : (b))
#define   max(a,b)                     ((a) > (b) ? (a) : (b))
#endif

#define   REAL_EOF                     255

#define   FALSE                        0
#define   TRUE                         1
#define   MAYBE										     2

#define   FOREVER                      for (;;)

#define   DATE_YEAR_OFFSET             1900

#define   NO_ERROR                     0

#define   STATUS_STILL_RUNNING         -1
#define   STATUS_EXIT_DONE              0
#define   STATUS_EXIT_CANCEL           -2
#define   STATUS_EXIT_ERROR            -3

#define   RET_OK                        0
#define   RET_RUNNING                  -1
#define   RET_CANCEL                   -2
#define   RET_ERROR                    -3

#define   SETFLAG(flags,flag)          ((flags) = ((flags) | (flag)))
#define   CLEARFLAG(flags,flag)        ((flags) = ((flags) & (~flag)))
#define   FLAGSET(flags,flag)          (((flags) & (flag)) != 0L)

#define   BIT_SET(buffer,bit_n)        (*(((UBYTE *)(buffer))+((bit_n)>>3)) & (1<< ((bit_n) & 0x07)))
#define   SET_BIT(buffer,bit_n)        *(((UBYTE *)(buffer))+((bit_n)>>3)) = (*(((UBYTE *)(buffer))+((bit_n)>>3)) | (1<< ((bit_n) & 0x07)))
#define   CLEAR_BIT(buffer,bit_n)      *(((UBYTE *)(buffer))+((bit_n)>>3)) = (*(((UBYTE *)(buffer))+((bit_n)>>3)) & ~(1<< ((bit_n) & 0x07)))

#define   A_BYTES_NEEDED(a_bits)       (((a_bits-1)>>3)+1)

#define   W2BS(w)                      (UBYTE) ((w)    &0x00ff), \
                                       (UBYTE)(((w)>>8)&0x00ff)

#define   L2BS(l)                      (UBYTE) ((l)     &0x000000ff), \
                                       (UBYTE)(((l)>>8) &0x000000ff), \
                                       (UBYTE)(((l)>>16)&0x000000ff), \
                                       (UBYTE)(((l)>>24)&0x000000ff)

/*************************************************************************/

#define BOOL                    char
typedef	char *									STRPTR;
#define	VOID										void

#define CHAR										char
#define	BYTE										signed char
#define	SHORT										signed short int
#define	LONG										signed long int
#define	UBYTE										unsigned char
#define USHORT									unsigned short int
#define ULONG										unsigned long int
#define	FLOAT										float
#define	DOUBLE									double

#define CHECK_T                 SHORT
#define TXTCOORS_T              UBYTE

/*************************************************************************/

struct XYZPrgGlobalAktData
{
	SHORT			last_kcode;
	SHORT			jump_out;
	SHORT			last_error;
  SHORT     lalo_error;
  BOOL      button_sys;
};

extern struct XYZPrgGlobalAktData    pgad_xyz;

/*************************************************************************/

#define   SPECIAL_KEYS                 1000

enum
{
  KEYS_START = 1014,
  BACK_TAB,     ALT_Q,        ALT_W,        ALT_E,         ALT_R,
  ALT_T,        ALT_Z,        ALT_U,        ALT_I,         ALT_O,
  ALT_P,        ALT_UE,       ALT_PLUS,     ALT_RETURN,    UNKNOWN_01,
  ALT_A,        ALT_S,        ALT_D,        ALT_F,         ALT_G,
  ALT_H,        ALT_J,        ALT_K,        ALT_L,         ALT_OE,
  ALT_AE,       ALT_POWER,    UNKNOWN_02,   UNKNOWN_03,    ALT_Y,
  ALT_X,        ALT_C,        ALT_V,        ALT_B,         ALT_N,
  ALT_M,        UNKNOWN_04,   UNKNOWN_05,   UNKNOWN_06,    UNKNOWN_07,
  UNKNOWN_08,   UNKNOWN_09,   UNKNOWN_10,   UNKNOWN_11,    F1,
  F2,           F3,           F4,           F5,            F6,
  F7,           F8,           F9,           F10,           UNKNOWN_12,
  UNKNOWN_13,   C_HOME,       C_UP,         PAGE_UP,       UNKNOWN_14,
  C_LEFT,       Z_5,          C_RIGHT,      UNKNOWN_15,    C_END,
  C_DOWN,       PAGE_DOWN,    INSERT,       DELETE,        SHIFT_F1,
  SHIFT_F2,     SHIFT_F3,     SHIFT_F4,     SHIFT_F5,      SHIFT_F6,
  SHIFT_F7,     SHIFT_F8,     SHIFT_F9,     SHIFT_F10,     CTRL_F1,
  CTRL_F2,      CTRL_F3,      CTRL_F4,      CTRL_F5,       CTRL_F6,
  CTRL_F7,      CTRL_F8,      CTRL_F9,      CTRL_F10,      ALT_F1,
  ALT_F2,       ALT_F3,       ALT_F4,       ALT_F5,        ALT_F6,
  ALT_F7,       ALT_F8,       ALT_F9,       ALT_F10,       UNKNOWN_16,
  CTRL_C_LEFT,  CTRL_C_RIGHT, CTRL_END,     CTRL_PAGE_DOWN,CTRL_HOME,
  ALT_1,        ALT_2,        ALT_3,        ALT_4,         ALT_5,
  ALT_6,        ALT_7,        ALT_8,        ALT_9,         ALT_0,
  ALT_SS,       ALT_APOS,
};

#define		TAB											9
#define   BACKSPACE               8
#define   ESCAPE                  27
#define   ESC                     ESCAPE
#define   RETURN                  13
#define   ENTER                   RETURN

/*************************************************************************/

#endif
