/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * viewer.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PSZ         *rgpsz;
extern PTILEBOX    ptbox, ptboxFont, ptboxWeaps;
extern CHAR        g_pszErr[];

/*************************************************************************/

#define MAX_TEXTS 7
#define XS_VIEWER 150

PSZ *pszTexts;

/*************************************************************************/

VOID Viewer (PGADGETLIST pgadlist, USHORT xo, USHORT yo)
{
    SHORT    kcode, action;
    SHORT    text = 0, old_text = text+1;

    pszTexts = &rgpsz[TXT_VIEWER_0];
    
    pgadlist->xo = xo;
    pgadlist->yo = yo;

    draw_stone (0+xo, 0+yo, 232+xo, 106+yo, LIGHTGRAY, WHITE, DARKGRAY);
    draw_stone (4+xo, 4+yo, 228+xo, 102+yo, CYAN, DARKGRAY, WHITE);
    draw_stone (8+xo, 8+yo, 204+xo, 98+yo, BLACK, WHITE, DARKGRAY);

    gadlist_draw (pgadlist);
    
    do
    {
        if (text != old_text)
        {
            draw_stone (8+xo, 8+yo, 204+xo, 98+yo, BLACK, WHITE, DARKGRAY);
            show_string (ptboxFont, pszTexts[text], 12+xo, 12+yo, 200);
            
            old_text = text;
        }

        kcode = -1;
        do
        {
            /*** Check for any user activities (keyboard,mouse) ***/
            kcode = _read_kbd (0, 0, 0);
            if (kcode == 0)
                kcode = _read_kbd (0, 0, 0);

            do_stars (xo+0, yo+0, xo+232, yo+106);
        }
        while (kcode == -1);
        action = -1;

        /*** Check what action user wants ***/
        if (kcode != -1)
        {
            switch (kcode)
                {
                case C_UP:       action = ACT_VIEW_PREV;       break;
                case C_DOWN:     action = ACT_VIEW_NEXT;       break;
                case PAGE_UP:    action = ACT_VIEW_PREV;       break;
                case PAGE_DOWN:  action = ACT_VIEW_NEXT;       break;
                case 27:         action = ACT_VIEW_OK;         break;
                
                case 9:          action = ACT_GADGET_NEXT;     break;
                case K_BACKTAB:  action = ACT_GADGET_PREV;     break;
                case 13:         action = ACT_GADGET_SHOOT;    break;
                }
        }

        /*** Anything to do with the gadgets? ***/
        switch (action)
        {
        case ACT_GADGET_NEXT:
            gadlist_next (pgadlist);
            break;
 
        case ACT_GADGET_PREV:
            gadlist_prev (pgadlist);
            break;

        case ACT_GADGET_SHOOT:
            action = gadlist_shoot (pgadlist);
            break;
        }

        /*** Make action ***/
        switch (action)
        {
        case ACT_VIEW_NEXT:
            if (text < MAX_TEXTS-1)
                text ++;
            else
                text = 0;
            break;

        case ACT_VIEW_PREV:
            if (text > 0)
                text --;
            else
                text = MAX_TEXTS-1;
            break;
        }
    }
    while (action != ACT_VIEW_OK);

    GFX_BOX (0+xo, 0+yo, 232+xo, 106+yo, BLACK);
}
/*************************************************************************/
