#define INCL_DOSMEMMGR
#include <os2.h>

#include <stdio.h>

#define OBJSIZE 32768
#define STRLEN 64   /* Maximum length of name string */

main()
{
    char * pstring;
    void *memobj;
    APIRET usResult, ErrorCode;

    /* *LAB * Allocate a memory object of OBJSIZE bytes */
    usResult = DosAllocMem(&memobj, OBJSIZE, PAG_COMMIT | PAG_READ | PAG_WRITE);

    /* *LAB* Prepare it for suballocation */
    usResult = DosSubSet(memobj, DOSSUB_INIT, OBJSIZE);
    /* *LAB* Suballocate a block of STRLEN bytes in length */
    usResult = DosSubAlloc(memobj, (PPVOID)&pstring, STRLEN);

    puts("Hi, what's your name?");
    if(gets(pstring) == NULL) {
        fputs("gets function call failed", stderr);
        ErrorCode = 1;
    }
    else {
        fputs("Pleased to meet you, ",stdout);
        fputs(pstring, stdout);
        fputs("\n",stdout);
        ErrorCode = 0;
    }
    /* *LAB* Free up memory */
    DosSubFree(memobj, pstring, STRLEN);
    DosSubUnsetMem(memobj);
    DosFreeMem(memobj);

    DosExit(EXIT_PROCESS,ErrorCode);
}
