#pragma pack(1)

struct field {
    int id;                 /* Field id on screen */
    int row;                /* Screen coordinates */
    int col;
    int prow;
    int pcol;
    short type;             /* SQL Server types */
    int length;             /* Field length */
    char *name;             /* Field name - will double as prompt for simple apps */
    unsigned char attrib;   /* Screen attributes, not currently used in PM */
    long colsize;           /* SQL Server variable size */
    void *value;            /* SQL Server value, as SQL Server type */
    char *content;          /* Current record value, as char string */
    char *prompt;
    HWND hwndParent;
    HWND hwndPrompt;
    HWND hwndField;         /* Handle to entry control */
    struct field *prev;     /* Pointers to previous and next fields */
    struct field *next;     /*  - used for cursor movement in form-filling */
} ;

extern  struct field *add_field(struct field *where,struct field *p);
extern	struct field *make_field(char *name,int prow, int pcol, int row,int col,int length, unsigned char type,
    long colsize, unsigned char attrib, char *content, char *prompt);
extern	void set_field_char(struct field *which,char *what);
extern  void set_field_int(struct field *which,int i);
extern  void set_field_hex(struct field *which,int i);
extern	unsigned int disp_form(struct field *h);
extern  void SetFormPos(struct field *f);
extern  void release_field(struct field *where);
extern	void unlink_field(struct field *where);
extern  void release_form(struct field *where);
extern  struct field *append_field(struct field *where,struct field *p);
extern	void clear_rd(int row, int col);
extern	void set_field_ver_no(struct field *which, unsigned int i);
extern	void set_field_flstr(struct field *which, char *pbuf, long len);
extern	void v2c(struct field *f); /* field value to content conversion */
extern	void fv2c(struct field *f); /* Convert _all_ values to contents */
extern	void refreshform(struct field *f);
extern	void read_form(struct field * f);
extern	void fc2v(struct field *f)	/* Convert all form contents to values */;
extern	void c2v(struct field *f);
extern	void set_flstr_field(struct field *f, char *dest, long length);

/* Field types */
#define FLS 0x01
