#define INCL_WIN
#include <os2.h>

#include <string.h>

#include "forms.h"
#include "pmforms.h"

RECTL ClientSize;

/**** Field positioning and dimension constants */
#define FIELD_HEIGHT	26
#define FIELD_X 10  /* Field horizontal spacing */
#define FIELD_Y (FIELD_HEIGHT + 4)	/* Field vertical spacing */
#define TOP_MARGIN  10	/* Margin from top of client window area */

/**** Display a field f on screen *****/

unsigned int disp_field(struct field *f)
{
    ENTRYFDATA efd;

    WinQueryWindowRect(f->hwndParent, &ClientSize);

    f->hwndPrompt = WinCreateWindow(f->hwndParent,
	WC_STATIC,
	f->prompt,
	WS_VISIBLE | SS_TEXT | DT_RIGHT,
	FIELD_X * (f->pcol),(short) ClientSize.yTop - TOP_MARGIN - (f->prow * FIELD_Y),
	FIELD_X * strlen(f->prompt), FIELD_HEIGHT,
	f->hwndParent,
	HWND_TOP,
	2 * f->id + 1,
	(PVOID) NULL,
	(PVOID) NULL);

    efd.cb = sizeof(ENTRYFDATA);
    efd.cchEditLimit = (USHORT)f->colsize;
    efd.ichMinSel = 0;
    efd.ichMaxSel = (USHORT)f->colsize;

    f->hwndField = WinCreateWindow(f->hwndParent,
	WC_ENTRYFIELD,
	f->content,
	WS_VISIBLE | ES_AUTOSCROLL| ES_MARGIN,
	FIELD_X * f->col, (short) ClientSize.yTop - TOP_MARGIN + 10 - (f->row * FIELD_Y),
	f->length >10 ? (FIELD_X-2) * f->length : FIELD_X * f->length,FIELD_HEIGHT - 10,
	f->hwndParent,
	HWND_TOP,
	2 * f->id,
	&efd,
	(PVOID) NULL);

    return 0;
}

void SetFieldPos(struct field *f)
{
    WinQueryWindowRect(f->hwndParent, &ClientSize);

    WinSetWindowPos(f->hwndPrompt,
	0L,
	FIELD_X * f->pcol,(short) ClientSize.yTop - TOP_MARGIN - (f->prow * FIELD_Y),
	FIELD_X * strlen(f->prompt), FIELD_HEIGHT,
	SWP_MOVE);

    WinSetWindowPos(f->hwndField,
	0L,
	FIELD_X * f->col, (short) ClientSize.yTop - TOP_MARGIN + 10 - (f->row * FIELD_Y),
	FIELD_X * f->length,FIELD_HEIGHT - 10,
	SWP_MOVE);
}

void refreshfield(struct field *f)
{
    WinSetWindowText(f->hwndField,f->content);
}

void read_field(struct field *f)
{   /* f->colsize +1 to allow for trailing null */
    WinQueryWindowText(f->hwndField,(short)f->colsize+1,f->content);
}
