#define INCL_PM

#include <os2.h>
#include <malloc.h>

#include "lab12.h"
#include "..\lab15\pmassert.h"

MRESULT EXPENTRY Chart2WndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ScrlChartWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ChartWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

HWND hwndFrame, hwndClient, hwndMenuBar, hwndToolBar;

main(int argc, char *argv[], char *envp[])
{
   HAB hab;
   HMQ hmq;
   QMSG qmsg;
   PFNWP pfnwpOldFrameProc ;
   ULONG flFrameFlags = FCF_STANDARD & ~FCF_ICON & ~FCF_ACCELTABLE & ~FCF_MENU;

   hab = WinInitialize(0);

   hmq = WinCreateMsgQueue(hab,0);
   pmassert(hab, hmq);

   if(!WinRegisterClass(hab,
      WC_CHART2,
      Chart2WndProc,
      CS_SIZEREDRAW,
      sizeof(PPLAN)))
         return(1);

   if(!WinRegisterClass(hab,
      WC_CHART,
      ChartWndProc,
      CS_SIZEREDRAW,
      0))
         return(1);

   hwndFrame = WinCreateStdWindow(  HWND_DESKTOP,
                                    WS_VISIBLE,
                                    &flFrameFlags,
                                    WC_CHART2,
                                    PROGNAME,
                                    0L,
                                    (HMODULE)0,
                                    ID_MAIN,
                                    &hwndClient);

   pmassert(hab, hwndFrame);
   pmassert(hab, hwndClient);

   /* Subclass the old frame window */
   pfnwpOldFrameProc = WinSubclassWindow(hwndFrame, (PFNWP) NewFrameProc);
   pmassert(hab, pfnwpOldFrameProc);

   /* Store pointer to the old frame proc into the window words */
   WinSetWindowPtr(hwndFrame, 0, (PVOID)pfnwpOldFrameProc );

   hwndMenuBar = WinLoadMenu(hwndFrame, (HMODULE)NULL, ID_MAIN );
   pmassert(hab, hwndMenuBar);

   hwndToolBar = WinLoadMenu(hwndFrame, (HMODULE)NULL, MID_TOOLBAR );
   pmassert(hab, hwndToolBar);

   WinPostMsg(hwndFrame, WM_UPDATEFRAME, 0L, 0L);

   /*
    *  Note that the last menu loaded, the toolbar, is the
    *  one that is associated with the frame as "the" menu.
    *  this means that hwndMenuBar is the only link to the
    *  regular action bar, so hang onto it tightly
    */
   while(WinGetMsg(hab, &qmsg, 0, 0, 0))
      WinDispatchMsg(hab, &qmsg);

   WinDestroyWindow(hwndFrame);
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   return 0;
}

char *pszToolsText[CTOOLS] = {"Zoom In", "Zoom Out", "Button 3", "Button 4",
                           "Button 5", "Button 6", "Button 7", "Button 8"};

MRESULT EXPENTRY Chart2WndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   HAB hab;
   RECTL rc;
   VSCDATA vscData;
   int i;               // General purpose counter
   HWND hwndPopup;      // Pop up menu handle
   PPLAN p;
   MRESULT mrTemp;
   USHORT uscxVScroll, uscyHScroll;

   hab = WinQueryAnchorBlock(hwnd);
   p = PPLANFROMHWND(hwnd);

   switch(msg) {
      case WM_CREATE:
         /* malloc space for a PLAN structure */
         p = (PPLAN)malloc(sizeof(PLAN));
         WinSetWindowPtr(hwnd, 0, p);
         pmassert(hab, p);

         /* WinSetPresParam(hwnd,
             PP_FONTNAMESIZE,
             sizeof("8.Helv"),
             "8.Helv"); */

         /* Create toolbar */
         vscData.cbSize = sizeof(VSCDATA);
         vscData.usRowCount = CTOOLS;
         vscData.usColumnCount = 1;

         p->hwndToolbar = WinCreateWindow(hwnd,
                                       WC_VALUESET,
                                       (PSZ)NULL,
                                       VS_TEXT | VS_ITEMBORDER | VS_BORDER | WS_VISIBLE,
                                       0,0,0,0,
                                       hwnd,
                                       HWND_TOP,
                                       ID_TOOLBAR,
                                       &vscData,    //pCtrlData
                                       NULL);       //pPresParams

         pmassert(hab, p->hwndToolbar);

         p->hwndVScroll = WinCreateWindow(hwnd,
                                       WC_SCROLLBAR,
                                       (PSZ)NULL,
                                       WS_VISIBLE | SBS_VERT,
                                       0,0,0,0,
                                       p->hwndChart,
                                       HWND_TOP,
                                       ID_VERTSCROLL,
                                       NULL,
                                       NULL);

         pmassert(hab, p->hwndVScroll);

         p->hwndHScroll = WinCreateWindow(hwnd,
                                       WC_SCROLLBAR,
                                       (PSZ)NULL,
                                       WS_VISIBLE | SBS_HORZ,
                                       0,0,0,0,
                                       p->hwndChart,
                                       HWND_TOP,
                                       ID_HORZSCROLL,
                                       NULL,
                                       NULL);

         pmassert(hab, p->hwndVScroll);

         p->hwndChart = WinCreateWindow(hwnd,
                                     WC_CHART,
                                     (PSZ)NULL,
                                     WS_VISIBLE,
                                     0,0,0,0,
                                     hwnd,
                                     HWND_TOP,
                                     ID_CHART,
                                     NULL,
                                     NULL);

         pmassert(hab, p->hwndChart);

         /* Insert text into toolbar */
         for(i = 0; i < CTOOLS; i++)
            WinSendMsg(p->hwndToolbar,
                        VM_SETITEM,
                        MPFROM2SHORT(i+1, 1),
                        pszToolsText[i]);

        WinSetOwner(p->hwndVScroll, p->hwndChart);
        WinSetOwner(p->hwndHScroll, p->hwndChart);

        return (MRESULT) FALSE;

      case WM_SIZE:
        /* mp1 = cxOld, cyOld,  mp2 = cxNew, cyNew */

        uscxVScroll = WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL);
        uscyHScroll = WinQuerySysValue(HWND_DESKTOP, SV_CYHSCROLL);

        /* Set the position and size of the chart window first */
        WinSetWindowPos(p->hwndChart,
                        HWND_TOP,
                        TOOLBARWIDTH,
                        uscyHScroll,
                        SHORT1FROMMP(mp2) - uscxVScroll - TOOLBARWIDTH,
                        SHORT2FROMMP(mp2) - uscyHScroll,
                        SWP_SIZE | SWP_MOVE);

        /* Set the position and size of the horizontal scroll bar */
        WinSetWindowPos(p->hwndHScroll,
                        HWND_TOP,
                        TOOLBARWIDTH,
                        0,
                        SHORT1FROMMP(mp2) - uscxVScroll - TOOLBARWIDTH,
                        uscyHScroll,
                        SWP_SIZE | SWP_MOVE);

        /* And set the position and size of the vertical scroll bar */
        WinSetWindowPos(p->hwndVScroll,
                        HWND_TOP,
                        SHORT1FROMMP(mp2) - uscxVScroll,
                        0,
                        uscxVScroll,
                        SHORT2FROMMP(mp2),
                        SWP_SIZE | SWP_MOVE);

        WinSetWindowPos(p->hwndToolbar,
                    HWND_TOP,
                    0,
                    0,
                    TOOLBARWIDTH,
                    SHORT2FROMMP(mp2),
                    SWP_SIZE | SWP_MOVE);
         return (MRESULT)0;
     break;

     case WM_CONTROL:
        switch (SHORT2FROMMP(mp1)) {
            case VN_ENTER:
                mrTemp = WinSendMsg(p->hwndToolbar, VM_QUERYSELECTEDITEM, 0, 0);
                switch(SHORT1FROMMR(mrTemp)) {
                    case 1:     /* Zoom In */
                        return WinSendMsg(p->hwndChart, UM_ZOOM, 0, 0);
                        break;
                    case 2:
                        return WinSendMsg(p->hwndChart, UM_MOOZ, 0, 0);
                        break;
                    default:
                        return (MRESULT) 0;
                        break;
                }
            default:
                return (MRESULT) 0;
                break;
        }
        return (MRESULT) 0;
        break;

      case WM_COMMAND:
         switch(SHORT1FROMMP(mp1)) {
            case IDM_NEW: break;
            case IDM_OPEN: break;
            case IDM_FILE: break;
            case IDM_EXIT:
               if(WinMessageBox(HWND_DESKTOP,
                              HWND_DESKTOP,
                              "Do you want to exit?",
                              PROGNAME,
                              1,
                              MB_ICONQUESTION | MB_YESNO) == MBID_YES)
                  WinPostMsg(hwnd, WM_QUIT, 0, 0);
               break;

            case IDM_HABOUT:
                WinMessageBox(HWND_DESKTOP,
                                HWND_DESKTOP,
                                VERNUM,
                                PROGNAME,
                                1,
                                MB_INFORMATION | MB_CANCEL);
                break;

            case MID_TB_1:
                return WinSendMsg(p->hwndChart, UM_ZOOM, 0, 0);
                break;

            case MID_TB_2:
                return WinSendMsg(p->hwndChart, UM_MOOZ, 0, 0);
                break;

            case MID_TB_3:
                return WinSendMsg(p->hwndChart, WM_VSCROLL, 0, MPFROM2SHORT(0, SB_LINEUP));
                break;

            default:
                return (MRESULT) FALSE;
                break;
      }
      break;    /* End of WM_COMMAND processing */

    case WM_DESTROY:
        free(p);
        return (MRESULT)0;
        break;

    default:
        return WinDefWindowProc(hwnd, msg, mp1, mp2);
        break;
    }
    return (MRESULT) FALSE;
}

#include "oz.h"

static MATRIXLF matlf = {MAKEFIXED(1,0), MAKEFIXED(0,0), 0L,
                         MAKEFIXED(0,0), MAKEFIXED(1,0), 0L,
                         0L, 0L, 1L};
static FIXED scaleupfactor[] = {MAKEFIXED(1,6554), MAKEFIXED(1,6554)};
static FIXED scaledownfactor[] = {MAKEFIXED(0,58982), MAKEFIXED(0,58982)};

static POINTL slidedownfactor = {0,-10};
static POINTL slideupfactor = {0,10};
static POINTL slideleftfactor = {10,0};
static POINTL sliderightfactor = {-10,0};

static POINTL YSSY = {15116, -3393};
static POINTL YMML = {14485, -3767};
static POINTL YPPH = {11597, -3193};


MRESULT EXPENTRY ChartWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

    HAB hab;
    static HPS hps;
    static HDC hdc;

    static RECTL australia_recl;
    static RECTL recl;
    static POINTL name_location;
    static POINTL ptlCenter;
    static SIZEL australia_sizl;
    ULONG australia_element_count = sizeof(australia) / sizeof(POINTL);
    PSZ ptd = "Australia";
    HBITMAP hbmApt;
    MARKERBUNDLE mb;
    BOOL fSuccess;
    ERRORID eid;
    int i;
    HWND hwndHScroll, hwndVScroll;

    hab = WinQueryAnchorBlock(hwnd);
 
    switch(msg) {

        case WM_CREATE:

            australia_recl.xLeft = australia[0].x;
            australia_recl.xRight = australia[0].x;
            australia_recl.yBottom = australia[0].y;
            australia_recl.yTop = australia[0].y;
            for(i=0;i<australia_element_count;i++) {
                if(australia[i].x < australia_recl.xLeft)
                     australia_recl.xLeft = australia[i].x;

                if(australia[i].x > australia_recl.xRight)
                     australia_recl.xRight = australia[i].x;

                if(australia[i].y < australia_recl.yBottom)
                     australia_recl.yBottom = australia[i].y;

                if(australia[i].y > australia_recl.yTop)
                     australia_recl.yTop = australia[i].y;
            }

            matlf.lM31 = -australia_recl.xLeft;
            matlf.lM32 = -australia_recl.yBottom;

            australia_sizl.cx = australia_recl.xRight - australia_recl.xLeft;
            australia_sizl.cy = australia_recl.yTop - australia_recl.yBottom;
            ptlCenter.x = australia_sizl.cx/2;
            ptlCenter.y = australia_sizl.cy/2;

            hwndVScroll = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT), ID_VERTSCROLL);
            pmassert(hab, hwndVScroll);
            WinSendMsg( hwndVScroll,
                        SBM_SETSCROLLBAR,
                        (MPARAM) (australia_recl.yBottom + ptlCenter.y),
                        MPFROM2SHORT(australia_recl.yBottom, australia_recl.yTop));

            hwndHScroll = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT), ID_HORZSCROLL);
            pmassert(hab, hwndHScroll);
            WinSendMsg( hwndHScroll,
                        SBM_SETSCROLLBAR,
                        (MPARAM) (-australia_recl.xLeft - ptlCenter.x),
                        MPFROM2SHORT(-australia_recl.xRight, -australia_recl.xLeft));

            name_location.x         = 13500;
            name_location.y         = -2900;

            /*
            *LAB**
            Open a window device context and create a presentation space
            with arbitrary presentation units, associated with that DC
            */



            pmassert(hab, hps);

            /* 
             *LAB*
             Set drawing mode to create all segments in retained mode 
             */


            mb.lColor = CLR_GREEN;
            GpiSetAttrs(hps, PRIM_MARKER, MBB_COLOR, 0L, &mb);

            /* Make chart segment */
            GpiOpenSegment(hps, ID_AUSTRALIA_SEG);
            GpiSetColor(hps, CLR_DARKBLUE);
            GpiBeginPath(hps, 1L);  /* Create a path */

            /*
             *LAB*
            Draw the outline of the chart, using GpiMove() and GpiPolyLine()
            to draw the contents of the chart array into the current path
            */



            GpiEndPath(hps);
            GpiStrokePath(hps, 1L, 0L);
            GpiCloseSegment(hps);

            /* Make name segment */
            GpiOpenSegment(hps, ID_NAME_SEG);
            GpiSetColor(hps, CLR_DARKBLUE);
            GpiMove(hps, &name_location);
            GpiCharStringAt(hps, &name_location, 11L, ptd);
            GpiCloseSegment(hps);

            /* Mark YSSY, YMML and YPPH in another segment*/

            GpiOpenSegment(hps, ID_APT_SEG);
            GpiMarker(hps, &YSSY);
            GpiMarker(hps, &YMML);
            GpiMarker(hps, &YPPH);
            GpiCloseSegment(hps);

            GpiSetDrawingMode(hps, DM_DRAW);

            /* transform picture view to origin */
            GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);

            return (MRESULT) FALSE;

        case WM_PAINT:
            hps = WinBeginPaint(hwnd, hps, &recl);
            WinFillRect(hps, &recl, CLR_PALEGRAY);
            fSuccess = GpiDrawChain(hps);
            pmassert(hab, fSuccess);
            WinEndPaint(hps);
            return (MRESULT) 0;
            break;

//        case WM_SIZE:
//            recl.xRight = SHORT1FROMMP(mp2);
//            recl.yTop = SHORT2FROMMP(mp2);
//            GpiSetPageViewport(hps, &recl);
//            return (MRESULT) 0;
//            break;

        case WM_VSCROLL:
            switch(SHORT2FROMMP(mp2)) {
                case SB_LINEUP:
                    fSuccess = GpiTranslate(hps, &matlf, TRANSFORM_ADD, &slidedownfactor);
                    pmassert(hab, fSuccess);
                    /* transform picture view to origin */
                    fSuccess = GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);
                    pmassert(hab, fSuccess);
                    WinInvalidateRect(hwnd, NULL, FALSE);
                    return (MRESULT) 0;
                    break;
                case SB_LINEDOWN:
                    fSuccess = GpiTranslate(hps, &matlf, TRANSFORM_ADD, &slideupfactor);
                    pmassert(hab, fSuccess);
                    /* transform picture view to origin */
                    fSuccess = GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);
                    pmassert(hab, fSuccess);
                    WinInvalidateRect(hwnd, NULL, FALSE);
                    return (MRESULT) 0;
                    break;
            }
            break;
        case WM_HSCROLL:
            switch(SHORT2FROMMP(mp2)) {
                case SB_LINELEFT:
                    fSuccess = GpiTranslate(hps, &matlf, TRANSFORM_ADD, &slideleftfactor);
                    pmassert(hab, fSuccess);
                    /* transform picture view to origin */
                    fSuccess = GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);
                    pmassert(hab, fSuccess);
                    WinInvalidateRect(hwnd, NULL, FALSE);
                    return (MRESULT) 0;
                    break;
                case SB_LINERIGHT:
                    fSuccess = GpiTranslate(hps, &matlf, TRANSFORM_ADD, &sliderightfactor);
                    pmassert(hab, fSuccess);
                    /* transform picture view to origin */
                    fSuccess = GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);
                    pmassert(hab, fSuccess);
                    WinInvalidateRect(hwnd, NULL, FALSE);
                    return (MRESULT) 0;
                    break;
            }
            break;

        case UM_ZOOM:
            fSuccess = GpiScale(hps, &matlf, TRANSFORM_ADD, &scaleupfactor[0], &ptlCenter);
            pmassert(hab, fSuccess);
            /* transform picture view to origin */
            fSuccess = GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);
            pmassert(hab, fSuccess);
            WinInvalidateRect(hwnd, NULL, FALSE);
            return (MRESULT) 0;
            break;

        case UM_MOOZ:
            GpiScale(hps, &matlf, TRANSFORM_ADD, &scaledownfactor[0], &ptlCenter);
            /* transform picture view to origin */
            GpiSetDefaultViewMatrix(hps, 8L, &matlf, TRANSFORM_REPLACE);
            WinInvalidateRect(hwnd, NULL, FALSE);
            return (MRESULT) 0;
            break;

        case WM_DESTROY:
            GpiDeleteSegments(hps, ID_AUSTRALIA_SEG, ID_NAME_SEG);
            GpiAssociate(hps, 0);
            GpiDestroyPS(hps);
            return (MRESULT) 0;
            break;

        default:
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
            break;
    }
    return (MRESULT) FALSE;
}

MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  PFNWP   pfnwpOldFrameProc ;

  /* Get original frame procedure */
  pfnwpOldFrameProc = (PFNWP) WinQueryWindowPtr(hwnd, 0);

  switch (msg) {
    case WM_QUERYFRAMECTLCOUNT :
         {
          USHORT   usItemCount ;

          /* *LAB* Get count of original frame controls */

          /* *LAB* Add 1 for new toolbar control and return that */

         }

    case WM_FORMATFRAME :
       {
         PSWP     pSWP ;               // pointer to array of frame ctl SWPs
         USHORT   usItemCount ;        // count of original frame controls
         USHORT   usNewMenuIndex ;     // index of new menu SWP
         USHORT   usToolBarIndex ;     // index of Tool Bar menu SWP
         USHORT   usClientIndex ;      // index of client window SWP
         USHORT   usVertScrollIndex ;  // index of vertical scrollbar SWP
         HWND     hwndVertScroll ;     // hwnd of vertical scrollbar

         /* Get a pointer to the SWP array */
         pSWP = PVOIDFROMMP(mp1);

           /* ---- run regular processing for original controls --- */
           /*
            *  Note that the original frame proc will setup all
            *  the SWP sturctures for the standard frame window
            *  controls starting at the beginning of the array.
            *  A count of how many SWP structures were initialized
            *  is returned.
            *  All SWP structures for new controls that are to be
            *  added ( in our case, 1 ) will be uninitialized and
            *  at the end of the array. The start of the uninitialied
            *  SWP structure start at an index equal to the returned
            *  count.
            */
         usItemCount = SHORT1FROMMR(pfnwpOldFrameProc(hwnd, msg, mp1, mp2));

            /* ------------- locate SWP for 1st menu  ---------- */
            /*
             *  We will use the settings of the 1st menu to help initialize
             *  the SWP for the second menu. We look for the proper SWP
             *  by scanning the array for the matching hwnd.
             */
         for (usToolBarIndex = 0;usToolBarIndex < usItemCount; usToolBarIndex++)
            if (pSWP[usToolBarIndex].hwnd == hwndToolBar)
               break;

            /* ------------- locate SWP for client window  ---------- */
            /*
             *  We will need to adjust the vertical height of the client
             *  window to make room for the second menu. We look for the
             *  proper SWP by scanning the array for a matching hwnd.
             */
         for(usClientIndex = 0; usClientIndex < usItemCount; usClientIndex++)
            if (pSWP[usClientIndex].hwnd == hwndClient )
               break;

            /* --- locate SWP for vert scroll (if exists) --- */
            /*
             *  First we will check if this window has a vert. scroll bar.
             *  We will need to adjust the vertical height of the scroll
             *  bar to make room for the second menu. We look for the
             *  proper SWP by scanning the array for a matching hwnd.
             */

         if((hwndVertScroll = WinWindowFromID(hwnd, FID_VERTSCROLL)) != NULLHANDLE)
            for(usVertScrollIndex = 0; usVertScrollIndex < usItemCount; usVertScrollIndex++)
               if(pSWP[usVertScrollIndex].hwnd == hwndVertScroll )
                  break;

         /* The new SWP starts after standard control SWPs */
         usNewMenuIndex = usItemCount ;

         /* Get size values for 2nd menu bar */
         pSWP[ usNewMenuIndex ].fl = SWP_SIZE;
         pSWP[ usNewMenuIndex ].cx =  pSWP[usToolBarIndex].cx ;  // set some
         pSWP[ usNewMenuIndex ].cy =  pSWP[usToolBarIndex].cy ;  // defaults
         pSWP[ usNewMenuIndex ].hwndInsertBehind = HWND_TOP ;
         pSWP[ usNewMenuIndex ].hwnd = hwndMenuBar ;

         /* Get the menu code to make the actual size adjustments */
         WinSendMsg( hwndMenuBar,
                     WM_ADJUSTWINDOWPOS,
                     MPFROMP( pSWP+usNewMenuIndex ),
                     (MPARAM) 0L );

         /* Position menu directly below other menu */
         pSWP[usNewMenuIndex].x = pSWP[usToolBarIndex].x ;
         pSWP[usNewMenuIndex].y = pSWP[usToolBarIndex].y -
                                               pSWP[usNewMenuIndex].cy ;
         pSWP[usNewMenuIndex].fl = pSWP[usToolBarIndex].fl ;

         /* Adjust client window size for 2nd menu */
         pSWP[usClientIndex].cy -= pSWP[usNewMenuIndex].cy ;

         /* Adjust vertical scroll size for 2nd menu */
         if ( hwndVertScroll != NULLHANDLE )
             pSWP[usVertScrollIndex].cy -= pSWP[usNewMenuIndex].cy ;

         /* Return total count of controls ( +1 for 2nd menu ) */
         return MRFROMSHORT(++usItemCount);
       }
       break;

    default:
      return pfnwpOldFrameProc(hwnd,msg,mp1,mp2);

  } /* end of switch () */

  return (MRESULT)FALSE;

}

