#define INCL_GPI
#define INCL_WIN

#include <os2.h>

#include "..\pmassert\pmassert.h"

#define WC_GRAFTEST "WCGraphicsTest"

MRESULT EXPENTRY wpGraphics(HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2);
void star5(HPS hps);

HAB hab;
QMSG qmsg;
HMQ hmq;

main(int argc, char *argv[], char *envp[])
{
    HWND hwndFrame, hwndClient;
    ULONG flStyle = FCF_STANDARD & ~FCF_MENU & ~FCF_ACCELTABLE & ~FCF_ICON;

    hab = WinInitialize(0);

    hmq = WinCreateMsgQueue(hab, 0L);

    if(!WinRegisterClass(hab,
                        WC_GRAFTEST,
                        wpGraphics,
                        CS_SIZEREDRAW,
                        0L))
    {
        WinAlarm(HWND_DESKTOP,WA_ERROR);
        DosExit(EXIT_PROCESS, 1);
    }
    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
        WS_VISIBLE,             /* frame-window style            */
        &flStyle,               /* window style                  */
        WC_GRAFTEST,            /* class name                    */
        "Graphics Test",        /* window title                  */
        WS_VISIBLE,             /* default client style          */
        NULLHANDLE,             /* resource in executable file   */
        0L,                     /* resource id                   */
        &hwndClient);           /* receives client window handle */
 
    pmassert(hab, hwndFrame);

    while (WinGetMsg(hab, &qmsg, 0L, 0, 0))
        WinDispatchMsg(hab, &qmsg);

    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}

MRESULT EXPENTRY wpGraphics(HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2)
{
   HPS hps;

   switch (ulMsg) {
   case WM_ERASEBACKGROUND:
      return (MRESULT) TRUE;
      break;
   case WM_PAINT:
      hps = WinBeginPaint(hwnd, 0L, NULL);
      star5(hps);
      WinEndPaint(hps);
      break;
   case WM_CLOSE: WinPostMsg(hwnd, WM_QUIT, 0, 0);
      break;
   default: 
      return WinDefWindowProc(hwnd, ulMsg, mp1, mp2);
      break;
   } /* endswitch */
}

void star5(HPS hps)
{
    POINTL aptl[5];

    /* Initialize thhe array of points for the 5-pointed star */
    aptl[0].x = 400; aptl[0].y = 195;
    aptl[1].x = 40;  aptl[1].y = 320;
    aptl[2].x = 260; aptl[2].y = 10;
    aptl[3].x = 260; aptl[3].y = 390;
    aptl[4].x = 37;  aptl[4].y = 82;

    GpiSetPattern(hps, PATSYM_HALFTONE);

    /* Draw the star */
    GpiBeginArea(hps, BA_WINDING);
    GpiMove(hps, &aptl[4]);     /* First and last point of star */
    GpiPolyLine(hps, 5L, aptl);
    GpiEndArea(hps);
}
