/***************************************************************************
*   Lab 13                                                                 *
***************************************************************************/
#define  INCL_PM                               // Include PM info
#include <os2.h>                               // Include OS2H

#include <string.h>                            // Include C string functions
#include <malloc.h>                            // Include C memory functions

#include "lab13.h"                             // Include local header file

void SetFont(HWND hwndMLE);
void ConvertVectorFontSize(FIXED fxPointSize, PFATTRS pfattrs);

void main(int argc, char **argv)               // Thread 1 entry point
{
    HAB      hab;                              // Thread 1 PM ID
    QMSG     qmsg;                             // Queue message temp storage
    HMQ      hmq;                              // Handle to thread 1 Msg q
    HWND     hwndFrame, hwndClient;            // Main window handles
    RECTL    rctlDesk;                         // Storage for desktop size
    BOOL     rc;                               // Return code storage
    ULONG    flCreateFlags;

    hab = WinInitialize( 0 );
    hmq = WinCreateMsgQueue( hab, 0 );
    if(!WinRegisterClass( (HAB)hab,            // Register a private class
                          (PSZ)"WC_SIMEDIT",   //   called WC_SIMEDIT for the
                          (PFNWP)wpSimEdit,      //   client window
                          0L,
                          4)) {                // Storage for a pointer
        WinMessageBox( HWND_DESKTOP, 
                        0L, 
                        "Unable to register a class",
                        "WinRegisterClass...", 
                        1, 
                        MB_OK );
        WinDestroyMsgQueue( hmq );
        WinTerminate( hab );
        DosExit( EXIT_PROCESS, 1 );
    }

    flCreateFlags = FCF_STANDARD & ~FCF_SHELLPOSITION;

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &flCreateFlags,
                                "WC_SIMEDIT",
                                (PSZ)NULL,
                                0,                  // Client NOT visible
                                (HMODULE)0,
                                ID_MAIN,
                                &hwndClient);

    WinSetWindowText( hwndFrame, APP_TITLE );       // Init titlebar text

    WinQueryWindowRect( HWND_DESKTOP, &rctlDesk);   // Query screen size
    WinSetWindowPos((HWND)hwndFrame,                // Reposition frame
                    (HWND)HWND_TOP,                 // On top of siblings
                    (SHORT)rctlDesk.xRight/8,       // a short distance from left
                    (SHORT)rctlDesk.yTop/8,         // and from the bottom
                    (SHORT)rctlDesk.xRight/1.34,    // 3/4 size of desktop
                    (SHORT)rctlDesk.yTop/1.34,      // centered in screen
                    SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ACTIVATE | SWP_ZORDER);

    while( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
        WinDispatchMsg( hab, (PQMSG)&qmsg );        

    WinDestroyWindow( hwndFrame );
    WinDestroyMsgQueue( hmq );
    WinTerminate( hab );
}

MRESULT EXPENTRY wpSimEdit(HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2)
{
    switch(ulMsg) {
        case WM_CREATE: {                       // Window being created?
            HWND hMLE;                          // Create the editing child

            CHAR *datbuf = (PCHAR)malloc(32768 * sizeof( CHAR )); // Buffer

            hMLE = WinCreateWindow( hwnd,       // MLE is child of client
                                 WC_MLE,        // Class is MLE
                                 (PSZ)NULL,     // No window text
                                 WS_VISIBLE   | // Visible
                                 MLS_HSCROLL  | // Horizontal scrollbar
                                 MLS_VSCROLL,   // Vertical scrollbar
                                 0,0,0,0,       // No initial size/pos
                                 hwnd,          // Client is owner
                                 HWND_TOP,      // On top of siblings
                                 ID_MLE,        // Window ID
                                 NULL,          // No control data
                                 (PVOID)NULL ); // No pres parameters
            WinSetWindowPtr( hwnd, 0, (PVOID)datbuf );          // Store buffer pointer
            WinSendMsg( hMLE, MLM_SETIMPORTEXPORT,              // Set import/export buffer
                     MPFROMP( datbuf ), MPFROMSHORT(32768));    // and size
            WinSendMsg( hMLE, MLM_FORMAT,        // Set format to NO_TRANS
                     MPFROMSHORT( MLFIE_CFTEXT ), (MPARAM)0L );
        }
        break;

        case WM_SIZE: {                          // Client being sized?

            USHORT cxNew, cyNew;                 // Storage for new dimensions

            cxNew = SHORT1FROMMP(mp2);           // Extract width from ulMsg
            cyNew = SHORT2FROMMP(mp2);           // Extract height from ulMsg

            WinSetWindowPos( WinWindowFromID( hwnd, ID_MLE ), // Set size/pos of
                          (HWND)HWND_TOP,        // MLE
                          0,0,
                          cxNew,                 // Same as Client
                          cyNew,                 // Same as Client
                          SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER);

            WinSetFocus( HWND_DESKTOP, WinWindowFromID( hwnd, ID_MLE ));
        }
        break;

        case WM_COMMAND: {

            switch(SHORT1FROMMP(mp1)) {
                case MNF_NEW: {
                    LONG lTxtCount;
                    HWND hMLE = WinWindowFromID( hwnd, ID_MLE );

                    lTxtCount = (LONG)WinSendMsg( hMLE,
                                             MLM_QUERYTEXTLENGTH,
                                             (MPARAM)0L,
                                             (MPARAM)0L );
                    if( lTxtCount > 0 )
                        WinSendMsg( hMLE, MLM_DELETE, MPFROMLONG( 0L ), MPFROMLONG( lTxtCount ) );
                    WinSetWindowText( WinQueryWindow( hwnd, QW_PARENT ), "New File" );
                    }
                break;

                case MNF_OPEN: {
                    PFILEDLG pfildlg;
                    TID      ThreadID;
                    PPARMARG parmarg;

                    pfildlg = (PFILEDLG)malloc(sizeof(FILEDLG) );
                    parmarg = (PPARMARG)malloc(sizeof(PARMARG) );

                    memset(pfildlg, 0, sizeof(FILEDLG));
                    pfildlg->cbSize          = sizeof( FILEDLG );
                    pfildlg->fl              = FDS_CENTER | FDS_OPEN_DIALOG;
                    pfildlg->pszTitle        = "Open...";    /* Dialog title string  */

                    WinFileDlg( HWND_DESKTOP, hwnd, pfildlg );
                    if(pfildlg->lReturn == DID_OK ) {
                        parmarg->datbuf   = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                        strcpy(parmarg->filename, pfildlg->szFullFile);
                        parmarg->hwndSend = hwnd;
                        parmarg->usOpt    = T2READ;
                        ThreadID = (TID)_beginthread( FileThread, (PVOID)NULL, 8192, parmarg );

                        WinSetWindowText(WinQueryWindow(hwnd, QW_PARENT), parmarg->filename );
                    }
                    free(pfildlg);
                }
                break;
                case MNF_SAVE:
                case MNF_SAVEAS:
                {
                    CHAR *chTitString;
                    PFILEDLG pfildlg;
                    TID     ThreadID;
                    PARMARG *parmarg;
                    HWND    hMLE = WinWindowFromID( hwnd, ID_MLE );
                    ULONG   ulOff = 0;
                    ULONG   ulCopy;

                    pfildlg  = (PFILEDLG)malloc(sizeof(FILEDLG) );
                    parmarg = (PPARMARG)malloc(sizeof(PARMARG) );

                    chTitString = (PCHAR)malloc( CCHMAXPATH * sizeof( CHAR ) );
                    WinQueryWindowText( WinQueryWindow( hwnd, QW_PARENT ),
                                   CCHMAXPATH,
                                   chTitString );
                    if((!(strcmp( chTitString, "New File" ))) || (SHORT1FROMMP(mp1) == MNF_SAVEAS )) {
                        memset(pfildlg, 0, sizeof(FILEDLG));
                        pfildlg->cbSize          = sizeof( FILEDLG );
                        pfildlg->fl              = FDS_CENTER | FDS_SAVEAS_DIALOG;
                        pfildlg->pszTitle        = "Save...";               /* Dialog title string  */

                        WinFileDlg( HWND_DESKTOP, hwnd, pfildlg );
                        if(pfildlg->lReturn == DID_OK) {
                            strcpy(parmarg->filename, pfildlg->szFullFile);
                            WinSendMsg( hMLE, MLM_SETIMPORTEXPORT,
                                 MPFROMP( parmarg->datbuf ), MPFROMLONG(parmarg->ulSize) );
                            WinSendMsg( hMLE, MLM_EXPORT, MPFROMP( &ulOff ), MPFROMP( &ulCopy ));
                            parmarg->datbuf   = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                            parmarg->hwndSend = hwnd;
                            parmarg->usOpt    = T2WRITE;
                            parmarg->ulSize   = (ULONG)WinSendMsg( hMLE,
                                                            MLM_QUERYTEXTLENGTH,
                                                            (MPARAM)0L, (MPARAM)0L );
                            ThreadID = (TID)_beginthread(FileThread, (PVOID)NULL, 8192, parmarg );
                            ulCopy = parmarg->ulSize;
                            WinSetWindowText( WinQueryWindow( hwnd, QW_PARENT ), parmarg->filename );
                        }
                    }
                    else {
                        strcpy( parmarg->filename, chTitString );
                        parmarg->hwndSend = hwnd;
                        parmarg->usOpt    = T2WRITE;
                        parmarg->ulSize   = (ULONG)WinSendMsg( hMLE,
                                                         MLM_QUERYTEXTLENGTH,
                                                         (MPARAM)0L, (MPARAM)0L );
                        parmarg->datbuf   = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                        ulCopy = parmarg->ulSize;
                        WinSendMsg( hMLE, MLM_SETIMPORTEXPORT,
                              MPFROMP( parmarg->datbuf ), MPFROMLONG(parmarg->ulSize) );
                        WinSendMsg( hMLE, MLM_EXPORT, MPFROMP( &ulOff ), MPFROMP( &ulCopy ));
                        ThreadID = (TID)_beginthread( FileThread, (PVOID)NULL, 8192, parmarg );
                    }
                    free(pfildlg);
                }
                break;
                case MNF_EXIT:
                    WinPostMsg( hwnd, WM_CLOSE, (MPARAM)0L, (MPARAM)0L );
                    break;
                case MNE_CUT:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                          MLM_CUT, (MPARAM)0L, (MPARAM)0L );
                    break;
                case MNE_COPY:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                          MLM_COPY, (MPARAM)0L, (MPARAM)0L );
                    break;
                case MNE_PASTE:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                          MLM_PASTE, (MPARAM)0L, (MPARAM)0L );
                    break;
                case MNE_CLEAR:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                          MLM_CLEAR, (MPARAM)0L, (MPARAM)0L );
                    break;
                case MNE_DELETE:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                          MLM_DELETE, (MPARAM)-1L, (MPARAM)0L );
                    break;
                case MNOF_BLACK:
                case MNOF_WHITE:
                case MNOF_BLUE:
                case MNOF_RED:
                case MNOF_GREEN:
                case MNOF_CYAN:
                case MNOF_PINK:
                case MNOF_BROWN:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ), 
                                MLM_SETTEXTCOLOR, 
                                MPFROMLONG( 100-SHORT1FROMMP(mp1) ),
                                (MPARAM)0L);
                    break;
                case MNOB_BLACK:
                case MNOB_WHITE:
                case MNOB_BLUE:
                case MNOB_RED:
                case MNOB_GREEN:
                case MNOB_CYAN:
                case MNOB_PINK:
                case MNOB_BROWN:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ), 
                                MLM_SETBACKCOLOR, 
                                MPFROMLONG( 200-SHORT1FROMMP(mp1) ), 
                                (MPARAM)0L);
                    break;

                case MNO_FONTS:
                    SetFont(WinWindowFromID(hwnd, ID_MLE));
                    break;

                case MNO_WORDWRAP: {

                    BOOL Checked;
                    Checked = WinIsMenuItemChecked(WinWindowFromID( WinQueryWindow( hwnd, QW_PARENT ), FID_MENU ), MNO_WORDWRAP);
                    Checked = !Checked;
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                             MLM_SETWRAP,
                             (MPARAM)Checked, (MPARAM)0L );
                    WinCheckMenuItem(WinWindowFromID( WinQueryWindow( hwnd, QW_PARENT ), FID_MENU ), MNO_WORDWRAP,  Checked);
                    }
                    break;
                default:
                    break;
            }
        }
        break;

        case WM_ERASEBACKGROUND:
            return (MRESULT)TRUE;
            break;

        case UM_FILE_DEAD: {  // File-handling thread has finished
                            // mp1 = char count, mp2 = read/write option
            ULONG ulOff = 0;
            ULONG ulCount = LONGFROMMP( mp1 );

            if( SHORT1FROMMP( mp2 ) == T2READ ) {
                CHAR *datbuf;
                LONG lTxtCount;
                HWND hMLE = WinWindowFromID( hwnd, ID_MLE );

                lTxtCount = (LONG)WinSendMsg( hMLE,
                                          MLM_QUERYTEXTLENGTH,
                                          (MPARAM)0L,
                                          (MPARAM)0L );
                if( lTxtCount > 0 )
                    WinSendMsg( hMLE, MLM_DELETE, MPFROMLONG( 0L ), MPFROMLONG( lTxtCount ) );
                datbuf = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                WinSendMsg( WinWindowFromID( hwnd, ID_MLE) , MLM_SETIMPORTEXPORT,
                        MPFROMP( datbuf ), mp1 );
                WinSendMsg( WinWindowFromID( hwnd, ID_MLE) , MLM_IMPORT, &ulOff, &ulCount );
            }
        }
        break;

        case WM_CLOSE:
            if( WinMessageBox( HWND_DESKTOP, 0L, "Do you really want to Exit?",
                           APP_TITLE, (USHORT)1, MB_YESNO | MB_MOVEABLE ) == MBID_YES)
            {
                free ( WinQueryWindowPtr( hwnd, 0 ) );
                WinPostMsg( hwnd, WM_QUIT, (MPARAM)0L, (MPARAM)0L );
            }
            break;

        default:
            return WinDefWindowProc( hwnd, ulMsg, mp1, mp2 );
            break;
    }
    return (MRESULT)FALSE;
}

VOID SetFont(HWND hwndMLE)
{
    FONTDLG fontDlg;
    HPS hps;
    FONTMETRICS fontMetrics;
    CHAR szFamily[CCHMAXPATH];
    static fxPointSize = 0;            /* keep track of this for vector fonts */

    /*
     * Get the current font attributes
    */
    hps = WinGetPS(hwndMLE);

    /* *LAB* Query the MLE to get the current font (MLM_QUERYFONT) */
    WinSendMsg(hwndMLE, MLM_QUERYFONT,
        MPFROMP((PFATTRS)&(fontDlg.fAttrs)), NULL);

    /* *LAB* create current default font, using GpiCreateLogFont with local */
    /* identifier 1 */
    GpiCreateLogFont(
        hps,
        (PSTR8)fontDlg.fAttrs.szFacename,
        1,
        &(fontDlg.fAttrs));

    /* *LAB* Now set the current character attribute to that font */
    GpiSetCharSet(hps, 1);

    /* *LAB* Fill the fontMetrics structure */
    GpiQueryFontMetrics(hps, sizeof(FONTMETRICS), &fontMetrics);

    GpiSetCharSet(hps, LCID_DEFAULT);
    GpiDeleteSetId(hps, 1);
    WinReleasePS(hps);

    /*
     * Initialize the FONTDLG structure with the current font
     */
    memset(&fontDlg, 0, sizeof(fontDlg));            /* initialize all fields */
    fontDlg.cbSize     = sizeof(FONTDLG);                  /* sizeof(FONTDLG) */
    fontDlg.hpsScreen  = WinGetScreenPS(HWND_DESKTOP);  /* Screen presentation space */
    fontDlg.hpsPrinter = NULLHANDLE;            /* Printer presentation space */

    fontDlg.pszTitle      = "Font...";     /* Application supplied title      */
    fontDlg.pszPreview    = NULL;          /* String to print in preview wndw */
    fontDlg.pszPtSizeList = NULL;          /* Application provided size list  */
    fontDlg.pfnDlgProc    = NULL;          /* Dialog subclass procedure       */
    strcpy(szFamily, fontMetrics.szFamilyname); /* Family name of font        */
    fontDlg.pszFamilyname = szFamily;      /* point to Family name of font    */
    fontDlg.fxPointSize = fxPointSize;     /* Point size the user selected    */
    fontDlg.fl           = FNTS_CENTER |   /* FNTS_* flags - dialog styles    */
                           FNTS_INITFROMFATTRS;
    fontDlg.flFlags      = 0;              /* FNTF_* state flags              */
                                          /* Font type option bits           */
    fontDlg.flType       = (LONG) fontMetrics.fsType;
    fontDlg.flTypeMask   = 0;              /* Mask of which font types to use */
    fontDlg.flStyle      = 0;              /* The selected style bits         */
    fontDlg.flStyleMask  = 0;              /* Mask of which style bits to use */
    fontDlg.clrFore      = CLR_BLACK;      /* Selected foreground color       */
    fontDlg.clrBack      = CLR_WHITE;      /* Selected background color       */
    fontDlg.ulUser       = 0;              /* Blank field for application     */
    fontDlg.lReturn      = 0;              /* Return Value of the Dialog      */
    fontDlg.lSRC         = 0;              /* System return code.             */
    fontDlg.lEmHeight    = 0;              /* Em height of the current font   */
    fontDlg.lXHeight     = 0;              /* X height of the current font    */
    fontDlg.lExternalLeading = 0;          /* External Leading of font        */
    fontDlg.hMod = NULLHANDLE;             /* Module to load custom template  */
                                           /* Nominal Point Size of font      */
    fontDlg.sNominalPointSize = fontMetrics.sNominalPointSize;
    fontDlg.usWeight = fontMetrics.usWeightClass; /* The boldness of the font */
    fontDlg.usWidth = fontMetrics.usWidthClass;  /* The width of the font     */
    fontDlg.x            = 0;              /* X coordinate of the dialog      */
    fontDlg.y            = 0;              /* Y coordinate of the dialog      */
    fontDlg.usDlgId      = 0;       /* ID of a custom dialog template  */
    fontDlg.usFamilyBufLen = sizeof(szFamily); /*Length of family name buffer */

    /*
     *   Bring up the standard Font Dialog
     */

    if(WinFontDlg(HWND_DESKTOP, hwndMLE, &fontDlg) != DID_OK) {
        WinReleasePS(fontDlg.hpsScreen);
        return;
    }
    fxPointSize = fontDlg.fxPointSize;     /* save point size for next dialog */

    /*
     *   If outline font, calculate the maxbaselineext and
     *   avecharwidth for the point size selected
     */

    if ( fontDlg.fAttrs.fsFontUse == FATTR_FONTUSE_OUTLINE ) 
      ConvertVectorFontSize(fontDlg.fxPointSize, &fontDlg.fAttrs);

    WinReleasePS(fontDlg.hpsScreen);
    WinSendMsg(hwndMLE, MLM_SETFONT, MPFROMP(&(fontDlg.fAttrs)), NULL);
}

/*
 *   Convert vector font size using point size and fAttrs structure and
 *   return it in that structure.
 */

void ConvertVectorFontSize(FIXED fxPointSize, PFATTRS pfattrs)
{
    HPS   hps;
    HDC   hDC;
    LONG  lxFontResolution;
    LONG  lyFontResolution;
    SIZEF sizef;

    hps = WinGetScreenPS(HWND_DESKTOP);        /* Screen presentation space */

    /*
     *   Query device context for the screen and then query
     *   the resolution of the device for the device context.
     */

    hDC = GpiQueryDevice(hps);
    DevQueryCaps( hDC, CAPS_HORIZONTAL_FONT_RES, (LONG)1, &lxFontResolution);
    DevQueryCaps( hDC, CAPS_VERTICAL_FONT_RES, (LONG)1, &lyFontResolution);

    /*
     *   Calculate the size of the character box, based on the
     *   point size selected and the resolution of the device.
     *   The size parameters are of type FIXED, NOT int.
     *   NOTE: 1 point == 1/72 of an inch.
     */

    sizef.cx = (FIXED)(((fxPointSize) / 72 ) * lxFontResolution );
    sizef.cy = (FIXED)(((fxPointSize) / 72 ) * lyFontResolution );

    pfattrs->lMaxBaselineExt = MAKELONG( HIUSHORT( sizef.cy ), 0 );
    pfattrs->lAveCharWidth   = MAKELONG( HIUSHORT( sizef.cx ), 0 );
    WinReleasePS(hps);
}

