/* Polyfmt.cmd
Usage: OUT=polyfmt(P)
Returns a string OUT which displays the polynomial P in the form
  +|- a[N]*x^N +|- a[N-1]*x^(N-1) +|- ...  +|- a[1]*x +|- a[0]
where a[k]=abs(P[k])
*/
numeric digits 16
use arg p
count=p~degree+1
out=''
do i=1 to count
  out=out sfmt(p[i],count-i)
end
if out='' then return 0
else return out

sfmt: procedure   /* generates a term in the polynomial */
  parse arg x,n
  if abs(x)<1e-6 then return ''
  if x>=0 then out='+' fmt(x)
  else out='-' fmt(-x)
  select
    when n=0 then return out
    when n=1 then return out'*x'
    otherwise return out'*x^'n
  end

fmt: procedure   /* formats positive number */
  parse arg x
  r=5
  if x>=1e10 then return x/1
  x=((10**r*x+.5)%1)*10**-r
  ip=x%1
  fp=x//1
  return ip||substr(fp,2)
