#ifndef _STATLINE_HPP_
#define _STATLINE_HPP_

#include <iframe.hpp>           //Include IFrameWindow Class Header
#include <imenubar.hpp>
#include <istattxt.hpp>
#include <ipainhdr.hpp>
#include <ikeyhdr.hpp>
#include <ithread.hpp>
#include <icmdhdr.hpp>
#include <ifont.hpp>
#include <istring.hpp>

#include "editfile.hpp"
#include "procssta.hpp"
#include "usermsgh.hpp"

class AStatusLineSample : public IFrameWindow,
                          public IKeyboardHandler,
                          public ICommandHandler,
                          public AUserMessageHandler

{
  public:                               
    AStatusLineSample (unsigned long windowId);       // Constructor
    ~AStatusLineSample (void);                        // Destructor for this class

  protected:
    void setupVariables (void);                       // set up the variables
    void setupStatusLine (void);                      // set up the progress-indicating status line
    Boolean virtualKeyPress (IKeyboardEvent& event);  // handle virtual key press
    Boolean command(ICommandEvent &evt);              // command handling
    Boolean startOpenFile (void);                     // prepare to open a file
    void openFile (void);                             // read the file inside of a separate thread
    Boolean openFileReady (IEvent& evt);              // called when sub-thread has finished
    Boolean startSaveFile (void);                     // prepare to save a file
    void saveFile (void);                             // write the file inside of a separate thread
    Boolean saveFileReady (IEvent& evt);              // called when sub-thread has finished
    Boolean loadString (unsigned long ulStringId);    // load a string from the resource library

  private:
    IMenuBar * m_pMenuBar;                            // pointer to the menu bar
    IStaticText * m_pText;                            // text inside of the client area
    IThread * m_pFileThread;                          // the thread to read/write a file
    IString m_sFilename,                              // keeps the filename
            m_String;                                 // working string
    AEditFile * m_pEditFile;                          // the file
    AProcessStatus * m_pStatusLine;                   // the progress-indicating status line
    PROCESS_START_PARAMS m_startParams;               // parameters passed to the status line
};

#endif //_STATLINE_HPP_
