#include <stdlib.h>

#include "DupStream.h"

//#define BUFSIZ 512
#define BUFSIZ 1

DupInBuf::DupInBuf(streambuf *_in, streambuf *_out):in(_in),out(_out){
}
DupInBuf::~DupInBuf(){
  delete [] base ();
}

int DupInBuf::overflow(int c){
  int ret;

  if (pbase () == 0 && doallocate () == 0) return EOF;

  if(pbase()<pptr())
     ret=in->sputn(pbase(),pptr()-pbase());

  setp (pbase (), pbase () + BUFSIZ);

  if(c==EOF)
     ret=in->overflow();
  else
     ret=in->sputc(c);

return ret;
}
int DupInBuf::underflow(){
  if (gptr () < egptr ()) return *(unsigned char*)gptr ();

  if (base () == 0 && doallocate () == 0) return EOF;

  int   NumToRead;
  int   NRead;

  if(in->in_avail()==0)
     in->sgetc();

  NumToRead= BUFSIZ<in->in_avail() ? BUFSIZ: in->in_avail();

  NRead=in->sgetn(base(),NumToRead);
  out->sputn(base(),NRead);

  setg (eback(), base (), base () + NRead);
  if(NRead==0)
     return EOF;

return *(unsigned char*)gptr ();
}


int DupInBuf::doallocate(){
  if (!base ()) {
    char* buf = new char[2*BUFSIZ];
    setb (buf, buf+BUFSIZ, 0);
    setg (buf, buf, buf);

    buf += BUFSIZ;
    setp (buf, buf+BUFSIZ);
    return 1;
  }
  return 0;

}


iDupStream::iDupStream(istream &in, ostream &out):ios(new DupInBuf(in.rdbuf(),out.rdbuf())){
}

iDupStream::~iDupStream(){
  delete (DupInBuf*)(ios::rdbuf ());
}

