#include "DlgDemMain.h"
#include <ireslib.hpp>
#include "DlgDemRC.H"




MainWin::MainWin(unsigned long  windowID):
              IDialogWindow(windowID),
              ICommandHandler(){


   int i;

   //add a menu
   MainMenu=new IMenuBar(MainWinMenu,this);

   //set the icon for the window
   setIcon(IResourceId(1));

   //add to switch list
   addToWindowList();

   //register the command handler
   ICommandHandler::handleEventsFor(this);

   //set focus and display the window
   setFocus();
   show();
}


MainWin::~MainWin(){
   delete MainMenu;
}


Boolean MainWin::command(ICommandEvent & cmd){

   // check if the exit menu or exit button has been selected
   if(((cmd.source()==ICommandEvent::pushButton)||
      (cmd.source()==ICommandEvent::menu) )&&
      (cmd.commandId()==ButExit))
             // is so, quite
             close();
   else
      // if not, see which control caused the message and act properly
      switch(cmd.commandId()){
         default:
            break;
      }

//prevent the command event from reaching the Default Dialog Procedure
return true;
}



