#define INCL_WINDIALOGS
#define INCL_WININPUT
#define INCL_WINMESSAGEMGR
#define INCL_WINSTATICS
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
#include <viowin.h>
#include "cl.h"

#define DL_TOP                   0x0001
#define DL_BOTTOM                0x0002
#define DL_LEFT                  0x0004
#define DL_RIGHT                 0x0008
#define DL_HORIZONTAL            (DL_TOP|DL_BOTTOM)
#define DL_VERTICAL              (DL_LEFT|DL_RIGHT)

VOID paintText(HVWWND hwndWnd,ULONG ulStyle)
//-------------------------------------------------------------------------
// This function paints the text for the static control.  If DT_WORDBREAK
// is set in the style bits, word-wrapping is done here also.
//
// Input:  hwndWnd - window handle
//         ulStyle - window style
//-------------------------------------------------------------------------
{
   CHAR achText[256];
   RECTL rclWnd;
   SHORT sNumLines;
   SHORT sLine;
   ULONG ulFlags;
   SHORT sDrawn;
   SHORT sTotal;

   vwQueryWindowText(hwndWnd,sizeof(achText),achText);

   //----------------------------------------------------------------------
   // Calculate the size of our drawing area
   //----------------------------------------------------------------------
   vwQueryWindowRect(hwndWnd,&rclWnd);
   rclWnd.xRight--;
   rclWnd.yTop--;

   sNumLines=rclWnd.yTop-rclWnd.yBottom+1;
   sLine=0;

   vwFillRect(hwndWnd,&rclWnd,vwQueryBackColor(hwndWnd));

   //----------------------------------------------------------------------
   // Check our alignment flags
   //----------------------------------------------------------------------
   ulFlags=0;

   ulFlags|=(ulStyle & (DT_LEFT | DT_CENTER | DT_RIGHT));
   ulFlags|=(ulStyle & (DT_TOP | DT_VCENTER | DT_BOTTOM));

   //----------------------------------------------------------------------
   // Add the DT_WORDBREAK flag if it exists and only if DT_LEFT and
   // DT_TOP were specified
   //----------------------------------------------------------------------
   if (ulFlags==(DT_LEFT | DT_TOP)) {
      ulFlags|=(ulStyle & DT_WORDBREAK);
   } /* endif */

   vwQueryWindowRect(hwndWnd,&rclWnd);
   rclWnd.xRight--;
   rclWnd.yTop--;

   rclWnd.yTop-=sLine;
   rclWnd.yBottom=rclWnd.yTop-1;

   //----------------------------------------------------------------------
   // Draw the first line of text and keep track of how many characters
   // of the total were drawn.
   //----------------------------------------------------------------------
   sTotal=0;

   sDrawn=vwDrawText(hwndWnd,
                     -1,
                     achText,
                     &rclWnd,
                     vwQueryForeColor(hwndWnd),
                     vwQueryBackColor(hwndWnd),
                     ulFlags);
   sLine++;
   sTotal+=sDrawn;

   //----------------------------------------------------------------------
   // If DT_WORDBREAK, loop until we're done.
   //----------------------------------------------------------------------
   if (ulFlags & DT_WORDBREAK) {
      while ((sDrawn>0) && (sLine<sNumLines)) {
         vwQueryWindowRect(hwndWnd,&rclWnd);
         rclWnd.xRight--;
         rclWnd.yTop--;

         rclWnd.yTop-=sLine;
         rclWnd.yBottom=rclWnd.yTop-1;

         //----------------------------------------------------------------
         // Fine the beginning of the next word to be drawn on the new
         // line
         //----------------------------------------------------------------
         while ((achText[sTotal]!=0) && (isspace(achText[sTotal]))) {
            sTotal++;
         } /* endwhile */

         if (achText[sTotal]!=0) {
            sDrawn=vwDrawText(hwndWnd,
                              -1,
                              &achText[sTotal],
                              &rclWnd,
                              vwQueryForeColor(hwndWnd),
                              vwQueryBackColor(hwndWnd),
                              ulFlags);
            sLine++;
            sTotal+=sDrawn;
         } else {
            sDrawn=0;
         } /* endif */
      } /* endwhile */
   } /* endif */
}

VOID drawLine(HVWWND hwndWnd,PRECTL prclDraw,USHORT usType)
//-------------------------------------------------------------------------
// This function is used by the group box to draw the borders around the
// control.
//
// Input:  hwndWnd - window handle
//         prclDraw - points to the RECTL structure containing the drawing
//                    area
//         usType - DL_ constant specifying the type of line
//-------------------------------------------------------------------------
{
   ULONG ulFore;
   ULONG ulBack;
   CHAR achChar[2];
   ULONG ulIndex;
   RECTL rclChar;

   ulFore=vwQueryForeColor(hwndWnd);
   ulBack=vwQueryBackColor(hwndWnd);

   vwFillRect(hwndWnd,prclDraw,ulBack);

   if ((usType & DL_VERTICAL)!=0) {
      //-------------------------------------------------------------------
      // Vertical line
      //-------------------------------------------------------------------
      achChar[0]='';
      achChar[1]=0;

      for (ulIndex=prclDraw->yBottom; ulIndex<=prclDraw->yTop; ulIndex++) {
         rclChar=*prclDraw;
         rclChar.yBottom=ulIndex;
         rclChar.yTop=ulIndex;

         vwDrawText(hwndWnd,
                    1,
                    achChar,
                    &rclChar,
                    ulFore,
                    ulBack,
                    DT_LEFT | DT_TOP);
      } /* endfor */

      rclChar=*prclDraw;

      if (usType==DL_LEFT) {
         achChar[0]='';
      } else {
         achChar[0]='';
      } /* endif */

      rclChar.yBottom=prclDraw->yBottom;
      rclChar.yTop=rclChar.yBottom;

      vwDrawText(hwndWnd,
                 1,
                 achChar,
                 &rclChar,
                 ulFore,
                 ulBack,
                 DT_LEFT | DT_TOP);

      if (usType==DL_LEFT) {
         achChar[0]='';
      } else {
         achChar[0]='';
      } /* endif */

      rclChar.yBottom=prclDraw->yTop;
      rclChar.yTop=rclChar.yBottom;

      vwDrawText(hwndWnd,
                 1,
                 achChar,
                 &rclChar,
                 ulFore,
                 ulBack,
                 DT_LEFT | DT_TOP);
   } else {
      //-------------------------------------------------------------------
      // Horizontal line
      //-------------------------------------------------------------------
      achChar[0]='';
      achChar[1]=0;

      for (ulIndex=prclDraw->xLeft; ulIndex<=prclDraw->xRight; ulIndex++) {
         rclChar=*prclDraw;
         rclChar.xLeft=ulIndex;
         rclChar.xRight=ulIndex;

         vwDrawText(hwndWnd,
                    1,
                    achChar,
                    &rclChar,
                    ulFore,
                    ulBack,
                    DT_LEFT | DT_TOP);
      } /* endfor */

      rclChar=*prclDraw;

      if (usType==DL_TOP) {
         achChar[0]='';
      } else {
         achChar[0]='';
      } /* endif */

      rclChar.xLeft=prclDraw->xLeft;
      rclChar.xRight=rclChar.xLeft;

      vwDrawText(hwndWnd,
                 1,
                 achChar,
                 &rclChar,
                 ulFore,
                 ulBack,
                 DT_LEFT | DT_TOP);

      if (usType==DL_TOP) {
         achChar[0]='';
      } else {
         achChar[0]='';
      } /* endif */

      rclChar.xLeft=prclDraw->xRight;
      rclChar.xRight=rclChar.xLeft;

      vwDrawText(hwndWnd,
                 1,
                 achChar,
                 &rclChar,
                 ulFore,
                 ulBack,
                 DT_LEFT | DT_TOP);
   } /* endif */
}

VOID paintGroupbox(HVWWND hwndWnd,ULONG ulStyle)
//-------------------------------------------------------------------------
// This function paints the group box.
//
// Input:  hwndWnd - window handle
//         ulStyle - window style
//-------------------------------------------------------------------------
{
   CHAR achText[256];
   RECTL rclWnd;
   RECTL rclSide;
   CHAR achDraw[256];

   vwQueryWindowText(hwndWnd,sizeof(achText),achText);

   vwQueryWindowRect(hwndWnd,&rclWnd);
   rclWnd.xRight--;
   rclWnd.yTop--;

   //----------------------------------------------------------------------
   // Top side
   //----------------------------------------------------------------------
   rclSide.xLeft=rclWnd.xLeft;
   rclSide.yTop=rclWnd.yTop;
   rclSide.xRight=rclWnd.xRight;
   rclSide.yBottom=rclSide.yTop;

   drawLine(hwndWnd,&rclSide,DL_TOP);

   //----------------------------------------------------------------------
   // Bottom side
   //----------------------------------------------------------------------
   rclSide.xLeft=rclWnd.xLeft;
   rclSide.yTop=rclWnd.yBottom;
   rclSide.xRight=rclWnd.xRight;
   rclSide.yBottom=rclSide.yTop;

   drawLine(hwndWnd,&rclSide,DL_BOTTOM);

   //----------------------------------------------------------------------
   // Left side
   //----------------------------------------------------------------------
   rclSide.xLeft=rclWnd.xLeft;
   rclSide.yTop=rclWnd.yTop;
   rclSide.xRight=rclSide.xLeft;
   rclSide.yBottom=rclWnd.yBottom;

   drawLine(hwndWnd,&rclSide,DL_LEFT);

   //----------------------------------------------------------------------
   // Right side
   //----------------------------------------------------------------------
   rclSide.xLeft=rclWnd.xRight;
   rclSide.yTop=rclWnd.yTop;
   rclSide.xRight=rclSide.xLeft;
   rclSide.yBottom=rclWnd.yBottom;

   drawLine(hwndWnd,&rclSide,DL_RIGHT);

   //----------------------------------------------------------------------
   // Draw the text if it exists
   //----------------------------------------------------------------------
   if (achText[0]!=0) {
      if (rclWnd.xRight-rclWnd.xLeft-6>=0) {
         achText[(rclWnd.xRight-rclWnd.xLeft-6)]=0;
         sprintf(achDraw," %s ",achText);
      } else {
         achText[0]=0;
         achDraw[0]=0;
      } /* endif */

      rclSide.xLeft=rclWnd.xLeft;
      rclSide.yTop=rclWnd.yTop;
      rclSide.xRight=rclWnd.xRight;
      rclSide.yBottom=rclSide.yTop;

      vwDrawText(hwndWnd,
                 -1,
                 achDraw,
                 &rclSide,
                 vwQueryForeColor(hwndWnd),
                 vwQueryBackColor(hwndWnd),
                 DT_CENTER | DT_TOP);
   } /* endif */
}

MRESULT EXPENTRY VwStaticClassProc(HVWWND hwndWnd,
                                   ULONG ulMsg,
                                   MPARAM mpParm1,
                                   MPARAM mpParm2)
{
   switch (ulMsg) {
   case WM_PAINT:
      {
         ULONG ulStyle;

         ulStyle=vwQueryWindowULong(hwndWnd,QWL_STYLE);

         if ((ulStyle & SS_TEXT)!=0) {
            paintText(hwndWnd,ulStyle);
         } else
         if ((ulStyle & SS_GROUPBOX)!=0) {
            paintGroupbox(hwndWnd,ulStyle);
         } else {
            vwAlarm(WA_ERROR);
         } /* endif */
      }
      break;
   case WM_QUERYDLGCODE:
      return MRFROMLONG(DLGC_STATIC|DLGC_TABONCLICK);
   case WM_SETWINDOWPARAMS:
      {
         PWNDPARAMS pwpParms;
         MRESULT mrRc;

         pwpParms=(PWNDPARAMS)PVOIDFROMMP(mpParm1);

         mrRc=vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);

         if (pwpParms->fsStatus==WPM_TEXT) {
            vwSendMsg(hwndWnd,WM_PAINT,0,0);
         } /* endif */

         return mrRc;
      }
      break;
   default:
      return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMLONG(FALSE);
}
