//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#define INCL_DOSERRORS
#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_KBD
#define INCL_WINDIALOGS
#define INCL_WININPUT
#define INCL_WINWINDOWMGR
#include "vwdefs.h"
#include <string.h>

SHORT EXPENTRY _findWindowId(HVWWND hwndWnd,PUSHORT pusId)
//-------------------------------------------------------------------------
// This function compares the id of the specified window to see if it
// matches the specified id.  It is called by CmnLstSearchRecord().
//
// Input:  hwndWnd - window handle
//         pusId - points to the identifier to compare with
// Returns:  0 if match, non-0 otherwise
//-------------------------------------------------------------------------
{
   if (hwndWnd->usId==(*pusId)) {
      return 0;
   } else {
      return 1;
   } /* endif */
}

SHORT EXPENTRY _findClass(PVWCLASSINFO pciInfo,PCHAR pchClass)
//-------------------------------------------------------------------------
// This function compares the name of the specified class to see if it
// matches the specified name.  It is called by CmnLstSearchRecord().
//
// Input:  pciInfo - points to a VWCLASSINFO structure
//         pchClass - points to the class name to compare with
// Returns:  0 if match, non-0 otherwise
//-------------------------------------------------------------------------
{
   return (strcmp(pciInfo->achName,pchClass)!=0);
}

VOID dumpKeyData(struct _MONKEYPACKET *pmkpChar)
//-------------------------------------------------------------------------
// This function is used for debugging the keyboard monitor.
//-------------------------------------------------------------------------
{
   static BOOL bFirst=TRUE;
   FILE *pfFile;

   if (bFirst) {
      bFirst=FALSE;
      remove("DEBUG");
   } /* endif */

   pfFile=fopen("DEBUG","a");
   if (pfFile==NULL) {
      return;
   } /* endif */

   fprintf(pfFile,"chChar=0x%02X\n",pmkpChar->kkiKey.chChar);
   fprintf(pfFile,"chScan=0x%02X\n",pmkpChar->kkiKey.chScan);
   fprintf(pfFile,"fbStatus=0x%02X\n",pmkpChar->kkiKey.fbStatus);
   fprintf(pfFile,"bNlsShift=0x%02X\n",pmkpChar->kkiKey.bNlsShift);
   fprintf(pfFile,"fsState=0x%04X\n",pmkpChar->kkiKey.fsState);
   fprintf(pfFile,"usKbdDDFlags=0x%08lX\n\n",pmkpChar->usKbdDDFlags);
   fflush(pfFile);
   fclose(pfFile);
}

BOOL postKeyMsg(struct _MONKEYPACKET *pmkpChar)
//-------------------------------------------------------------------------
// This function is called by the keyboard monitor.  It converts the
// MONKEYPACKET structure to the WM_CHAR parameter format, and then
// posts the message to the window with the focus.
//
// Input:  pmkpChar - points to the _MONKEYPACKET structure containing
//                    the keyboard information as received by the keyboard
//                    monitor
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   BOOL bInit;
   USHORT usFlags;
   BYTE bRepeat;
   CHAR chScan;
   CHAR chChar1;
   CHAR chChar2;
   USHORT usVkey;
   USHORT usMods;
   BOOL bNeedPost;
   HVWWND hwndFocus;

   bInit=TRUE;
   usFlags=0;
   bRepeat=0;
   chScan=pmkpChar->kkiKey.chScan;
   chChar1=0;
   chChar2=0;
   usVkey=0;

   //----------------------------------------------------------------------
   // Set the WM_CHAR flags first
   //----------------------------------------------------------------------
   if ((pmkpChar->usKbdDDFlags & 0x0040)!=0) {
      usFlags|=KC_KEYUP;
   } /* endif */

   if ((pmkpChar->kkiKey.fsState & (KBDSTF_LEFTSHIFT | KBDSTF_RIGHTSHIFT))!=0) {
      usFlags|=KC_SHIFT;
   } /* endif */

   if ((pmkpChar->kkiKey.fsState & KBDSTF_CONTROL)!=0) {
      usFlags|=KC_CTRL;
   } /* endif */

   if ((pmkpChar->kkiKey.fsState & KBDSTF_ALT)!=0) {
      usFlags|=KC_ALT;
   } /* endif */

   //----------------------------------------------------------------------
   // If chChar==0 or chChar==0xE0, then we have an extended key code, i.e.
   // KC_VIRTUALKEY.  Check the scan code to determine what key was pressed.
   // THIS WILL CREATE PROBLEMS ON OTHER KEYBOARD LAYOUTS!!!  We need to
   // figure out a way around this (\OS2\KEYBOARD.DCP interpretation maybe?).
   //----------------------------------------------------------------------
   if (pmkpChar->kkiKey.chChar==0) {
      usFlags|=KC_VIRTUALKEY;

      switch (chScan) {
      case 0x0F:
         if ((usFlags & (KC_SHIFT | KC_CTRL | KC_ALT))==KC_SHIFT) {
            usVkey=VK_BACKTAB;
         } else {
            usVkey=VK_TAB;
         } /* endif */
         break;
      //-------------------------------------------------------------------
      // Since there are function keys F1-F12 and F13-F24, assign F1-F12 with
      // shift key to F13-F24, and all other F1-F12 to F1-F12.
      //-------------------------------------------------------------------
      case 0x3B:                 // Normal
      case 0x5E:                 // Control
      case 0x68:                 // Alt
         usVkey=VK_F1;
         break;
      case 0x3C:
      case 0x5F:
      case 0x69:
         usVkey=VK_F2;
         break;
      case 0x3D:
      case 0x60:
      case 0x6A:
         usVkey=VK_F3;
         break;
      case 0x3E:
      case 0x61:
      case 0x6B:
         usVkey=VK_F4;
         break;
      case 0x3F:
      case 0x62:
      case 0x6C:
         usVkey=VK_F5;
         break;
      case 0x40:
      case 0x63:
      case 0x6D:
         usVkey=VK_F6;
         break;
      case 0x41:
      case 0x64:
      case 0x6E:
         usVkey=VK_F7;
         break;
      case 0x42:
      case 0x65:
      case 0x6F:
         usVkey=VK_F8;
         break;
      case 0x43:
      case 0x66:
      case 0x70:
         usVkey=VK_F9;
         break;
      case 0x44:
      case 0x67:
      case 0x71:
         usVkey=VK_F10;
         break;
      case 0x45:
      case 0x89:
      case 0x8B:
         usVkey=VK_F11;
         break;
      case 0x46:
      case 0x8A:
      case 0x8C:
         usVkey=VK_F12;
         break;
      case 0x54:
         usVkey=VK_F13;
         break;
      case 0x55:
         usVkey=VK_F14;
         break;
      case 0x56:
         usVkey=VK_F15;
         break;
      case 0x57:
         usVkey=VK_F16;
         break;
      case 0x58:
         usVkey=VK_F17;
         break;
      case 0x59:
         usVkey=VK_F18;
         break;
      case 0x5A:
         usVkey=VK_F19;
         break;
      case 0x5B:
         usVkey=VK_F20;
         break;
      case 0x5C:
         usVkey=VK_F21;
         break;
      case 0x5D:
         usVkey=VK_F22;
         break;
      case 0x87:
         usVkey=VK_F23;
         break;
      case 0x88:
         usVkey=VK_F24;
         break;
      case 0x52:
         usVkey=VK_INSERT;
         break;
      case 0x47:
         usVkey=VK_HOME;
         break;
      case 0x49:
         usVkey=VK_PAGEUP;
         break;
      case 0x53:
         usVkey=VK_DELETE;
         break;
      case 0x4F:
         usVkey=VK_END;
         break;
      case 0x51:
         usVkey=VK_PAGEDOWN;
         break;
      case 0x4B:
         usVkey=VK_LEFT;
         break;
      case 0x48:
         usVkey=VK_UP;
         break;
      case 0x4D:
         usVkey=VK_RIGHT;
         break;
      case 0x50:
         usVkey=VK_DOWN;
         break;
      default:
         bInit=FALSE;
         break;
      } /* endswitch */
   } else
   if (pmkpChar->kkiKey.chChar==0xE0) {
      usFlags|=KC_VIRTUALKEY;

      switch (chScan) {
      case 0x52:
         usVkey=VK_INSERT;
         break;
      case 0x47:
         usVkey=VK_HOME;
         break;
      case 0x49:
         usVkey=VK_PAGEUP;
         break;
      case 0x53:
         usVkey=VK_DELETE;
         break;
      case 0x4F:
         usVkey=VK_END;
         break;
      case 0x51:
         usVkey=VK_PAGEDOWN;
         break;
      case 0x4B:
         usVkey=VK_LEFT;
         break;
      case 0x48:
         usVkey=VK_UP;
         break;
      case 0x4D:
         usVkey=VK_RIGHT;
         break;
      case 0x50:
         usVkey=VK_DOWN;
         break;
      default:
         bInit=FALSE;
         break;
      } /* endswitch */
   } else {
      //-------------------------------------------------------------------
      // Certain "non-extended" characters are still translated to
      // KC_VIRTUALKEY WM_CHAR messages.  Check for these cases and
      // act accordingly.
      //-------------------------------------------------------------------
      switch (pmkpChar->kkiKey.chChar) {
      case 0x08:
         usFlags|=KC_VIRTUALKEY;
         usVkey=VK_BACKSPACE;
         break;
      case 0x09:
         usFlags|=KC_VIRTUALKEY;
         usVkey=VK_TAB;
         break;
      case 0x0D:
         if (chScan==0x1C) {
            usFlags|=KC_VIRTUALKEY;
            usVkey=VK_NEWLINE;
         } else {
            usFlags|=KC_VIRTUALKEY;
            usVkey=VK_ENTER;
         } /* endif */
         break;
      case 0x1B:
         usFlags|=KC_VIRTUALKEY;
         usVkey=VK_ESC;
         break;
      case 0x20:
         usFlags|=KC_VIRTUALKEY;
         usVkey=VK_SPACE;
         break;
      default:
         usFlags|=KC_CHAR;
         chChar1=pmkpChar->kkiKey.chChar;
      } /* endswitch */
   } /* endif */

   if ((bInit) && (habAnchor->hwndFocus!=NULL)) {
      usMods=KC_CTRL | KC_ALT | KC_SHIFT;

      if ((usFlags & KC_VIRTUALKEY)!=KC_VIRTUALKEY) {
         if (vwIsWindowEnabled(habAnchor->hwndFocus)) {
            if (!vwPostMsg(habAnchor->hwndFocus,
                           WM_CHAR,
                           MPFROM2SHORT(usFlags,MAKEUSHORT(bRepeat,chScan)),
                           MPFROM2SHORT(MAKEUSHORT(chChar1,chChar2),usVkey))) {
               vwAlarm(WA_ERROR);
            } /* endif */
         } else {
            vwAlarm(WA_ERROR);
         } /* endif */

         return TRUE;
      } else
      if ((usFlags & KC_KEYUP)!=0) {
         if (vwIsWindowEnabled(habAnchor->hwndFocus)) {
            if (!vwPostMsg(habAnchor->hwndFocus,
                           WM_CHAR,
                           MPFROM2SHORT(usFlags,MAKEUSHORT(bRepeat,chScan)),
                           MPFROM2SHORT(MAKEUSHORT(chChar1,chChar2),usVkey))) {
               vwAlarm(WA_ERROR);
            } /* endif */
         } else {
            vwAlarm(WA_ERROR);
         } /* endif */

         return TRUE;
      } /* endif */

      bNeedPost=TRUE;

      switch (usFlags & usMods) {
      case 0:
         {
            ULONG ulDlgCode;

            if (usVkey==VK_TAB) {
               hwndFocus=habAnchor->hwndFocus;

               do {
                  hwndFocus=vwQueryWindow(hwndFocus,QW_NEXT);

                  if (hwndFocus==NULLHANDLE) {
                     hwndFocus=vwQueryWindow(habAnchor->hwndFocus,QW_TOP);
                  } /* endif */

                  ulDlgCode=LONGFROMMR(vwSendMsg(hwndFocus,
                                                 WM_QUERYDLGCODE,
                                                 0,
                                                 0));
               } while ((((ulDlgCode & DLGC_TABONCLICK)!=0) ||
                         (!vwIsWindowEnabled(hwndFocus))) &&
                        (hwndFocus!=habAnchor->hwndFocus)); /* enddo */

               if (hwndFocus!=habAnchor->hwndFocus) {
                  vwSetFocus(hwndFocus);
               } /* endif */

               bNeedPost=FALSE;
            } /* endif */
         }
         break;
      case KC_SHIFT:
         {
            ULONG ulDlgCode;

            if (usVkey==VK_BACKTAB) {
               hwndFocus=habAnchor->hwndFocus;

               do {
                  hwndFocus=vwQueryWindow(hwndFocus,QW_PREV);

                  if (hwndFocus==NULLHANDLE) {
                     hwndFocus=vwQueryWindow(habAnchor->hwndFocus,QW_BOTTOM);
                  } /* endif */

                  ulDlgCode=LONGFROMMR(vwSendMsg(hwndFocus,
                                                 WM_QUERYDLGCODE,
                                                 0,
                                                 0));
               } while ((((ulDlgCode & DLGC_TABONCLICK)!=0) ||
                         (!vwIsWindowEnabled(hwndFocus))) &&
                        (hwndFocus!=habAnchor->hwndFocus)); /* enddo */

               if (hwndFocus!=habAnchor->hwndFocus) {
                  vwSetFocus(hwndFocus);
               } /* endif */

               bNeedPost=FALSE;
            } /* endif */
         }
         break;
      default:
         break;
      } /* endswitch */

      if (bNeedPost) {
         if (vwIsWindowEnabled(habAnchor->hwndFocus)) {
            if (!vwPostMsg(habAnchor->hwndFocus,
                           WM_CHAR,
                           MPFROM2SHORT(usFlags,MAKEUSHORT(bRepeat,chScan)),
                           MPFROM2SHORT(MAKEUSHORT(chChar1,chChar2),usVkey))) {
               vwAlarm(WA_ERROR);
            } /* endif */
         } else {
            vwAlarm(WA_ERROR);
         } /* endif */
      } /* endif */
   } /* endif */

   return TRUE;
}

VOID _Optlink keyMonitor(PVOID pvDummy)
//-------------------------------------------------------------------------
// This function is the keyboard monitor installed by vwInitialize().  It
// attempts to install itself and sets a flag in habAnchor->ulStatus
// indicating success or failure.  If it succeeds, it loops reading
// characters from the keyboard and calling postKeyMsg() to convert to
// WM_CHAR message and post it.
//-------------------------------------------------------------------------
{
   USHORT usMonitor;
   USHORT usGlobalSel;
   USHORT usLocalSel;
   struct _GINFOSEG *pgisInfo;
   USHORT usSession;
   USHORT abMonIn[2];
   USHORT abMonOut[2];
   PBYTE pbMonData;
   struct _MONBUFF *pmbMonIn;
   struct _MONBUFF *pmbMonOut;
   USHORT usSzData;
   struct _MONKEYPACKET mkpChar;
   APIRET16 arRc;

   if (DosMonOpen("KBD$",&usMonitor)!=0) {
      habAnchor->ulStatus|=VW_HABST_MONINITBAD;
      return;
   } /* endif */

   //----------------------------------------------------------------------
   // DosMonReg() requires the session number.  Note the following
   // problem when using IPMD to debug:  PM (session 1) does not allow
   // monitors to be installed in its session.  When running from IPMD,
   // pgisInfo->sgCurrent always reports the current session as 1, instead
   // of the session of the program being debugged.  The result is that
   // the monitor fails to install, causing vmInitialize() to return FALSE.
   //
   // The way to get around this is to use the following procedure:
   //
   // 1)  Open a new full screen session
   // 2)  Run the program SESS.EXE, which prints the session number
   // 3)  Set a breakpoint on the line following the assignment to
   //     usSession.
   // 4)  Open a variable monitor and type in the session number of the
   //     full screen session opened in step 1
   // 5)  Continue running
   //
   // This forces you to input your keystrokes in the session opened in
   // step 1, but the results are still displayed in the debug full-screen
   // session.  I realize this is a pain, but it is the only way.
   //----------------------------------------------------------------------
   DosGetInfoSeg(&usGlobalSel,&usLocalSel);
   pgisInfo=(struct _GINFOSEG *)MAKEP(usGlobalSel,0);
   usSession=pgisInfo->sgCurrent;

   //----------------------------------------------------------------------
   // Query the size of the needed monitor buffers
   //----------------------------------------------------------------------
   abMonIn[0]=sizeof(abMonIn);
   abMonOut[0]=sizeof(abMonOut);

   if (DosMonReg(usMonitor,
                 (struct _MONBUFF *)abMonIn,
                 (struct _MONBUFF *)abMonOut,
                 MONITOR_BEGIN,
                 usSession)!=ERROR_MON_BUFFER_TOO_SMALL) {
      DosMonClose(usMonitor);
      habAnchor->ulStatus|=VW_HABST_MONINITBAD;
      return;
   } /* endif */

   //----------------------------------------------------------------------
   // Allocate memory for the total size and specify the OBJ_TILE
   // attribute to force this to be 64K segment aligned.  This results
   // in both pmbMonIn and pmbMonOut to be in the same 16-bit segment
   // which is a requirement of DosMonReg().
   //----------------------------------------------------------------------
   if (DosAllocMem((PPVOID)&pbMonData,
                   abMonIn[1]+abMonOut[1],
                   PAG_COMMIT|PAG_READ|PAG_WRITE|OBJ_TILE)!=0) {
      DosMonClose(usMonitor);
      habAnchor->ulStatus|=VW_HABST_MONINITBAD;
      return;
   } /* endif */

   pmbMonIn=(struct _MONBUFF *)pbMonData;
   pmbMonOut=(struct _MONBUFF *)(((PBYTE)pbMonData)+abMonIn[1]);

   pmbMonIn->cb=abMonIn[1];
   pmbMonOut->cb=abMonOut[1];

   if (DosMonReg(usMonitor,pmbMonIn,pmbMonOut,MONITOR_BEGIN,usSession)!=0) {
      DosMonClose(usMonitor);
      DosFreeMem(pbMonData);
      habAnchor->ulStatus|=VW_HABST_MONINITBAD;
      return;
   } /* endif */

   habAnchor->ulStatus|=VW_HABST_MONINITGOOD;

   //----------------------------------------------------------------------
   // Loop - read from the monitor and if not a "flush buffer" packet,
   // call postKeyMsg(), else pass the packet along the monitor chain.
   //----------------------------------------------------------------------
   while ((habAnchor->ulStatus & VW_HABST_MONSHOULDTERM)==0) {
      usSzData=sizeof(mkpChar);

      arRc=DosMonRead(pmbMonIn,DCWW_WAIT,&mkpChar,&usSzData);
      if (arRc==0) {
         if (mkpChar.uchFlags & 0x04) {
            DosMonWrite(pmbMonOut,&mkpChar,usSzData);
         } else {
            postKeyMsg(&mkpChar);
         } /* endif */
      } /* endif */
   } /* endwhile */

   DosMonClose(usMonitor);
   DosFreeMem(pbMonData);
   habAnchor->ulStatus|=VW_HABST_MONTERM;
}

VOID EXPENTRY paintWindow(HVWWND hwndWnd)
{
   vwSendMsg(hwndWnd,WM_PAINT,0,0);
}

VOID EXPENTRY destroyWindow(HVWWND hwndWnd)
{
   if ((vwQueryWindowUShort(hwndWnd,QWS_ID)==VWWID_DESKTOP) &&
       (CmnLstQueryRecordCount(habAnchor->hclWindows)>1)) {
      return;
   } /* endif */

   vwSendMsg(hwndWnd,WM_DESTROY,0,0);
   CmnLstDeleteRecord(habAnchor->hclWindows,hwndWnd);
}
