// ***********************************************************************
// BITMAP.HPP
// ***********************************************************************
//
// Written by Michael T. Duffy
//
// Base object for bitmap codecs
//
// ***********************************************************************

#ifndef BITMAP_HPP
#define BITMAP_HPP

// ***********************************************************************
//  Encoding constants
// ***********************************************************************

#define BMP_WORK_BUFFER_SIZE      30000
#define BMP_WORK_BUFF_INCREMENT    5000

// ***********************************************************************
//  Structures
// ***********************************************************************

typedef struct _BITMAPSTATS
  {
  SHORT            sWidth;
  SHORT            sHeight;
  BYTE             byBitDepth;
  } BITMAPSTATS;
typedef BITMAPSTATS *  PBITMAPSTATS;


// ***********************************************************************
//  Class Definition
// ***********************************************************************

class BitmapPainter
  {
  protected:
    USHORT         usLastErrorCode;
    ULONG          ulPainterType;
    BYTE           byWhite;
    BYTE           byBlack;
    BYTE           abyPalette [1024];
    PBYTE          pbySourceBuffer;
    ULONG          ulBufferSize;
    ULONG          ulBufferOffset;
    PCANVAS        pcnvDestCanvas;

    PBYTE          pbyEncodeBuffer;
    ULONG          ulEncBufferSize;
    ULONG          ulEncBufferOffset;

  public:

    // Constructor
    BitmapPainter (VOID);
    ~BitmapPainter (VOID);

    ERRORSTATUS AssociateCanvas
      (
      PCANVAS      pcnvCanvasIn
      );

    VOID DissociateCanvas
      (
      VOID
      );

    ERRORSTATUS InitializeEncodeBuffer
      (
      VOID
      );

    ERRORSTATUS AssureEncodeMemory
      (
      ULONG            ulAmount
      );

    ERRORSTATUS TrimEncodeBuffer
      (
      VOID
      );

    ERRORSTATUS FreeEncodeBuffer
      (
      VOID
      );

    // virtual functions

    virtual ERRORSTATUS PaintCanvas
      (
      VOID
      ) = 0;

    virtual ERRORSTATUS EncodeCanvas
      (
      PBYTE        pbyPalette,
      PBYTE *      ppbyBufferOut,
      PULONG       pulBufferSizeOut
      ) = 0;


    virtual ERRORSTATUS AssociateBuffer
      (
      PBYTE        pbyBufferIn,
      ULONG        ulBufferSizeIn
      );

    virtual VOID DissociateBuffer
      (
      VOID
      );

    virtual ERRORSTATUS QueryBitmapStats
      (
      PBITMAPSTATS     pbmsStatsOut
      ) = 0;


    // inline functions

    VOID MonoSetWhite
      (
      BYTE             byWhiteIn
      ) {byWhite = byWhiteIn;};

    VOID MonoSetBlack
      (
      BYTE             byBlackIn
      ) {byBlack = byBlackIn;};

    ULONG QueryType
      (
      VOID
      ) {return (ulPainterType);};

    VOID SetType
      (
      ULONG            ulType
      ) {ulPainterType = ulType;};

    PBYTE QueryPaletteBuffer
      (
      VOID
      ) {return (abyPalette);};

    USHORT QueryLastErrorCode
      (
      VOID
      ) {return (usLastErrorCode);};

  };



#endif // BITMAP_HPP

