/* BV PPP Door v1.0 */

ARG line

CALL AdeptLog Line, 3, '       ---==> BV PPP Door v1.0 <==---'
CALL AdeptLog Line, 3, '   Copyright: B.V. Compuworks Group 1997'
CALL AdeptLog Line, 3, '           WWW: BVCompuworks.com'
/* CALL AdeptPrint line, '        One of the Best PPP Doors for AdeptXBBS!\r\n'*/

IF line = 0 THEN
  DO
    CALL AdeptLog Line, 3, 'BV-PPP: NO LOCAL PPP SUPPORT!'
    Call ShowScreens
    EXIT 0
  END

/* CALL AdeptLog Line, 3, 'BV-PPP: Doing Config' */
IF line = 1 THEN
  CALL AdeptPrint line, '[40m[2J[0;1m             ---==> BV PPP Door v1.0 <==---\r\n'

/* ---- Begin Configuration ------------------------------------------------- */

/* BBS IP Address                  */  IP_Address     = '209.17.168.106'

/* Min Sec 1 Level to Access PPP   */  Min_Sec_Access = '20'

/* IP Addresses for Nodes          */  Node.1.IP      = '209.17.168.107'
/* ->A '' Means they can not use   */  Node.1.COM     = 'com2'
/*   PPP On this node!             */  Node.2.IP      = '209.17.168.108'
/* ->Make sure you have EVERY node */  Node.2.COM     = 'com4'
/*   Set up here!!!!!              */  Node.3.IP      = ''
/* ->COM4 is incorrect!!! It needs */  Node.3.COM     = ''
/*   to be in lower case! (com4)   */

/* Dir you put BV PPP into         */  PPPDir         = 'E:\Adept\BVPPP\'
/* Same but for adept's /'s        */  PPPDir2        = 'E:\\Adept\\BVPPP\\'
/* Welcom Screen                   */  WelcomeScreen  = 'Greet.asc'
/* News Screen                     */  NewsScreen     = 'gen_news.asc'
/* BulletinScreen                  */  BulletinScreen = 'Sign.asc'
/* ---- End of Configuration ------------------------------------------------ */

/* CALL AdeptLog Line, 3, 'BV-PPP: Config Done' */

IF line = 0 THEN
  DO
    CALL AdeptLog Line, 3, 'BV-PPP: NO LOCAL PPP SUPPORT!'
    Call ShowScreens
    EXIT 0
  END

UserName = AdeptGetVar(Line,1)
UserSecLevel = AdeptGetVar(Line,40)

IF (UserSecLevel < Min_Sec_Access) THEN
  DO
    CALL AdeptLog Line, 3, 'BV-PPP: User DOES NOT have PPP Access.'
    Call ShowScreens
    EXIT 0
  END

CALL AdeptLog Line, 3, 'BV-PPP: User has PPP Access...'

IF (Node.line.IP = '') THEN
  DO
    CALL AdeptLog Line, 3, 'BV-PPP: This line does not support PPP.'
    Call ShowScreens
    EXIT 0
  END


ret = AdeptSetGlobalVar('PPP'line, 'ACTIVE')
CALL AdeptLocation line, "Using PPP"

ThreadID = AdeptStartRexxThread(PPPDir||'Connect.cmd', Line IP_Address || ':' || Node.Line.IP Node.line.COM PPPDir2)
If ThreadID <= '0' Then Do
  CALL AdeptLog Line, 3, 'BV-PPP: Cannot start thread cmd file.  Check path of Connect.cmd'
  CALL AdeptPrint Line, '\r\n' || 'PPP ERROR - cannot start thread, notify the Sysop.'
  CALL AdeptSleep Line, 3000
  EXIT -2
END

DO FOREVER
  IF AdeptGetVar(Line,276) = 0 THEN /* Check Carrier */
    DO
      CALL AdeptLog Line, 3, 'BV-PPP: 'UserName' has dropped carrier!!!'
      ret = AdeptDropGlobalVar('PPP'line)
      EXIT -2
    END
  status = AdeptGetGlobalVar('PPP'line)
  IF status = 'INACTIVE' THEN
    DO
      CALL AdeptLog Line, 3, 'BV-PPP: 'UserName' has dropped carrier or PPP was killed off'
      CALL AdeptComDoDTR Line, 0
      ret = AdeptDropGlobalVar('PPP'line)
      RETURN -2
    END
  CALL AdeptSleep Line, 500
END

