program TopTen;
uses
  TParam,
  TFileIO,
  TOSInt,
  ApiInt,
  Bits,
  Types;

label
  NextTopUser,
  NextDown,
  NextUp,
  NextFDown,
  NextFUp;

type
  PTopTenBull      = ^TTopTenBull;
  TTopTenBull      = object
    Language       : Char;
    SkipFile       : string;
    AreaCode       : string;
    BullPath       : string;

    constructor Init;
    destructor Done;

    procedure ReadParams;
    procedure CreateBull;
  end;

var
  TopTenBull       : PTopTenBull;

constructor TTopTenBull.Init;
begin
  dllInit( '', 0 );
end; { contructor Init }

destructor TTopTenBull.Done;
begin
end; { destructor Done }

procedure TTopTenBull.ReadParams;
begin
  if Par^.SwAct['L'] then
    case UpCh( Par^.SwStr['L', 1] ) of
      'A': Language := 'A';
      'E': Language := 'E';
      'N': Language := 'N';
    else
      Language := 'A';
    end
  else Language := 'A';

  SkipFile := '';
  if Par^.SwAct['S'] then
    if FileExist( Par^.SwStr['S'] ) then
      SkipFile := Par^.SwStr['S'];

  if Par^.SwAct['A'] then AreaCode := Par^.SwStr['A']
  else AreaCode := 'MAIN';

  BullPath := Par^.Str[1];
end; { procedure ReadParams }

procedure TTopTenBull.CreateBull;
type
  PTopTenData      = ^TTopTenData;
  TTopTenData      = record
    TotalTime,
    TotalOn,
    TotalDown,
    TotalUp,
    TotalFiles     : LongInt;
    TotalMDown,
    TotalMUp,
    TotalMB        : Real;

    TopUserTime,
    TopUserCnt,
    Down,
    Up             : array[1..10] of LocUsers;

    FDown,
    FUp            : array[1..10] of TFileRec;
  end;

const
  TopLine          = '[0mĿ  Ŀ';
  BottomLine       = '[0m  '#13#10 +
                     '[44m                                                                              [0m'#13#10'%!m%';

var
  T10               : PTopTenData;
  User              : LocUsers;
  FPos              : LongInt;
  L1, L2            : LongInt;
  Area              : Area_Config_Record;
  Dir               : TFileRec;
  OutE,
  OutN              : TFile;
  Year              : Word;
  Month, Day        : Byte;
  TmpStr            : string;
  TmpTime           : LongInt;

{}function  SkipUser( Name : string ) : Boolean;
  var
    SkFile         : TFile;
    NameMask       : string;

  begin
    if not ( Length( SkipFile ) = 0 ) then
      with SkFile do
      begin
        Assign( SkipFile,
                fmReadOnly or fmDenyWrite,
                1,
                faNormalAccess,
                ftMaxTimeout );
        Reset;

        while not Eof do
        begin
          ReadTextln( NameMask );
          if LookInIf( Name, NameMask ) then
          begin
            Close;
            SkipUser := TRUE;
            exit;
          end;
        end;

        Close;
      end;

    SkipUser := FALSE;
{}end;

{}procedure PrintOut           ( Lang : Char; Txt : String );
  begin
    if ( Lang in ['A', 'E'] ) then OutE.WriteTextln( Txt );
    if ( Lang in ['A', 'N'] ) then OutN.WriteTextln( Txt );
{}end; { Procedure PrintOut }

begin
  New( T10 );
  FillChar( T10^, SizeOf( T10^ ), 0 );

  Write( '  - Scanning user: ' );
  FPos := 0;
  while fioReadLocalUsr( User, FPos ) do
  begin
    OS^.Sleep( 2 );
    Inc( FPos );
    if ( Killed in User.Flags ) then Continue;

    Write( Fill( User.UserName, High( User.UserName ), ' ' ) +
           Fill( '', High( User.UserName ), #8 ));

    with T10^ do
    begin
      Inc( TotalTime, User.TimeTotal );
      Inc( TotalOn, User.TimesOn );
      Inc( TotalDown, User.Downloads );
      TotalMDown := TotalMDown + User.DownloadKB / 1024;
      Inc( TotalUp, User.Uploads );
      TotalMUp := TotalMUp + User.UploadKB / 1024;

      if not SkipUser( User.UserName ) then
      begin
        for L1 := 1 to 10 do
          if ( TopUserTime[L1].TimeTotal < User.TimeTotal ) then
          begin
            for L2 := 9 downto L1 do
              TopUserTime[L2 + 1] := TopUserTime[L2];
            TopUserTime[L1] := User;
            Break;
          end;

        for L1 := 1 to 10 do
          if ( TopUserCnt[L1].TimesOn < User.TimesOn ) then
          begin
            for L2 := 9 downto L1 do
              TopUserCnt[L2 + 1] := TopUserCnt[L2];
            TopUserCnt[L1] := User;
            Break;
          end;

        for L1 := 1 to 10 do
          if ( Down[L1].Downloads < User.Downloads ) then
          begin
            for L2 := 9 downto L1 do
              Down[L2 + 1] := Down[L2];
            Down[L1] := User;
            Break;
          end;

        for L1 := 1 to 10 do
          if ( Up[L1].Uploads < User.Uploads) then
          begin
            for L2 := 9 downto L1 do
              Up[L2 + 1] := Up[L2];
            Up[L1] := User;
            Break;
          end;
      end  { if SkipUser( User ) }
      else
      begin
        Writeln( Fill( '', 19, #8 ) +
                 '  - Skipped user: ' + User.UserName + '. ' );
        Write( '  - Scanning user: ' );
      end; { if SkipUser( User ) else }
    end;
  end;
  Write( Fill( '', High( User.UserName ), ' ') +
         Fill( '', 19 + High( User.UserName ), #8 ));

  fioFindAreaCode( Area, AreaCode,  0 );
  Write( '  - Scanning file: ' );
  FPos := 0;
  while fioReadFileRec( Dir, Area, FPos ) do
  begin
    OS^.Sleep( 2 );
    Inc( FPos );
    if ( KilledFile in Dir.FileFlags ) then Continue;

    Write( Fill( Dir.FileName, High( Dir.FileName ), ' ' ) +
           Fill( '', High( Dir.FileName ), #8 ));

    with T10^ do
    begin
      Inc( TotalFiles );
      TotalMB := TotalMB + Dir.Size / 1048576;

      for L1 := 1 to 10 do
        if (FDown[L1].Downloads<Dir.Downloads) then
        begin
          for L2 := 9 downto L1 do
            FDown[L2+1] := FDown[L2];
          FDown[L1] := Dir;
          Break;
        end;
    end;
  end;
  Write( Fill( '', High( User.UserName ), ' ') +
         Fill( '', 19 + High( User.UserName ), #8 ));

  if ( Language in ['A', 'E'] ) then
  begin
    with OutE do
    begin
      Assign( BullPath + '.E',
              fmWriteOnly or fmExclusive,
              1,
              faNormalAccess,
              ftMaxTimeout );
      ReWrite;
    end;
  end;

  if ( Language in ['A', 'N'] ) then
  begin
    with OutN do
    begin
      Assign( BullPath + '.N',
              fmWriteOnly or fmExclusive,
              1,
              faNormalAccess,
              ftMaxTimeout );
      ReWrite;
    end;
  end;

  with T10^ do
  begin
    Date( Year, Month, Day );
    TmpTime := TimeNow;
    PrintOut( 'E', '[1;37;41m' + Fill( ' TopTen statistics', 39, ' ' ) +
                   PreFill( TimeStr( TmpTime ) + ' ' + DateStr( Year, Month, Day ), 38, ' ' ) + ' [0m' );
    PrintOut( 'N', '[1;37;41m' + Fill( ' Ti p topp statistikk', 39, ' ' ) +
                   PreFill( TimeStr( TmpTime ) + ' ' + DateStr( Year, Month, Day ), 38, ' ' ) + ' [0m' );
    PrintOut( 'A', '' );
    PrintOut( 'E', '[1;33m' + Center( 'TOP-10 USERS', 78, ' ' ));
    PrintOut( 'N', '[1;33m' + Center( 'TI P TOPP BRUKERE', 78, ' ' ));
    PrintOut( 'A', '[36m' );
    PrintOut( 'E', Center( 'Total user time: ' + I2S( TotalTime, 0 ), 78, ' ' ));
    PrintOut( 'N', Center( 'Total bruker tid: ' + I2S( TotalTime, 0 ) ,78, ' ' ));
    PrintOut( 'E', Center( 'Total number of logons: ' + I2S( TotalOn, 0 ), 78, ' ' ));
    PrintOut( 'N', Center( 'Antall plogginger: ' + I2S( TotalOn, 0 ), 78, ' ' ));
    PrintOut( 'A', '' );
    PrintOut( 'E', '[37;44m Username                     Minutes    Username                      Logons [0;37m' );
    PrintOut( 'N', '[37;44m Brukernavn                  Minutter    Plogginger              Plogginger [0;37m' );
    PrintOut( 'A', TopLine );

    for L1 := 1 to 10 do
    begin
      if ( L1 = 1 ) then TmpStr := '[1;32m'
      else TmpStr := '[1;36m';
      PrintOut( 'A', '' + TmpStr + Fill( TopUserTime[L1].UserName, 30 ,' ' ) +
                     PreFill( I2S( TopUserTime[L1].TimeTotal, 0 ), 6, ' ' ) +
                     '[0m' + I2S( L1, 2 ) +
                     '' + TmpStr + Fill( TopUserCnt[L1].UserName, 30, ' ' ) +
                     PreFill( I2S( TopUserCnt[L1].TimesOn, 0 ), 6, ' ' ) + '[0m' );
    end;
    PrintOut( 'A', BottomLine );

    PrintOut( 'E', '[1;37;41m' + Fill( ' TopTen statistics', 39, ' ' ) +
                   PreFill( TimeStr( TmpTime ) + ' ' + DateStr( Year, Month, Day ), 38, ' ' ) + ' [0m' );
    PrintOut( 'N', '[1;37;41m' + Fill( ' Ti p topp statistikk', 39, ' ' ) +
                   PreFill( TimeStr( TmpTime ) + ' ' + DateStr( Year, Month, Day ), 38, ' ' ) + ' [0m' );
    PrintOut( 'A', '' );
    PrintOut( 'E', '[1;33m' + Center( 'TOP-10 DOWNLOADERS', 39, ' ' ) +
                               Center( 'TOP-10 UPLOADERS', 39, ' ' ));
    PrintOut( 'N', '[1;33m' + Center( 'TI P TOPP DOWNLOADERE', 39, ' ' ) +
                               Center( 'TI P TOPP UPLOADERE', 39, ' ' ));
    PrintOut( 'A', '[36m' );
    PrintOut( 'E', Center( 'Total number of downloads: ' + I2S( TotalDown, 0 ), 39, ' ' ) +
                   Center( 'Total number of uploads: ' + I2S( TotalUp, 0 ), 39, ' ' ));
    PrintOut( 'N', Center( 'Antall downloads totalt: ' + I2S( TotalDown, 0 ), 39, ' ' ) +
                   Center( 'Antall uploads totalt: ' + I2S( TotalUp, 0 ), 39, ' ' ));
    PrintOut( 'E', Center( 'MB downloaded: ' + R2S( TotalMDown, 0, 1 ), 39, ' ' ) +
                   Center( 'MB uploaded: ' + R2S( TotalMUp, 0, 1 ), 39, ' ' ));;
    PrintOut( 'N', Center( 'MB downloadet: ' + R2S( TotalMDown, 0, 1 ), 39, ' ' ) +
                   Center( 'MB uploadet: ' + R2S( TotalMUp, 0, 1 ), 39, ' ' ));
    PrintOut( 'A', '' );
    PrintOut( 'E', '[37;44m Username                   Downloads    Username                     Uploads [0;37m' );
    PrintOut( 'N', '[37;44m Brukernavn                 Downloads    Brukernavn                   Uploads [0;37m' );
    PrintOut( 'A', TopLine );

    for L1 := 1 to 10 do
    begin
      if ( L1 = 1 ) then TmpStr := '[1;32m'
      else TmpStr := '[1;36m';
      PrintOut( 'A',  '' + TmpStr + Fill( Down[L1].UserName, 30, ' ' ) +
                      PreFill( I2S( Down[L1].Downloads, 0 ), 6, ' ' ) +
                      '[0m' + I2S( L1, 2 ) +
                      '' + TmpStr + Fill( Up[L1].UserName, 30, ' ' ) +
                      PreFill( I2S( Up[L1].Uploads, 0 ), 6, ' ' ) + '[0m' );
    end;
    PrintOut( 'A', BottomLine );

    PrintOut( 'E', '[1;37;41m' + Fill( ' TopTen statistics', 39, ' ' ) +
                   PreFill( TimeStr( TmpTime ) + ' ' + DateStr( Year, Month, Day ), 38, ' ' ) + ' [0m' );
    PrintOut( 'N', '[1;37;41m' + Fill( ' Ti p topp statistikk', 39, ' ' ) +
                   PreFill( TimeStr( TmpTime ) + ' ' + DateStr( Year, Month, Day ), 38, ' ' ) + ' [0m' );
    PrintOut( 'A', '' );
    PrintOut( 'E', '[1;33m' + Center( 'TOP-10 DOWNLOADED FILES', 39, ' ' ) +
                               Center( '', 39, ' ' ));
    PrintOut( 'N', '[1;33m' + Center( 'TI P TOPP DOWNLOADEDE FILER', 39, ' ' ) +
                               Center( '', 39, ' ' ));
    PrintOut( 'A', '[36m' );
    PrintOut( 'E', Center( 'Total number of files: ' + I2S( TotalFiles, 0 ), 39, ' ' ));
    PrintOut( 'N', Center( 'Antall filer totalt: ' + I2S( TotalFiles, 0 ), 39, ' ' ));
    PrintOut( 'E', Center( 'Total number of MB: ' + R2S( TotalMB, 0, 2 ), 39, ' ' ));
    PrintOut( 'N', Center( 'Antall MB totalt: ' + R2S( TotalMB, 0, 2 ), 39, ' ' ));
    PrintOut( 'A',  '' );
    PrintOut( 'E', '[37;44m' + Fill( ' File name          Size   Dls Date', 78, ' ' ) + '[0;37m' );
    PrintOut( 'N', '[37;44m' + Fill( ' Filnavn            Str.  Ant. Dato', 78, ' ' ) + '[0;37m' );

    PrintOut( 'A', TopLine );

    for L1 := 1 to 10 do
    begin
      if ( L1 = 1 ) then TmpStr := '[1;32m'
      else TmpStr := '[1;36m';
      PrintOut( 'A', '' + TmpStr + Fill( FDown[L1].FileName, 16, ' ' ) +
                     PreFill( I2S( FDown[L1].Size div 1024, 0 ), 7, ' ' ) + ' ' +
                     PreFill( I2S( FDown[L1].Downloads, 0 ), 5, ' ' ) +
                     ' ' +
                     I2S( FDown[L1].Date.Date.Day, 2 ) +
                     I2S( FDown[L1].Date.Date.Month, 2 )+
                     I2S( FDown[L1].Date.Date.Year - 1900, 2 ) +
                     '[0m' + I2S( L1, 2 ) +
                     '' + TmpStr + Fill( '', 36, ' ' ) + '[0m' );
    end;

    PrintOut( 'A', BottomLine );
  end;

  if ( Language in ['A', 'E'] ) then
  begin
    OutE.Close;
    Writeln( '  - English Top 10 bulletin written.' );
  end;

  if ( Language in ['A', 'N'] ) then
  begin
    OutN.Close;
    Writeln( '  - Norsk 10 p Topp bulletin skrevet.' );
  end;

  Dispose( T10 );
end; { procedure CreateBull }

begin
  Writeln;
  Writeln( 'TopTen v1.04 - Generate TopTen bulletins from FOSS system files' );
  Writeln;

  if not ( Par^.Count = 1 ) then
  begin
    Writeln( 'Usage:' );
    Writeln( '   TOPTEN {-L[A|E|N]} {-S[filename]} {-A[area]} [bullpath]' );
    Writeln;
    Writeln( '   -L           Requested bulletin language (All, English or Norwegian)' );
    Writeln( '                (Default: All)' );
    Writeln( '   -S           Path to list of user names to ignore' );
    Writeln( '                (Default: Ignore none)' );
    Writeln( '   -A           Area code of area to collect info from' );
    Writeln( '                (Default: MAIN)' );
    Writeln( '   bullpath     Path of file to write bulletin into (without extension)' );
    Exit;
  end;

  New( TopTenBull, Init );
  TopTenBull^.ReadParams;
  TopTenBull^.CreateBull;
  Dispose( TopTenBull, Done );
End. { Program TopTen }