Type
  USERSFile   = record
                 UserIndex          : Integer;
                 Handle             : String[20];
                 Name               : String[40];
                 Sex, SilentMode    : Char;
                 DOB                : String[8];
                 StreetAddress,
                 City, Suburb       : String[20];
                 DataPhone,
                 VoicePhone         : String[15];
                 UserComment        : String[40];
                 Password           : String[20];
                 LastLogon          : String[8];
                 BaudRate           : String[6];
                 BankedTime,
                 NumberDownloads,
                 NumberUploads,
                 TimeLimit,
                 TimeLeft, CPSRate,
                 SecurityValue      : String[5];
                 SecurityLevel      : String[15];
                 BankedKB,
                 FilePoints,
                 UploadKB,
                 DownloadKb,
                 DownloadLimit      : String[10];
                 Validated          : Boolean;
                 FLActive           : Array [1..7] of Integer;
                 MSGId              : LongInt;
                 MenuSetDesc        : String[40];
                end;

  PROTOFile     = record
                 ProtocolName       : String[15];
                 ExeName            : String[12];
                 ProtocolPath,
                 ProtocolPara       : String[40];
                end;

  SECFile     = record
                 SecurityName       : String[15];
                 SecurityValue,
                 TimeLimit          : String[5];
                 FilePoints,
                 DownloadLimit      : String[10];
                 SilentMode         : Char;
                end;

  INIFile     = record
                 ChatStatus         : Boolean;
                 SysMail, TotCall,
                 TodCall, NewUsers,
                 TotUsers, TodMSG,
                 TotMSG, TodFIA,
                 TotFIA             : Integer;
                 Day                : Word;
                 DisableScreenSaver : Boolean;
                end;

  CFGFile     = record
                 SpecChar           : Char;
                 SysHandle          : String[20];
                 BoardName,
                 RegName, RegBoard,
                 LogPath, DataPath,
                 TempPath, ExePath,
                 AnsiPath, MsgPath,
                 FileWPath,
                 BadUpPath,
                 UserComment,
                 ShutDownMsg        : String[40];
                 SecurityLevel,
                 RegCode            : String[15];
                 SysPass,
                 NewUserPass        : String[20];
                 AutoVal,
                 SysAutoLogin, Logs : Char;
                 MinSysBaudRate,
                 MaxSysBaudRate     : String[6];
                 StartTime, EndTime : String[5];
                 EventTime          : String[8];
                 FstInit, SecInit,
                 HangUp, Engage     : String[30];
                 ComPort            : Byte;
                 LeechWeek,
                 UseFileDesc,
                 ScanNewFiles,
                 ShowMissFile,
                 PaybackRatio,
                 UseFilePoints,
                 AllowPrivateMsgs,
                 AllowAnonMsgs,
                 ScanNewMsgs,
                 AllowAllToMsgs,
                 PromptStatus,
                 UploadChecker,
                 WFCStatus          : Char;
                 System1EXE,
                 System2EXE,
                 System3EXE         : String[12];
                 ScanPara,
                 System1Path,
                 System2Path,
                 System3Path        : String[40];
                 IdleTime           : String[5];
                 FLActive           : Array [1..7] of Integer;
                 DaysDelMess        : Byte;
                 MenuSetDesc        : String[40];
                end;

  MSGFile     = record
                 TotMSG, TodMSG     : Integer;
                 SaveFile           : String[12];
                 AreaName           : String[20];
                 PostAccess,
                 ReadAccess         : String[5];
                end;

  UPFFile     = record
                  UPFileName        : String[12];
                  UploadedBy,
                  PassWord          : String[20];
                  NoDownloads,
                  FilePoints        : Integer;
                  Size              : LongInt;
                  DateUL            : String[8];
                  Description       : Array [1..11] of String[40];
                end;

  FIAFile     = record
                 TotFIA, TodFIA     : Integer;
                 UploadAccess,
                 DownLoadAccess,
                 ListAccess         : String[5];
                 AreaName           : String[20];
                 AreaDir            : String[40];
                 AreaFile           : String[12];
                end;

  CONFile     = record
                 ConName            : String[20];
                 ConFileName        : String[12];
                 ConSponsor         : String[40];
                 SecurityAccess     : String[15];
                 SecurityValue      : String[5];
                end;

  MNUFile     = record
                 MenuKey            : String[2];
                 MenuAction1        : Integer;
                 MenuAction2        : Integer;
                 ExecuteCommand     : String[31];
                 SecurityAccess     : String[15];
                 SecurityValue      : String[5];
                end;

  MenuSetFile = record
                 SetDescription     : String[40];
                 SetDir             : String[40];
                 Active, UseCommon  : Char;
                end;

  MSGFormat   = record
                 ToMess, FromMess   : String[20];
                 DateCreated,
                 DateReceived       : String[8];
                 MSGStatus          : Word;      {0-Special,1-Private,2-All}
                 Reason             : String[40];
                 MSGBody            : Array [1..200] of String[80];
                 MSGId              : LongInt;
                end;

  OnlineRec   = record
                 LoggedIn           : Boolean;
                 ToMes, Reason,
                 MessageArea,
                 ConferenceName,
                 FileArea           : String[20];
                 ConferenceSpons    : String[40];
                 ConFileName        : String[12];
                 Baud               : String[6];
                 Paged              : Integer;
                 Silent, TempSys    : Boolean;
                 Colour             : Array [1..4] of String;
                end;

Const
    Version       : String[6] = '0.993';
    INSTLVersion  : String[6] = '0.993';
    NEWSVersion   : String[6] = '0.993';
    STRVersion    : String[6] = '0.993';
    MNUVersion    : String[6] = '0.993';
    WFCVersion    : String[6] = '0.993';
    USERVersion   : String[6] = '0.993';
    LOGINVersion  : String[6] = '0.993';
    CONFIGVersion : String[6] = '0.993';
    MNUSETVersion : String[6] = '0.993';
    BURNVersion   : String[6] = '0.993';
    CodedBy       : String[13] = 'Cameron Booth';
    BuildDate     : String[8] = '03/10/95';
    MinBaudRate   : String[6] = '2400  ';
    MaxBaudRate   : String[6] = '115200';
    DOSPrompt     : String[4] = '$p$g';
    MaxSec        : Byte = 50;
    UpArrow       = #72;
    DownArrow     = #80;
    RightArrow    = #77;
    LeftArrow     = #75;
    ReturnKey     = #13;
    SpaceKey      = #32;
    ESCKey        = #27;
    BackSpace     = #08;
    TabKey        = #09;
    ALTA          = #30;
    ALTD          = #32;
    ALTI          = #23;
    ALTO          = #24;
    ALTH          = #35;
    ALTS          = #31;
    ALTC          = #46;
    ALTN          = #49;
    ALTV          = #47;
    ALTM          = #50;
    ALTJ          = #36;
    ALTE          = #18;
    CTLS          = #19;
